/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jpa.integration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.xbean.asm5.ClassWriter;
import org.apache.xbean.asm5.Label;
import org.apache.xbean.asm5.MethodVisitor;
import org.apache.xbean.asm5.Opcodes;
import org.apache.xbean.asm5.Type;

public class MakeTxLookup
implements Opcodes {
    public static final String HIBERNATE_FACTORY = "org.apache.openejb.hibernate.TransactionManagerLookup";
    public static final String HIBERNATE_NEW_FACTORY = "org.apache.openejb.hibernate.OpenEJBJtaPlatform";
    public static final String HIBERNATE_NEW_FACTORY2 = "org.apache.openejb.hibernate.OpenEJBJtaPlatform2";
    public static final String TOPLINK_FACTORY = "org.apache.openejb.toplink.JTATransactionController";

    public static void main(String[] args) throws Exception {
        File file = new File(args[0]);
        MakeTxLookup.createTopLinkStrategy(file);
        MakeTxLookup.createHibernteStrategy(file);
        MakeTxLookup.createNewHibernateStrategy(file, HIBERNATE_NEW_FACTORY, "org/hibernate/service/jta/platform/internal");
        MakeTxLookup.createNewHibernateStrategy(file, HIBERNATE_NEW_FACTORY2, "org/hibernate/engine/transaction/jta/platform/internal");
    }

    private static void createNewHibernateStrategy(File basedir, String target, String abstractJtaPlatformPackage) throws Exception {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 33, target.replace('.', '/'), null, abstractJtaPlatformPackage + "/AbstractJtaPlatform", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, abstractJtaPlatformPackage + "/AbstractJtaPlatform", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4, "locateTransactionManager", "()Ljavax/transaction/TransactionManager;", null, null);
        mv.visitCode();
        mv.visitMethodInsn(184, "org/apache/openejb/OpenEJB", "getTransactionManager", "()Ljavax/transaction/TransactionManager;", false);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4, "locateUserTransaction", "()Ljavax/transaction/UserTransaction;", null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "javax/naming/NamingException");
        mv.visitLabel(l0);
        mv.visitMethodInsn(184, "org/apache/openejb/loader/SystemInstance", "get", "()Lorg/apache/openejb/loader/SystemInstance;", false);
        mv.visitLdcInsn((Object)Type.getType((String)"Lorg/apache/openejb/spi/ContainerSystem;"));
        mv.visitMethodInsn(182, "org/apache/openejb/loader/SystemInstance", "getComponent", "(Ljava/lang/Class;)Ljava/lang/Object;", false);
        mv.visitTypeInsn(192, "org/apache/openejb/spi/ContainerSystem");
        mv.visitMethodInsn(185, "org/apache/openejb/spi/ContainerSystem", "getJNDIContext", "()Ljavax/naming/Context;", true);
        mv.visitLdcInsn((Object)"comp/UserTransaction");
        mv.visitMethodInsn(185, "javax/naming/Context", "lookup", "(Ljava/lang/String;)Ljava/lang/Object;", true);
        mv.visitTypeInsn(192, "javax/transaction/UserTransaction");
        mv.visitLabel(l1);
        mv.visitInsn(176);
        mv.visitLabel(l2);
        mv.visitFrame(4, 0, null, 1, new Object[]{"javax/naming/NamingException"});
        mv.visitVarInsn(58, 1);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        cw.visitEnd();
        MakeTxLookup.write(basedir, cw, target.replace('.', '/'));
    }

    private static void createHibernteStrategy(File baseDir) throws Exception {
        String factory = HIBERNATE_FACTORY;
        String classFilePath = HIBERNATE_FACTORY.replace('.', '/');
        String sourceFileName = HIBERNATE_FACTORY.substring(HIBERNATE_FACTORY.lastIndexOf(46) + 1, HIBERNATE_FACTORY.length()) + ".java";
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 33, classFilePath, null, "java/lang/Object", new String[]{"org/hibernate/transaction/TransactionManagerLookup"});
        cw.visitSource(sourceFileName, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getTransactionManager", "(Ljava/util/Properties;)Ljavax/transaction/TransactionManager;", null, new String[]{"org/hibernate/HibernateException"});
        mv.visitCode();
        mv.visitMethodInsn(184, "org/apache/openejb/OpenEJB", "getTransactionManager", "()Ljavax/transaction/TransactionManager;", false);
        mv.visitInsn(176);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getUserTransactionName", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)"java:comp/UserTransaction");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getTransactionIdentifier", "(Ljavax/transaction/Transaction;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        cw.visitEnd();
        MakeTxLookup.write(baseDir, cw, classFilePath);
    }

    private static void createTopLinkStrategy(File baseDir) throws Exception {
        String factory = TOPLINK_FACTORY;
        String classFilePath = TOPLINK_FACTORY.replace('.', '/');
        String sourceFileName = TOPLINK_FACTORY.substring(TOPLINK_FACTORY.lastIndexOf(46) + 1, TOPLINK_FACTORY.length()) + ".java";
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 33, classFilePath, null, "oracle/toplink/essentials/transaction/JTATransactionController", null);
        cw.visitSource(sourceFileName, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "oracle/toplink/essentials/transaction/JTATransactionController", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4, "acquireTransactionManager", "()Ljavax/transaction/TransactionManager;", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitMethodInsn(184, "org/apache/openejb/OpenEJB", "getTransactionManager", "()Ljavax/transaction/TransactionManager;", false);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        MakeTxLookup.write(baseDir, cw, classFilePath);
    }

    private static void write(File originalFile, ClassWriter cw, String originalClassFileName) throws IOException {
        String classFileName = "classes/" + originalClassFileName + ".class";
        File file = originalFile;
        for (String part : classFileName.split("/")) {
            file = new File(file, part);
        }
        file.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(cw.toByteArray());
        }
    }
}

