/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.groups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.validation.GroupDefinitionException;
import org.apache.bval.jsr.groups.Group;
import org.apache.bval.jsr.groups.GroupStrategy;
import org.apache.bval.util.Exceptions;

public class Groups {
    private final Set<Group> groups = new LinkedHashSet<Group>();
    private final Set<Group.Sequence> sequences = new LinkedHashSet<Group.Sequence>();

    public Set<Group> getGroups() {
        return Collections.unmodifiableSet(this.groups);
    }

    public Collection<Group.Sequence> getSequences() {
        return Collections.unmodifiableSet(this.sequences);
    }

    boolean insertGroup(Group group) {
        return this.groups.add(group);
    }

    boolean insertSequence(Collection<Group> groups) {
        return groups != null && !groups.isEmpty() && this.sequences.add(Group.sequence(groups));
    }

    @Deprecated
    public void assertDefaultGroupSequenceIsExpandable(List<Group> defaultGroups) {
        Consumer<List> action = groupList -> {
            int idx = groupList.indexOf(Group.DEFAULT);
            if (idx >= 0) {
                this.ensureExpandable((List<Group>)groupList, defaultGroups, idx);
            }
        };
        this.sequences.stream().map(Group.Sequence::getGroups).map(ArrayList::new).forEach(action);
    }

    private void ensureExpandable(List<Group> groupList, List<Group> defaultGroupList, int defaultGroupIndex) {
        int sz = defaultGroupList.size();
        for (int i = 0; i < sz; ++i) {
            int index;
            Group group = defaultGroupList.get(i);
            if (group.isDefault() || (index = groupList.indexOf(group)) < 0 || i == 0 && index == defaultGroupIndex - 1 || i == defaultGroupList.size() - 1 && index == defaultGroupIndex + 1) continue;
            Exceptions.raise(GroupDefinitionException::new, "Unable to expand default group list %s into sequence %s", defaultGroupList, groupList);
        }
    }

    public GroupStrategy asStrategy() {
        ArrayList<GroupStrategy> components = new ArrayList<GroupStrategy>();
        components.addAll(this.groups);
        components.addAll(this.sequences);
        return GroupStrategy.composite(components);
    }
}

