/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.validation.BootstrapConfiguration;
import javax.validation.ValidationException;
import javax.validation.executable.ExecutableType;
import org.apache.bval.jsr.BootstrapConfigurationImpl;
import org.apache.bval.jsr.ConfigurationImpl;
import org.apache.bval.jsr.metadata.XmlBuilder;
import org.apache.bval.jsr.xml.DefaultValidatedExecutableTypesType;
import org.apache.bval.jsr.xml.ExecutableValidationType;
import org.apache.bval.jsr.xml.PropertyType;
import org.apache.bval.jsr.xml.SchemaManager;
import org.apache.bval.jsr.xml.ValidationConfigType;
import org.apache.bval.jsr.xml.ValidationParser$org_apache_bval_util_reflection_Reflection$$getClassLoader$$Ljava_lang_Class$_ACTION;
import org.apache.bval.jsr.xml.ValidationParser$parseXmlConfig$$Ljava_lang_String$_ACTION;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;
import org.xml.sax.InputSource;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public class ValidationParser {
    private static final String DEFAULT_VALIDATION_XML_FILE = "META-INF/validation.xml";
    private static final Logger log;
    private static final SchemaManager SCHEMA_MANAGER;

    public static String getValidationXmlFile(String file) {
        return file == null ? DEFAULT_VALIDATION_XML_FILE : file;
    }

    public static BootstrapConfiguration processValidationConfig(String file, ConfigurationImpl targetConfig) {
        boolean executableValidationEnabled;
        Set<Object> defaultValidatedExecutableTypes;
        ValidationConfigType xmlConfig = ValidationParser.parseXmlConfig(file);
        if (xmlConfig == null) {
            return null;
        }
        if (xmlConfig.getExecutableValidation() == null) {
            defaultValidatedExecutableTypes = EnumSet.of(ExecutableType.IMPLICIT);
            executableValidationEnabled = true;
        } else {
            Optional<ExecutableValidationType> executableValidation = Optional.of(xmlConfig).map(ValidationConfigType::getExecutableValidation);
            executableValidationEnabled = executableValidation.map(ExecutableValidationType::getEnabled).filter(Predicate.isEqual(Boolean.TRUE)).isPresent();
            defaultValidatedExecutableTypes = executableValidation.filter(x -> executableValidationEnabled).map(ExecutableValidationType::getDefaultValidatedExecutableTypes).map(DefaultValidatedExecutableTypesType::getExecutableType).map(EnumSet::copyOf).orElse(EnumSet.noneOf(ExecutableType.class));
        }
        return new BootstrapConfigurationImpl(xmlConfig.getDefaultProvider(), xmlConfig.getConstraintValidatorFactory(), xmlConfig.getMessageInterpolator(), xmlConfig.getTraversableResolver(), xmlConfig.getParameterNameProvider(), new HashSet<String>(xmlConfig.getConstraintMapping()), executableValidationEnabled, defaultValidatedExecutableTypes, ValidationParser.toMap(xmlConfig.getProperty()), xmlConfig.getClockProvider(), new HashSet<String>(xmlConfig.getValueExtractor()));
    }

    private static Map<String, String> toMap(List<PropertyType> property) {
        return property == null || property.isEmpty() ? Collections.emptyMap() : property.stream().collect(Collectors.toMap(PropertyType::getName, PropertyType::getValue));
    }

    @Privileged
    private static ValidationConfigType parseXmlConfig(String string) {
        if (!(System.getSecurityManager() != null)) {
            return ValidationParser.__privileged_parseXmlConfig(string);
        }
        return (ValidationConfigType)AccessController.doPrivileged(new ValidationParser$parseXmlConfig$$Ljava_lang_String$_ACTION(string));
    }

    static /* synthetic */ ValidationConfigType __privileged_access$0(String string) {
        return ValidationParser.__privileged_parseXmlConfig(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ValidationConfigType __privileged_parseXmlConfig(String validationXmlFile) {
        try (InputStream inputStream = ValidationParser.getInputStream(ValidationParser.getValidationXmlFile(validationXmlFile));){
            if (inputStream == null) {
                log.log(Level.FINEST, String.format("No %s found. Using annotation based configuration only.", validationXmlFile));
                ValidationConfigType validationConfigType = null;
                return validationConfigType;
            }
            log.log(Level.FINEST, String.format("%s found.", validationXmlFile));
            ValidationConfigType validationConfigType = SCHEMA_MANAGER.unmarshal(new InputSource(inputStream), ValidationConfigType.class);
            return validationConfigType;
        }
        catch (Exception e) {
            throw Exceptions.create(ValidationException::new, e, "Unable to parse %s", validationXmlFile);
        }
    }

    public static InputStream open(String mappingFileName) {
        if (mappingFileName.charAt(0) == '/') {
            mappingFileName = mappingFileName.substring(1);
        }
        try {
            InputStream in = ValidationParser.getInputStream(mappingFileName);
            Exceptions.raiseIf(in == null, ValidationException::new, "Unable to open input stream for mapping file %s", mappingFileName);
            return in;
        }
        catch (IOException e) {
            throw Exceptions.create(ValidationException::new, e, "Unable to open input stream for mapping file %s", mappingFileName);
        }
    }

    static InputStream getInputStream(String path) throws IOException {
        ClassLoader loader = ValidationParser.org_apache_bval_util_reflection_Reflection$$getClassLoader(ValidationParser.class);
        ArrayList<URL> urls = Collections.list(loader.getResources(path));
        Exceptions.raiseIf(urls.stream().distinct().count() > 1L, ValidationException::new, "More than one %s is found in the classpath", path);
        return urls.isEmpty() ? null : ((URL)urls.get(0)).openStream();
    }

    @Privileged
    private static /* synthetic */ ClassLoader org_apache_bval_util_reflection_Reflection$$getClassLoader(Class<?> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return ValidationParser.__privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(clazz);
        }
        return (ClassLoader)AccessController.doPrivileged(new ValidationParser$org_apache_bval_util_reflection_Reflection$$getClassLoader$$Ljava_lang_Class$_ACTION(clazz));
    }

    static /* synthetic */ ClassLoader __privileged_access$1(Class clazz) {
        return ValidationParser.__privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(clazz);
    }

    private static /* synthetic */ ClassLoader __privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(Class<?> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? clazz.getClassLoader() : classLoader;
    }

    private ValidationParser() {
    }

    private static void __privileged_clinit0() {
        log = Logger.getLogger(ValidationParser.class.getName());
        SCHEMA_MANAGER = new SchemaManager.Builder().add(XmlBuilder.Version.v10.getId(), "http://jboss.org/xml/ns/javax/validation/configuration", "META-INF/validation-configuration-1.0.xsd").add(XmlBuilder.Version.v11.getId(), "http://jboss.org/xml/ns/javax/validation/configuration", "META-INF/validation-configuration-1.1.xsd").add(XmlBuilder.Version.v20.getId(), "http://xmlns.jcp.org/xml/ns/validation/configuration", "META-INF/validation-configuration-2.0.xsd").build();
    }

    static {
        ValidationParser.__privileged_clinit0();
    }
}

