/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.ejb.spi.HandleDelegate;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.servlet.ServletContext;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Service;
import org.apache.catalina.ThreadBindingListener;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.Valve;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.tcp.SimpleTcpCluster;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.startup.OpenEJBContextConfig;
import org.apache.catalina.users.MemoryUserDatabase;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.naming.ContextAccessController;
import org.apache.naming.ContextBindings;
import org.apache.naming.ResourceEnvRef;
import org.apache.naming.ResourceRef;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.Injection;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.DeployerEjb;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.ClassListInfo;
import org.apache.openejb.assembler.classic.DeploymentExceptionManager;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.InjectionBuilder;
import org.apache.openejb.assembler.classic.JaccPermissionsBuilder;
import org.apache.openejb.assembler.classic.JndiEncBuilder;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.OpenEjbConfigurationFactory;
import org.apache.openejb.assembler.classic.PersistenceUnitInfo;
import org.apache.openejb.assembler.classic.PolicyContext;
import org.apache.openejb.assembler.classic.ReloadableEntityManagerFactory;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.ServletInfo;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.assembler.classic.event.NewEjbAvailableAfterApplicationCreated;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.cdi.CdiBuilder;
import org.apache.openejb.cdi.OpenEJBLifecycle;
import org.apache.openejb.cdi.Proxys;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.TldScanner;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.core.CoreContainerSystem;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.core.ivm.IntraVmProxy;
import org.apache.openejb.core.ivm.naming.SystemComponentReference;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.BeginWebBeansListener;
import org.apache.openejb.server.httpd.EndWebBeansListener;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.proxy.LocalBeanProxyFactory;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.util.descriptor.web.ApplicationParameter;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ContextTransaction;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.descriptor.web.ResourceBase;
import org.apache.tomcat.util.http.CookieProcessor;
import org.apache.tomcat.util.scan.StandardJarScanFilter;
import org.apache.tomee.catalina.ContextListener;
import org.apache.tomee.catalina.Contexts;
import org.apache.tomee.catalina.GlobalListenerSupport;
import org.apache.tomee.catalina.IgnoredStandardContext;
import org.apache.tomee.catalina.JavaeeInstanceManager;
import org.apache.tomee.catalina.LazyStopLoader;
import org.apache.tomee.catalina.LazyStopStandardRoot;
import org.apache.tomee.catalina.LinkageErrorProtection;
import org.apache.tomee.catalina.OpenEJBNamingResource;
import org.apache.tomee.catalina.OpenEJBSecurityListener;
import org.apache.tomee.catalina.OpenEJBValve;
import org.apache.tomee.catalina.SimpleTomEETcpCluster;
import org.apache.tomee.catalina.TomEEContainerListener;
import org.apache.tomee.catalina.TomEERealm;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.catalina.TomEEWebappClassLoader;
import org.apache.tomee.catalina.TomEEWebappLoader;
import org.apache.tomee.catalina.TomcatDeploymentLoader;
import org.apache.tomee.catalina.TomcatJavaJndiBinder;
import org.apache.tomee.catalina.TomcatJndiBuilder;
import org.apache.tomee.catalina.TomcatLoader;
import org.apache.tomee.catalina.WebSockets;
import org.apache.tomee.catalina.cdi.ServletContextHandler;
import org.apache.tomee.catalina.cdi.WebBeansThreadBindingListener;
import org.apache.tomee.catalina.cluster.ClusterObserver;
import org.apache.tomee.catalina.cluster.TomEEClusterListener;
import org.apache.tomee.catalina.environment.Hosts;
import org.apache.tomee.catalina.event.AfterApplicationCreated;
import org.apache.tomee.catalina.routing.RouterValve;
import org.apache.tomee.catalina.security.TomcatSecurityConstaintsToJaccPermissionsTransformer;
import org.apache.tomee.common.NamingUtil;
import org.apache.tomee.common.UserTransactionFactory;
import org.apache.tomee.loader.TomcatHelper;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContextsService;

public class TomcatWebAppBuilder
implements WebAppBuilder,
ContextListener,
ParentClassLoaderFinder {
    public static final String OPENEJB_CROSSCONTEXT_PROPERTY = "openejb.crosscontext";
    public static final String OPENEJB_SESSION_MANAGER_PROPERTY = "openejb.session.manager";
    public static final String OPENEJB_JSESSION_ID_SUPPORT = "openejb.jsessionid-support";
    public static final String OPENEJB_MYFACES_DISABLE_DEFAULT_VALUES = "openejb.myfaces.disable-default-values";
    public static final String IGNORE_CONTEXT = TomcatWebAppBuilder.class.getName() + ".IGNORE";
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB.createChild("tomcat"), (String)"org.apache.openejb.util.resources");
    public static final String DEFAULT_J2EE_SERVER = "Apache TomEE";
    public static final String OPENEJB_WEBAPP_MODULE_ID = "openejb.webapp.moduleId";
    private static final boolean FORCE_RELOADABLE = SystemInstance.get().getOptions().get("tomee.force-reloadable", false);
    private static final boolean SKIP_TLD = SystemInstance.get().getOptions().get("tomee.skip-tld", false);
    private static final Method GET_NAMING_CONTEXT_NAME;
    private final Map<String, Realm> realms = new ConcurrentHashMap<String, Realm>();
    private final Map<ClassLoader, InstanceManager> instanceManagers = new ConcurrentHashMap<ClassLoader, InstanceManager>();
    private final Map<String, ContextInfo> infos = new HashMap<String, ContextInfo>();
    private final GlobalListenerSupport globalListenerSupport;
    private final ConfigurationFactory configurationFactory;
    private final Map<String, HostConfig> deployers = new TreeMap<String, HostConfig>();
    private final Hosts hosts;
    private final Map<String, DeployedApplication> deployedApps = new TreeMap<String, DeployedApplication>();
    private final DeploymentLoader deploymentLoader;
    private Assembler assembler;
    private CoreContainerSystem containerSystem;
    private final Map<ClassLoader, Map<String, Set<String>>> jsfClasses = new HashMap<ClassLoader, Map<String, Set<String>>>();
    private Class<?> sessionManagerClass;
    private final Set<CatalinaCluster> clusters = new HashSet<CatalinaCluster>();
    private ClassLoader parentClassLoader;
    private boolean initJEEInfo = true;
    private final ServletContextHandler servletContextHandler;
    private final boolean noHostCheck;
    private static final AtomicReference<Field> HOST_CONFIG_HOST;

    public TomcatWebAppBuilder() {
        ConfigurationFactory configurationFactory;
        SystemInstance.get().setComponent(WebAppBuilder.class, (Object)this);
        SystemInstance.get().setComponent(TomcatWebAppBuilder.class, (Object)this);
        this.initJEEInfo = "true".equalsIgnoreCase(SystemInstance.get().getProperty("tomee.init-J2EE-info", "true"));
        StandardServer standardServer = TomcatHelper.getServer();
        this.globalListenerSupport = new GlobalListenerSupport(standardServer, this);
        this.hosts = new Hosts();
        SystemInstance.get().setComponent(Hosts.class, (Object)this.hosts);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        for (Service service : standardServer.findServices()) {
            if (!(service.getContainer() instanceof Engine)) continue;
            Engine engine = service.getContainer();
            URL globalRouterConf = RouterValve.serverRouterConfigurationURL();
            if (globalRouterConf != null) {
                RouterValve routerValve = new RouterValve();
                routerValve.setConfigurationPath(globalRouterConf);
                engine.getPipeline().addValve((Valve)routerValve);
            }
            this.parentClassLoader = engine.getParentClassLoader();
            if (this.parentClassLoader == ClassLoader.getSystemClassLoader() && this.parentClassLoader != tccl) {
                this.parentClassLoader = tccl;
                engine.setParentClassLoader(tccl);
            }
            this.manageCluster(engine.getCluster());
            this.hosts.setDefault(engine.getDefaultHost());
            this.addTomEERealm(engine);
            for (Container engineChild : engine.findChildren()) {
                if (!(engineChild instanceof StandardHost)) continue;
                StandardHost host = (StandardHost)engineChild;
                this.manageCluster(host.getCluster());
                this.addTomEERealm((Host)host);
                host.getPipeline().addValve((Valve)new OpenEJBSecurityListener.RequestCapturer());
                this.hosts.add((Host)host);
                for (LifecycleListener listener : host.findLifecycleListeners()) {
                    if (!(listener instanceof HostConfig)) continue;
                    HostConfig hostConfig = (HostConfig)listener;
                    this.deployers.put(host.getName(), hostConfig);
                }
            }
        }
        SystemInstance.get().addObserver((Object)new ClusterObserver(this.clusters));
        OpenEjbConfigurationFactory component = (OpenEjbConfigurationFactory)SystemInstance.get().getComponent(OpenEjbConfigurationFactory.class);
        ConfigurationFactory configurationFactory2 = configurationFactory = ConfigurationFactory.class.isInstance(component) ? (ConfigurationFactory)ConfigurationFactory.class.cast(component) : (ConfigurationFactory)SystemInstance.get().getComponent(ConfigurationFactory.class);
        if (configurationFactory == null) {
            configurationFactory = new ConfigurationFactory();
        }
        this.configurationFactory = configurationFactory;
        this.deploymentLoader = new DeploymentLoader();
        this.servletContextHandler = new ServletContextHandler();
        this.setComponentsUsedByCDI();
        try {
            WebSockets.setConfigurator();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.noHostCheck = !Boolean.parseBoolean(SystemInstance.get().getProperty("tomee.host.check", "true"));
    }

    private void setComponentsUsedByCDI() {
        SystemInstance systemInstance = SystemInstance.get();
        if (systemInstance.getComponent(HttpServletRequest.class) == null) {
            systemInstance.setComponent(HttpServletRequest.class, Proxys.threadLocalProxy(HttpServletRequest.class, OpenEJBSecurityListener.requests, null));
        }
        if (systemInstance.getComponent(org.apache.openejb.server.httpd.HttpSession.class) == null) {
            systemInstance.setComponent(HttpSession.class, (Object)Proxys.threadLocalRequestSessionProxy(OpenEJBSecurityListener.requests, null));
        }
        if (systemInstance.getComponent(ServletContext.class) == null) {
            systemInstance.setComponent(ServletContext.class, Proxys.handlerProxy((InvocationHandler)this.servletContextHandler, ServletContext.class, (Class[])new Class[]{CdiAppContextsService.FiredManually.class}));
        }
    }

    private void manageCluster(Cluster cluster) {
        if (cluster == null || cluster instanceof SimpleTomEETcpCluster) {
            return;
        }
        Object current = cluster;
        if (cluster instanceof SimpleTcpCluster) {
            Container container = cluster.getContainer();
            current = new SimpleTomEETcpCluster((SimpleTcpCluster)cluster);
            container.setCluster(current);
        }
        if (current instanceof CatalinaCluster) {
            CatalinaCluster haCluster = (CatalinaCluster)current;
            TomEEClusterListener listener = (TomEEClusterListener)((Object)SystemInstance.get().getComponent(TomEEClusterListener.class));
            if (listener == null) {
                listener = new TomEEClusterListener();
                SystemInstance.get().setComponent(TomEEClusterListener.class, (Object)listener);
            }
            haCluster.addClusterListener((ClusterListener)listener);
            this.clusters.add(haCluster);
        }
    }

    private void addTomEERealm(Engine engine) {
        Realm realm = engine.getRealm();
        if (!(realm == null || realm instanceof TomEERealm || engine.getParent() != null && realm.equals(engine.getParent().getRealm()))) {
            Realm tomeeRealm = this.tomeeRealm(realm);
            engine.setRealm(tomeeRealm);
            if (LifecycleState.STARTING_PREP.equals((Object)engine.getState())) {
                try {
                    ((Lifecycle)Lifecycle.class.cast(tomeeRealm)).start();
                }
                catch (LifecycleException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private void addTomEERealm(Host host) {
        Realm realm = host.getRealm();
        if (!(realm == null || realm instanceof TomEERealm || host.getParent() != null && realm.equals(host.getParent().getRealm()))) {
            host.setRealm(this.tomeeRealm(realm));
        }
    }

    protected Realm tomeeRealm(Realm realm) {
        TomEERealm trealm = new TomEERealm();
        trealm.setRealmPath("/tomee");
        trealm.addRealm(realm);
        return trealm;
    }

    public void start() {
        this.globalListenerSupport.start();
    }

    public void stop() {
        this.globalListenerSupport.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(StandardServer server) {
        block6: {
            if (SystemInstance.get().isDefaultProfile()) {
                try {
                    NamingResourcesImpl resources = server.getGlobalNamingResources();
                    ContextResource userDataBaseResource = resources.findResource("UserDatabase");
                    UserDatabase db = (UserDatabase)server.getGlobalNamingContext().lookup(userDataBaseResource.getName());
                    if (db.getUsers().hasNext() || !(db instanceof MemoryUserDatabase)) break block6;
                    MemoryUserDatabase mudb = (MemoryUserDatabase)db;
                    boolean oldRo = mudb.getReadonly();
                    try {
                        ((MemoryUserDatabase)db).setReadonly(false);
                        db.createRole("tomee-admin", "tomee admin role");
                        db.createUser("tomee", "tomee", "TomEE");
                        db.findUser("tomee").addRole(db.findRole("tomee-admin"));
                    }
                    finally {
                        mudb.setReadonly(oldRo);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployWebApps(AppInfo appInfo, ClassLoader classLoader) throws Exception {
        try {
            for (WebAppInfo webApp : appInfo.webApps) {
                String host;
                String hostname;
                ClassLoader currentParent;
                StandardContext standardContext;
                File war = new File(webApp.path);
                URL contextXmlUrl = null;
                if (war.isDirectory()) {
                    File cXml = new File(war, "META-INF/context.xml").getAbsoluteFile();
                    if (cXml.exists()) {
                        contextXmlUrl = cXml.toURI().toURL();
                        LOGGER.info("using context file " + cXml.getAbsolutePath());
                    }
                } else {
                    try (JarFile warAsJar = new JarFile(war);){
                        JarEntry entry = warAsJar.getJarEntry("META-INF/context.xml");
                        if (entry != null) {
                            contextXmlUrl = new URL("jar:" + war.getAbsoluteFile().toURI().toURL().toExternalForm() + "!/" + "META-INF/context.xml");
                        }
                    }
                }
                if (this.isAlreadyDeployed(appInfo, webApp)) continue;
                ClassLoader containerLoader = ParentClassLoaderFinder.Helper.get();
                Host host2 = this.hosts.getDefault();
                if (StandardHost.class.isInstance(host2) && !StandardContext.class.getName().equals(((StandardHost)StandardHost.class.cast(host2)).getContextClass())) {
                    try {
                        standardContext = (StandardContext)StandardContext.class.cast(containerLoader.loadClass(((StandardHost)StandardHost.class.cast(host2)).getContextClass()).newInstance());
                    }
                    catch (Throwable th) {
                        LOGGER.warning("Can't use context class specified, using default StandardContext", th);
                        standardContext = new StandardContext();
                    }
                } else {
                    standardContext = new StandardContext();
                }
                if ((currentParent = standardContext.getParentClassLoader()) == null || TomcatWebAppBuilder.isParent(currentParent, containerLoader)) {
                    standardContext.setParentClassLoader(containerLoader);
                }
                standardContext.setUnpackWAR(!"false".equalsIgnoreCase(appInfo.properties.getProperty("tomcat.unpackWar")));
                if (contextXmlUrl != null) {
                    standardContext.setConfigFile(contextXmlUrl);
                }
                try {
                    if (webApp.defaultContextPath != null && webApp.defaultContextPath.matches("^/\\w*[^/]$")) {
                        standardContext.setPath(webApp.defaultContextPath);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (standardContext.getPath() != null) {
                    webApp.contextRoot = standardContext.getPath();
                }
                if (webApp.contextRoot.startsWith("/") || webApp.contextRoot.startsWith(File.separator)) {
                    webApp.contextRoot = webApp.contextRoot.substring(1);
                }
                if (webApp.contextRoot.startsWith(File.separator)) {
                    webApp.contextRoot = webApp.contextRoot.replaceFirst(File.separator, "");
                }
                if ((hostname = Contexts.getHostname(standardContext)) != null && !"_".equals(hostname)) {
                    webApp.host = hostname;
                }
                ApplicationParameter appParam = new ApplicationParameter();
                appParam.setName(OPENEJB_WEBAPP_MODULE_ID);
                appParam.setValue(webApp.moduleId);
                standardContext.addApplicationParameter(appParam);
                if (this.isAlreadyDeployed(appInfo, webApp)) continue;
                if (standardContext.getPath() == null) {
                    if (webApp.contextRoot != null && webApp.contextRoot.startsWith("/")) {
                        standardContext.setPath(webApp.contextRoot);
                    } else if (TomcatWebAppBuilder.isRoot(webApp.contextRoot)) {
                        standardContext.setPath("");
                    } else {
                        standardContext.setPath("/" + webApp.contextRoot);
                    }
                }
                if (standardContext.getDocBase() == null) {
                    standardContext.setDocBase(webApp.path);
                }
                String docBase = standardContext.getDocBase();
                File docBaseFile = new File(docBase);
                if (docBase != null && docBaseFile.isFile() && docBase.endsWith(".war")) {
                    DeploymentLoader.unpack((File)docBaseFile);
                    if (standardContext.getPath().endsWith(".war")) {
                        standardContext.setPath(TomcatWebAppBuilder.removeFirstSlashAndWar("/" + standardContext.getPath()));
                        standardContext.setName(standardContext.getPath());
                        webApp.contextRoot = standardContext.getPath();
                    }
                    standardContext.setDocBase(docBase.substring(0, docBase.length() - 4));
                }
                if (TomcatWebAppBuilder.isRoot(standardContext.getName())) {
                    standardContext.setName("");
                    webApp.contextRoot = "";
                }
                if (this.isAlreadyDeployed(appInfo, webApp)) continue;
                if (classLoader != null) {
                    standardContext.setParentClassLoader(classLoader);
                    standardContext.setDelegate(true);
                }
                if ((host = webApp.host) == null) {
                    host = this.hosts.getDefaultHost();
                    LOGGER.info("using default host: " + host);
                }
                if (classLoader != null) {
                    appInfo.autoDeploy = false;
                    this.deployWar(standardContext, host, appInfo);
                } else {
                    this.deployWar(standardContext, host, null);
                }
                TomcatSecurityConstaintsToJaccPermissionsTransformer transformer = new TomcatSecurityConstaintsToJaccPermissionsTransformer(standardContext);
                PolicyContext policyContext = transformer.createResourceAndDataPermissions();
                JaccPermissionsBuilder jaccPermissionsBuilder = new JaccPermissionsBuilder();
                jaccPermissionsBuilder.install(policyContext);
            }
        }
        finally {
            for (WebAppInfo webApp : appInfo.webApps) {
                appInfo.properties.remove(webApp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAlreadyDeployed(AppInfo appInfo, WebAppInfo webApp) {
        String version = TomcatWebAppBuilder.appVersion(appInfo);
        ContextInfo contextInfo = this.getContextInfo(webApp.host, webApp.contextRoot, version);
        if (contextInfo != null && contextInfo.standardContext != null && contextInfo.standardContext.getState() == LifecycleState.FAILED) {
            Map<String, ContextInfo> map = this.infos;
            synchronized (map) {
                this.infos.remove(this.getId(webApp.host, webApp.contextRoot, version));
            }
            return false;
        }
        return contextInfo != null;
    }

    private static boolean isParent(ClassLoader parent, ClassLoader child) {
        for (ClassLoader current = child; current != null; current = current.getParent()) {
            if (current != parent) continue;
            return true;
        }
        return child.getParent() == null && child != ClassLoader.getSystemClassLoader();
    }

    private static boolean isRoot(String name) {
        return "/ROOT".equals(name) || "ROOT".equals(name) || name == null || name.isEmpty() || "ROOT.war".equals(name);
    }

    public void deployWar(StandardContext standardContext, String host, AppInfo info) {
        HostConfig deployer = this.deployers.get(host);
        if (TomcatWebAppBuilder.isReady(deployer)) {
            if (info != null) {
                ContextInfo contextInfo = this.addContextInfo(host, standardContext);
                contextInfo.appInfo = info;
                contextInfo.deployer = deployer;
                contextInfo.module = this.extractModule(standardContext, info);
            }
            deployer.manageApp((org.apache.catalina.Context)standardContext);
        } else {
            Host theHost = this.hosts.get(host);
            if (theHost != null) {
                if (info != null) {
                    ContextInfo contextInfo = this.addContextInfo(host, standardContext);
                    contextInfo.appInfo = info;
                    contextInfo.host = theHost;
                    contextInfo.module = this.extractModule(standardContext, info);
                }
                theHost.addChild((Container)standardContext);
            }
        }
    }

    private EjbModule extractModule(StandardContext standardContext, AppInfo appInfo) {
        for (WebAppInfo app : appInfo.webApps) {
            if (app.path == null || !Contexts.warPath((org.apache.catalina.Context)standardContext).equals(TomcatWebAppBuilder.rootPath(new File(app.path)))) continue;
            return (EjbModule)EjbModule.class.cast(appInfo.properties.remove(app));
        }
        return null;
    }

    public synchronized ContextInfo standaAloneWebAppInfo(File file) {
        for (ContextInfo info : this.infos.values()) {
            if (info.appInfo != null && info.appInfo.webAppAlone && (file.equals(new File(info.appInfo.path)) || file.equals(new File(info.appInfo.path + ".war")))) {
                return info;
            }
            if (info.standardContext == null || !file.equals(new File(info.standardContext.getDocBase())) && !file.equals(new File(info.standardContext.getDocBase() + ".war"))) continue;
            return info;
        }
        String path = file.getAbsolutePath();
        for (ContextInfo info : this.infos.values()) {
            if (info.appInfo == null || !info.appInfo.webAppAlone || !info.appInfo.path.endsWith(path) && !(info.appInfo.path + ".war").endsWith(path)) continue;
            return info;
        }
        return null;
    }

    public synchronized Collection<String> availableApps() {
        ArrayList<String> apps = new ArrayList<String>();
        for (ContextInfo info : this.infos.values()) {
            if (info.appInfo != null) {
                apps.add(info.appInfo.path);
                continue;
            }
            if (info.standardContext == null) continue;
            apps.add("[not deployed] " + info.standardContext.getName());
        }
        return apps;
    }

    private static boolean isReady(HostConfig deployer) {
        if (deployer != null && HOST_CONFIG_HOST.get() != null) {
            try {
                return HOST_CONFIG_HOST.get().get(deployer) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static void addMyFacesDefaultParameters(ClassLoader classLoader, ServletContext context) {
        if (!SystemInstance.get().getOptions().get(OPENEJB_MYFACES_DISABLE_DEFAULT_VALUES, false)) {
            if (classLoader != null) {
                try {
                    classLoader.loadClass("org.apache.myfaces.shared.config.MyfacesConfig");
                }
                catch (ClassNotFoundException cnfe) {
                    return;
                }
            }
            TomcatWebAppBuilder.setInitParameter(context, "org.apache.myfaces.LOG_WEB_CONTEXT_PARAMS", "false");
            TomcatWebAppBuilder.setInitParameter(context, "org.apache.myfaces.EL_RESOLVER_COMPARATOR", "org.apache.myfaces.el.unified.OpenWebBeansELResolverComparator");
            TomcatWebAppBuilder.setInitParameter(context, "org.apache.myfaces.EXPRESSION_FACTORY", "org.apache.el.ExpressionFactoryImpl");
        }
    }

    private static void setInitParameter(ServletContext context, String key, String value) {
        if (context.getInitParameter(key) == null) {
            context.setInitParameter(key, value);
        }
    }

    public void undeployWebApps(AppInfo appInfo) throws Exception {
        String version = TomcatWebAppBuilder.appVersion(appInfo);
        for (WebAppInfo webApp : appInfo.webApps) {
            ContextInfo contextInfo = this.getContextInfo(webApp.host, webApp.contextRoot, version);
            if (contextInfo == null) continue;
            StandardContext standardContext = contextInfo.standardContext;
            if (appInfo.webAppAlone && appInfo.properties.containsKey("tomee.destroying")) continue;
            TomcatWebAppBuilder.undeploy(standardContext, contextInfo);
            File extracted = Contexts.warPath((org.apache.catalina.Context)standardContext);
            if (this.isExtracted(extracted)) {
                this.deleteDir(extracted);
            }
            this.removeContextInfo(standardContext);
        }
    }

    private boolean isExtracted(File extracted) {
        return false;
    }

    private void deleteDir(File dir) {
        if (dir == null) {
            return;
        }
        if (dir.isFile()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDir(file);
                    continue;
                }
                if (file.delete()) continue;
                file.deleteOnExit();
            }
        }
        if (!dir.delete()) {
            dir.deleteOnExit();
        }
    }

    @Override
    public void init(StandardContext standardContext) {
        LifecycleListener[] listeners;
        JarScanFilter jarScanFilter;
        ContextInfo ctxInfo;
        if (TomcatWebAppBuilder.isIgnored(standardContext)) {
            return;
        }
        LOGGER.info("------------------------- " + Contexts.getHostname(standardContext).replace("_", this.hosts.getDefaultHost()) + " -> " + TomcatWebAppBuilder.finalName(standardContext.getPath()));
        if (FORCE_RELOADABLE && ((ctxInfo = this.getContextInfo(standardContext)) == null || ctxInfo.appInfo != null && ctxInfo.appInfo.webAppAlone)) {
            standardContext.setReloadable(true);
        }
        if (SKIP_TLD && standardContext.getJarScanner() != null && standardContext.getJarScanner().getJarScanFilter() != null && StandardJarScanFilter.class.isInstance(jarScanFilter = standardContext.getJarScanner().getJarScanFilter())) {
            ((StandardJarScanFilter)StandardJarScanFilter.class.cast(jarScanFilter)).setDefaultTldScan(false);
        }
        String name = standardContext.getName();
        this.initJ2EEInfo(standardContext);
        File warFile = Contexts.warPath((org.apache.catalina.Context)standardContext);
        if (!warFile.exists()) {
            return;
        }
        if (!warFile.isDirectory()) {
            try {
                warFile = DeploymentLoader.unpack((File)warFile);
            }
            catch (OpenEJBException e) {
                LOGGER.error("can't unpack '" + warFile.getAbsolutePath() + "'");
            }
        }
        standardContext.setCrossContext(SystemInstance.get().getOptions().get(OPENEJB_CROSSCONTEXT_PROPERTY, false));
        standardContext.setNamingResources((NamingResourcesImpl)new OpenEJBNamingResource(standardContext.getNamingResources()));
        String sessionManager = SystemInstance.get().getOptions().get("openejb.session.manager." + name, (String)null);
        if (sessionManager == null) {
            sessionManager = SystemInstance.get().getOptions().get(OPENEJB_SESSION_MANAGER_PROPERTY, (String)null);
        }
        if (sessionManager != null) {
            if (this.sessionManagerClass == null) {
                try {
                    this.sessionManagerClass = ParentClassLoaderFinder.Helper.get().loadClass(sessionManager);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("can't find '" + sessionManager + "', StandardManager will be used", (Throwable)e);
                    this.sessionManagerClass = StandardManager.class;
                }
            }
            try {
                Manager mgr = (Manager)this.sessionManagerClass.newInstance();
                standardContext.setManager(mgr);
            }
            catch (Exception e) {
                LOGGER.error("can't instantiate '" + sessionManager + "', StandardManager will be used", (Throwable)e);
            }
        }
        for (LifecycleListener l : listeners = standardContext.findLifecycleListeners()) {
            if (!(l instanceof ContextConfig)) continue;
            standardContext.removeLifecycleListener(l);
        }
        standardContext.addLifecycleListener((LifecycleListener)new OpenEJBContextConfig(new StandardContextInfo(standardContext)));
        NamingContextListener ncl = new NamingContextListener();
        try {
            ncl.setName((String)GET_NAMING_CONTEXT_NAME.invoke((Object)standardContext, new Object[0]));
        }
        catch (Exception e) {
            ncl.setName(this.getId(standardContext));
        }
        ncl.setExceptionOnFailedWrite(standardContext.getJndiExceptionOnFailedWrite());
        standardContext.setNamingContextListener(ncl);
        standardContext.addLifecycleListener((LifecycleListener)ncl);
        standardContext.addLifecycleListener((LifecycleListener)new TomcatJavaJndiBinder());
        standardContext.addContainerListener((ContainerListener)new TomEEContainerListener());
    }

    public void initJ2EEInfo(StandardContext standardContext) {
        if (this.initJEEInfo) {
            standardContext.setJ2EEServer(DEFAULT_J2EE_SERVER);
            ContextInfo contextInfo = this.getContextInfo(standardContext);
            if (contextInfo == null || contextInfo.appInfo == null || contextInfo.appInfo.path == null) {
                standardContext.setJ2EEApplication(this.jmxName(standardContext.getName()));
            } else {
                standardContext.setJ2EEApplication(this.jmxName(this.shortName(contextInfo.appInfo.path)));
            }
        }
    }

    private String jmxName(String name) {
        return name.replace(':', '_');
    }

    private String shortName(String path) {
        if (path.contains("/")) {
            return path.substring(path.lastIndexOf(47), path.length());
        }
        return path;
    }

    private static String finalName(String path) {
        if (TomcatWebAppBuilder.isRoot(path)) {
            return "/";
        }
        return path;
    }

    public ContextInfo getContextInfo(String appName) {
        ContextInfo info = null;
        for (Map.Entry<String, ContextInfo> current : this.infos.entrySet()) {
            String key = current.getKey();
            if (key.equals(appName)) {
                info = current.getValue();
                break;
            }
            if (!key.endsWith(appName)) continue;
            info = current.getValue();
        }
        return info;
    }

    @Override
    public void beforeStart(StandardContext standardContext) {
        String cookieProcessor;
        Set defaultTrackingModes;
        ServletContext sc;
        if (standardContext.getResources() != null && LazyStopStandardRoot.class.isInstance(standardContext.getResources())) {
            Reflections.set((Object)standardContext, (String)"resources", (Object)((LazyStopStandardRoot)LazyStopStandardRoot.class.cast(standardContext.getResources())).getDelegate());
        }
        if ((sc = standardContext.getServletContext()) != null && !SystemInstance.get().getOptions().get(OPENEJB_JSESSION_ID_SUPPORT, true) && (defaultTrackingModes = sc.getEffectiveSessionTrackingModes()).contains(SessionTrackingMode.URL)) {
            HashSet newModes = new HashSet();
            newModes.remove(SessionTrackingMode.URL);
            sc.setSessionTrackingModes(newModes);
        }
        this.initContextLoader(standardContext);
        String filters = SystemInstance.get().getProperty("org.apache.openejb.servlet.filters");
        if (filters != null) {
            String[] names;
            for (String name : names = filters.split(",")) {
                String[] clazzMapping = name.split("=");
                FilterDef filterDef = new FilterDef();
                filterDef.setFilterClass(clazzMapping[0]);
                filterDef.setFilterName(clazzMapping[0]);
                standardContext.addFilterDef(filterDef);
                FilterMap filterMap = new FilterMap();
                filterMap.setFilterName(clazzMapping[0]);
                filterMap.addURLPattern(clazzMapping[1]);
                standardContext.addFilterMapBefore(filterMap);
            }
        }
        if ((cookieProcessor = SystemInstance.get().getProperty("tomee.tomcat.cookieProcessor")) != null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> cookieProcessorClass = contextClassLoader.loadClass(cookieProcessor.trim());
                standardContext.setCookieProcessor((CookieProcessor)CookieProcessor.class.cast(cookieProcessorClass.newInstance()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot set CookieProcessor: " + cookieProcessor);
            }
        }
    }

    private void initContextLoader(StandardContext standardContext) {
        Loader standardContextLoader = standardContext.getLoader();
        if (standardContextLoader != null && (!TomEEWebappLoader.class.equals(standardContextLoader.getClass()) && !WebappLoader.class.equals(standardContextLoader.getClass()) || WebappLoader.class.equals(standardContextLoader.getClass()) && !((WebappLoader)WebappLoader.class.cast(standardContextLoader)).getLoaderClass().startsWith("org.apache.tom"))) {
            return;
        }
        if (standardContextLoader != null && TomEEWebappLoader.class.isInstance(standardContextLoader)) {
            standardContextLoader.setContext((org.apache.catalina.Context)standardContext);
            return;
        }
        TomEEWebappLoader loader = new TomEEWebappLoader();
        loader.setDelegate(standardContext.getDelegate());
        loader.setLoaderClass(TomEEWebappClassLoader.class.getName());
        LazyStopLoader lazyStopLoader = new LazyStopLoader((Loader)loader);
        standardContext.setLoader((Loader)lazyStopLoader);
    }

    @Override
    public void configureStart(LifecycleEvent event, StandardContext standardContext) {
        ContextTransaction contextTransaction = new ContextTransaction();
        contextTransaction.setProperty("factory", (Object)UserTransactionFactory.class.getName());
        standardContext.getNamingResources().setTransaction(contextTransaction);
        if (event != null) {
            standardContext.getNamingContextListener().lifecycleEvent(event);
        }
        TomcatHelper.configureJarScanner((org.apache.catalina.Context)standardContext);
        this.startInternal(standardContext);
        TomcatWebAppBuilder.addMyFacesDefaultParameters(standardContext.getLoader().getClassLoader(), standardContext.getServletContext());
        standardContext.setTldValidation(Boolean.parseBoolean(SystemInstance.get().getProperty("tomee.tld.validation", "false")));
        standardContext.setXmlValidation(Boolean.parseBoolean(SystemInstance.get().getProperty("tomee.xml.validation", "false")));
    }

    @Override
    public void start(StandardContext standardContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInternal(StandardContext standardContext) {
        URL routerConfig;
        DeploymentExceptionManager dem;
        if (TomcatWebAppBuilder.isIgnored(standardContext)) {
            return;
        }
        if (TomcatWebAppBuilder.shouldNotDeploy(standardContext)) {
            return;
        }
        CoreContainerSystem cs = this.getContainerSystem();
        Assembler a = this.getAssembler();
        if (a == null) {
            LOGGER.warning("OpenEJB has not been initialized so war will not be scanned for nested modules " + standardContext.getPath());
            return;
        }
        AppContext appContext = null;
        ContextInfo contextInfo = this.getContextInfo(standardContext);
        ClassLoader classLoader = standardContext.getLoader().getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader originalLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        String listenerName = standardContext.getNamingContextListener().getName();
        ContextAccessController.setWritable((Object)listenerName, (Object)standardContext.getNamingToken());
        try {
            Context comp = (Context)Context.class.cast(ContextBindings.getClassLoader().lookup("comp"));
            TransactionManager transactionManager = (TransactionManager)SystemInstance.get().getComponent(TransactionManager.class);
            this.safeBind(comp, "TransactionManager", transactionManager);
            TransactionSynchronizationRegistry synchronizationRegistry = (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class);
            this.safeBind(comp, "TransactionSynchronizationRegistry", synchronizationRegistry);
        }
        catch (NamingException comp) {
        }
        finally {
            thread.setContextClassLoader(originalLoader);
            ContextAccessController.setReadOnly((Object)listenerName);
        }
        if (contextInfo == null) {
            boolean skipTomeeResourceWrapping;
            AppModule appModule = this.loadApplication(standardContext);
            appModule.getProperties().put("loader.from", "tomcat");
            boolean bl = skipTomeeResourceWrapping = !"true".equalsIgnoreCase(SystemInstance.get().getProperty("tomee.tomcat.resource.wrap", "true"));
            if (!skipTomeeResourceWrapping && OpenEJBNamingResource.class.isInstance(standardContext.getNamingResources())) {
                ArrayList<String> importedNames = new ArrayList<String>();
                boolean forceDataSourceWrapping = "true".equalsIgnoreCase(SystemInstance.get().getProperty("tomee.tomcat.datasource.wrap", "false"));
                OpenEJBNamingResource nr = (OpenEJBNamingResource)standardContext.getNamingResources();
                for (ResourceBase resource : nr.getTomcatResources()) {
                    Resource newResource;
                    boolean isAlreadyCreated;
                    String name = resource.getName();
                    boolean isDataSource = DataSource.class.getName().equals(resource.getType());
                    boolean bl2 = isAlreadyCreated = ContextResource.class.isInstance(resource) && ((ContextResource)ContextResource.class.cast(resource)).getSingleton() && isDataSource;
                    if (importedNames.contains(name)) continue;
                    importedNames.add(name);
                    boolean found = false;
                    for (ResourceInfo r : ((OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class)).facilities.resources) {
                        if (!r.id.equals(name)) continue;
                        nr.removeResource(name);
                        found = true;
                        LOGGER.warning(name + " resource was defined in both tomcat and tomee so removing tomcat one");
                        break;
                    }
                    if (found) continue;
                    if (forceDataSourceWrapping || !isAlreadyCreated && isDataSource) {
                        newResource = new Resource(name, resource.getType());
                        boolean jta = false;
                        Properties properties = newResource.getProperties();
                        Iterator params = resource.listProperties();
                        while (params.hasNext()) {
                            String paramName = (String)params.next();
                            String paramValue = (String)resource.getProperty(paramName);
                            if ("driverClassName".equals(paramName)) {
                                properties.setProperty("JdbcDriver", paramValue);
                            } else if ("url".equals(paramName)) {
                                properties.setProperty("JdbcUrl", paramValue);
                            } else {
                                properties.setProperty(paramName, paramValue);
                            }
                            if (!"JtaManaged".equalsIgnoreCase(paramName)) continue;
                            jta = Boolean.parseBoolean(paramValue);
                        }
                        if (!jta) {
                            properties.setProperty("JtaManaged", "false");
                        }
                    } else {
                        newResource = new Resource(name, resource.getType(), "org.apache.tomee:ProvidedByTomcat");
                        Properties properties = newResource.getProperties();
                        properties.setProperty("jndiName", newResource.getId());
                        properties.setProperty("appName", this.getId(standardContext));
                        properties.setProperty("factory", (String)resource.getProperty("factory"));
                        Reference reference = TomcatWebAppBuilder.createReference(resource);
                        if (reference != null) {
                            properties.put("reference", reference);
                        }
                    }
                    appModule.getResources().add(newResource);
                }
            }
            if (appModule != null) {
                try {
                    contextInfo = this.addContextInfo(Contexts.getHostname(standardContext), standardContext);
                    contextInfo.standardContext = standardContext;
                    contextInfo.appInfo = this.configurationFactory.configureApplication(appModule);
                    Boolean autoDeploy = (Boolean)DeployerEjb.AUTO_DEPLOY.get();
                    contextInfo.appInfo.autoDeploy = autoDeploy == null || autoDeploy != false;
                    DeployerEjb.AUTO_DEPLOY.remove();
                    if (!appModule.isWebapp()) {
                        classLoader = appModule.getClassLoader();
                    } else {
                        ClassLoader loader = standardContext.getLoader().getClassLoader();
                        if (loader instanceof TomEEWebappClassLoader) {
                            TomEEWebappClassLoader tomEEWebappClassLoader = (TomEEWebappClassLoader)((Object)loader);
                            for (URL url : ((WebModule)appModule.getWebModules().iterator().next()).getAddedUrls()) {
                                tomEEWebappClassLoader.addURL(url);
                            }
                        }
                    }
                    this.setFinderOnContextConfig(standardContext, appModule);
                    this.servletContextHandler.getContexts().put(classLoader, standardContext.getServletContext());
                    try {
                        appContext = a.createApplication(contextInfo.appInfo, classLoader);
                    }
                    finally {
                        this.servletContextHandler.getContexts().remove(classLoader);
                    }
                    TomcatWebAppBuilder.eagerInitOfLocalBeanProxies(appContext.getBeanContexts(), classLoader);
                }
                catch (Exception e) {
                    LOGGER.error("Unable to deploy collapsed ear in war " + standardContext, (Throwable)e);
                    TomcatWebAppBuilder.undeploy(standardContext, contextInfo);
                    if (System.getProperty("tomee.eat-exception") == null) {
                        TomEERuntimeException tre = new TomEERuntimeException(e);
                        dem = (DeploymentExceptionManager)SystemInstance.get().getComponent(DeploymentExceptionManager.class);
                        dem.saveDeploymentException(contextInfo.appInfo, (Exception)tre);
                        throw tre;
                    }
                    return;
                }
            }
        } else {
            OpenEJBContextConfig openEJBContextConfig;
            contextInfo.standardContext = standardContext;
            if (contextInfo.module != null && contextInfo.module.getFinder() != null && (openEJBContextConfig = this.findOpenEJBContextConfig(standardContext)) != null) {
                openEJBContextConfig.finder(contextInfo.module.getFinder(), contextInfo.module.getClassLoader());
            }
        }
        String id = this.getId(standardContext);
        WebAppInfo webAppInfo = null;
        if (contextInfo.appInfo != null) {
            for (WebAppInfo w : contextInfo.appInfo.webApps) {
                if (!id.equals(this.getId(w.host, w.contextRoot, contextInfo.version)) && !id.equals(this.getId(w.host, w.moduleId, contextInfo.version))) continue;
                if (webAppInfo == null) {
                    webAppInfo = w;
                    break;
                }
                if (w.host == null || !w.host.equals(Contexts.getHostname(standardContext))) break;
                webAppInfo = w;
                break;
            }
            if (appContext == null) {
                appContext = cs.getAppContext((Object)contextInfo.appInfo.appId);
            }
        }
        if (webAppInfo != null) {
            block65: {
                if (appContext == null) {
                    appContext = this.getContainerSystem().getAppContext((Object)contextInfo.appInfo.appId);
                }
                webAppInfo.host = Contexts.getHostname(standardContext);
                webAppInfo.contextRoot = standardContext.getPath();
                HashMap<String, Set> scannedJsfClasses = new HashMap<String, Set>();
                for (Object info : webAppInfo.jsfAnnotatedClasses) {
                    scannedJsfClasses.put(((ClassListInfo)info).name, ((ClassListInfo)info).list);
                }
                this.jsfClasses.put(classLoader, scannedJsfClasses);
                try {
                    HashSet<Injection> injections = new HashSet<Injection>();
                    injections.addAll(appContext.getInjections());
                    if (!contextInfo.appInfo.webAppAlone) {
                        TomcatWebAppBuilder.updateInjections(injections, classLoader, false);
                        for (Object bean : appContext.getBeanContexts()) {
                            TomcatWebAppBuilder.updateInjections(bean.getInjections(), classLoader, true);
                        }
                    }
                    injections.addAll(new InjectionBuilder(classLoader).buildInjections(webAppInfo.jndiEnc));
                    TomcatJndiBuilder jndiBuilder = new TomcatJndiBuilder(standardContext, webAppInfo, injections);
                    NamingUtil.setCurrentContext((StandardContext)standardContext);
                    try {
                        jndiBuilder.mergeJndi();
                    }
                    finally {
                        NamingUtil.setCurrentContext(null);
                    }
                    for (PersistenceUnitInfo unitInfo : contextInfo.appInfo.persistenceUnits) {
                        if (unitInfo.webappName == null || !unitInfo.webappName.equals(webAppInfo.moduleId)) continue;
                        try {
                            ReloadableEntityManagerFactory remf = (ReloadableEntityManagerFactory)((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext().lookup("openejb/PersistenceUnit/" + unitInfo.id);
                            remf.overrideClassLoader(classLoader);
                            remf.createDelegate();
                        }
                        catch (NameNotFoundException nnfe) {
                            LOGGER.warning("Can't find " + unitInfo.id + " persistence unit");
                        }
                    }
                    WebContext webContext = new WebContext(appContext);
                    webContext.setServletContext(standardContext.getServletContext());
                    webContext.setJndiEnc((Context)new InitialContext());
                    webContext.setClassLoader(classLoader);
                    webContext.setId(webAppInfo.moduleId);
                    webContext.setContextRoot(webAppInfo.contextRoot);
                    webContext.setHost(webAppInfo.host);
                    webContext.setBindings(new HashMap());
                    webContext.getInjections().addAll(injections);
                    appContext.getWebContexts().add(webContext);
                    cs.addWebContext(webContext);
                    standardContext.getServletContext().setAttribute("openejb.web.context", (Object)webContext);
                    if (!contextInfo.appInfo.webAppAlone) {
                        List beanContexts = this.assembler.initEjbs(classLoader, contextInfo.appInfo, appContext, injections, new ArrayList(), webAppInfo.moduleId);
                        OpenEJBLifecycle.CURRENT_APP_INFO.set(contextInfo.appInfo);
                        this.servletContextHandler.getContexts().put(classLoader, standardContext.getServletContext());
                        try {
                            new CdiBuilder().build(contextInfo.appInfo, appContext, beanContexts, webContext);
                        }
                        catch (Exception e) {
                            DeploymentExceptionManager dem2 = (DeploymentExceptionManager)SystemInstance.get().getComponent(DeploymentExceptionManager.class);
                            if (dem2 != null) {
                                dem2.saveDeploymentException(contextInfo.appInfo, e);
                            }
                            throw e;
                        }
                        finally {
                            this.servletContextHandler.getContexts().remove(classLoader);
                            OpenEJBLifecycle.CURRENT_APP_INFO.remove();
                        }
                        this.assembler.startEjbs(true, beanContexts);
                        this.assembler.bindGlobals(appContext.getBindings());
                        TomcatWebAppBuilder.eagerInitOfLocalBeanProxies(beanContexts, standardContext.getLoader().getClassLoader());
                        TomcatWebAppBuilder.deployWebServicesIfEjbCreatedHere(contextInfo.appInfo, beanContexts);
                    }
                    webContext.getBindings().putAll(appContext.getBindings());
                    webContext.getBindings().putAll(this.getJndiBuilder(classLoader, webAppInfo, injections, appContext.getProperties()).buildBindings(JndiEncBuilder.JndiScope.comp));
                    JavaeeInstanceManager instanceManager = new JavaeeInstanceManager(standardContext, webContext);
                    standardContext.setInstanceManager((InstanceManager)instanceManager);
                    this.instanceManagers.put(classLoader, instanceManager);
                    standardContext.getServletContext().setAttribute(InstanceManager.class.getName(), (Object)standardContext.getInstanceManager());
                }
                catch (Exception e) {
                    LOGGER.error("Error merging Java EE JNDI entries in to war " + standardContext.getPath() + ": Exception: " + e.getMessage(), (Throwable)e);
                    if (System.getProperty("tomee.eat-exception") != null || (dem = (DeploymentExceptionManager)SystemInstance.get().getComponent(DeploymentExceptionManager.class)) == null || dem.getDeploymentException(contextInfo.appInfo) == null) break block65;
                    if (RuntimeException.class.isInstance(e)) {
                        throw (RuntimeException)RuntimeException.class.cast(e);
                    }
                    throw new TomEERuntimeException(e);
                }
            }
            WebBeansContext webBeansContext = appContext.getWebBeansContext();
            if (webBeansContext != null && webBeansContext.getBeanManagerImpl().isInUse()) {
                OpenEJBLifecycle.initializeServletContext((ServletContext)standardContext.getServletContext(), (WebBeansContext)webBeansContext);
            }
        }
        if ((routerConfig = RouterValve.configurationURL(standardContext.getServletContext())) != null) {
            RouterValve filter = new RouterValve();
            filter.setPrefix(standardContext.getName());
            filter.setConfigurationPath(routerConfig);
            standardContext.getPipeline().addValve((Valve)filter);
        }
        Realm realm = standardContext.getRealm();
        this.realms.put(standardContext.getName(), realm);
    }

    private static boolean shouldNotDeploy(StandardContext standardContext) {
        StandardHost host;
        if (StandardHost.class.isInstance(standardContext.getParent()) && (host = (StandardHost)StandardHost.class.cast(standardContext.getParent())).getAutoDeploy() && standardContext.getDocBase() != null && standardContext.getDocBase() != null && new File(host.getAppBaseFile(), standardContext.getDocBase()).isDirectory() && (new File(host.getAppBaseFile(), standardContext.getDocBase() + ".ear").exists() || new File(host.getAppBaseFile(), standardContext.getDocBase() + ".rar").exists())) {
            LOGGER.info(String.format("Not deploying exploded directory %s as Java EE artifact exists which will be deployed.", new File(host.getAppBaseFile(), standardContext.getPath()).getAbsolutePath()));
            return true;
        }
        return false;
    }

    public void setFinderOnContextConfig(StandardContext standardContext, AppModule appModule) {
        OpenEJBContextConfig openEJBContextConfig = this.findOpenEJBContextConfig(standardContext);
        if (openEJBContextConfig != null) {
            for (EjbModule ejbModule : appModule.getEjbModules()) {
                if (ejbModule.getFile() == null || !Contexts.warPath((org.apache.catalina.Context)standardContext).equals(TomcatWebAppBuilder.rootPath(ejbModule.getFile()))) continue;
                openEJBContextConfig.finder(ejbModule.getFinder(), ejbModule.getClassLoader());
                break;
            }
        }
    }

    private OpenEJBContextConfig findOpenEJBContextConfig(StandardContext standardContext) {
        OpenEJBContextConfig openEJBContextConfig = null;
        for (LifecycleListener listener : standardContext.findLifecycleListeners()) {
            if (!OpenEJBContextConfig.class.isInstance(listener)) continue;
            openEJBContextConfig = (OpenEJBContextConfig)((Object)OpenEJBContextConfig.class.cast(listener));
            break;
        }
        return openEJBContextConfig;
    }

    private static File rootPath(File file) {
        if (file.isDirectory() && file.getName().equals("classes") && file.getParentFile() != null && file.getParentFile().getName().equals("WEB-INF")) {
            File parentFile = file.getParentFile().getParentFile();
            try {
                return parentFile.getCanonicalFile();
            }
            catch (IOException e) {
                return parentFile;
            }
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    private static void deployWebServicesIfEjbCreatedHere(AppInfo info, Collection<BeanContext> beanContexts) {
        if (beanContexts == null || beanContexts.isEmpty()) {
            return;
        }
        SystemInstance.get().fireEvent((Object)new NewEjbAvailableAfterApplicationCreated(info, beanContexts));
    }

    private static void eagerInitOfLocalBeanProxies(Collection<BeanContext> beans, ClassLoader classLoader) {
        for (BeanContext deployment : beans) {
            if (!deployment.isLocalbean() || deployment.isDynamicallyImplemented()) continue;
            ArrayList<Class<BeanContext.Removable>> interfaces = new ArrayList<Class<BeanContext.Removable>>(2);
            interfaces.add(Serializable.class);
            interfaces.add(IntraVmProxy.class);
            BeanType type = deployment.getComponentType();
            if (BeanType.STATEFUL.equals((Object)type) || BeanType.MANAGED.equals((Object)type)) {
                interfaces.add(BeanContext.Removable.class);
            }
            try {
                LocalBeanProxyFactory.createProxy((Class)deployment.getBeanClass(), (ClassLoader)classLoader, (Class[])interfaces.toArray(new Class[interfaces.size()]));
            }
            catch (Exception exception) {}
        }
    }

    private static Reference createReference(ResourceBase resource) {
        ResourceEnvRef ref;
        if (resource instanceof ContextResource) {
            ContextResource cr = (ContextResource)resource;
            ref = new ResourceRef(resource.getType(), resource.getDescription(), cr.getScope(), cr.getAuth(), cr.getSingleton());
        } else {
            ref = new ResourceEnvRef(resource.getType());
        }
        Iterator params = resource.listProperties();
        while (params.hasNext()) {
            String paramName = (String)params.next();
            String paramValue = (String)resource.getProperty(paramName);
            StringRefAddr refAddr = new StringRefAddr(paramName, paramValue);
            ref.add(refAddr);
        }
        return ref;
    }

    private static void updateInjections(Collection<Injection> injections, ClassLoader classLoader, boolean keepInjection) {
        Iterator<Injection> it = injections.iterator();
        ArrayList<Injection> newOnes = new ArrayList<Injection>();
        while (it.hasNext()) {
            Injection injection = it.next();
            if (injection.getTarget() != null) continue;
            try {
                Class<?> target = classLoader.loadClass(injection.getClassname());
                if (keepInjection) {
                    Injection added = new Injection(injection.getJndiName(), injection.getName(), target);
                    newOnes.add(added);
                    continue;
                }
                injection.setTarget(target);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (!newOnes.isEmpty()) {
            injections.addAll(newOnes);
        }
    }

    private static boolean undeploy(StandardContext standardContext, ContextInfo contextInfo) {
        StandardContext container;
        if (TomcatWebAppBuilder.isReady(contextInfo.deployer)) {
            contextInfo.deployer.unmanageApp(standardContext.getName());
            return true;
        }
        if (contextInfo.host != null) {
            return TomcatWebAppBuilder.undeploy(standardContext, (Container)contextInfo.host);
        }
        for (container = contextInfo.standardContext; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        return container != null && TomcatWebAppBuilder.undeploy(standardContext, (Container)container);
    }

    private static boolean undeploy(StandardContext standardContext, Container host) {
        Container child = host.findChild(standardContext.getName());
        if (child instanceof org.apache.catalina.Context && ((org.apache.catalina.Context)org.apache.catalina.Context.class.cast(child)).getPaused()) {
            return true;
        }
        TomEEWebappClassLoader tomEEWebappClassLoader = TomcatWebAppBuilder.lazyClassLoader(org.apache.catalina.Context.class.isInstance(child) ? (org.apache.catalina.Context)org.apache.catalina.Context.class.cast(child) : null);
        if (tomEEWebappClassLoader != null && tomEEWebappClassLoader.isRestarting()) {
            return true;
        }
        if (child != null) {
            host.removeChild((Container)standardContext);
            return true;
        }
        return false;
    }

    private static TomEEWebappClassLoader lazyClassLoader(org.apache.catalina.Context child) {
        if (child == null) {
            return null;
        }
        Loader loader = child.getLoader();
        if (loader == null || !(loader instanceof LazyStopLoader)) {
            return null;
        }
        ClassLoader old = ((LazyStopLoader)loader).getStopClassLoader();
        if (old == null || !(old instanceof TomEEWebappClassLoader)) {
            return null;
        }
        return (TomEEWebappClassLoader)((Object)old);
    }

    private JndiEncBuilder getJndiBuilder(ClassLoader classLoader, WebAppInfo webAppInfo, Set<Injection> injections, Properties props) throws OpenEJBException {
        return new JndiEncBuilder(webAppInfo.jndiEnc, injections, webAppInfo.moduleId, "Bean", null, webAppInfo.uniqueId, classLoader, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void afterStart(StandardContext standardContext) {
        String[] valves;
        WebAppInfo currentWebAppInfo;
        ContextInfo contextInfo;
        ClassLoader classLoader;
        block46: {
            if (TomcatWebAppBuilder.isIgnored(standardContext)) {
                return;
            }
            if (TomcatWebAppBuilder.shouldNotDeploy(standardContext)) {
                return;
            }
            Realm realm = standardContext.getRealm();
            classLoader = standardContext.getLoader().getClassLoader();
            Thread thread = Thread.currentThread();
            ClassLoader originalLoader = thread.getContextClassLoader();
            if (!(realm == null || realm instanceof TomEERealm || standardContext.getParent() != null && realm.equals(standardContext.getParent().getRealm()))) {
                thread.setContextClassLoader(classLoader);
                try {
                    standardContext.setRealm(this.tomeeRealm(realm));
                }
                finally {
                    thread.setContextClassLoader(originalLoader);
                }
            }
            contextInfo = this.getContextInfo(standardContext);
            contextInfo.module = null;
            if (contextInfo != null && contextInfo.appInfo == null) {
                return;
            }
            if (contextInfo == null) {
                return;
            }
            String id = this.getId(standardContext);
            currentWebAppInfo = null;
            for (WebAppInfo webAppInfo : contextInfo.appInfo.webApps) {
                String wId2 = this.getId(webAppInfo.host, webAppInfo.contextRoot, contextInfo.version);
                if (!id.equals(wId2)) continue;
                currentWebAppInfo = webAppInfo;
                break;
            }
            thread.setContextClassLoader(classLoader);
            NamingContextListener ncl = standardContext.getNamingContextListener();
            String listenerName = ncl.getName();
            ContextAccessController.setWritable((Object)listenerName, (Object)standardContext.getNamingToken());
            try {
                Iterator openejbContext = (Context)this.getContainerSystem().getJNDIContext().lookup("openejb");
                Context root = (Context)ContextBindings.getClassLoader().lookup("");
                Context comp = (Context)ContextBindings.getClassLoader().lookup("comp");
                this.safeBind(root, "openejb", openejbContext);
                if (currentWebAppInfo != null) {
                    WebContext webContext = this.getContainerSystem().getWebContext(currentWebAppInfo.moduleId);
                    if (webContext != null) {
                        webContext.setJndiEnc(root);
                    }
                    try {
                        standardContext.getServletContext().setAttribute("javax.faces.validator.beanValidator.ValidatorFactory", openejbContext.lookup("openejb/ValidatorFactory/".replaceFirst("openejb", "") + currentWebAppInfo.uniqueId));
                    }
                    catch (NamingException ne) {
                        LOGGER.warning("no validator factory found for webapp " + currentWebAppInfo.moduleId);
                    }
                }
                try {
                    Class<?> orb = TomcatWebAppBuilder.class.getClassLoader().loadClass("org.omg.CORBA.ORB");
                    if (SystemInstance.get().getComponent(orb) != null) {
                        this.safeBind(comp, "ORB", new SystemComponentReference(orb));
                    }
                }
                catch (ClassNotFoundException | NoClassDefFoundError orb) {
                    // empty catch block
                }
                if (SystemInstance.get().getComponent(HandleDelegate.class) != null) {
                    this.safeBind(comp, "HandleDelegate", new SystemComponentReference(HandleDelegate.class));
                }
            }
            catch (NamingException openejbContext) {
            }
            finally {
                try {
                    this.servletContextHandler.getContexts().put(classLoader, standardContext.getServletContext());
                    for (WebAppInfo webAppInfo : contextInfo.appInfo.webApps) {
                        String wId = this.getId(webAppInfo.host, webAppInfo.contextRoot, contextInfo.version);
                        if (!id.equals(wId)) continue;
                        Request request = OpenEJBSecurityListener.requests.get();
                        OpenEJBSecurityListener.requests.remove();
                        SystemInstance.get().fireEvent((Object)new AfterApplicationCreated(contextInfo.appInfo, webAppInfo, standardContext.getServletContext()));
                        if (request != null) {
                            OpenEJBSecurityListener.requests.set(request);
                        }
                        break;
                    }
                }
                finally {
                    this.servletContextHandler.getContexts().remove(classLoader);
                }
                thread.setContextClassLoader(originalLoader);
                ContextAccessController.setReadOnly((Object)listenerName);
            }
            thread.setContextClassLoader(classLoader);
            try {
                WebBeansContext webBeansContext = this.getWebBeansContext(contextInfo);
                if (webBeansContext != null) {
                    BeginWebBeansListener beginWebBeansListener = new BeginWebBeansListener(webBeansContext);
                    EndWebBeansListener endWebBeansListener = new EndWebBeansListener(webBeansContext);
                    Object[] appEventListeners = standardContext.getApplicationEventListeners();
                    Object[] newEventListeners = new Object[appEventListeners.length + 2];
                    newEventListeners[0] = beginWebBeansListener;
                    System.arraycopy(appEventListeners, 0, newEventListeners, 1, appEventListeners.length);
                    newEventListeners[newEventListeners.length - 1] = endWebBeansListener;
                    standardContext.setApplicationEventListeners(newEventListeners);
                    Object[] lifecycleListeners = standardContext.getApplicationLifecycleListeners();
                    Object[] newLifecycleListeners = new Object[lifecycleListeners.length + 2];
                    newLifecycleListeners[0] = beginWebBeansListener;
                    System.arraycopy(lifecycleListeners, 0, newLifecycleListeners, 1, lifecycleListeners.length);
                    newLifecycleListeners[newLifecycleListeners.length - 1] = endWebBeansListener;
                    standardContext.setApplicationLifecycleListeners(newLifecycleListeners);
                    WebBeansThreadBindingListener webBeansThreadBindingListener = new WebBeansThreadBindingListener(webBeansContext, standardContext.getThreadBindingListener());
                    standardContext.setThreadBindingListener((ThreadBindingListener)webBeansThreadBindingListener);
                    ContextsService contextsService = webBeansContext.getContextsService();
                    if (CdiAppContextsService.class.isInstance(contextsService)) {
                        ((CdiAppContextsService)CdiAppContextsService.class.cast(contextsService)).applicationStarted((Object)standardContext.getServletContext());
                    }
                    break block46;
                }
                EndWebBeansListener endWebBeansListener = new EndWebBeansListener(webBeansContext);
                Object[] appEventListeners = standardContext.getApplicationEventListeners();
                Object[] newEventListeners = new Object[appEventListeners.length + 1];
                System.arraycopy(appEventListeners, 0, newEventListeners, 0, appEventListeners.length);
                newEventListeners[newEventListeners.length - 1] = endWebBeansListener;
                standardContext.setApplicationEventListeners(newEventListeners);
                Object[] lifecycleListeners = standardContext.getApplicationLifecycleListeners();
                Object[] newLifecycleListeners = new Object[lifecycleListeners.length + 1];
                System.arraycopy(lifecycleListeners, 0, newLifecycleListeners, 0, lifecycleListeners.length);
                newLifecycleListeners[newLifecycleListeners.length - 1] = endWebBeansListener;
                standardContext.setApplicationLifecycleListeners(newLifecycleListeners);
            }
            finally {
                thread.setContextClassLoader(originalLoader);
            }
        }
        LinkageErrorProtection.preload(standardContext);
        Pipeline pipeline = standardContext.getPipeline();
        pipeline.addValve((Valve)new OpenEJBValve());
        for (String className : valves = SystemInstance.get().getOptions().get("tomee.valves", "").split(" *, *")) {
            if ("".equals(className)) continue;
            try {
                Class<?> clazz = classLoader.loadClass(className);
                if (!Valve.class.isAssignableFrom(clazz)) continue;
                Valve valve = (Valve)clazz.newInstance();
                pipeline.addValve(valve);
            }
            catch (Exception e) {
                LOGGER.error("can't add the valve " + className, (Throwable)e);
            }
        }
        if (currentWebAppInfo != null) {
            for (String mapping : standardContext.findServletMappings()) {
                ServletInfo info = new ServletInfo();
                info.servletName = standardContext.findServletMapping(mapping);
                info.mappings.add(mapping);
                Container container = standardContext.findChild(info.servletName);
                info.servletClass = container instanceof StandardWrapper ? ((StandardWrapper)container).getServletClass() : mapping;
                currentWebAppInfo.servlets.add(info);
            }
        }
        this.addConfiguredDocBases(standardContext, contextInfo);
        this.ensureMyFacesDontLooseFacesContext(standardContext);
    }

    private void ensureMyFacesDontLooseFacesContext(StandardContext standardContext) {
        for (Container w : standardContext.findChildren()) {
            Wrapper wrapper;
            if (!Wrapper.class.isInstance(w) || !"FacesServlet".equals((wrapper = (Wrapper)Wrapper.class.cast(w)).getName()) || !"javax.faces.webapp.FacesServlet".equals(wrapper.getServletClass())) continue;
            ClassLoader loader = standardContext.getLoader().getClassLoader();
            try {
                if (!Files.toFile((URL)loader.getResource("javax/faces/webapp/FacesServlet.class")).getName().startsWith("myfaces")) continue;
                loader.loadClass("org.apache.tomee.myfaces.TomEEWorkaroundFacesServlet");
                wrapper.setServletClass("org.apache.tomee.myfaces.TomEEWorkaroundFacesServlet");
                break;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static String appVersion(AppInfo appInfo) {
        if (appInfo != null && appInfo.webAppAlone && appInfo.appId != null) {
            int versionIndex = appInfo.appId.indexOf("##");
            return versionIndex >= 0 ? appInfo.appId.substring(versionIndex) : "";
        }
        return "";
    }

    private void addConfiguredDocBases(StandardContext standardContext, ContextInfo contextInfo) {
        if (contextInfo.appInfo.path != null) {
            String contextPath = standardContext.getServletContext().getContextPath();
            String name = contextPath.isEmpty() ? "ROOT" : contextPath.substring(1);
            String webResources = SystemInstance.get().getProperty("tomee." + name + ".docBases", contextInfo.appInfo.properties.getProperty("docBases"));
            if (webResources != null) {
                for (String alt : webResources.trim().split(",")) {
                    String trim = alt.trim();
                    if (trim.isEmpty()) continue;
                    if (!new File(trim).isDirectory()) {
                        LOGGER.warning("Can't add docBase which are not directory: " + trim);
                        continue;
                    }
                    WebResourceRoot root = standardContext.getResources();
                    root.addPreResources((WebResourceSet)new DirResourceSet(root, "/", trim, "/"));
                }
            }
        }
    }

    private WebBeansContext getWebBeansContext(ContextInfo contextInfo) {
        AppContext appContext = this.getContainerSystem().getAppContext((Object)contextInfo.appInfo.appId);
        if (appContext == null) {
            return null;
        }
        WebBeansContext webBeansContext = appContext.getWebBeansContext();
        if (webBeansContext == null) {
            return null;
        }
        for (WebContext web : appContext.getWebContexts()) {
            String name;
            String stdName = TomcatWebAppBuilder.removeFirstSlashAndWar(contextInfo.standardContext.getName());
            if (stdName == null || !stdName.equals(name = TomcatWebAppBuilder.removeFirstSlashAndWar(web.getContextRoot()))) continue;
            webBeansContext = web.getWebbeansContext();
            if (!Contexts.getHostname(contextInfo.standardContext).equals(web.getHost())) continue;
            break;
        }
        if (webBeansContext == null) {
            webBeansContext = appContext.getWebBeansContext();
        }
        return webBeansContext;
    }

    private static String removeFirstSlashAndWar(String name) {
        if (name == null || "/".equals(name) || name.isEmpty()) {
            return "";
        }
        String out = name;
        if (out.startsWith("/")) {
            out = out.substring(1);
        }
        if (out.endsWith(".war")) {
            return out.substring(0, Math.max(out.length() - 4, 0));
        }
        return out;
    }

    private static boolean isIgnored(StandardContext standardContext) {
        return standardContext.getServletContext().getAttribute(IGNORE_CONTEXT) != null || standardContext.getServletContext().getInitParameter(IGNORE_CONTEXT) != null || standardContext instanceof IgnoredStandardContext || TomcatWebAppBuilder.isExcludedBySystemProperty(standardContext);
    }

    private static boolean isExcludedBySystemProperty(StandardContext standardContext) {
        String name = standardContext.getName();
        if (name == null && (name = standardContext.getPath()) == null) {
            name = "";
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        SystemInstance systemInstance = SystemInstance.get();
        return "true".equalsIgnoreCase(systemInstance.getProperty(name + ".tomcat-only", systemInstance.getProperty("tomcat-only", "false")));
    }

    @Override
    public void beforeStop(StandardContext standardContext) {
        ClassLoader classLoader = standardContext.getLoader().getClassLoader();
        if (!(standardContext.getLoader() instanceof LazyStopLoader)) {
            this.jsfClasses.remove(classLoader);
        }
        if (!LazyStopStandardRoot.class.isInstance(standardContext.getResources()) && TomEEWebappClassLoader.class.isInstance(classLoader) && !((TomEEWebappClassLoader)((Object)TomEEWebappClassLoader.class.cast(classLoader))).isForceStopPhase()) {
            LazyStopStandardRoot standardRoot = new LazyStopStandardRoot(standardContext.getResources());
            Reflections.set((Object)standardContext, (String)"resources", (Object)standardRoot);
            ((TomEEWebappClassLoader)((Object)TomEEWebappClassLoader.class.cast(classLoader))).setWebResourceRoot(standardRoot);
        }
    }

    private boolean isUnDeployable(ContextInfo contextInfo) {
        return contextInfo.appInfo != null && contextInfo.deployer == null && contextInfo.appInfo.webAppAlone;
    }

    @Override
    public void stop(StandardContext standardContext) {
    }

    @Override
    public void afterStop(StandardContext standardContext) {
        ContextInfo contextInfo;
        boolean destroyFromTomcat;
        if (TomcatWebAppBuilder.isIgnored(standardContext)) {
            return;
        }
        TomEEWebappClassLoader old = TomcatWebAppBuilder.lazyClassLoader((org.apache.catalina.Context)standardContext);
        if (old != null) {
            TldScanner.forceCompleteClean((ClassLoader)((Object)old));
            this.jsfClasses.remove((Object)old);
        }
        boolean bl = destroyFromTomcat = (contextInfo = this.getContextInfo(standardContext)) != null && this.getAssembler().getDeployedApplications().contains(contextInfo.appInfo);
        if (destroyFromTomcat && this.isUnDeployable(contextInfo)) {
            contextInfo.appInfo.properties.setProperty("tomee.destroying", "true");
            try {
                this.getAssembler().destroyApplication(contextInfo.appInfo.path);
            }
            catch (Exception e) {
                LOGGER.error("Unable to stop web application " + standardContext.getPath() + ": Exception: " + e.getMessage(), (Throwable)e);
            }
        } else {
            destroyFromTomcat = false;
        }
        NamingUtil.cleanUpContextResource((StandardContext)standardContext);
        if (old != null) {
            if (destroyFromTomcat) {
                try {
                    old.internalStop();
                }
                catch (LifecycleException e) {
                    LOGGER.error("error stopping classloader of webapp " + standardContext.getName(), (Throwable)e);
                }
                ClassLoaderUtil.cleanOpenJPACache((ClassLoader)((Object)old));
            }
            this.instanceManagers.remove((Object)old);
        } else if (standardContext.getLoader() != null && standardContext.getLoader().getClassLoader() != null) {
            ClassLoader classLoader = standardContext.getLoader().getClassLoader();
            this.instanceManagers.remove(classLoader);
        }
        this.realms.remove(standardContext.getName());
        if (contextInfo != null && (contextInfo.appInfo == null || contextInfo.appInfo.webAppAlone)) {
            this.removeContextInfo(standardContext);
        }
    }

    @Override
    public void destroy(StandardContext standardContext) {
        WebResourceRoot root;
        Loader delegate;
        Loader standardContextLoader = standardContext.getLoader();
        if (LazyStopLoader.class.isInstance(standardContextLoader) && TomEEWebappLoader.class.isInstance(delegate = ((LazyStopLoader)LazyStopLoader.class.cast(standardContextLoader)).getDelegateLoader())) {
            TomEEWebappLoader webappLoader = (TomEEWebappLoader)((Object)TomEEWebappLoader.class.cast(delegate));
            ClassLoader loader = webappLoader.internalLoader();
            webappLoader.clearLoader();
            if (TomEEWebappClassLoader.class.isInstance(loader)) {
                ((TomEEWebappClassLoader)((Object)TomEEWebappClassLoader.class.cast(loader))).internalDestroy();
            }
        }
        if (LazyStopStandardRoot.class.isInstance(root = standardContext.getResources())) {
            try {
                ((LazyStopStandardRoot)LazyStopStandardRoot.class.cast(root)).internalDestroy();
            }
            catch (LifecycleException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public synchronized void afterStop(StandardServer standardServer) {
        for (ContextInfo contextInfo : this.infos.values()) {
            if (contextInfo == null || contextInfo.deployer == null) continue;
            StandardContext standardContext = contextInfo.standardContext;
            HostConfig deployer = contextInfo.deployer;
            deployer.unmanageApp(standardContext.getPath());
            File realPath = Contexts.warPath((org.apache.catalina.Context)standardContext);
            if (realPath == null) continue;
            this.deleteDir(realPath);
        }
        TomcatLoader.destroy();
    }

    @Override
    public synchronized void checkHost(StandardHost standardHost) {
        if (this.noHostCheck) {
            return;
        }
        if (standardHost.getAutoDeploy()) {
            Iterator<Map.Entry<String, DeployedApplication>> iterator = this.deployedApps.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, DeployedApplication> entry = iterator.next();
                DeployedApplication deployedApplication = entry.getValue();
                if (!deployedApplication.isModified()) continue;
                if (deployedApplication.appInfo != null) {
                    try {
                        this.getAssembler().destroyApplication(((DeployedApplication)deployedApplication).appInfo.path);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to application " + ((DeployedApplication)deployedApplication).appInfo.path, (Throwable)e);
                    }
                } else {
                    LOGGER.error("appinfo is null for " + deployedApplication);
                }
                iterator.remove();
            }
            File appBase = this.appBase(standardHost);
            File[] files = appBase.listFiles();
            if (null != files) {
                for (File file : files) {
                    String name;
                    if (file.getName().endsWith(".tmp") || (name = file.getName()).toLowerCase().endsWith(".war") || TomcatWebAppBuilder.isRoot(name) || name.equalsIgnoreCase("META-INF") || name.equalsIgnoreCase("WEB-INF") || name.toLowerCase().equals(".ds_store") || file.isDirectory() && new File(file, "WEB-INF").exists() || file.isDirectory() && (new File(file.getParent(), file.getName() + ".ear").exists() || new File(file.getParent(), file.getName() + ".war").exists() || new File(file.getParent(), file.getName() + ".rar").exists()) || this.isDeployed(file, standardHost)) continue;
                    try {
                        ContainerBase context;
                        file = file.getCanonicalFile().getAbsoluteFile();
                        AppModule appModule = this.deploymentLoader.load(file, null);
                        if (appModule.getDeploymentModule().size() == 1 && appModule.getWebModules().size() == 1) {
                            WebModule webModule = (WebModule)appModule.getWebModules().iterator().next();
                            if (file.getAbsolutePath().equals(webModule.getJarLocation())) continue;
                        }
                        for (WebModule webModule : appModule.getWebModules()) {
                            webModule.setHost(standardHost.getName());
                        }
                        AppInfo appInfo = this.configurationFactory.configureApplication(appModule);
                        if (file.isFile() && file.getName().toLowerCase().endsWith(".ear")) {
                            appInfo.properties.setProperty("tomcat.unpackWar", "false");
                        }
                        if (file.isDirectory() && (context = (ContainerBase)standardHost.findChild("/" + name)) != null) {
                            try {
                                standardHost.removeChild((Container)context);
                            }
                            catch (Throwable t) {
                                LOGGER.warning("Error undeploying wep application from Tomcat  " + name, t);
                            }
                            try {
                                context.destroy();
                            }
                            catch (Throwable t) {
                                LOGGER.warning("Error destroying Tomcat web context " + name, t);
                            }
                        }
                        this.getAssembler().createApplication(appInfo);
                        this.deployedApps.put(file.getAbsolutePath(), new DeployedApplication(file, appInfo));
                    }
                    catch (Throwable e) {
                        LOGGER.warning("Error deploying application " + file.getAbsolutePath(), e);
                    }
                }
            }
        }
    }

    private boolean isDeployed(File file, StandardHost standardHost) {
        if (this.deployedApps.containsKey(file.getAbsolutePath())) {
            return true;
        }
        String name = "/" + file.getName();
        if (TomcatWebAppBuilder.isRoot(name)) {
            name = "";
        }
        return file.exists() && standardHost.findChild(name) != null;
    }

    protected File appBase(StandardHost standardHost) {
        File file = new File(standardHost.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), standardHost.getAppBase());
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return file;
    }

    private AppModule loadApplication(StandardContext standardContext) {
        AppModule appModule;
        String id = standardContext.getName();
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        TomcatDeploymentLoader tomcatDeploymentLoader = new TomcatDeploymentLoader(standardContext, id);
        try {
            appModule = tomcatDeploymentLoader.load(Contexts.warPath((org.apache.catalina.Context)standardContext), TomcatWebAppBuilder.configuredClasspath(standardContext));
        }
        catch (OpenEJBException e) {
            throw new TomEERuntimeException(e);
        }
        this.loadWebModule(appModule, standardContext);
        return appModule;
    }

    private static DeploymentLoader.ExternalConfiguration configuredClasspath(StandardContext standardContext) {
        Loader loader = standardContext.getLoader();
        if (loader != null && LazyStopLoader.class.isInstance(loader)) {
            loader = ((LazyStopLoader)LazyStopLoader.class.cast(loader)).getDelegateLoader();
        }
        if (loader != null) {
            ClassLoader cl = standardContext.getLoader().getClassLoader();
            if (cl == null) {
                return null;
            }
            LinkedList<String> cp = new LinkedList<String>();
            WebResourceRoot webResources = standardContext.getResources();
            if (webResources != null) {
                Iterator iterator = Arrays.asList(webResources.getPreResources(), webResources.getPostResources(), webResources.getJarResources()).iterator();
                while (iterator.hasNext()) {
                    WebResourceSet[] sets;
                    for (WebResourceSet wr : sets = (WebResourceSet[])iterator.next()) {
                        URL base = wr.getBaseUrl();
                        if (base == null) continue;
                        File baseFile = URLs.toFile((URL)base);
                        if (baseFile.isDirectory()) {
                            String path;
                            WebResource classes;
                            String[] libs = wr.list("/WEB-INF/lib/");
                            if (libs != null) {
                                for (String resource : libs) {
                                    cp.add(new File(baseFile, resource).getAbsolutePath());
                                }
                            }
                            if ((classes = wr.getResource("/WEB-INF/classes/")) == null || (path = classes.getCanonicalPath()) == null) continue;
                            cp.add(path);
                            continue;
                        }
                        if (!baseFile.exists() || !baseFile.getName().endsWith(".jar") || !wr.getResource("/WEB-INF/classes/").exists()) continue;
                        try {
                            cp.add(baseFile.getCanonicalPath());
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }
            }
            if (!cp.isEmpty()) {
                return new DeploymentLoader.ExternalConfiguration(cp.toArray(new String[cp.size()]), null);
            }
        }
        return null;
    }

    private void loadWebModule(AppModule appModule, StandardContext standardContext) {
        String name;
        List webModules = appModule.getWebModules();
        if (webModules.isEmpty()) {
            File file = appModule.getFile();
            LOGGER.error("Failed to find a single module in: " + file);
            return;
        }
        WebModule webModule = (WebModule)webModules.get(0);
        WebApp webApp = webModule.getWebApp();
        String path = standardContext.getPath();
        LOGGER.debug("context path = " + path);
        webModule.setHost(Contexts.getHostname(standardContext));
        NamingResourcesImpl naming = standardContext.getNamingResources();
        for (ContextEnvironment contextEnvironment : naming.findEnvironments()) {
            EnvEntry envEntry = (EnvEntry)webApp.getEnvEntryMap().get(contextEnvironment.getName());
            if (envEntry == null) {
                envEntry = new EnvEntry();
                envEntry.setName(contextEnvironment.getName());
                webApp.getEnvEntry().add(envEntry);
            }
            envEntry.setEnvEntryValue(contextEnvironment.getValue());
            envEntry.setEnvEntryType(contextEnvironment.getType());
        }
        for (ContextEnvironment contextEnvironment : naming.findResources()) {
            name = contextEnvironment.getName();
            this.removeRef(webApp, name);
        }
        for (ContextEnvironment contextEnvironment : naming.findResourceLinks()) {
            name = contextEnvironment.getName();
            this.removeRef(webApp, name);
        }
        for (ContextEnvironment contextEnvironment : naming.findEnvironments()) {
            if (contextEnvironment.getOverride()) continue;
            webApp.getEnvEntryMap().remove(contextEnvironment.getName());
        }
    }

    private void removeRef(WebApp webApp, String name) {
        webApp.getEnvEntryMap().remove(name);
        webApp.getEjbRefMap().remove(name);
        webApp.getEjbLocalRefMap().remove(name);
        webApp.getMessageDestinationRefMap().remove(name);
        webApp.getPersistenceContextRefMap().remove(name);
        webApp.getPersistenceUnitRefMap().remove(name);
        webApp.getResourceRefMap().remove(name);
        webApp.getResourceEnvRefMap().remove(name);
    }

    private void safeBind(Context comp, String name, Object value) {
        try {
            comp.lookup(name);
            LOGGER.debug(name + " already bound, ignoring");
        }
        catch (Exception e) {
            try {
                comp.bind(name, value);
            }
            catch (NamingException ne) {
                LOGGER.error("Error in safeBind method", (Throwable)e);
            }
        }
    }

    private Assembler getAssembler() {
        if (this.assembler == null) {
            this.assembler = (Assembler)SystemInstance.get().getComponent(org.apache.openejb.spi.Assembler.class);
        }
        return this.assembler;
    }

    private CoreContainerSystem getContainerSystem() {
        if (this.containerSystem == null) {
            this.containerSystem = (CoreContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        }
        return this.containerSystem;
    }

    private String getId(StandardContext standardContext) {
        return this.getId(Contexts.getHostname(standardContext), standardContext.getPath(), standardContext.getWebappVersion());
    }

    private String getId(String host, String context, String version) {
        String contextRoot = context;
        if (TomcatWebAppBuilder.isRoot(contextRoot)) {
            contextRoot = "";
        }
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        return (host == null ? this.hosts.getDefaultHost() : host) + contextRoot + (version == null || version.isEmpty() ? "" : (version.startsWith("##") ? version : "##" + version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextInfo getContextInfo(StandardContext standardContext) {
        ContextInfo value;
        String id = this.getId(standardContext);
        Map<String, ContextInfo> map = this.infos;
        synchronized (map) {
            value = this.infos.get(id);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ContextInfo getContextInfo(String webAppHost, String webAppContextRoot, String version) {
        ContextInfo value;
        String host = webAppHost;
        if (host == null) {
            host = this.hosts.getDefaultHost();
        }
        String id = this.getId(host, webAppContextRoot, version);
        Map<String, ContextInfo> map = this.infos;
        synchronized (map) {
            value = this.infos.get(id);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextInfo addContextInfo(String host, StandardContext standardContext) {
        ContextInfo contextInfo;
        String contextRoot = standardContext.getName();
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        String id = host + contextRoot;
        Map<String, ContextInfo> map = this.infos;
        synchronized (map) {
            contextInfo = this.infos.get(id);
            if (contextInfo == null) {
                contextInfo = new ContextInfo();
                String webappVersion = standardContext.getWebappVersion();
                contextInfo.version = webappVersion != null && !webappVersion.isEmpty() ? "##" + webappVersion : webappVersion;
                contextInfo.standardContext = standardContext;
                this.infos.put(id, contextInfo);
            }
        }
        return contextInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContextInfo(StandardContext standardContext) {
        boolean found = false;
        Map<String, ContextInfo> map = this.infos;
        synchronized (map) {
            Iterator<Map.Entry<String, ContextInfo>> info = this.infos.entrySet().iterator();
            while (info.hasNext()) {
                if (info.next().getValue().standardContext != standardContext) continue;
                info.remove();
                found = true;
                break;
            }
        }
        if (!found) {
            String id = this.getId(standardContext);
            Map<String, ContextInfo> map2 = this.infos;
            synchronized (map2) {
                this.infos.remove(id);
            }
        }
    }

    public Map<ClassLoader, Map<String, Set<String>>> getJsfClasses() {
        return this.jsfClasses;
    }

    public ClassLoader getParentClassLoader(ClassLoader fallback) {
        return null != this.parentClassLoader ? this.parentClassLoader : fallback;
    }

    public Map<String, Realm> getRealms() {
        return this.realms;
    }

    public Map<ClassLoader, InstanceManager> getInstanceManagers() {
        return this.instanceManagers;
    }

    static {
        try {
            GET_NAMING_CONTEXT_NAME = StandardContext.class.getDeclaredMethod("getNamingContextName", new Class[0]);
            GET_NAMING_CONTEXT_NAME.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new OpenEJBRuntimeException("can't find method getNamingContextName", (Throwable)e);
        }
        HOST_CONFIG_HOST = new AtomicReference<Object>(null);
        try {
            HOST_CONFIG_HOST.set(HostConfig.class.getDeclaredField("host"));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private static class DeployedApplication {
        private final AppInfo appInfo;
        private final Map<File, Long> watchedResource = new HashMap<File, Long>();

        public DeployedApplication(File base, AppInfo appInfo) {
            this.appInfo = appInfo;
            this.watchedResource.put(base, base.lastModified());
            if (appInfo != null) {
                File file;
                for (String resource : appInfo.watchedResources) {
                    File file2 = new File(resource);
                    this.watchedResource.put(file2, file2.lastModified());
                }
                for (EjbJarInfo info : appInfo.ejbJars) {
                    for (String resource : info.watchedResources) {
                        file = new File(resource);
                        this.watchedResource.put(file, file.lastModified());
                    }
                }
                for (EjbJarInfo info : appInfo.webApps) {
                    for (String resource : info.watchedResources) {
                        file = new File(resource);
                        this.watchedResource.put(file, file.lastModified());
                    }
                }
                for (EjbJarInfo info : appInfo.connectors) {
                    for (String resource : info.watchedResources) {
                        file = new File(resource);
                        this.watchedResource.put(file, file.lastModified());
                    }
                }
            }
        }

        public boolean isModified() {
            for (Map.Entry<File, Long> entry : this.watchedResource.entrySet()) {
                File file = entry.getKey();
                long lastModified = entry.getValue();
                if ((file.exists() || lastModified == 0L) && file.lastModified() == lastModified) continue;
                return true;
            }
            return false;
        }
    }

    public static class ContextInfo {
        public AppInfo appInfo;
        public StandardContext standardContext;
        public HostConfig deployer;
        public Host host;
        public EjbModule module;
        public String version;
        public Collection<String> resourceNames = Collections.emptyList();

        public String toString() {
            return "ContextInfo{appInfo = " + this.appInfo + ", deployer = " + this.deployer + ", host = " + this.host + "}";
        }
    }

    public class StandardContextInfo {
        private final StandardContext standardContext;

        public StandardContextInfo(StandardContext standardContext) {
            this.standardContext = standardContext;
            if (standardContext == null) {
                Throwable throwable = new Exception("StandardContext is null").fillInStackTrace();
                LOGGER.warning("StandardContext should not be null", throwable);
            }
        }

        public AppInfo app() {
            ContextInfo contextInfo = TomcatWebAppBuilder.this.getContextInfo(this.standardContext);
            if (contextInfo == null) {
                LOGGER.debug("No ContextInfo for StandardContext " + this.standardContext.getName());
                return null;
            }
            return contextInfo.appInfo;
        }

        public WebAppInfo get() {
            if (this.standardContext == null) {
                return null;
            }
            ContextInfo contextInfo = TomcatWebAppBuilder.this.getContextInfo(this.standardContext);
            if (contextInfo == null) {
                LOGGER.debug("No ContextInfo for StandardContext " + this.standardContext.getName());
                return null;
            }
            LOGGER.debug("contextInfo = " + contextInfo);
            LOGGER.debug("standardContext = " + this.standardContext);
            if (contextInfo.appInfo == null) {
                LOGGER.debug("ContextInfo has no AppInfo for StandardContext " + this.standardContext.getName());
                return null;
            }
            String id = TomcatWebAppBuilder.this.getId(this.standardContext);
            for (WebAppInfo webApp : contextInfo.appInfo.webApps) {
                if (webApp == null) {
                    LOGGER.debug("ContextInfo.appInfo.webApps entry is null StandardContext " + this.standardContext.getName());
                    continue;
                }
                String wId = TomcatWebAppBuilder.this.getId(webApp.host, webApp.contextRoot, contextInfo.version);
                if (!id.equals(wId)) continue;
                return webApp;
            }
            return null;
        }

        public ClassLoader loader() {
            if (this.standardContext != null && this.standardContext.getLoader() != null) {
                return this.standardContext.getLoader().getClassLoader();
            }
            return null;
        }

        public String toString() {
            if (this.standardContext == null) {
                return super.toString();
            }
            return "StandardContextInfo{standardContext=" + this.standardContext + '}';
        }
    }
}

