/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.JAASRealm;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.PropertyPlaceHolderHelper;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;
import org.apache.tomee.embedded.LifecycleTask;
import org.apache.tomee.embedded.LoginConfigBuilder;
import org.apache.tomee.embedded.SecurityConstaintBuilder;
import org.apache.tomee.embedded.component.TomEEEmbeddedArgs;
import org.apache.xbean.finder.filter.Filter;

public class Main {
    public static final String PORT = "port";
    public static final String SHUTDOWN = "shutdown";
    public static final String HOST = "host";
    public static final String PATH = "path";
    public static final String CONTEXT = "context";
    public static final String DIRECTORY = "directory";
    public static final String DOC_BASE = "doc-base";
    public static final String AS_WAR = "as-war";
    public static final String RENAMING = "renaming";
    public static final String SERVER_XML = "serverxml";
    public static final String TOMEE_XML = "tomeexml";
    public static final String PROPERTY = "property";
    public static final String SINGLE_CLASSLOADER = "single-classloader";
    public static final String QUICK_SESSION = "quick-session";
    public static final String SKIP_HTTP = "skip-http";
    public static final String HTTPS_PORT = "https-port";
    public static final String SSL = "ssl";
    public static final String KEYSTORE_FILE = "keystore";
    public static final String KEYSTORE_PASS = "keystore-pass";
    public static final String KEYSTORE_TYPE = "keystore-type";
    public static final String CLIENT_AUTH = "client-auth";
    public static final String KEY_ALIAS = "key-alias";
    public static final String SSL_PROTOCOL = "ssl-protocol";
    public static final String WEB_XML = "web-xml";
    public static final String JAAS_CONFIG = "jaas";
    public static final String CACHE_WEB_RESOURCES = "cache-web-resources";
    public static final String BASIC = "basic";
    public static final String SIMPLE_LOG = "simple-log";
    public static final String PRE_TASK = "pre-task";
    public static final String INTERACTIVE = "interactive";
    public static final String CONFIGURATION = "configuration-location";
    public static final String CLASSES_FILTER = "classes-filter";
    public static final String HELP = "help";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        CommandLine line;
        PosixParser parser = new PosixParser();
        Options options = Main.createOptions();
        try {
            line = parser.parse(options, args, true);
        }
        catch (ParseException exp) {
            Main.help(options);
            return;
        }
        if (line.hasOption(HELP)) {
            Main.help(options);
            return;
        }
        final ArrayList<Closeable> post = new ArrayList<Closeable>();
        for (LifecycleTask lifecycleTask : ServiceLoader.load(LifecycleTask.class)) {
            Closeable closeable = lifecycleTask.beforeContainerStartup();
            if (closeable == null) continue;
            post.add(closeable);
        }
        if (line.hasOption(PRE_TASK)) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (String string : line.getOptionValues(PRE_TASK)) {
                Object task;
                try {
                    task = loader.loadClass(string).newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
                if (Runnable.class.isInstance(task)) {
                    ((Runnable)Runnable.class.cast(task)).run();
                    continue;
                }
                if (LifecycleTask.class.isInstance(task)) {
                    Closeable closeable = ((LifecycleTask)LifecycleTask.class.cast(task)).beforeContainerStartup();
                    if (closeable == null) continue;
                    post.add(closeable);
                    continue;
                }
                throw new IllegalArgumentException(String.valueOf(task) + " can't be executed");
            }
        }
        try {
            boolean autoWar;
            void var6_13;
            final Container container = new Container(Main.createConfiguration(line));
            if (line.hasOption(CONTEXT)) {
                String[] stringArray = line.getOptionValues(CONTEXT);
            } else {
                Object var6_12 = null;
            }
            SystemInstance.get().setComponent(TomEEEmbeddedArgs.class, (Object)new TomEEEmbeddedArgs(args, line));
            if (line.hasOption(PATH)) {
                int i = 0;
                for (String path : line.getOptionValues(PATH)) {
                    Set locations = ProvisioningUtil.realLocation((String)path);
                    for (String location : locations) {
                        File file = new File(location);
                        if (!file.exists()) {
                            System.err.println(file.getAbsolutePath() + " does not exist, skipping");
                            continue;
                        }
                        String name = file.getName().replaceAll("\\.[A-Za-z]+$", "");
                        if (var6_13 != null) {
                            name = var6_13[i++];
                        }
                        container.deploy(name, file, true);
                    }
                }
                autoWar = false;
            } else if (line.hasOption(AS_WAR)) {
                Main.deployClasspath(line, container, (String[])var6_13);
                autoWar = false;
            } else {
                autoWar = true;
            }
            if (autoWar) {
                File me = JarLocation.jarLocation(Main.class);
                if (me.getName().endsWith(".war")) {
                    container.deploy((String)(var6_13 == null || 0 == ((void)var6_13).length ? "" : var6_13[0]), me, line.hasOption(RENAMING));
                } else {
                    Main.deployClasspath(line, container, (String[])var6_13);
                }
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        container.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        Main.close(post);
                    }
                }
            });
            if (line.hasOption(INTERACTIVE)) {
                String l;
                Scanner scanner = new Scanner(System.in);
                while ((l = scanner.nextLine()) != null) {
                    switch (l.trim()) {
                        case "quit": 
                        case "exit": {
                            return;
                        }
                    }
                    System.out.println("Unknown command '" + l + "', supported commands: 'quit', 'exit'");
                }
            }
            container.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Main.close(post);
        }
    }

    private static void help(Options options) {
        new HelpFormatter().printHelp("java -jar tomee-embedded-user.jar", options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(Collection<Closeable> post) {
        Collection<Closeable> collection = post;
        synchronized (collection) {
            for (Closeable p : post) {
                try {
                    p.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            post.clear();
        }
    }

    private static void deployClasspath(CommandLine line, Container container, String[] contexts) {
        container.deployClasspathAsWebApp(contexts == null || 0 == contexts.length ? "" : contexts[0], line.hasOption(DOC_BASE) ? new File(line.getOptionValue(DOC_BASE)) : null, line.hasOption(SINGLE_CLASSLOADER));
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(null, PATH, true, "");
        options.addOption(null, CONTEXT, true, "Context name for applications (same order than paths)");
        options.addOption("p", PORT, true, "TomEE http port");
        options.addOption("s", SHUTDOWN, true, "TomEE shutdown port");
        options.addOption("d", DIRECTORY, true, "TomEE directory");
        options.addOption("c", AS_WAR, false, "deploy classpath as war");
        options.addOption("b", DOC_BASE, true, "when deploy classpath as war, the doc base");
        options.addOption(null, RENAMING, true, "for fat war only, is renaming of the context supported");
        options.addOption(null, SERVER_XML, true, "the server.xml path");
        options.addOption(null, TOMEE_XML, true, "the tomee.xml path");
        options.addOption(null, PROPERTY, true, "some container properties");
        options.addOption(null, HOST, true, "server host");
        options.addOption(null, QUICK_SESSION, true, "use a quick session - it uses Random instead of SecureRandom");
        options.addOption(null, SKIP_HTTP, true, "should http connector be ignored");
        options.addOption(null, HTTPS_PORT, true, "the https port if needed");
        options.addOption(null, SSL, true, "Is https enabled");
        options.addOption(null, KEYSTORE_FILE, true, "the https keystore");
        options.addOption(null, KEYSTORE_PASS, true, "the https keystore password (can use cipher:xxx)");
        options.addOption(null, KEYSTORE_TYPE, true, "the https keystore type");
        options.addOption(null, CLIENT_AUTH, true, "is client_auth used");
        options.addOption(null, KEY_ALIAS, true, "the https key alias");
        options.addOption(null, SSL_PROTOCOL, true, "the https SSL protocols");
        options.addOption(null, WEB_XML, true, "override global web.xml");
        options.addOption(null, JAAS_CONFIG, true, "forces tomee to use JAAS with the set config");
        options.addOption(null, CACHE_WEB_RESOURCES, true, "should web resources be cached");
        options.addOption(null, BASIC, true, "basic authentication if set");
        options.addOption(null, SIMPLE_LOG, false, "should tomee use simple log format (level - message) - demo intended");
        options.addOption("i", INTERACTIVE, false, "should tomee start and wait for SIGTERM signal or wait for 'exit' to be entered");
        options.addOption(null, CONFIGURATION, true, "a properties file containing the configuration to load");
        options.addOption(null, SINGLE_CLASSLOADER, false, "if the application should use the same classloader as the boot one");
        options.addOption(null, CLASSES_FILTER, true, "A custom implementation of a xbean filter to exclude classes to not scan");
        options.addOption("h", HELP, false, "show help");
        return options;
    }

    private static Configuration createConfiguration(CommandLine args) {
        Configuration config = new Configuration();
        if (args.hasOption(CONFIGURATION)) {
            config.loadFrom(args.getOptionValue(CONFIGURATION));
        }
        config.setHttpPort(Integer.parseInt(args.getOptionValue(PORT, Integer.toString(config.getHttpPort()))));
        config.setStopPort(Integer.parseInt(args.getOptionValue(SHUTDOWN, Integer.toString(config.getHttpsPort()))));
        config.setDir(args.getOptionValue(DIRECTORY, config.getDir() == null ? new File(new File("."), "apache-tomee").getAbsolutePath() : config.getDir()));
        if (args.hasOption(SERVER_XML)) {
            config.setServerXml(args.getOptionValue(SERVER_XML));
        }
        if (args.hasOption(WEB_XML)) {
            config.setWebXml(args.getOptionValue(WEB_XML));
        }
        if (args.hasOption(TOMEE_XML)) {
            config.property("openejb.conf.file", args.getOptionValue(TOMEE_XML));
        }
        if (args.hasOption(SIMPLE_LOG)) {
            config.property("openejb.jul.forceReload", "true");
        }
        if (args.hasOption(CLASSES_FILTER)) {
            try {
                config.classesFilter((Filter)Filter.class.cast(Thread.currentThread().getContextClassLoader().loadClass(args.getOptionValue(CLASSES_FILTER)).newInstance()));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (args.hasOption(PROPERTY)) {
            for (String opt : args.getOptionValues(PROPERTY)) {
                int sep = opt.indexOf(61);
                if (sep > 0) {
                    config.property(opt.substring(0, sep), opt.substring(sep + 1));
                    continue;
                }
                config.property(opt, "true");
            }
        }
        if (args.hasOption(JAAS_CONFIG)) {
            String jaas = args.getOptionValue(JAAS_CONFIG);
            final File file = new File(jaas);
            System.setProperty("java.security.auth.login.config", file.getAbsolutePath());
            JAASRealm realm = new JAASRealm(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected javax.security.auth.login.Configuration getConfig() {
                    try {
                        if (this.jaasConfigurationLoaded) {
                            return this.jaasConfiguration;
                        }
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            javax.security.auth.login.Configuration config;
                            if (this.configFile == null) {
                                this.jaasConfigurationLoaded = true;
                                return null;
                            }
                            this.configFile = file.getAbsolutePath();
                            Class<?> sunConfigFile = Class.forName("com.sun.security.auth.login.ConfigFile");
                            Constructor<?> constructor = sunConfigFile.getConstructor(URI.class);
                            this.jaasConfiguration = config = (javax.security.auth.login.Configuration)javax.security.auth.login.Configuration.class.cast(constructor.newInstance(file.toURI()));
                            this.jaasConfigurationLoaded = true;
                            return this.jaasConfiguration;
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
            realm.setAppName("application");
            realm.setConfigFile(new File(jaas).getAbsolutePath());
            config.setRealm((Realm)realm);
        }
        if (args.hasOption(BASIC)) {
            config.loginConfig(new LoginConfigBuilder().basic().realmName(System.getProperty("tomee.embedded.main.basic.realm", "Security")));
            config.securityConstaint(new SecurityConstaintBuilder().authConstraint(true).addAuthRole(System.getProperty("tomee.embedded.main.basic.role", "*")).addCollection("Basic", System.getProperty("tomee.embedded.main.basic.pattern", "/*"), new String[0]).displayName(System.getProperty("tomee.embedded.main.basic.display-name", "Basic security")));
        }
        if (args.hasOption(CACHE_WEB_RESOURCES)) {
            config.setWebResourceCached(Boolean.parseBoolean(args.getOptionValue(CACHE_WEB_RESOURCES)));
        }
        if (args.hasOption(SSL_PROTOCOL)) {
            config.setSslProtocol(args.getOptionValue(SSL_PROTOCOL));
        }
        if (args.hasOption(KEY_ALIAS)) {
            config.setKeyAlias(args.getOptionValue(KEY_ALIAS));
        }
        if (args.hasOption(KEYSTORE_TYPE)) {
            config.setKeystoreType(args.getOptionValue(KEYSTORE_TYPE));
        }
        if (args.hasOption(KEYSTORE_PASS)) {
            config.setKeystorePass(PropertyPlaceHolderHelper.simpleValue((String)args.getOptionValue(KEYSTORE_PASS)));
        }
        if (args.hasOption(KEYSTORE_FILE)) {
            config.setKeystoreFile(args.getOptionValue(KEYSTORE_FILE));
        }
        if (args.hasOption(SSL)) {
            config.setSsl(Boolean.parseBoolean(args.getOptionValue(SSL)));
        }
        if (args.hasOption(HTTPS_PORT)) {
            config.setHttpsPort(Integer.parseInt(args.getOptionValue(HTTPS_PORT)));
        }
        if (args.hasOption(SKIP_HTTP)) {
            config.setSkipHttp(Boolean.parseBoolean(args.getOptionValue(SKIP_HTTP)));
        }
        if (args.hasOption(QUICK_SESSION)) {
            config.setQuickSession(Boolean.parseBoolean(args.getOptionValue(QUICK_SESSION)));
        }
        return config;
    }
}

