/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class QuickServerXmlParser
extends DefaultHandler {
    private static final SAXParserFactory FACTORY = SAXParserFactory.newInstance();
    private static final String STOP_KEY = "STOP";
    private static final String HTTP_KEY = "HTTP";
    private static final String SECURED_SUFFIX = "S";
    private static final String AJP_KEY = "AJP";
    private static final String HOST_KEY = "host";
    private static final String APP_BASE_KEY = "app-base";
    private static final String DEFAULT_CONNECTOR_KEY = "HTTP";
    private static final String KEYSTORE_KEY = "keystoreFile";
    public static final String DEFAULT_HTTP_PORT = "8080";
    public static final String DEFAULT_HTTPS_PORT = "8443";
    public static final String DEFAULT_STOP_PORT = "8005";
    public static final String DEFAULT_AJP_PORT = "8009";
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_APP_BASE = "webapps";
    public static final String DEFAULT_KEYSTORE;
    private final Map<String, String> values = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public QuickServerXmlParser() {
        this(true);
    }

    public QuickServerXmlParser(boolean useDefaults) {
        if (useDefaults) {
            this.values.put(STOP_KEY, DEFAULT_STOP_PORT);
            this.values.put("HTTP", DEFAULT_HTTP_PORT);
            this.values.put(AJP_KEY, DEFAULT_AJP_PORT);
            this.values.put(HOST_KEY, DEFAULT_HOST);
            this.values.put(APP_BASE_KEY, DEFAULT_APP_BASE);
            this.values.put(KEYSTORE_KEY, DEFAULT_KEYSTORE);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("Server".equalsIgnoreCase(localName)) {
            String port = attributes.getValue("port");
            if (port != null) {
                this.values.put(STOP_KEY, port);
            } else {
                this.values.put(STOP_KEY, DEFAULT_STOP_PORT);
            }
        } else if ("Connector".equalsIgnoreCase(localName)) {
            String protocol = attributes.getValue("protocol");
            if (protocol == null) {
                protocol = "HTTP";
            } else if (protocol.contains("/")) {
                protocol = protocol.substring(0, protocol.indexOf("/"));
            }
            String port = attributes.getValue("port");
            String ssl = attributes.getValue("secure");
            if (ssl == null || "false".equalsIgnoreCase(ssl)) {
                this.values.put(protocol.toUpperCase(), port);
            } else {
                this.values.put(protocol.toUpperCase() + SECURED_SUFFIX, port);
            }
            String keystore = attributes.getValue(KEYSTORE_KEY);
            if (null != keystore) {
                this.values.put(KEYSTORE_KEY, keystore);
            }
        } else if ("Host".equalsIgnoreCase(localName)) {
            String appBase;
            String host = attributes.getValue("name");
            if (host != null) {
                this.values.put(HOST_KEY, host);
            }
            if ((appBase = attributes.getValue("appBase")) != null) {
                this.values.put(APP_BASE_KEY, appBase);
            }
        }
    }

    public static QuickServerXmlParser parse(File serverXml) {
        return QuickServerXmlParser.parse(serverXml, true);
    }

    public static QuickServerXmlParser parse(File serverXml, boolean defaults) {
        QuickServerXmlParser handler = new QuickServerXmlParser(defaults);
        try {
            SAXParser parser = FACTORY.newSAXParser();
            parser.parse(serverXml, (DefaultHandler)handler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler;
    }

    public static QuickServerXmlParser parse(String serverXmlContents) {
        QuickServerXmlParser handler = new QuickServerXmlParser();
        try {
            SAXParser parser = FACTORY.newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(serverXmlContents.getBytes()), (DefaultHandler)handler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler;
    }

    public String http() {
        return this.value("HTTP", DEFAULT_HTTP_PORT);
    }

    public String https() {
        return this.securedValue("HTTP", DEFAULT_HTTPS_PORT);
    }

    public String ajp() {
        return this.value(AJP_KEY, DEFAULT_AJP_PORT);
    }

    public String stop() {
        return this.value(STOP_KEY, DEFAULT_STOP_PORT);
    }

    public String appBase() {
        return this.value(APP_BASE_KEY, DEFAULT_APP_BASE);
    }

    public String host() {
        return this.value(HOST_KEY, DEFAULT_HOST);
    }

    public String keystore() {
        return this.value(KEYSTORE_KEY, DEFAULT_KEYSTORE);
    }

    public String value(String key, String defaultValue) {
        String val = this.values.get(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public String securedValue(String key, String defaultValue) {
        return this.value(key + SECURED_SUFFIX, defaultValue);
    }

    public String toString() {
        return "QuickServerXmlParser: " + this.values;
    }

    static {
        FACTORY.setNamespaceAware(true);
        FACTORY.setValidating(false);
        DEFAULT_KEYSTORE = null;
    }
}

