/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.helper;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;

public class TypeTable {
    public static final String XML_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String XS_URI_PREFIX = "xs";
    public static final QName XS_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "schema", "xs");
    public static final String DELIMITER = "#";
    private Hashtable simpleXSDTypes = new Hashtable();
    private Hashtable complexXSDTypes = new Hashtable();
    private Hashtable xsdTypeDefs = new Hashtable();

    public static String asQualifiedName(String uri, String typeName) {
        return uri + DELIMITER + typeName;
    }

    public TypeTable() {
        this.populateSimpleXSDTypes();
        this.populateStdSDOTypes();
    }

    private void populateStdSDOTypes() {
        this.simpleXSDTypes.put("Boolean", new QName(XML_SCHEMA_URI, "boolean", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Byte", new QName(XML_SCHEMA_URI, "byte", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Bytes", new QName(XML_SCHEMA_URI, "hexBinary", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Character", new QName(XML_SCHEMA_URI, "string", XS_URI_PREFIX));
        this.simpleXSDTypes.put("DataObject", new QName(XML_SCHEMA_URI, "anyType", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Date", new QName(XML_SCHEMA_URI, "dateTime", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Day", new QName(XML_SCHEMA_URI, "gDay", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Decimal", new QName(XML_SCHEMA_URI, "decimal", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Double", new QName(XML_SCHEMA_URI, "double", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Duration", new QName(XML_SCHEMA_URI, "duration", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Float", new QName(XML_SCHEMA_URI, "float", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Int", new QName(XML_SCHEMA_URI, "int", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Integer", new QName(XML_SCHEMA_URI, "integer", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Long", new QName(XML_SCHEMA_URI, "long", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Month", new QName(XML_SCHEMA_URI, "gMonth", XS_URI_PREFIX));
        this.simpleXSDTypes.put("monthDay", new QName(XML_SCHEMA_URI, "gMonthDay", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Object", new QName(XML_SCHEMA_URI, "anySimpleType", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Short", new QName(XML_SCHEMA_URI, "short", XS_URI_PREFIX));
        this.simpleXSDTypes.put("String", new QName(XML_SCHEMA_URI, "string", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Strings", new QName(XML_SCHEMA_URI, "string", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Time", new QName(XML_SCHEMA_URI, "time", XS_URI_PREFIX));
        this.simpleXSDTypes.put("Year", new QName(XML_SCHEMA_URI, "gYear", XS_URI_PREFIX));
        this.simpleXSDTypes.put("YearMonth", new QName(XML_SCHEMA_URI, "gYearMonth", XS_URI_PREFIX));
        this.simpleXSDTypes.put("YearMonthDay", new QName(XML_SCHEMA_URI, "date", XS_URI_PREFIX));
        this.simpleXSDTypes.put("URI", new QName(XML_SCHEMA_URI, "anyURI", XS_URI_PREFIX));
    }

    private void populateSimpleXSDTypes() {
        this.simpleXSDTypes.put("int", new QName(XML_SCHEMA_URI, "int", XS_URI_PREFIX));
        this.simpleXSDTypes.put("java.lang.String", new QName(XML_SCHEMA_URI, "string", XS_URI_PREFIX));
        this.simpleXSDTypes.put("boolean", new QName(XML_SCHEMA_URI, "boolean", XS_URI_PREFIX));
        this.simpleXSDTypes.put("float", new QName(XML_SCHEMA_URI, "float", XS_URI_PREFIX));
        this.simpleXSDTypes.put("double", new QName(XML_SCHEMA_URI, "double", XS_URI_PREFIX));
        this.simpleXSDTypes.put("short", new QName(XML_SCHEMA_URI, "short", XS_URI_PREFIX));
        this.simpleXSDTypes.put("long", new QName(XML_SCHEMA_URI, "long", XS_URI_PREFIX));
        this.simpleXSDTypes.put("byte", new QName(XML_SCHEMA_URI, "byte", XS_URI_PREFIX));
        this.simpleXSDTypes.put("char", new QName(XML_SCHEMA_URI, "anyType", XS_URI_PREFIX));
        this.simpleXSDTypes.put("java.lang.Integer", new QName(XML_SCHEMA_URI, "int", XS_URI_PREFIX));
        this.simpleXSDTypes.put("java.lang.Double", new QName(XML_SCHEMA_URI, "double", XS_URI_PREFIX));
        this.simpleXSDTypes.put("java.lang.Float", new QName(XML_SCHEMA_URI, "float", XS_URI_PREFIX));
        this.simpleXSDTypes.put("java.lang.Long", new QName(XML_SCHEMA_URI, "long", XS_URI_PREFIX));
        this.simpleXSDTypes.put("java.lang.Character", new QName(XML_SCHEMA_URI, "anyType", XS_URI_PREFIX));
        this.simpleXSDTypes.put("java.lang.Boolean", new QName(XML_SCHEMA_URI, "boolean", XS_URI_PREFIX));
        this.simpleXSDTypes.put("java.lang.Byte", new QName(XML_SCHEMA_URI, "byte", XS_URI_PREFIX));
        this.simpleXSDTypes.put("java.lang.Short", new QName(XML_SCHEMA_URI, "short", XS_URI_PREFIX));
        this.simpleXSDTypes.put("java.util.Date", new QName(XML_SCHEMA_URI, "dateTime", XS_URI_PREFIX));
        this.simpleXSDTypes.put("java.util.Calendar", new QName(XML_SCHEMA_URI, "dateTime", XS_URI_PREFIX));
        this.simpleXSDTypes.put("java.lang.Object", new QName(XML_SCHEMA_URI, "anyType", XS_URI_PREFIX));
        this.simpleXSDTypes.put("java.math.BigDecimal", new QName(XML_SCHEMA_URI, "decimal", XS_URI_PREFIX));
        this.simpleXSDTypes.put(Element.class.getName(), new QName(XML_SCHEMA_URI, "anyType", XS_URI_PREFIX));
        this.simpleXSDTypes.put(ArrayList.class.getName(), new QName(XML_SCHEMA_URI, "anyType", XS_URI_PREFIX));
        this.simpleXSDTypes.put(Vector.class.getName(), new QName(XML_SCHEMA_URI, "anyType", XS_URI_PREFIX));
        this.simpleXSDTypes.put(List.class.getName(), new QName(XML_SCHEMA_URI, "anyType", XS_URI_PREFIX));
    }

    public QName getStdSdoType(String typename) {
        return (QName)this.simpleXSDTypes.get(typename);
    }

    public QName getComplexSchemaTypeName(String sdoURI, String sdoTypeName) {
        return (QName)this.complexXSDTypes.get(TypeTable.asQualifiedName(sdoURI, sdoTypeName));
    }

    public boolean isSimpleType(String typeName) {
        Iterator keys = this.simpleXSDTypes.keySet().iterator();
        while (keys.hasNext()) {
            String s = (String)keys.next();
            if (!s.equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public QName getSimpleSchemaTypeName(String typename) {
        return (QName)this.simpleXSDTypes.get(typename);
    }

    public void addSimpleSchemaType(String typeName, QName schemaType) {
        this.simpleXSDTypes.put(typeName, schemaType);
    }

    public void addComplexSchemaType(String namespaceURI, String name, QName schemaType) {
        this.complexXSDTypes.put(TypeTable.asQualifiedName(namespaceURI, name), schemaType);
    }

    public QName getQNamefortheType(String namespaceURI, String typeName) {
        if (XML_SCHEMA_URI.equals(namespaceURI)) {
            return this.getSimpleSchemaTypeName(typeName);
        }
        return this.getComplexSchemaTypeName(namespaceURI, typeName);
    }

    public void addXSDTypeDef(String namespaceURI, String typeName, XSDTypeDefinition aTypeDef) {
        if (namespaceURI != null && typeName != null && aTypeDef != null) {
            this.xsdTypeDefs.put(TypeTable.asQualifiedName(namespaceURI, typeName), aTypeDef);
        }
    }

    public XSDTypeDefinition getXSDTypeDef(String namespaceURI, String typeName) {
        XSDTypeDefinition typeDef = null;
        if (namespaceURI != null && typeName != null) {
            if (XML_SCHEMA_URI.equals(namespaceURI)) {
                typeDef = (XSDTypeDefinition)this.xsdTypeDefs.get(TypeTable.asQualifiedName(namespaceURI, typeName));
                if (typeDef == null) {
                    typeDef = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
                    typeDef.setName(typeName);
                    typeDef.setTargetNamespace(namespaceURI);
                    this.addXSDTypeDef(namespaceURI, typeName, typeDef);
                }
            } else {
                typeDef = (XSDTypeDefinition)this.xsdTypeDefs.get(TypeTable.asQualifiedName(namespaceURI, typeName));
            }
        }
        return typeDef;
    }
}

