/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import commonj.sdo.helper.XMLDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sdo.SimpleAnyTypeDataObject;
import org.apache.tuscany.sdo.util.DataObjectUtil;
import org.apache.tuscany.sdo.util.SDOUtil;
import org.apache.tuscany.sdo.util.resource.SDOXMLResourceImpl;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLDocumentImpl
implements XMLDocument {
    protected ExtendedMetaData extendedMetaData;
    protected EObject rootObject;
    protected XMLResource resource;
    protected EStructuralFeature rootElement;
    protected EObject documentRoot;
    protected static final String WHITESPACE_REGEX = "\\s";

    protected XMLDocumentImpl(ExtendedMetaData extendedMetaData, Object options) {
        Class resourceFactoryClass;
        this.extendedMetaData = extendedMetaData;
        ResourceSet resourceSet = DataObjectUtil.createResourceSet();
        if (options instanceof Map && (resourceFactoryClass = (Class)((Map)options).get("GENERATED_LOADER")) != null) {
            try {
                Object resourceFactory = resourceFactoryClass.newInstance();
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", resourceFactory);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.resource = (XMLResource)resourceSet.createResource(URI.createURI((String)"http:///temp.xml"));
        DataObjectUtil.configureXMLResource(this.resource, extendedMetaData);
    }

    protected XMLDocumentImpl(ExtendedMetaData extendedMetaData) {
        this(extendedMetaData, null);
    }

    protected XMLDocumentImpl(ExtendedMetaData extendedMetaData, DataObject dataObject, String rootElementURI, String rootElementName) {
        this(extendedMetaData);
        this.rootObject = (EObject)dataObject;
        this.rootElement = extendedMetaData.getElement(rootElementURI, rootElementName);
        if (this.rootElement == null) {
            this.rootElement = ExtendedMetaData.INSTANCE.demandFeature(rootElementURI, rootElementName, true);
        }
        EClass documentRootClass = this.rootElement.getEContainingClass();
        this.documentRoot = EcoreUtil.create((EClass)documentRootClass);
        this.resource.getContents().add((Object)this.documentRoot);
    }

    protected void save(OutputStream outputStream, Object options) throws IOException {
        this.save(outputStream, null, options);
    }

    protected void save(Writer outputWriter, Object options) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.save(outputStream, options);
        outputWriter.write(new String(outputStream.toByteArray()));
    }

    protected void save(Node node, Object options) throws IOException {
        this.save(null, (Document)node, options);
    }

    protected void save(OutputStream outputStream, Document document, Object options) throws IOException {
        EObject oldContainer = null;
        Resource oldResource = null;
        EReference oldContainmentReference = null;
        int oldContainmentIndex = -1;
        if (this.documentRoot != null) {
            oldContainer = this.rootObject.eContainer();
            if (oldContainer != null) {
                oldContainmentReference = this.rootObject.eContainmentFeature();
            } else {
                oldResource = this.rootObject.eResource();
            }
            if (oldContainer != this.documentRoot || oldContainmentReference != this.rootElement) {
                if (oldResource != null) {
                    oldContainmentIndex = oldResource.getContents().indexOf((Object)this.rootObject);
                    oldResource.getContents().remove(oldContainmentIndex);
                } else if (oldContainmentReference != null && FeatureMapUtil.isMany((EObject)oldContainer, (EStructuralFeature)oldContainmentReference)) {
                    oldContainmentIndex = ((List)oldContainer.eGet((EStructuralFeature)oldContainmentReference)).indexOf(this.rootObject);
                }
                EObject rootValue = this.rootElement instanceof EAttribute && this.rootObject instanceof SimpleAnyTypeDataObject ? ((SimpleAnyTypeDataObject)this.rootObject).getValue() : this.rootObject;
                this.documentRoot.eSet(this.rootElement, (Object)rootValue);
            }
        }
        if (outputStream != null) {
            this.resource.save(outputStream, (Map)options);
        } else {
            this.resource.save(document, (Map)options, null);
        }
        if (oldResource != null) {
            oldResource.getContents().add(oldContainmentIndex, (Object)this.rootObject);
        }
        if (this.rootElement instanceof EReference) {
            if (oldContainer != null) {
                if (oldContainer != this.documentRoot || oldContainmentReference != this.rootElement) {
                    if (FeatureMapUtil.isMany((EObject)oldContainer, (EStructuralFeature)oldContainmentReference)) {
                        ((List)oldContainer.eGet((EStructuralFeature)oldContainmentReference)).add(oldContainmentIndex, this.rootObject);
                    } else {
                        oldContainer.eSet((EStructuralFeature)oldContainmentReference, (Object)this.rootObject);
                    }
                }
            } else if (this.documentRoot != null) {
                this.documentRoot.eSet(this.rootElement, null);
            }
        }
    }

    protected void load(InputStream inputStream, String locationURI, Object options) throws IOException {
        InputSource inputSource = new InputSource(inputStream);
        this.load(inputSource, locationURI, options);
    }

    protected void load(Reader inputReader, String locationURI, Object options) throws IOException {
        InputSource inputSource = new InputSource(inputReader);
        this.load(inputSource, locationURI, options);
    }

    protected final void load(Node node, Object options) throws IOException {
        this.resource.load(node, (Map)options);
        this.initLoadedRoot();
    }

    protected final void load(XMLStreamReader reader, Map options) throws IOException {
        ((SDOXMLResourceImpl)this.resource).load(reader, options);
        this.initLoadedRoot();
    }

    protected void load(InputSource inputSource, String locationURI, Object options) throws IOException {
        if (locationURI != null) {
            inputSource.setSystemId(locationURI);
            this.resource.setURI(URI.createURI((String)locationURI));
        }
        this.resource.load(inputSource, (Map)options);
        this.initLoadedRoot();
    }

    public Map getUnknownProperties() {
        return this.resource.getEObjectToExtensionMap();
    }

    private void initLoadedRoot() {
        this.rootObject = null;
        this.rootElement = null;
        this.documentRoot = null;
        if (!this.resource.getContents().isEmpty()) {
            this.documentRoot = (EObject)this.resource.getContents().get(0);
            EClass documentRootClass = this.documentRoot.eClass();
            if ("".equals(this.extendedMetaData.getName((EClassifier)documentRootClass))) {
                FeatureMap featureMap = (FeatureMap)this.documentRoot.eGet(documentRootClass.getEStructuralFeature(0));
                int size = featureMap.size();
                for (int index = 0; index < size; ++index) {
                    boolean isText;
                    EStructuralFeature feature = featureMap.getEStructuralFeature(index);
                    boolean bl = isText = feature == XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT || feature == XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__CDATA || feature == XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__COMMENT;
                    if (isText) continue;
                    if (feature instanceof EReference) {
                        this.rootObject = (EObject)featureMap.getValue(index);
                        this.documentRoot.eUnset(feature);
                    } else {
                        this.rootObject = (EObject)SDOUtil.createDataTypeWrapper((Type)feature.getEType(), featureMap.getValue(index));
                    }
                    this.rootElement = feature;
                    break;
                }
                if (this.rootObject == null) {
                    this.rootObject = ((SDOXMLResourceImpl)this.resource).root;
                }
            } else {
                this.rootObject = this.documentRoot;
                this.documentRoot = null;
            }
        }
    }

    public DataObject getRootObject() {
        return (DataObject)this.rootObject;
    }

    public String getRootElementURI() {
        if (this.rootElement != null) {
            return this.extendedMetaData.getNamespace(this.rootElement);
        }
        if (this.rootObject != null) {
            return this.extendedMetaData.getNamespace((EClassifier)this.rootObject.eClass());
        }
        return null;
    }

    public String getRootElementName() {
        if (this.rootElement != null) {
            return this.extendedMetaData.getName(this.rootElement);
        }
        if (this.rootObject != null) {
            return this.extendedMetaData.getName((EClassifier)this.rootObject.eClass());
        }
        return null;
    }

    public String getEncoding() {
        return this.resource.getEncoding();
    }

    public void setEncoding(String encoding) {
        this.resource.setEncoding(encoding);
    }

    public boolean isXMLDeclaration() {
        return Boolean.FALSE.equals(this.resource.getDefaultSaveOptions().get("DECLARE_XML"));
    }

    public void setXMLDeclaration(boolean xmlDeclaration) {
        this.resource.getDefaultSaveOptions().put("DECLARE_XML", xmlDeclaration ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getXMLVersion() {
        return this.resource.getXMLVersion();
    }

    public void setXMLVersion(String xmlVersion) {
        this.resource.setXMLVersion(xmlVersion);
    }

    protected EMap getSchemaLocationMap() {
        EReference xsiSchemaLocationMapFeature;
        EMap result = null;
        if (this.documentRoot != null && this.extendedMetaData != null && (xsiSchemaLocationMapFeature = this.extendedMetaData.getXSISchemaLocationMapFeature(this.documentRoot.eClass())) != null) {
            result = (EMap)this.documentRoot.eGet((EStructuralFeature)xsiSchemaLocationMapFeature);
        }
        return result;
    }

    protected String deresolve(String value) {
        URI deresolvedURI;
        boolean shouldDeresolve;
        URI location = URI.createURI((String)value);
        URI resourceURI = this.resource.getURI();
        boolean bl = shouldDeresolve = resourceURI != null && !resourceURI.isRelative() && resourceURI.isHierarchical();
        if (shouldDeresolve && !location.isRelative() && (deresolvedURI = location.deresolve(resourceURI, true, true, false)).hasRelativePath()) {
            location = deresolvedURI;
        }
        return location.toString();
    }

    protected String resolve(String value) {
        boolean shouldResolve;
        URI location = URI.createURI((String)value);
        URI resourceURI = this.resource.getURI();
        boolean bl = shouldResolve = resourceURI != null && resourceURI.isHierarchical() && !resourceURI.isRelative();
        if (shouldResolve && location.isRelative() && location.hasRelativePath()) {
            location = location.resolve(resourceURI, false);
        }
        return location.toString();
    }

    public String getSchemaLocation() {
        EMap xsiSchemaLocationMap = this.getSchemaLocationMap();
        if (xsiSchemaLocationMap != null && !xsiSchemaLocationMap.isEmpty()) {
            StringBuffer xsiSchemaLocation = new StringBuffer();
            Iterator i = xsiSchemaLocationMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                String namespace = (String)entry.getKey();
                if (namespace == null) continue;
                if (xsiSchemaLocation.length() > 0) {
                    xsiSchemaLocation.append(' ');
                }
                xsiSchemaLocation.append(namespace);
                xsiSchemaLocation.append(' ');
                String value = entry.getValue().toString();
                xsiSchemaLocation.append(this.deresolve(value));
            }
            return xsiSchemaLocation.toString().equals("") ? null : xsiSchemaLocation.toString();
        }
        return null;
    }

    public void setSchemaLocation(String schemaLocation) {
        EMap xsiSchemaLocationMap = this.getSchemaLocationMap();
        if (xsiSchemaLocationMap != null) {
            Iterator i = xsiSchemaLocationMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                if (entry.getKey() == null) continue;
                i.remove();
            }
            if (xsiSchemaLocationMap.size() == 0) {
                this.resource.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.FALSE);
            }
            if (schemaLocation != null) {
                String[] values = schemaLocation.split(WHITESPACE_REGEX);
                for (int i2 = 0; i2 < values.length; ++i2) {
                    String key = values[i2++];
                    if (i2 >= values.length) continue;
                    xsiSchemaLocationMap.put((Object)key, (Object)this.resolve(values[i2]));
                }
                if (xsiSchemaLocationMap.size() != 0) {
                    this.resource.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
                }
            }
        }
    }

    public String getNoNamespaceSchemaLocation() {
        EMap xsiSchemaLocationMap = this.getSchemaLocationMap();
        if (xsiSchemaLocationMap != null) {
            StringBuffer xsiSchemaLocation = new StringBuffer();
            if (!xsiSchemaLocationMap.isEmpty()) {
                String result;
                Object valueObject = xsiSchemaLocationMap.get(null);
                if (valueObject != null) {
                    String valueString = (String)valueObject;
                    String[] values = valueString.split(WHITESPACE_REGEX);
                    for (int i = 0; i < values.length; ++i) {
                        if (xsiSchemaLocation.length() > 0) {
                            xsiSchemaLocation.append(' ');
                        }
                        xsiSchemaLocation.append(this.deresolve(values[i]));
                    }
                }
                return (result = xsiSchemaLocation.toString()).equals("") ? null : result;
            }
        }
        return null;
    }

    public void setNoNamespaceSchemaLocation(String schemaLocation) {
        EMap xsiSchemaLocationMap = this.getSchemaLocationMap();
        if (xsiSchemaLocationMap != null) {
            xsiSchemaLocationMap.removeKey(null);
            if (xsiSchemaLocationMap.size() == 0) {
                this.resource.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.FALSE);
            }
            if (schemaLocation != null) {
                String[] values = schemaLocation.split(WHITESPACE_REGEX);
                for (int i = 0; i < values.length; ++i) {
                    xsiSchemaLocationMap.put(null, (Object)this.resolve(values[i]));
                }
                if (xsiSchemaLocationMap.size() != 0) {
                    this.resource.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
                }
            }
        }
    }
}

