/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.impl;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import org.apache.tuscany.sdo.SDOFactory;
import org.apache.tuscany.sdo.impl.DynamicDataObjectImpl;
import org.apache.tuscany.sdo.impl.SDOFactoryImpl;
import org.apache.tuscany.sdo.util.DataObjectUtil;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.EPackageImpl;

public class FactoryBase
extends EPackageImpl {
    public static final boolean IS_ATTRIBUTE = true;
    private static final Type sequence = SDOFactory.eINSTANCE.createDataType();
    private static final int DOCUMENT_ROOT = 0;
    private static final int DOCUMENT_ROOT__MIXED = 0;
    private static final int DOCUMENT_ROOT__XMLNS_PREFIX_MAP = 1;
    private static final int DOCUMENT_ROOT__XSI_SCHEMA_LOCATION = 2;
    private static final String ANNOTATION_SOURCE = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";
    private EClass documentRootEClass = null;

    protected FactoryBase(String namespaceURI, String namespacePrefix) {
        super((EFactory)new SDOEFactoryImpl());
        this.ecoreFactory = new SDOFactoryImpl.SDOEcoreFactory();
        int index = namespacePrefix.lastIndexOf(".");
        this.setName(index != -1 ? namespacePrefix.substring(index + 1) : namespacePrefix);
        this.setNsPrefix(namespacePrefix);
        this.createResource(namespaceURI);
        this.setNsURI(namespaceURI);
        ((SDOEFactoryImpl)this.getEFactoryInstance()).sdoFactory = this;
    }

    protected FactoryBase(String namespaceURI, String namespacePrefix, String interfacePackage) {
        super((EFactory)new SDOEFactoryImpl());
        this.ecoreFactory = new SDOFactoryImpl.SDOEcoreFactory();
        int index = interfacePackage.lastIndexOf(".");
        this.setName(index != -1 ? interfacePackage.substring(index + 1) : interfacePackage);
        this.setNsPrefix(namespacePrefix);
        this.createResource(namespaceURI);
        this.setNsURI(namespaceURI);
        ((SDOEFactoryImpl)this.getEFactoryInstance()).sdoFactory = this;
    }

    public DataObject create(int typeNumber) {
        return null;
    }

    public Object createFromString(int typeNumber, String stringValue) {
        return ((SDOEFactoryImpl)this.getEFactoryInstance()).createFromString(typeNumber, stringValue);
    }

    public String convertToString(int typeNumber, Object objectValue) {
        return ((SDOEFactoryImpl)this.getEFactoryInstance()).convertToString(typeNumber, objectValue);
    }

    protected Type createType(boolean isDataType, int typeNumber) {
        if (isDataType) {
            return (Type)this.createEDataType(typeNumber);
        }
        return (Type)this.createEClass(typeNumber);
    }

    protected void createProperty(boolean isDataType, Type containingType, int internalPropertyNumber) {
        if (isDataType) {
            this.createEAttribute((EClass)containingType, internalPropertyNumber);
        } else {
            this.createEReference((EClass)containingType, internalPropertyNumber);
        }
    }

    protected Property getProperty(Type type, int internalPropertyNumber) {
        return (Property)((EClass)type).getEAllStructuralFeatures().get(internalPropertyNumber);
    }

    protected Property getLocalProperty(Type type, int localPropertyIndex) {
        return (Property)((EClass)type).getEStructuralFeatures().get(localPropertyIndex);
    }

    protected void initializeType(Type type, Class instanceClass, String name) {
        this.initEClass((EClass)type, instanceClass, name, false, false, true);
    }

    protected void initializeType(Type type, Class instanceClass, String name, boolean isAbstract) {
        this.initEClass((EClass)type, instanceClass, name, isAbstract, false, true);
    }

    protected void initializeType(Type type, Class instanceClass, String name, boolean isSerializable, boolean isGenerated) {
        this.initEDataType((EDataType)type, instanceClass, name, isSerializable, isGenerated);
    }

    protected void initializeProperty(Property property, Type type, String name, String defaultValue, int lower, int upper, Class containerClass, boolean isReadonly, boolean isUnsettable, boolean isDerived) {
        this.initEAttribute((EAttribute)property, (EClassifier)(type != sequence ? (EClassifier)type : this.ecorePackage.getEFeatureMapEntry()), name, defaultValue, lower, upper, containerClass, isDerived, isDerived, !isReadonly, isUnsettable, false, false, isDerived, true);
    }

    protected void initializeProperty(Property property, Type type, String name, String defaultValue, int lower, int upper, Class containerClass, boolean isReadonly, boolean isUnsettable, boolean isDerived, boolean isComposite, Property oppositeProperty) {
        this.initEReference((EReference)property, (EClassifier)type, (EReference)oppositeProperty, name, defaultValue, lower, upper, containerClass, isDerived, isDerived, !isReadonly, isComposite, !isComposite, isUnsettable, true, isDerived, true);
    }

    protected void initXSD() {
        this.createDocumentRoot();
    }

    protected void addXSDMapping(String[] xsdMappings, String annotationSource) {
        this.addAnnotation((ENamedElement)this, annotationSource, xsdMappings);
    }

    protected void addXSDMapping(Type type, String[] xsdMappings) {
        this.addAnnotation((ENamedElement)type, ANNOTATION_SOURCE, xsdMappings);
    }

    protected void addXSDMapping(Property property, String[] xsdMappings) {
        this.addAnnotation((ENamedElement)property, ANNOTATION_SOURCE, xsdMappings);
    }

    protected void setInstanceProperty(Type type, String namespaceURI, String propertyName, String propertyValue) {
        this.setInstanceProperty((ENamedElement)type, namespaceURI, propertyName, propertyValue);
    }

    protected void setInstanceProperty(Property property, String namespaceURI, String propertyName, String propertyValue) {
        this.setInstanceProperty((ENamedElement)property, namespaceURI, propertyName, propertyValue);
    }

    private void setInstanceProperty(ENamedElement eNamedElement, String namespaceURI, String propertyName, String propertyValue) {
        EAnnotation annotation = eNamedElement.getEAnnotation(namespaceURI);
        if (annotation == null) {
            this.addAnnotation(eNamedElement, namespaceURI, new String[]{propertyName, propertyValue});
        } else {
            annotation.getDetails().put((Object)propertyName, (Object)propertyValue);
        }
    }

    protected Property createGlobalProperty(String name, Type type, String[] xsdMappings) {
        return this.createGlobalProperty(name, type, xsdMappings, false);
    }

    protected Property createGlobalProperty(String name, Type type, String[] xsdMappings, boolean asAttribute) {
        return this.createGlobalProperty(name, type, xsdMappings, asAttribute, ANNOTATION_SOURCE);
    }

    protected Property createGlobalProperty(String name, Type type, String[] xsdMappings, boolean asAttribute, String annotationSource) {
        EAttribute globalProperty;
        int propertyNumber = this.documentRootEClass.getEStructuralFeatures().size();
        if (asAttribute) {
            this.createEAttribute(this.documentRootEClass, propertyNumber);
            EAttribute gatt = (EAttribute)this.documentRootEClass.getEStructuralFeatures().get(propertyNumber);
            this.initEAttribute(gatt, (EClassifier)((EDataType)type), name, null, 0, -2, true, true, true, false, false, false, true, true);
            globalProperty = gatt;
        } else {
            this.createEReference(this.documentRootEClass, propertyNumber);
            EReference gref = (EReference)this.documentRootEClass.getEStructuralFeatures().get(propertyNumber);
            this.initEReference(gref, (EClassifier)((EClass)type), null, name, null, 0, -2, null, true, true, true, true, false, false, true, true, true);
            globalProperty = gref;
        }
        this.addAnnotation((ENamedElement)globalProperty, annotationSource, xsdMappings);
        return (Property)globalProperty;
    }

    protected Type getSequence() {
        return sequence;
    }

    protected void addSuperType(Type subType, Type superType) {
        ((EClass)subType).getESuperTypes().add((Object)((EClass)superType));
    }

    public static Object getStaticFactory(String namespaceURI) {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(namespaceURI);
        return ePackage instanceof FactoryBase ? ePackage : ePackage.getEFactoryInstance();
    }

    private void createDocumentRoot() {
        this.documentRootEClass = this.ecoreFactory.createEClass();
        ((EClassImpl)this.documentRootEClass).setClassifierID(0);
        this.getEClassifiers().add(0, (Object)this.documentRootEClass);
        this.createEAttribute(this.documentRootEClass, 0);
        this.createEReference(this.documentRootEClass, 1);
        this.createEReference(this.documentRootEClass, 2);
        this.initEClass(this.documentRootEClass, null, "DocumentRoot", false, false, false);
        this.initEAttribute((EAttribute)this.documentRootEClass.getEStructuralFeatures().get(0), (EClassifier)this.ecorePackage.getEFeatureMapEntry(), "mixed", null, 0, -1, null, false, false, true, false, false, false, false, true);
        this.initEReference((EReference)this.documentRootEClass.getEStructuralFeatures().get(1), (EClassifier)this.ecorePackage.getEStringToStringMapEntry(), null, "xMLNSPrefixMap", null, 0, -1, null, true, false, true, true, false, false, true, false, true);
        this.initEReference((EReference)this.documentRootEClass.getEStructuralFeatures().get(2), (EClassifier)this.ecorePackage.getEStringToStringMapEntry(), null, "xSISchemaLocation", null, 0, -1, null, true, false, true, true, false, false, true, false, true);
        this.addAnnotation((ENamedElement)this.documentRootEClass, ANNOTATION_SOURCE, new String[]{"name", "", "kind", "mixed"});
        this.addAnnotation((ENamedElement)((EAttribute)this.documentRootEClass.getEStructuralFeatures().get(0)), ANNOTATION_SOURCE, new String[]{"kind", "elementWildcard", "name", ":mixed"});
        this.addAnnotation((ENamedElement)((EReference)this.documentRootEClass.getEStructuralFeatures().get(1)), ANNOTATION_SOURCE, new String[]{"kind", "attribute", "name", "xmlns:prefix"});
        this.addAnnotation((ENamedElement)((EReference)this.documentRootEClass.getEStructuralFeatures().get(2)), ANNOTATION_SOURCE, new String[]{"kind", "attribute", "name", "xsi:schemaLocation"});
    }

    static {
        DataObjectUtil.initRuntime();
    }

    private static class SDOEFactoryImpl
    extends DynamicDataObjectImpl.FactoryImpl {
        protected FactoryBase sdoFactory;

        public EObject create(EClass eClass) {
            DataObject result = this.sdoFactory.create(eClass.getClassifierID());
            if (result == null) {
                if (eClass.isAbstract()) {
                    Class instanceClass = eClass.getInstanceClass();
                    try {
                        Class concreteInstanceClass = DataObjectUtil.getImplementationClass(instanceClass, true);
                        return (EObject)concreteInstanceClass.newInstance();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return super.create(eClass);
            }
            return (EObject)result;
        }

        public Object createFromString(EDataType eDataType, String stringValue) {
            return this.sdoFactory.createFromString(eDataType.getClassifierID(), stringValue);
        }

        public String convertToString(EDataType eDataType, Object objectValue) {
            return this.sdoFactory.convertToString(eDataType.getClassifierID(), objectValue);
        }

        protected Object createFromString(int typeNumber, String stringValue) {
            return super.createFromString((EDataType)this.sdoFactory.getEClassifiers().get(typeNumber), stringValue);
        }

        protected String convertToString(int typeNumber, Object objectValue) {
            return super.convertToString((EDataType)this.sdoFactory.getEClassifiers().get(typeNumber), objectValue);
        }
    }
}

