/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.model.xml.impl;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import org.apache.tuscany.sdo.helper.TypeHelperImpl;
import org.apache.tuscany.sdo.impl.FactoryBase;
import org.apache.tuscany.sdo.model.ModelFactory;
import org.apache.tuscany.sdo.model.impl.ModelFactoryImpl;
import org.apache.tuscany.sdo.model.internal.InternalFactory;
import org.apache.tuscany.sdo.model.internal.impl.InternalFactoryImpl;
import org.apache.tuscany.sdo.model.xml.XMLFactory;
import org.apache.tuscany.sdo.model.xml.XMLInfo;
import org.apache.tuscany.sdo.model.xml.impl.XMLInfoImpl;
import org.eclipse.emf.ecore.EPackage;

public class XMLFactoryImpl
extends FactoryBase
implements XMLFactory {
    public static final String NAMESPACE_URI = "commonj.sdo/xml";
    public static final String NAMESPACE_PREFIX = "sdoXML";
    public static final String PATTERN_VERSION = "1.2";
    public static final int XML_INFO = 1;
    protected Type xmlInfoType = null;
    private static XMLFactoryImpl instance = null;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    public XMLFactoryImpl() {
        super(NAMESPACE_URI, NAMESPACE_PREFIX, "org.apache.tuscany.sdo.model.xml");
    }

    public void register(HelperContext scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Scope can not be null");
        }
        ModelFactory.INSTANCE.register(scope);
        InternalFactory.INSTANCE.register(scope);
        TypeHelperImpl th = (TypeHelperImpl)scope.getTypeHelper();
        th.getExtendedMetaData().putPackage(NAMESPACE_URI, (EPackage)this);
    }

    public DataObject create(int typeNumber) {
        switch (typeNumber) {
            case 1: {
                return (DataObject)this.createXMLInfo();
            }
        }
        return super.create(typeNumber);
    }

    public XMLInfo createXMLInfo() {
        XMLInfoImpl xmlInfo = new XMLInfoImpl();
        return xmlInfo;
    }

    public Type getXMLInfo() {
        return this.xmlInfoType;
    }

    public static XMLFactoryImpl init() {
        if (instance != null) {
            return instance;
        }
        instance = new XMLFactoryImpl();
        ModelFactory ModelFactoryInstance = ModelFactory.INSTANCE;
        InternalFactory InternalFactoryInstance = InternalFactory.INSTANCE;
        instance.createMetaData();
        instance.initializeMetaData();
        return instance;
    }

    public void createMetaData() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.xmlInfoType = this.createType(false, 1);
        this.createProperty(true, this.xmlInfoType, 0);
    }

    public void initializeMetaData() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        ModelFactoryImpl theModelPackageImpl = (ModelFactoryImpl)ModelFactory.INSTANCE;
        InternalFactoryImpl theInternalPackageImpl = (InternalFactoryImpl)InternalFactory.INSTANCE;
        Property property = null;
        this.initializeType(this.xmlInfoType, XMLInfo.class, "XMLInfo", false);
        property = this.getLocalProperty(this.xmlInfoType, 0);
        this.initializeProperty(property, theModelPackageImpl.getBoolean(), "xmlElement", null, 0, 1, XMLInfo.class, false, true, false);
        this.createXSDMetaData(theModelPackageImpl, theInternalPackageImpl);
    }

    protected void createXSDMetaData(ModelFactoryImpl theModelPackageImpl, InternalFactoryImpl theInternalPackageImpl) {
        super.initXSD();
        Property property = null;
        property = this.createGlobalProperty("aliasName", theModelPackageImpl.getString(), new String[]{"kind", "attribute", "name", "aliasName", "namespace", "##targetNamespace"}, true);
        property = this.createGlobalProperty("dataType", theInternalPackageImpl.getQName(), new String[]{"kind", "attribute", "name", "dataType", "namespace", "##targetNamespace"}, true);
        property = this.createGlobalProperty("many", theModelPackageImpl.getBoolean(), new String[]{"kind", "attribute", "name", "many", "namespace", "##targetNamespace"}, true);
        property = this.createGlobalProperty("name", theModelPackageImpl.getString(), new String[]{"kind", "attribute", "name", "name", "namespace", "##targetNamespace"}, true);
        property = this.createGlobalProperty("oppositeProperty", theModelPackageImpl.getString(), new String[]{"kind", "attribute", "name", "oppositeProperty", "namespace", "##targetNamespace"}, true);
        property = this.createGlobalProperty("propertyType", theInternalPackageImpl.getQName(), new String[]{"kind", "attribute", "name", "propertyType", "namespace", "##targetNamespace"}, true);
        property = this.createGlobalProperty("readOnly", theModelPackageImpl.getBoolean(), new String[]{"kind", "attribute", "name", "readOnly", "namespace", "##targetNamespace"}, true);
        property = this.createGlobalProperty("sequence", theModelPackageImpl.getBoolean(), new String[]{"kind", "attribute", "name", "sequence", "namespace", "##targetNamespace"}, true);
        property = this.createGlobalProperty("string", theModelPackageImpl.getBoolean(), new String[]{"kind", "attribute", "name", "string", "namespace", "##targetNamespace"}, true);
        property = this.createGlobalProperty("xmlElement", theModelPackageImpl.getBoolean(), new String[]{"kind", "attribute", "name", "xmlElement", "namespace", "##targetNamespace"}, true);
        this.addXSDMapping(this.xmlInfoType, new String[]{"name", "XMLInfo", "kind", "empty"});
        this.addXSDMapping(this.getProperty(this.xmlInfoType, 0), new String[]{"kind", "attribute", "name", "xmlElement"});
    }
}

