/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.util;

import commonj.sdo.ChangeSummary;
import commonj.sdo.helper.TypeHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sdo.SDOFactory;
import org.apache.tuscany.sdo.SDOPackage;
import org.apache.tuscany.sdo.helper.TypeHelperImpl;
import org.apache.tuscany.sdo.impl.ChangeSummaryImpl;
import org.apache.tuscany.sdo.impl.DataGraphImpl;
import org.apache.tuscany.sdo.impl.DynamicDataObjectImpl;
import org.apache.tuscany.sdo.util.DataObjectUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.EcoreBuilder;
import org.eclipse.emf.ecore.xmi.NameInfo;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.emf.ecore.xmi.util.DefaultEcoreBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DataGraphResourceFactoryImpl
extends ResourceFactoryImpl {
    public Resource createResource(URI uri) {
        DataGraphResourceImpl result = new DataGraphResourceImpl(uri);
        ExtendedMetaData extendedMetaData = ((TypeHelperImpl)TypeHelper.INSTANCE).getExtendedMetaData();
        DataObjectUtil.configureXMLResource((XMLResource)result, extendedMetaData);
        result.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        result.getDefaultLoadOptions().put("USE_DEPRECATED_METHODS", Boolean.TRUE);
        return result;
    }

    public static class DataGraphResourceImpl
    extends XMLResourceImpl {
        public DataGraphResourceImpl(URI uri) {
            super(uri);
        }

        protected XMLHelper createXMLHelper() {
            return new HelperImpl((XMLResource)this);
        }

        protected EObject getEObjectByID(String id) {
            Object rootObject;
            EList contents = this.getContents();
            if (contents.size() >= 1 && (rootObject = contents.get(0)) instanceof DataGraphImpl) {
                DataGraphImpl eDataGraph = (DataGraphImpl)rootObject;
                EObject result = eDataGraph.getRootResource().getEObject(id);
                if (result != null) {
                    return result;
                }
                ChangeSummary eChangeSummary = eDataGraph.getEChangeSummary();
                if (eChangeSummary != null && (result = ((EObject)eDataGraph.getChangeSummary()).eResource().getEObject(id)) != null) {
                    return result;
                }
            }
            return super.getEObjectByID(id);
        }

        protected XMLSave createXMLSave() {
            return new SaveImpl(this.createXMLHelper());
        }

        protected XMLLoad createXMLLoad() {
            return new LoadImpl(this.createXMLHelper());
        }

        public static class LoadImpl
        extends XMLLoadImpl {
            protected boolean resumeLogging = false;

            public void load(XMLResource resource, InputSource inputSource, Map options) throws IOException {
                super.load(resource, inputSource, options);
                if (this.resumeLogging) {
                    ((ChangeSummaryImpl)((DataGraphImpl)resource.getContents().get(0)).getChangeSummary()).resumeLogging();
                }
            }

            public void load(XMLResource resource, InputStream inputStream, Map options) throws IOException {
                super.load(resource, inputStream, options);
                if (this.resumeLogging) {
                    ((ChangeSummaryImpl)((DataGraphImpl)resource.getContents().get(0)).getChangeSummary()).resumeLogging();
                }
            }

            public void load(XMLResource resource, Node node, Map options) throws IOException {
                super.load(resource, node, options);
                if (this.resumeLogging) {
                    ((ChangeSummaryImpl)((DataGraphImpl)resource.getContents().get(0)).getChangeSummary()).resumeLogging();
                }
            }

            public LoadImpl(XMLHelper xmlHelper) {
                super(xmlHelper);
            }

            protected DefaultHandler makeDefaultHandler() {
                return new SAXXMLHandler(this.resource, this.helper, this.options){
                    protected DataGraphImpl eDataGraph;
                    protected boolean isInModels;
                    protected List ePackages;
                    {
                        this.ePackages = new ArrayList();
                    }

                    protected EObject createDocumentRoot(String prefix, String uri, String name, EFactory eFactory, boolean top) {
                        return null;
                    }

                    protected void setAttribValue(EObject object, String name, String value) {
                        if ("logging".equals(name) && object instanceof ChangeSummaryImpl) {
                            LoadImpl.this.resumeLogging = Boolean.valueOf(value);
                        } else {
                            super.setAttribValue(object, name, value);
                        }
                    }

                    protected EMap recordNamespacesSchemaLocations(EObject root) {
                        EObject dgroot = this.eDataGraph.getERootObject();
                        if (dgroot == null) {
                            return null;
                        }
                        EMap prefixToNamespaceMap = super.recordNamespacesSchemaLocations(dgroot);
                        if (prefixToNamespaceMap != null) {
                            Iterator i = prefixToNamespaceMap.iterator();
                            while (i.hasNext()) {
                                Map.Entry entry = (Map.Entry)i.next();
                                String prefix = (String)entry.getKey();
                                String namespace = (String)entry.getValue();
                                if (!namespace.equals("commonj.sdo")) continue;
                                prefixToNamespaceMap.removeKey((Object)prefix);
                                break;
                            }
                        }
                        return prefixToNamespaceMap;
                    }

                    protected void handleFeature(String prefix, String name) {
                        if (this.isInModels && this.objects.size() == 2) {
                            EObject modelObject = this.createObjectByType(prefix, name, false);
                            this.processObject(modelObject);
                            this.ePackages.add(modelObject);
                        } else if (this.objects.size() == 1) {
                            this.eDataGraph = (DataGraphImpl)this.objects.peek();
                            this.eDataGraph.getResourceSet();
                            if ("".equals(prefix) && "changeSummary".equals(name)) {
                                ChangeSummary eChangeSummary = (ChangeSummary)this.createObjectFromFactory(SDOFactory.eINSTANCE, "ChangeSummary");
                                this.eDataGraph.setEChangeSummary(eChangeSummary);
                                this.processObject((EObject)eChangeSummary);
                            } else if ("".equals(prefix) && "models".equals(name)) {
                                this.isInModels = true;
                                this.types.push((Object)"object");
                                this.objects.push((EObject)this.eDataGraph);
                                this.mixedTargets.push(null);
                            } else if (this.eDataGraph.getERootObject() == null) {
                                EStructuralFeature rootFeature;
                                String namespaceURI;
                                if (this.useNewMethods) {
                                    this.handleSchemaLocation();
                                }
                                this.processSchemaLocations(prefix, name);
                                if (this.processAnyXML && this.extendedMetaData.getPackage(namespaceURI = this.helper.getURI(prefix)) == null) {
                                    EStructuralFeature rootFeature2 = this.extendedMetaData.demandFeature(namespaceURI, name, true);
                                    rootFeature2.getEContainingClass().getEPackage().setEFactoryInstance((EFactory)new DynamicDataObjectImpl.FactoryImpl());
                                }
                                if ((rootFeature = this.extendedMetaData.getElement(this.helper.getURI(prefix), name)) != null) {
                                    name = rootFeature.getEType().getName();
                                }
                                EObject rootObject = this.createObjectByType(prefix, name, false);
                                this.eDataGraph.setERootObject(rootObject);
                                this.processObject(rootObject);
                                if (rootObject != null && rootObject.eClass() == ExtendedMetaData.INSTANCE.getDocumentRoot(rootObject.eClass().getEPackage())) {
                                    super.handleFeature(prefix, name);
                                    Object mixedTarget = this.mixedTargets.pop();
                                    Object object = this.objects.pop();
                                    this.mixedTargets.pop();
                                    this.objects.pop();
                                    this.mixedTargets.push(mixedTarget);
                                    this.objects.push(object);
                                }
                            }
                        } else {
                            super.handleFeature(prefix, name);
                        }
                    }

                    public void endElement(String uri, String localName, String name) {
                        if (this.isInModels && this.objects.size() == 2) {
                            if (!this.ePackages.isEmpty()) {
                                Iterator i = this.ePackages.iterator();
                                while (i.hasNext()) {
                                    EPackage ePackage = (EPackage)i.next();
                                    ePackage.setEFactoryInstance((EFactory)new DynamicDataObjectImpl.FactoryImpl());
                                    Resource resource = this.resourceSet.createResource(URI.createURI((String)"*.ecore"));
                                    resource.getContents().add((Object)ePackage);
                                    if (ePackage.getNsURI() != null) {
                                        resource.setURI(URI.createURI((String)ePackage.getNsURI()));
                                    }
                                    if (this.extendedMetaData != null) {
                                        this.extendedMetaData.putPackage(this.extendedMetaData.getNamespace(ePackage), ePackage);
                                        continue;
                                    }
                                    this.packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
                                }
                                this.handleForwardReferences();
                            }
                            this.isInModels = false;
                        }
                        if ("".equals(uri) && "objectsToAttach".equals(name) && this.text != null && this.text.length() == 0) {
                            this.text = null;
                        }
                        super.endElement(uri, localName, name);
                    }

                    protected EPackage getPackageForURI(String uriString) {
                        if ("commonj.sdo".equals(uriString)) {
                            return SDOPackage.eINSTANCE;
                        }
                        return super.getPackageForURI(uriString);
                    }

                    protected EObject createObjectFromFactory(EFactory factory, String typeName) {
                        if (factory == SDOFactory.eINSTANCE && "datagraph".equals(typeName)) {
                            return super.createObjectFromFactory(factory, "DataGraph");
                        }
                        return super.createObjectFromFactory(factory, typeName);
                    }

                    protected EcoreBuilder createEcoreBuilder(Map options, ExtendedMetaData extendedMetaData) {
                        return new DefaultEcoreBuilder(extendedMetaData){

                            public Collection generate(Map urisToLocations) throws Exception {
                                Collection result = super.generate(urisToLocations);
                                return this.updateDynamicFactory(result);
                            }

                            public Collection generate(Collection urisToLocations) throws Exception {
                                Collection result = super.generate(urisToLocations);
                                return this.updateDynamicFactory(result);
                            }

                            protected Collection updateDynamicFactory(Collection result) {
                                Iterator i = result.iterator();
                                while (i.hasNext()) {
                                    Resource resource = (Resource)i.next();
                                    Iterator j = EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)EcorePackage.eINSTANCE.getEPackage()).iterator();
                                    while (j.hasNext()) {
                                        EPackage ePackage = (EPackage)j.next();
                                        ePackage.setEFactoryInstance((EFactory)new DynamicDataObjectImpl.FactoryImpl());
                                    }
                                }
                                return result;
                            }
                        };
                    }

                    protected EPackage handleMissingPackage(String uriString) {
                        EPackage result = super.handleMissingPackage(uriString);
                        if (this.processAnyXML && this.objects.size() == 1) {
                            result = this.extendedMetaData.demandPackage(uriString);
                        }
                        return result;
                    }
                };
            }
        }

        public static class SaveImpl
        extends XMLSaveImpl {
            protected DataGraphImpl eDataGraph;

            public SaveImpl(XMLHelper xmlHelper) {
                super(xmlHelper);
            }

            public void traverse(List contents) {
                if (contents.size() >= 1 && contents.get(0) instanceof DataGraphImpl) {
                    ChangeSummary changeSummary;
                    EObject eRootObject;
                    EReference xmlnsPrefixMapFeature;
                    this.eDataGraph = (DataGraphImpl)contents.get(0);
                    Object datagraphMark = null;
                    if (!this.toDOM) {
                        if (this.declareXML) {
                            this.doc.add("<?xml version=\"" + this.xmlVersion + "\" encoding=\"" + this.encoding + "\"?>");
                            this.doc.addLine();
                        }
                        String elementName = this.helper.getQName(this.eDataGraph.eClass());
                        this.doc.startElement(elementName);
                        datagraphMark = this.doc.mark();
                    } else {
                        this.helper.populateNameInfo(this.nameInfo, this.eDataGraph.eClass());
                        this.currentNode = this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                        this.document.appendChild(this.currentNode);
                    }
                    if (this.eDataGraph.eResource() != null && this.eDataGraph.eResource().getResourceSet() != null) {
                        ArrayList ePackages = new ArrayList();
                        Iterator i = this.eDataGraph.eResource().getResourceSet().getResources().iterator();
                        while (i.hasNext()) {
                            EList resourceContents = ((Resource)i.next()).getContents();
                            if (resourceContents.size() != 1 || !(resourceContents.get(0) instanceof EPackage)) continue;
                            ePackages.add(resourceContents.get(0));
                        }
                        if (!ePackages.isEmpty()) {
                            if (!this.toDOM) {
                                this.doc.startElement("models");
                                this.doc.addAttribute("xmlns", "");
                            } else {
                                this.currentNode = this.currentNode.appendChild(this.document.createElementNS(null, "models"));
                                ((Element)this.currentNode).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
                            }
                            i = ePackages.iterator();
                            while (i.hasNext()) {
                                this.writeTopObject((EObject)((EPackage)i.next()));
                            }
                            if (!this.toDOM) {
                                this.doc.endElement();
                            } else {
                                this.currentNode = this.currentNode.getParentNode();
                            }
                        }
                    }
                    if ((xmlnsPrefixMapFeature = this.extendedMetaData.getXMLNSPrefixMapFeature((eRootObject = this.eDataGraph.getERootObject()).eClass())) != null) {
                        EMap xmlnsPrefixMap = (EMap)eRootObject.eGet((EStructuralFeature)xmlnsPrefixMapFeature);
                        this.helper.setPrefixToNamespaceMap(xmlnsPrefixMap);
                    }
                    if ((changeSummary = this.eDataGraph.getEChangeSummary()) != null) {
                        this.helper.setMustHavePrefix(true);
                        if (changeSummary.isLogging()) {
                            ((ChangeSummaryImpl)changeSummary).summarize();
                            this.writeTopObject((EObject)changeSummary);
                        } else {
                            this.writeTopObject((EObject)changeSummary);
                        }
                        this.helper.setMustHavePrefix(false);
                    }
                    if (eRootObject != null && this.writeTopObject(eRootObject) == null && !this.toDOM) {
                        this.doc.addLine();
                        this.doc.setMixed(false);
                    }
                    if (!this.toDOM) {
                        this.doc.endElement();
                        this.doc.resetToMark(datagraphMark);
                    } else {
                        this.currentNode = this.document.getFirstChild();
                    }
                    this.addNamespaceDeclarations();
                } else {
                    super.traverse(contents);
                }
            }

            protected void writeTopAttributes(EObject top) {
                if (top == this.eDataGraph.getEChangeSummary()) {
                    if (!this.toDOM) {
                        this.doc.addAttribute("xmlns", "");
                        this.doc.addAttribute("logging", String.valueOf(this.eDataGraph.getEChangeSummary().isLogging()));
                    } else {
                        ((Element)this.currentNode).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
                        ((Element)this.currentNode).setAttributeNS("", "logging", String.valueOf(this.eDataGraph.getEChangeSummary().isLogging()));
                    }
                }
            }

            protected EObject getSchemaLocationRoot(EObject eObject) {
                return this.eDataGraph.getERootObject();
            }
        }

        public static class HelperImpl
        extends XMLHelperImpl {
            protected DataGraphImpl eDataGraph;
            protected List resources;
            protected List uris;

            public HelperImpl(XMLResource xmlResource) {
                super(xmlResource);
            }

            public void setResource(XMLResource resource) {
                super.setResource(resource);
                if (!resource.getContents().isEmpty()) {
                    this.eDataGraph = (DataGraphImpl)resource.getContents().get(0);
                    this.resources = new ArrayList();
                    this.uris = new ArrayList();
                    this.resources.add(this.eDataGraph.getRootResource());
                    this.uris.add("#" + resource.getURIFragment((EObject)this.eDataGraph) + "/@eRootObject");
                    if (this.eDataGraph.getEChangeSummary() != null) {
                        this.resources.add(((EObject)this.eDataGraph.getChangeSummary()).eResource());
                        this.uris.add("#" + resource.getURIFragment((EObject)this.eDataGraph) + "/@eChangeSummary");
                    }
                    if (this.eDataGraph.eResource() != null && this.eDataGraph.eResource().getResourceSet() != null) {
                        int count = 0;
                        Iterator i = this.eDataGraph.eResource().getResourceSet().getResources().iterator();
                        while (i.hasNext()) {
                            Resource ePackageResource = (Resource)i.next();
                            EList resourceContents = ePackageResource.getContents();
                            if (resourceContents.size() != 1 || !(resourceContents.get(0) instanceof EPackage)) continue;
                            this.resources.add(ePackageResource);
                            this.uris.add("#" + resource.getURIFragment((EObject)this.eDataGraph) + "/@models." + count++);
                        }
                    }
                }
            }

            public String getID(EObject eObject) {
                return super.getID(eObject);
            }

            public String getIDREF(EObject eObject) {
                int index;
                String fragment = super.getIDREF(eObject);
                if (fragment.startsWith("/") && (index = this.resources.indexOf(eObject.eResource())) != -1) {
                    fragment = ((String)this.uris.get(index)).substring(1) + fragment.substring(1);
                }
                return fragment;
            }

            public String getHREF(EObject eObject) {
                return super.getHREF(eObject);
            }

            protected URI getHREF(Resource otherResource, EObject obj) {
                int index = this.resources.indexOf(otherResource);
                if (index == -1) {
                    return super.getHREF(otherResource, obj);
                }
                return this.createHREF((String)this.uris.get(index), otherResource.getURIFragment(obj));
            }

            protected URI createHREF(String baseURI, String fragment) {
                if (fragment.startsWith("/")) {
                    return URI.createURI((String)(baseURI + fragment.substring(1)));
                }
                return URI.createURI((String)("#" + fragment));
            }

            public void populateNameInfo(NameInfo nameInfo, EClass c) {
                if (c == SDOPackage.eINSTANCE.getDataGraph()) {
                    if (this.extendedMetaData != null) {
                        this.extendedMetaData.demandPackage("commonj.sdo").setNsPrefix("sdo");
                    }
                    nameInfo.setQualifiedName(this.getQName("commonj.sdo", "datagraph"));
                    nameInfo.setNamespaceURI("commonj.sdo");
                    nameInfo.setLocalPart("datagraph");
                } else if (c == SDOPackage.eINSTANCE.getChangeSummary()) {
                    if (this.extendedMetaData != null) {
                        this.extendedMetaData.demandPackage("commonj.sdo").setNsPrefix("sdo");
                    }
                    nameInfo.setQualifiedName("changeSummary");
                    nameInfo.setNamespaceURI(null);
                    nameInfo.setLocalPart("changeSummary");
                } else {
                    super.populateNameInfo(nameInfo, c);
                }
            }

            public String getQName(EClass c) {
                if (c == SDOPackage.eINSTANCE.getDataGraph()) {
                    if (this.extendedMetaData != null) {
                        this.extendedMetaData.demandPackage("commonj.sdo").setNsPrefix("sdo");
                    }
                    return this.getQName("commonj.sdo", "datagraph");
                }
                if (c == SDOPackage.eINSTANCE.getChangeSummary()) {
                    if (this.extendedMetaData != null) {
                        this.extendedMetaData.demandPackage("commonj.sdo").setNsPrefix("sdo");
                    }
                    return this.getQName(null, "changeSummary");
                }
                return super.getQName(c);
            }
        }
    }
}

