/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.util.resource;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.helper.XSDHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.apache.tuscany.sdo.impl.AttributeImpl;
import org.apache.tuscany.sdo.impl.ReferenceImpl;
import org.apache.tuscany.sdo.util.SDOUtil;
import org.apache.tuscany.sdo.util.resource.XMLFragmentStreamReader;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public class DataObjectXMLStreamReader
implements XMLFragmentStreamReader {
    private static final QName XSI_TYPE_QNAME = new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi");
    private Property rootElement = null;
    private DataObject dataObject;
    private String rootElementURI;
    private String rootElementName;
    private DataObject serializeRoot;
    private TypeHelper typeHelper;
    private XSDHelper xsdHelper;
    private Map.Entry[] properties;
    private Map.Entry[] attributes;
    private QName elementQName;
    private NameSpaceContext namespaceContext;
    private Map declaredNamespaceMap = new HashMap();
    private static final int START_ELEMENT_STATE = 0;
    private static final int END_ELEMENT_STATE = 1;
    private static final int DELEGATED_STATE = 2;
    private static final int TEXT_STATE = 3;
    private int state = 0;
    private XMLFragmentStreamReader childReader;
    private int currentPropertyIndex = 0;

    public DataObjectXMLStreamReader(DataObject dataObject, String rootElmentURI, String rootElementName) {
        this(dataObject, rootElmentURI, rootElementName, null, null);
    }

    public DataObjectXMLStreamReader(DataObject dataObject, String rootElmentURI, String rootElementName, TypeHelper typeHelper) {
        this(dataObject, rootElmentURI, rootElementName, typeHelper, null);
    }

    public DataObjectXMLStreamReader(DataObject dataObject, String rootElmentURI, String rootElementName, TypeHelper typeHelper, XSDHelper xsdHelper) {
        this.dataObject = dataObject;
        this.rootElementURI = rootElmentURI;
        this.rootElementName = rootElementName;
        this.serializeRoot = dataObject;
        TypeHelper typeHelper2 = this.typeHelper = typeHelper == null ? TypeHelper.INSTANCE : typeHelper;
        this.xsdHelper = xsdHelper != null ? xsdHelper : (typeHelper == null ? XSDHelper.INSTANCE : SDOUtil.createXSDHelper(typeHelper));
        this.rootElement = this.xsdHelper.getGlobalProperty(rootElmentURI, rootElementName, true);
        this.namespaceContext = new NameSpaceContext();
        this.populateProperties();
    }

    protected DataObjectXMLStreamReader(TypeHelper typeHelper, XSDHelper xsdHelper, Property rootElement, DataObject dataObject) {
        TypeHelper typeHelper2 = this.typeHelper = typeHelper == null ? TypeHelper.INSTANCE : typeHelper;
        this.xsdHelper = xsdHelper != null ? xsdHelper : (typeHelper == null ? XSDHelper.INSTANCE : SDOUtil.createXSDHelper(typeHelper));
        this.rootElement = rootElement;
        this.dataObject = dataObject;
        this.rootElementURI = xsdHelper.getNamespaceURI(rootElement);
        this.rootElementName = xsdHelper.getLocalName(rootElement);
    }

    protected DataObjectXMLStreamReader(TypeHelper typeHelper, XSDHelper xsdHelper, Property rootElement, DataObject dataObject, DataObject serializeRoot) {
        TypeHelper typeHelper2 = this.typeHelper = typeHelper == null ? TypeHelper.INSTANCE : typeHelper;
        this.xsdHelper = xsdHelper != null ? xsdHelper : (typeHelper == null ? XSDHelper.INSTANCE : SDOUtil.createXSDHelper(typeHelper));
        this.rootElement = rootElement;
        this.dataObject = dataObject;
        this.serializeRoot = serializeRoot;
        this.rootElementURI = xsdHelper.getNamespaceURI(rootElement);
        this.rootElementName = xsdHelper.getLocalName(rootElement);
    }

    public DataObjectXMLStreamReader(Property rootElement, DataObject dataObject, TypeHelper typeHelper, XSDHelper xsdHelper) {
        this(typeHelper, xsdHelper, rootElement, dataObject);
        this.namespaceContext = new NameSpaceContext();
        this.populateProperties();
    }

    public DataObjectXMLStreamReader(XMLDocument document, TypeHelper typeHelper) {
        this.dataObject = document.getRootObject();
        this.rootElementName = document.getRootElementName();
        this.rootElementURI = document.getRootElementURI();
        this.serializeRoot = this.dataObject;
        this.typeHelper = typeHelper;
        this.xsdHelper = typeHelper == null ? XSDHelper.INSTANCE : SDOUtil.createXSDHelper(typeHelper);
        this.namespaceContext = new NameSpaceContext();
        this.populateProperties();
    }

    protected DataObjectXMLStreamReader(QName elementQName, Map.Entry[] properties, Map.Entry[] attributes) {
        this.properties = properties;
        this.elementQName = elementQName;
        this.attributes = attributes;
        this.namespaceContext = new NameSpaceContext();
    }

    private void addProperty(Property property, Object value, List propertyList) {
        if (property.isMany() && property.getContainingType().isOpen() && value instanceof Sequence) {
            this.addSequenceValue(propertyList, (Sequence)value);
        } else if (SDOUtil.isMany(property, this.dataObject) && value instanceof List) {
            this.addListValue(propertyList, property, (List)value);
        } else {
            this.addSingleValue(propertyList, property, value);
        }
    }

    void addProperty(List propertyList, Property property, Object value, Object type) {
        if (!DataObjectXMLStreamReader.isTransient(property, type)) {
            this.addProperty(property, value, propertyList);
        }
    }

    private void addSequenceValue(List elements, Sequence seq) {
        if (seq != null && seq.size() > 0) {
            for (int j = 0; j < seq.size(); ++j) {
                Object o = seq.getValue(j);
                Property p = seq.getProperty(j);
                this.addSingleValue(elements, p, o);
            }
        }
    }

    private static boolean isTransient(Property property, Object type) {
        EStructuralFeature feature = (EStructuralFeature)property;
        if (ExtendedMetaData.INSTANCE.getGroup(feature) != null) {
            return false;
        }
        if ((feature = ExtendedMetaData.INSTANCE.getAffiliation((EClass)type, feature)) != null && feature != property) {
            return false;
        }
        if (property instanceof ReferenceImpl) {
            ReferenceImpl r = (ReferenceImpl)property;
            if (r.isTransient()) {
                return true;
            }
            EReference opposite = r.getEOpposite();
            if (opposite != null && opposite.isContainment()) {
                return true;
            }
        } else if (property instanceof AttributeImpl) {
            AttributeImpl a = (AttributeImpl)property;
            if (a.isTransient()) {
                return true;
            }
            EDataType d = (EDataType)a.getEType();
            if (!d.isSerializable()) {
                return true;
            }
        }
        return false;
    }

    private void addListValue(List propertyList, Property property, List objList) {
        if (objList != null) {
            for (int j = 0; j < objList.size(); ++j) {
                Object object = objList.get(j);
                this.addSingleValue(propertyList, property, object);
            }
        }
    }

    private void addSingleValue(List propertyList, Property property, Object value) {
        String uri = this.xsdHelper.getNamespaceURI(property);
        String name = this.xsdHelper.getLocalName(property);
        QName qname = this.namespaceContext.createQName(uri, name);
        Type propertyType = property.getType();
        if (property.getName().equals("value") && uri == null && name.equals(":0")) {
            NameValuePair entry = new NameValuePair("Element Text", value);
            propertyList.add(entry);
        } else if (value == null) {
            this.registerNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            NameValuePair entry = new NameValuePair(qname, null);
            propertyList.add(entry);
        } else if (propertyType.isDataType()) {
            NameValuePair entry = new NameValuePair(qname, SDOUtil.convertToString(propertyType, value));
            propertyList.add(entry);
        } else if (!property.isContainment() || value != this.serializeRoot) {
            DataObjectXMLStreamReader childReader = new DataObjectXMLStreamReader(this.typeHelper, this.xsdHelper, property, (DataObject)value, this.serializeRoot);
            childReader.namespaceContext = this.namespaceContext;
            childReader.populateProperties();
            childReader.rootElement = property;
            NameValuePair entry = new NameValuePair(qname, childReader);
            propertyList.add(entry);
        }
    }

    public void populateProperties() {
        Property property;
        String typeName;
        if (this.properties != null) {
            return;
        }
        this.elementQName = this.elementQName == null ? this.namespaceContext.createQName(this.rootElementURI, this.rootElementName) : this.namespaceContext.createQName(this.elementQName.getNamespaceURI(), this.elementQName.getLocalPart());
        ArrayList<NameValuePair> elementList = new ArrayList<NameValuePair>();
        ArrayList<NameValuePair> attributeList = new ArrayList<NameValuePair>();
        if (this.dataObject == null) {
            return;
        }
        Type type = this.dataObject.getType();
        if ((this.rootElement == null || this.rootElement != null && this.rootElement.getType() != type) && (typeName = this.xsdHelper.getLocalName(type)) != null) {
            QName realTypeName = this.namespaceContext.createQName(type.getURI(), typeName);
            String typeQName = realTypeName.getPrefix() + ":" + realTypeName.getLocalPart();
            this.registerNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.registerNamespace(realTypeName.getPrefix(), realTypeName.getNamespaceURI());
            attributeList.add(new NameValuePair(XSI_TYPE_QNAME, typeQName));
        }
        if (type.isSequenced()) {
            Sequence sequence = this.dataObject.getSequence();
            for (int i = 0; i < sequence.size(); ++i) {
                property = sequence.getProperty(i);
                Object value = sequence.getValue(i);
                if (property == null) {
                    elementList.add(new NameValuePair("Element Text", value));
                    continue;
                }
                this.addProperty(property, value, elementList);
            }
            List properties = this.dataObject.getInstanceProperties();
            Iterator i = properties.iterator();
            while (i.hasNext()) {
                Property property2 = (Property)i.next();
                if (!this.xsdHelper.isAttribute(property2) || !this.dataObject.isSet(property2)) continue;
                Object value = this.dataObject.get(property2);
                this.addProperty(attributeList, property2, value, type);
            }
        } else {
            List properties = this.dataObject.getInstanceProperties();
            Iterator i = properties.iterator();
            while (i.hasNext()) {
                property = (Property)i.next();
                if (!this.dataObject.isSet(property)) continue;
                Object value = this.dataObject.get(property);
                if (this.xsdHelper.isAttribute(property)) {
                    this.addProperty(attributeList, property, value, type);
                    continue;
                }
                this.addProperty(elementList, property, value, type);
            }
        }
        this.properties = elementList.toArray(new Map.Entry[0]);
        this.attributes = attributeList.toArray(new Map.Entry[0]);
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    public void init() {
        this.populateNamespaceContext();
    }

    public Object getProperty(String key) throws IllegalArgumentException {
        if (this.state == 0 || this.state == 1) {
            return null;
        }
        if (this.state == 3) {
            return null;
        }
        if (this.state == 2) {
            return this.childReader.getProperty(key);
        }
        return null;
    }

    public int next() throws XMLStreamException {
        return this.updateStatus();
    }

    public void require(int i, String string, String string1) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public String getElementText() throws XMLStreamException {
        if (this.state == 2) {
            return this.childReader.getElementText();
        }
        return null;
    }

    public int nextTag() throws XMLStreamException {
        return 0;
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.state == 2) {
            if (this.childReader.isEndOfFragment()) {
                return true;
            }
            return this.childReader.hasNext();
        }
        return this.state == 0 || this.state == 3;
    }

    public void close() throws XMLStreamException {
    }

    public String getNamespaceURI(String prefix) {
        return this.namespaceContext.getNamespaceURI(prefix);
    }

    public boolean isStartElement() {
        if (this.state == 0) {
            return true;
        }
        if (this.state == 1) {
            return false;
        }
        return this.childReader.isStartElement();
    }

    public boolean isEndElement() {
        if (this.state == 0) {
            return false;
        }
        if (this.state == 1) {
            return true;
        }
        return this.childReader.isEndElement();
    }

    public boolean isCharacters() {
        if (this.state == 0 || this.state == 1) {
            return false;
        }
        return this.childReader.isCharacters();
    }

    public boolean isWhiteSpace() {
        if (this.state == 0 || this.state == 1) {
            return false;
        }
        return this.childReader.isWhiteSpace();
    }

    public String getAttributeValue(String nsUri, String localName) {
        int attribCount = this.getAttributeCount();
        String returnValue = null;
        for (int i = 0; i < attribCount; ++i) {
            QName attribQualifiedName = this.getAttributeName(i);
            if (nsUri == null) {
                if (!localName.equals(attribQualifiedName.getLocalPart())) continue;
                returnValue = this.getAttributeValue(i);
                break;
            }
            if (!localName.equals(attribQualifiedName.getLocalPart()) || !nsUri.equals(attribQualifiedName.getNamespaceURI())) continue;
            returnValue = this.getAttributeValue(i);
            break;
        }
        return returnValue;
    }

    public int getAttributeCount() {
        return this.state == 2 ? this.childReader.getAttributeCount() : (this.attributes != null && this.state == 0 ? this.attributes.length : 0);
    }

    public QName getAttributeName(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributeName(i);
        }
        if (this.state == 0) {
            if (this.attributes == null) {
                return null;
            }
            if (i >= this.attributes.length || i < 0) {
                return null;
            }
            Object attribPointer = this.attributes[i].getKey();
            if (attribPointer instanceof String) {
                return new QName((String)attribPointer);
            }
            if (attribPointer instanceof QName) {
                return (QName)attribPointer;
            }
            return null;
        }
        throw new IllegalStateException();
    }

    public String getAttributeNamespace(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributeNamespace(i);
        }
        if (this.state == 0) {
            QName name = this.getAttributeName(i);
            if (name == null) {
                return null;
            }
            return name.getNamespaceURI();
        }
        throw new IllegalStateException();
    }

    public String getAttributeLocalName(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributeLocalName(i);
        }
        if (this.state == 0) {
            QName name = this.getAttributeName(i);
            if (name == null) {
                return null;
            }
            return name.getLocalPart();
        }
        throw new IllegalStateException();
    }

    public String getAttributePrefix(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributePrefix(i);
        }
        if (this.state == 0) {
            QName name = this.getAttributeName(i);
            if (name == null) {
                return null;
            }
            return name.getPrefix();
        }
        throw new IllegalStateException();
    }

    public String getAttributeType(int i) {
        return null;
    }

    public String getAttributeValue(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributeValue(i);
        }
        if (this.state == 0) {
            if (this.attributes == null) {
                return null;
            }
            if (i >= this.attributes.length || i < 0) {
                return null;
            }
            Object attribPointer = this.attributes[i].getKey();
            Object omAttribObj = this.attributes[i].getValue();
            String propertyName = null;
            if (attribPointer instanceof String) {
                propertyName = (String)attribPointer;
            } else if (attribPointer instanceof QName) {
                propertyName = ((QName)attribPointer).getLocalPart();
            } else {
                return null;
            }
            String attrValue = (String)omAttribObj;
            Property property = this.dataObject.getType().getProperty(propertyName);
            if (property != null && "URI".equals(property.getType().getName())) {
                String namespace = null;
                String localPart = attrValue;
                int index = attrValue.indexOf(35);
                if (index == -1) {
                    return localPart;
                }
                namespace = localPart.substring(0, index);
                localPart = localPart.substring(index + 1);
                String prefix = this.namespaceContext.getPrefix(namespace);
                if (prefix == null || prefix.length() == 0) {
                    return localPart;
                }
                return prefix + ":" + localPart;
            }
            return attrValue;
        }
        throw new IllegalStateException();
    }

    public boolean isAttributeSpecified(int i) {
        return false;
    }

    public int getNamespaceCount() {
        if (this.state == 2) {
            return this.childReader.getNamespaceCount();
        }
        return this.declaredNamespaceMap.size();
    }

    public String getNamespacePrefix(int i) {
        if (this.state == 2) {
            return this.childReader.getNamespacePrefix(i);
        }
        if (this.state != 3) {
            String[] prefixes = this.makePrefixArray();
            if (i >= prefixes.length || i < 0) {
                return null;
            }
            return prefixes[i];
        }
        throw new IllegalStateException();
    }

    private String[] makePrefixArray() {
        Object[] prefixes = this.declaredNamespaceMap.keySet().toArray(new String[this.declaredNamespaceMap.size()]);
        Arrays.sort(prefixes);
        return prefixes;
    }

    public String getNamespaceURI(int i) {
        if (this.state == 2) {
            return this.childReader.getNamespaceURI(i);
        }
        if (this.state != 3) {
            String namespacePrefix = this.getNamespacePrefix(i);
            return namespacePrefix == null ? null : (String)this.declaredNamespaceMap.get(namespacePrefix);
        }
        throw new IllegalStateException();
    }

    public NamespaceContext getNamespaceContext() {
        if (this.state == 2) {
            return this.childReader.getNamespaceContext();
        }
        return this.namespaceContext;
    }

    public int getEventType() {
        if (this.state == 0) {
            return 1;
        }
        if (this.state == 1) {
            return 2;
        }
        return this.childReader.getEventType();
    }

    public String getText() {
        if (this.state == 2) {
            return this.childReader.getText();
        }
        if (this.state == 3) {
            return (String)this.properties[this.currentPropertyIndex - 1].getValue();
        }
        throw new IllegalStateException();
    }

    public char[] getTextCharacters() {
        if (this.state == 2) {
            return this.childReader.getTextCharacters();
        }
        if (this.state == 3) {
            return this.getTextData();
        }
        throw new IllegalStateException();
    }

    private char[] getTextData() {
        return this.properties[this.currentPropertyIndex - 1].getValue() == null ? new char[]{} : ((String)this.properties[this.currentPropertyIndex - 1].getValue()).toCharArray();
    }

    private int copy(int sourceStart, char[] target, int targetStart, int length) {
        char[] source = this.getTextData();
        if (sourceStart > source.length) {
            throw new IndexOutOfBoundsException("source start > source length");
        }
        int sourceLen = source.length - sourceStart;
        if (length > sourceLen) {
            length = sourceLen;
        }
        System.arraycopy(source, sourceStart, target, targetStart, length);
        return sourceLen;
    }

    public int getTextCharacters(int i, char[] chars, int i1, int i2) throws XMLStreamException {
        if (this.state == 2) {
            return this.childReader.getTextCharacters(i, chars, i1, i2);
        }
        if (this.state == 3) {
            return this.copy(i, chars, i1, i2);
        }
        throw new IllegalStateException();
    }

    public int getTextStart() {
        if (this.state == 2) {
            return this.childReader.getTextStart();
        }
        if (this.state == 3) {
            return 0;
        }
        throw new IllegalStateException();
    }

    public int getTextLength() {
        if (this.state == 2) {
            return this.childReader.getTextLength();
        }
        if (this.state == 3) {
            return this.getTextData().length;
        }
        throw new IllegalStateException();
    }

    public String getEncoding() {
        if (this.state == 2) {
            return this.childReader.getEncoding();
        }
        return null;
    }

    public boolean hasText() {
        if (this.state == 2) {
            return this.childReader.hasText();
        }
        return this.state == 3;
    }

    public Location getLocation() {
        return new Location(){

            public int getLineNumber() {
                return 0;
            }

            public int getColumnNumber() {
                return 0;
            }

            public int getCharacterOffset() {
                return 0;
            }

            public String getPublicId() {
                return null;
            }

            public String getSystemId() {
                return null;
            }
        };
    }

    public QName getName() {
        if (this.state == 2) {
            return this.childReader.getName();
        }
        if (this.state != 3) {
            return this.elementQName;
        }
        throw new IllegalStateException();
    }

    public String getLocalName() {
        if (this.state == 2) {
            return this.childReader.getLocalName();
        }
        if (this.state != 3) {
            return this.elementQName.getLocalPart();
        }
        throw new IllegalStateException();
    }

    public boolean hasName() {
        if (this.state == 2) {
            return this.childReader.hasName();
        }
        return this.state != 3;
    }

    public String getNamespaceURI() {
        if (this.state == 2) {
            return this.childReader.getNamespaceURI();
        }
        if (this.state == 3) {
            return null;
        }
        return this.elementQName.getNamespaceURI();
    }

    public String getPrefix() {
        if (this.state == 2) {
            return this.childReader.getPrefix();
        }
        if (this.state == 3) {
            return null;
        }
        return this.elementQName.getPrefix();
    }

    public String getVersion() {
        return null;
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean standaloneSet() {
        return true;
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getPITarget() {
        throw new UnsupportedOperationException("Yet to be implemented !!");
    }

    public String getPIData() {
        throw new UnsupportedOperationException("Yet to be implemented !!");
    }

    private void populateNamespaceContext() {
        this.registerNamespace(this.elementQName.getPrefix(), this.elementQName.getNamespaceURI());
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                Object attribName = this.attributes[i].getKey();
                if (attribName instanceof String || !(attribName instanceof QName)) continue;
                QName attribQName = (QName)attribName;
                this.registerNamespace(attribQName.getPrefix(), attribQName.getNamespaceURI());
            }
        }
    }

    private void registerNamespace(String prefix, String uri) {
        if (!uri.equals(this.namespaceContext.getNamespaceURI(prefix))) {
            this.namespaceContext.registerMapping(prefix, uri);
            this.declaredNamespaceMap.put(prefix, uri);
        }
    }

    private int updateStatus() throws XMLStreamException {
        int returnEvent = -1;
        switch (this.state) {
            case 0: {
                if (this.properties == null || this.properties.length == 0) {
                    this.state = 1;
                    returnEvent = 2;
                    break;
                }
                returnEvent = this.processProperties();
                break;
            }
            case 1: {
                throw new XMLStreamException("Trying to go beyond the end of the pullparser");
            }
            case 2: {
                if (this.childReader.isEndOfFragment()) {
                    if (this.currentPropertyIndex > this.properties.length - 1) {
                        this.state = 1;
                        returnEvent = 2;
                        break;
                    }
                    returnEvent = this.processProperties();
                    break;
                }
                returnEvent = this.childReader.next();
                break;
            }
            case 3: {
                if (this.currentPropertyIndex > this.properties.length - 1) {
                    this.state = 1;
                    returnEvent = 2;
                    break;
                }
                returnEvent = this.processProperties();
            }
        }
        return returnEvent;
    }

    private int processProperties() throws XMLStreamException {
        Object propPointer = this.properties[this.currentPropertyIndex].getKey();
        QName propertyQName = null;
        boolean textFound = false;
        if (propPointer == null) {
            throw new XMLStreamException("property key cannot be null!");
        }
        if (propPointer instanceof String) {
            if ("Element Text".equals(propPointer)) {
                textFound = true;
            } else {
                propertyQName = new QName((String)propPointer);
            }
        } else if (propPointer instanceof QName) {
            propertyQName = (QName)propPointer;
        } else {
            throw new XMLStreamException("unidentified property key!!!" + propPointer);
        }
        Object propertyValue = this.properties[this.currentPropertyIndex].getValue();
        if (textFound) {
            this.childReader = null;
            this.state = 3;
            ++this.currentPropertyIndex;
            return 4;
        }
        if (propertyValue == null || propertyValue instanceof String) {
            this.childReader = new SimpleElementStreamReader(propertyQName, (String)propertyValue, this.namespaceContext);
            this.childReader.init();
        } else if (propertyValue instanceof DataObjectXMLStreamReader) {
            DataObjectXMLStreamReader reader = (DataObjectXMLStreamReader)propertyValue;
            this.childReader = reader;
            this.childReader.init();
        } else {
            throw new UnsupportedOperationException("Not supported");
        }
        this.state = 2;
        ++this.currentPropertyIndex;
        return this.childReader.getEventType();
    }

    public boolean isEndOfFragment() {
        return this.state == 1;
    }

    protected class NameSpaceContext
    implements NamespaceContext {
        private Map prefixToNamespaceMapping = new HashMap();
        private int counter = 0;

        public NameSpaceContext() {
            this.prefixToNamespaceMapping.put("xml", "http://www.w3.org/XML/1998/namespace");
            this.prefixToNamespaceMapping.put("xmlns", "http://www.w3.org/2000/xmlns/");
            this.prefixToNamespaceMapping.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }

        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("Prefix is null");
            }
            String ns = (String)this.prefixToNamespaceMapping.get(prefix);
            if (ns != null) {
                return ns;
            }
            return null;
        }

        public String getPrefix(String nsURI) {
            if (nsURI == null) {
                throw new IllegalArgumentException("Namespace is null");
            }
            Iterator i = this.prefixToNamespaceMapping.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!entry.getValue().equals(nsURI)) continue;
                return (String)entry.getKey();
            }
            return null;
        }

        public Iterator getPrefixes(String nsURI) {
            ArrayList prefixList = new ArrayList();
            Iterator i = this.prefixToNamespaceMapping.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!entry.getValue().equals(nsURI)) continue;
                prefixList.add(entry.getKey());
            }
            return prefixList.iterator();
        }

        public void registerMapping(String prefix, String nsURI) {
            this.prefixToNamespaceMapping.put(prefix, nsURI);
        }

        public synchronized QName createQName(String nsURI, String name) {
            String prefix;
            String string = prefix = nsURI != null ? this.getPrefix(nsURI) : null;
            if (prefix == null && nsURI != null && !nsURI.equals("")) {
                prefix = "p" + this.counter++;
            }
            if (prefix == null) {
                prefix = "";
            }
            if (nsURI != null) {
                this.prefixToNamespaceMapping.put(prefix, nsURI);
                DataObjectXMLStreamReader.this.declaredNamespaceMap.put(prefix, nsURI);
            }
            return new QName(nsURI, name, prefix);
        }

        public void removeMapping(String prefix) {
            this.prefixToNamespaceMapping.remove(prefix);
        }
    }

    protected static class SimpleElementStreamReader
    implements XMLFragmentStreamReader {
        private static final int START_ELEMENT_STATE = 0;
        private static final int TEXT_STATE = 1;
        private static final int END_ELEMENT_STATE = 2;
        private static final int START_ELEMENT_STATE_WITH_NULL = 3;
        private static final QName XSI_NIL_QNAME = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi");
        private final NameSpaceContext namespaceContext;
        private QName name;
        private String value;
        private int state = 0;

        public SimpleElementStreamReader(QName name, String value, NameSpaceContext nameSpaces) {
            this.name = name;
            this.value = value;
            if (value == null) {
                this.state = 3;
            }
            this.namespaceContext = nameSpaces;
        }

        public Object getProperty(String key) throws IllegalArgumentException {
            return null;
        }

        public int next() throws XMLStreamException {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    return 4;
                }
                case 3: {
                    this.state = 2;
                    return 2;
                }
                case 2: {
                    throw new XMLStreamException("end already reached!");
                }
                case 1: {
                    this.state = 2;
                    return 2;
                }
            }
            throw new XMLStreamException("unknown event type!");
        }

        public void require(int i, String string, String string1) throws XMLStreamException {
        }

        public String getElementText() throws XMLStreamException {
            if (this.state == 1) {
                this.state = 2;
                return this.value;
            }
            throw new XMLStreamException();
        }

        public int nextTag() throws XMLStreamException {
            return 0;
        }

        public boolean hasNext() throws XMLStreamException {
            return this.state != 2;
        }

        public void close() throws XMLStreamException {
        }

        public String getNamespaceURI(String prefix) {
            return this.namespaceContext.getNamespaceURI(prefix);
        }

        public boolean isStartElement() {
            return this.state == 0 || this.state == 3;
        }

        public boolean isEndElement() {
            return this.state == 2;
        }

        public boolean isCharacters() {
            return this.state == 1;
        }

        public boolean isWhiteSpace() {
            return false;
        }

        public boolean isAttributeSpecified(int i) {
            return false;
        }

        public NamespaceContext getNamespaceContext() {
            return this.namespaceContext;
        }

        public int getEventType() {
            switch (this.state) {
                case 0: 
                case 3: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 1: {
                    return 4;
                }
            }
            throw new UnsupportedOperationException();
        }

        public String getText() {
            if (this.state == 1) {
                return this.value;
            }
            throw new IllegalStateException();
        }

        public char[] getTextCharacters() {
            if (this.state == 1) {
                return this.value.toCharArray();
            }
            throw new IllegalStateException();
        }

        public int getTextCharacters(int i, char[] chars, int i1, int i2) throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        public int getTextStart() {
            if (this.state == 1) {
                return 0;
            }
            throw new IllegalStateException();
        }

        public int getTextLength() {
            if (this.state == 1) {
                return this.value.length();
            }
            throw new IllegalStateException();
        }

        public String getEncoding() {
            return "UTF-8";
        }

        public boolean hasText() {
            return this.state == 1;
        }

        public Location getLocation() {
            return new Location(){

                public int getLineNumber() {
                    return 0;
                }

                public int getColumnNumber() {
                    return 0;
                }

                public int getCharacterOffset() {
                    return 0;
                }

                public String getPublicId() {
                    return null;
                }

                public String getSystemId() {
                    return null;
                }
            };
        }

        public QName getName() {
            if (this.state != 1) {
                return this.name;
            }
            return null;
        }

        public String getLocalName() {
            if (this.state != 1) {
                return this.name.getLocalPart();
            }
            return null;
        }

        public boolean hasName() {
            return this.state != 1;
        }

        public String getNamespaceURI() {
            if (this.state != 1) {
                return this.name.getNamespaceURI();
            }
            return null;
        }

        public String getPrefix() {
            if (this.state != 1) {
                return this.name.getPrefix();
            }
            return null;
        }

        public String getVersion() {
            return null;
        }

        public boolean isStandalone() {
            return false;
        }

        public boolean standaloneSet() {
            return false;
        }

        public String getCharacterEncodingScheme() {
            return null;
        }

        public String getPITarget() {
            return null;
        }

        public String getPIData() {
            return null;
        }

        public boolean isEndOfFragment() {
            return this.state == 2;
        }

        public void init() {
            this.registerNamespace(this.name.getPrefix(), this.name.getNamespaceURI());
        }

        private void registerNamespace(String prefix, String uri) {
            if (!uri.equals(this.namespaceContext.getNamespaceURI(prefix))) {
                this.namespaceContext.registerMapping(prefix, uri);
            }
        }

        public int getAttributeCount() {
            if (this.state == 3) {
                return 1;
            }
            if (this.state == 0) {
                return 0;
            }
            throw new IllegalStateException();
        }

        public String getAttributeLocalName(int i) {
            if (this.state == 3 && i == 0) {
                return XSI_NIL_QNAME.getLocalPart();
            }
            if (this.state == 0) {
                return null;
            }
            throw new IllegalStateException();
        }

        public QName getAttributeName(int i) {
            if (this.state == 3 && i == 0) {
                return XSI_NIL_QNAME;
            }
            if (this.state == 0) {
                return null;
            }
            throw new IllegalStateException();
        }

        public String getAttributeNamespace(int i) {
            if (this.state == 3 && i == 0) {
                return XSI_NIL_QNAME.getNamespaceURI();
            }
            if (this.state == 0) {
                return null;
            }
            throw new IllegalStateException();
        }

        public String getAttributePrefix(int i) {
            if (this.state == 3 && i == 0) {
                return XSI_NIL_QNAME.getPrefix();
            }
            if (this.state == 0) {
                return null;
            }
            throw new IllegalStateException();
        }

        public String getAttributeType(int i) {
            return null;
        }

        public String getAttributeValue(int i) {
            if (this.state == 3 && i == 0) {
                return "true";
            }
            if (this.state == 0) {
                return null;
            }
            throw new IllegalStateException();
        }

        public String getAttributeValue(String string, String string1) {
            if (this.state == 1) {
                return null;
            }
            return null;
        }

        public int getNamespaceCount() {
            if (this.state == 3 && this.isXsiNamespacePresent()) {
                return 1;
            }
            return 0;
        }

        public String getNamespacePrefix(int i) {
            if (this.state == 3 && this.isXsiNamespacePresent() && i == 0) {
                return XSI_NIL_QNAME.getPrefix();
            }
            return null;
        }

        public String getNamespaceURI(int i) {
            if (this.state == 3 && this.isXsiNamespacePresent() && i == 0) {
                return XSI_NIL_QNAME.getNamespaceURI();
            }
            return null;
        }

        private boolean isXsiNamespacePresent() {
            return this.namespaceContext.getNamespaceURI(XSI_NIL_QNAME.getPrefix()) != null;
        }
    }

    protected static class NameValuePair
    implements Map.Entry {
        private Object key;
        private Object value;

        public NameValuePair(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object v = this.value;
            this.value = value;
            return v;
        }
    }
}

