/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.spi;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.helper.HelperContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sdo.api.SDOHelper;
import org.apache.tuscany.sdo.api.SDOUtil;
import org.apache.tuscany.sdo.lib.SDOObjectInputStream;
import org.apache.tuscany.sdo.lib.SDOObjectOutputStream;

public abstract class SDOHelperBase
implements SDOHelper,
SDOHelper.MetaDataBuilder {
    protected static Map javaToSdoMappings = new HashMap();
    protected static Map xsdToSdoMappings;

    public HelperContext createHelperContext() {
        return this.createHelperContext(false);
    }

    public ObjectInputStream createObjectInputStream(InputStream inputStream, HelperContext helperContext) throws IOException {
        return new SDOObjectInputStream(inputStream, helperContext);
    }

    public ObjectOutputStream createObjectOutputStream(OutputStream outputStream, HelperContext helperContext) throws IOException {
        return new SDOObjectOutputStream(outputStream, helperContext);
    }

    public String getXPath(DataObject dataObject) {
        StringBuffer path = this.getXPath(dataObject, new StringBuffer(), dataObject);
        return path.toString();
    }

    protected StringBuffer getXPath(DataObject dataObject, StringBuffer path, DataObject root) {
        DataObject container = dataObject.getContainer();
        if (container == null) {
            return path;
        }
        if (container == root) {
            throw new IllegalStateException("There is a cycle in the containment hierarchy of " + root);
        }
        boolean first = path.length() == 0;
        Property property = dataObject.getContainmentProperty();
        if (SDOUtil.isMany(property, dataObject)) {
            List list = container.getList(property);
            int pos = list.indexOf(dataObject);
            path.insert(0, property.getName() + "." + pos + (first ? "" : "/"));
        } else {
            path.insert(0, property.getName() + (first ? "" : "/"));
        }
        return this.getXPath(container, path, root);
    }

    public SDOHelper.MetaDataBuilder getMetaDataBuilder() {
        return this;
    }

    static {
        javaToSdoMappings.put(Boolean.TYPE, "Boolean");
        javaToSdoMappings.put(Byte.TYPE, "Byte");
        javaToSdoMappings.put(Character.TYPE, "Character");
        javaToSdoMappings.put(Date.class, "Date");
        javaToSdoMappings.put(BigDecimal.class, "Decimal");
        javaToSdoMappings.put(Double.TYPE, "Double");
        javaToSdoMappings.put(Float.TYPE, "Float");
        javaToSdoMappings.put(Integer.TYPE, "Int");
        javaToSdoMappings.put(BigInteger.class, "Integer");
        javaToSdoMappings.put(Long.TYPE, "Long");
        javaToSdoMappings.put(Object.class, "Object");
        javaToSdoMappings.put(Short.TYPE, "Short");
        javaToSdoMappings.put(String.class, "String");
        javaToSdoMappings.put(Boolean.class, "BooleanObject");
        javaToSdoMappings.put(Byte.class, "ByteObject");
        javaToSdoMappings.put(Character.class, "CharacterObject");
        javaToSdoMappings.put(Double.class, "DoubleObject");
        javaToSdoMappings.put(Float.class, "FloatObject");
        javaToSdoMappings.put(Integer.class, "IntObject");
        javaToSdoMappings.put(Long.class, "LongObject");
        javaToSdoMappings.put(Short.class, "ShortObject");
        xsdToSdoMappings = new HashMap();
        xsdToSdoMappings.put("anySimpleType", "Object");
        xsdToSdoMappings.put("anyType", "DataObject");
        xsdToSdoMappings.put("anyURI", "URI");
        xsdToSdoMappings.put("base64Binary", "Bytes");
        xsdToSdoMappings.put("boolean", "Boolean");
        xsdToSdoMappings.put("byte", "Byte");
        xsdToSdoMappings.put("date", "YearMonthDay");
        xsdToSdoMappings.put("dateTime", "DateTime");
        xsdToSdoMappings.put("decimal", "Decimal");
        xsdToSdoMappings.put("double", "Double");
        xsdToSdoMappings.put("duration", "Duration");
        xsdToSdoMappings.put("ENTITIES", "Strings");
        xsdToSdoMappings.put("ENTITY", "String");
        xsdToSdoMappings.put("float", "Float");
        xsdToSdoMappings.put("gDay", "Day");
        xsdToSdoMappings.put("gMonth", "Month");
        xsdToSdoMappings.put("gMonthDay", "MonthDay");
        xsdToSdoMappings.put("gYear", "Year");
        xsdToSdoMappings.put("gYearMonth", "YearMonth");
        xsdToSdoMappings.put("hexBinary", "Bytes");
        xsdToSdoMappings.put("ID", "String");
        xsdToSdoMappings.put("IDREF", "String");
        xsdToSdoMappings.put("IDREFS", "Strings");
        xsdToSdoMappings.put("int", "Int");
        xsdToSdoMappings.put("integer", "Integer");
        xsdToSdoMappings.put("language", "String");
        xsdToSdoMappings.put("long", "Long");
        xsdToSdoMappings.put("Name", "String");
        xsdToSdoMappings.put("NCName", "String");
        xsdToSdoMappings.put("negativeInteger", "Integer");
        xsdToSdoMappings.put("NMTOKEN", "String");
        xsdToSdoMappings.put("NMTOKENS", "Strings");
        xsdToSdoMappings.put("nonNegativeInteger", "Integer");
        xsdToSdoMappings.put("nonPositiveInteger", "Integer");
        xsdToSdoMappings.put("normalizedString", "String");
        xsdToSdoMappings.put("NOTATION", "String");
        xsdToSdoMappings.put("positiveInteger", "Integer");
        xsdToSdoMappings.put("QName", "URI");
        xsdToSdoMappings.put("short", "Short");
        xsdToSdoMappings.put("string", "String");
        xsdToSdoMappings.put("time", "Time");
        xsdToSdoMappings.put("token", "String");
        xsdToSdoMappings.put("unsignedByte", "Short");
        xsdToSdoMappings.put("unsignedInt", "Long");
        xsdToSdoMappings.put("unsignedLong", "Integer");
        xsdToSdoMappings.put("unsignedShort", "Int");
    }
}

