/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.concurrent;

import com.google.common.collect.DiscreteDomain;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.tuweni.concurrent.AsyncResult;

public final class AtomicSlotMap<K extends Comparable, V> {
    private final DiscreteDomain<K> domain;
    private final ConcurrentHashMap<K, Optional<V>> slots = new ConcurrentHashMap();
    private final AtomicInteger size = new AtomicInteger(0);

    public static <V> AtomicSlotMap<Integer, V> positiveIntegerSlots() {
        return new AtomicSlotMap<Integer, V>(PositiveIntegerDomain.INSTANCE);
    }

    public AtomicSlotMap(DiscreteDomain<K> domain) {
        Objects.requireNonNull(domain);
        this.domain = domain;
    }

    public K add(V value) {
        Objects.requireNonNull(value);
        Comparable slot = this.domain.minValue();
        Optional<V> storedValue = Optional.of(value);
        while (this.slots.containsKey(slot) || this.slots.putIfAbsent(slot, storedValue) != null) {
            slot = this.domain.next(slot);
        }
        this.size.incrementAndGet();
        return (K)slot;
    }

    @Nullable
    public V put(K slot, V value) {
        Objects.requireNonNull(slot);
        Objects.requireNonNull(value);
        Optional<V> previous = this.slots.put(slot, Optional.of(value));
        if (previous == null || !previous.isPresent()) {
            this.size.incrementAndGet();
            return null;
        }
        return previous.get();
    }

    public K compute(Function<? super K, ? extends V> fn) {
        Objects.requireNonNull(fn);
        Comparable slot = this.domain.minValue();
        Optional placeholder = Optional.empty();
        while (this.slots.containsKey(slot) || this.slots.putIfAbsent(slot, placeholder) != null) {
            slot = this.domain.next(slot);
        }
        try {
            if (this.slots.replace(slot, placeholder, Optional.of(fn.apply(slot)))) {
                this.size.incrementAndGet();
            }
            return (K)slot;
        }
        catch (Throwable ex) {
            this.slots.remove(slot, placeholder);
            throw ex;
        }
    }

    public AsyncResult<K> computeAsync(Function<? super K, AsyncResult<? extends V>> fn) {
        Objects.requireNonNull(fn);
        Comparable slot = this.domain.minValue();
        Optional placeholder = Optional.empty();
        while (this.slots.containsKey(slot) || this.slots.putIfAbsent(slot, placeholder) != null) {
            slot = this.domain.next(slot);
        }
        Comparable finalSlot = slot;
        try {
            return fn.apply(finalSlot).thenApply(value -> {
                if (this.slots.replace(finalSlot, placeholder, Optional.of(value))) {
                    this.size.incrementAndGet();
                }
                return finalSlot;
            });
        }
        catch (Throwable ex) {
            this.slots.remove(finalSlot, placeholder);
            throw ex;
        }
    }

    @Nullable
    public V get(K slot) {
        Objects.requireNonNull(slot);
        Optional<V> value = this.slots.get(slot);
        if (value == null) {
            return null;
        }
        return value.orElse(null);
    }

    @Nullable
    public V remove(K slot) {
        Objects.requireNonNull(slot);
        Optional<V> previous = this.slots.remove(slot);
        if (previous == null || !previous.isPresent()) {
            return null;
        }
        this.size.decrementAndGet();
        return previous.get();
    }

    public int size() {
        return this.size.get();
    }

    public Stream<Map.Entry<K, V>> entries() {
        return this.slots.entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).map(e -> new Map.Entry<K, V>((Map.Entry)e){
            final /* synthetic */ Map.Entry val$e;
            {
                this.val$e = entry;
            }

            @Override
            public K getKey() {
                return (Comparable)this.val$e.getKey();
            }

            @Override
            public V getValue() {
                return ((Optional)this.val$e.getValue()).get();
            }

            @Override
            public V setValue(Object value) {
                throw new UnsupportedOperationException();
            }
        });
    }

    public Stream<V> values() {
        return this.slots.values().stream().filter(Optional::isPresent).map(Optional::get);
    }

    private static final class PositiveIntegerDomain
    extends DiscreteDomain<Integer> {
        private static final PositiveIntegerDomain INSTANCE = new PositiveIntegerDomain();

        private PositiveIntegerDomain() {
        }

        public Integer next(Integer value) {
            int i = value;
            return i == Integer.MAX_VALUE ? null : Integer.valueOf(i + 1);
        }

        public Integer previous(Integer value) {
            int i = value;
            return i == 1 ? null : Integer.valueOf(i - 1);
        }

        public long distance(Integer start, Integer end) {
            return (long)end.intValue() - (long)start.intValue();
        }

        public Integer minValue() {
            return 1;
        }

        public Integer maxValue() {
            return Integer.MAX_VALUE;
        }
    }
}

