/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.mikuli;

import java.util.List;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.mikuli.G2Point;

public final class Signature {
    private final G2Point point;

    public static Signature aggregate(List<Signature> signatures) {
        if (signatures.isEmpty()) {
            throw new IllegalArgumentException("Parameter list is empty");
        }
        return (Signature)signatures.stream().reduce(Signature::combine).get();
    }

    public static Signature decode(Bytes bytes) {
        G2Point point = G2Point.fromBytes(bytes);
        return new Signature(point);
    }

    Signature(G2Point point) {
        this.point = point;
    }

    public Signature combine(Signature signature) {
        return new Signature(this.point.add(signature.point));
    }

    public Bytes encode() {
        return this.point.toBytes();
    }

    public String toString() {
        return "Signature [ecpPoint=" + this.point.toString() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.point == null ? 0 : this.point.hashCode());
        return result;
    }

    G2Point g2Point() {
        return this.point;
    }

    public boolean equals(Object obj) {
        if (Objects.isNull(obj)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)obj;
        return this.point.equals(other.point);
    }
}

