/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.sodium;

import com.google.common.base.Preconditions;
import javax.security.auth.Destroyable;
import jnr.ffi.Pointer;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.sodium.Allocated;
import org.apache.tuweni.crypto.sodium.Sodium;
import org.apache.tuweni.crypto.sodium.SodiumException;

public final class HMACSHA512 {
    private HMACSHA512() {
    }

    public static Bytes authenticate(Bytes message, Key key) {
        return Bytes.wrap((byte[])HMACSHA512.authenticate(message.toArrayUnsafe(), key));
    }

    public static byte[] authenticate(byte[] message, Key key) {
        Preconditions.checkArgument((!key.isDestroyed() ? 1 : 0) != 0, (Object)"Key has been destroyed");
        long authBytes = Sodium.crypto_auth_hmacsha512_bytes();
        if (authBytes > Integer.MAX_VALUE) {
            throw new SodiumException("crypto_auth_hmacsha512_bytes: " + authBytes + " is too large");
        }
        byte[] out = new byte[(int)authBytes];
        int rc = Sodium.crypto_auth_hmacsha512(out, message, message.length, key.value.pointer());
        if (rc != 0) {
            throw new SodiumException("crypto_auth_hmacsha512: failed with result " + rc);
        }
        return out;
    }

    public static boolean verify(Bytes authenticator, Bytes in, Key key) {
        return HMACSHA512.verify(authenticator.toArrayUnsafe(), in.toArrayUnsafe(), key);
    }

    public static boolean verify(byte[] authenticator, byte[] in, Key key) {
        Preconditions.checkArgument((!key.isDestroyed() ? 1 : 0) != 0, (Object)"Key has been destroyed");
        if ((long)authenticator.length != Sodium.crypto_auth_hmacsha512_bytes()) {
            throw new IllegalArgumentException("Expected authenticator of " + Sodium.crypto_auth_hmacsha512_bytes() + " bytes, got " + authenticator.length + " instead");
        }
        int rc = Sodium.crypto_auth_hmacsha512_verify(authenticator, in, in.length, key.value.pointer());
        return rc == 0;
    }

    public static final class Key
    implements Destroyable {
        final Allocated value;

        Key(Pointer ptr, int length) {
            this.value = new Allocated(ptr, length);
        }

        @Override
        public void destroy() {
            this.value.destroy();
        }

        @Override
        public boolean isDestroyed() {
            return this.value.isDestroyed();
        }

        public static Key fromBytes(Bytes bytes) {
            return Key.fromBytes(bytes.toArrayUnsafe());
        }

        public static Key fromBytes(byte[] bytes) {
            if ((long)bytes.length != Sodium.crypto_auth_hmacsha512_keybytes()) {
                throw new IllegalArgumentException("key must be " + Sodium.crypto_auth_hmacsha512_keybytes() + " bytes, got " + bytes.length);
            }
            return Sodium.dup(bytes, Key::new);
        }

        public static Key random() {
            return Sodium.randomBytes(Key.length(), Key::new);
        }

        public static int length() {
            long keybytes = Sodium.crypto_auth_hmacsha512_keybytes();
            if (keybytes > Integer.MAX_VALUE) {
                throw new SodiumException("crypto_auth_hmacsha512_keybytes: " + keybytes + " is too large");
            }
            return (int)keybytes;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return other.value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public Bytes bytes() {
            return this.value.bytes();
        }

        public byte[] bytesArray() {
            return this.value.bytesArray();
        }
    }
}

