/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.mikuli;

import java.util.Objects;
import org.apache.milagro.amcl.BLS381.ECP2;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.mikuli.Group;
import org.apache.tuweni.crypto.mikuli.Scalar;

final class G2Point
implements Group<G2Point> {
    private final ECP2 point;
    private static final int fpPointSize = 48;

    G2Point(ECP2 point) {
        this.point = point;
    }

    @Override
    public G2Point add(G2Point other) {
        ECP2 sum = new ECP2();
        sum.add(this.point);
        sum.add(other.point);
        sum.affine();
        return new G2Point(sum);
    }

    @Override
    public G2Point mul(Scalar scalar) {
        ECP2 newPoint = this.point.mul(scalar.value());
        return new G2Point(newPoint);
    }

    Bytes toBytes() {
        byte[] bytes = new byte[192];
        this.point.toBytes(bytes);
        return Bytes.wrap((byte[])bytes);
    }

    static G2Point fromBytes(Bytes bytes) {
        return new G2Point(ECP2.fromBytes((byte[])bytes.toArrayUnsafe()));
    }

    ECP2 ecp2Point() {
        return this.point;
    }

    public String toString() {
        return this.point.toString();
    }

    public boolean equals(Object obj) {
        if (Objects.isNull(obj)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof G2Point)) {
            return false;
        }
        G2Point other = (G2Point)obj;
        return this.point.equals(other.point);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long xa = this.point.getX().getA().norm();
        long ya = this.point.getY().getA().norm();
        long xb = this.point.getX().getB().norm();
        long yb = this.point.getY().getB().norm();
        result = 31 * result + (int)(xa ^ xa >>> 32);
        result = 31 * result + (int)(ya ^ ya >>> 32);
        result = 31 * result + (int)(xb ^ xb >>> 32);
        result = 31 * result + (int)(yb ^ yb >>> 32);
        return result;
    }
}

