/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.mikuli;

import java.util.List;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.mikuli.G1Point;

public final class PublicKey {
    private final G1Point point;

    public static PublicKey aggregate(List<PublicKey> keys) {
        if (keys.isEmpty()) {
            throw new IllegalArgumentException("Parameter list is empty");
        }
        return (PublicKey)keys.stream().reduce((a, b) -> a.combine((PublicKey)b)).get();
    }

    public static PublicKey fromBytes(byte[] bytes) {
        return PublicKey.fromBytes(Bytes.wrap((byte[])bytes));
    }

    public static PublicKey fromBytes(Bytes bytes) {
        G1Point point = G1Point.fromBytes(bytes);
        return new PublicKey(point);
    }

    PublicKey(G1Point point) {
        this.point = point;
    }

    PublicKey combine(PublicKey pk) {
        return new PublicKey(this.point.add(pk.point));
    }

    public byte[] toByteArray() {
        return this.point.toBytes().toArrayUnsafe();
    }

    public Bytes toBytes() {
        return this.point.toBytes();
    }

    G1Point g1Point() {
        return this.point;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.point);
        return result;
    }

    public boolean equals(Object obj) {
        if (Objects.isNull(obj)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PublicKey)) {
            return false;
        }
        PublicKey other = (PublicKey)obj;
        return this.point.equals(other.point);
    }
}

