/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.sodium;

import java.util.Objects;
import javax.security.auth.Destroyable;
import jnr.ffi.Pointer;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.sodium.Allocated;
import org.apache.tuweni.crypto.sodium.DiffieHelman;
import org.apache.tuweni.crypto.sodium.Sodium;
import org.apache.tuweni.crypto.sodium.SodiumException;

public class SHA512Hash {
    public static Hash hash(Input input) {
        Pointer output = Sodium.malloc(Hash.length());
        Sodium.crypto_hash_sha512(output, input.value.pointer(), input.length());
        return new Hash(output, Hash.length());
    }

    public static final class Hash
    implements Destroyable {
        Allocated value;

        Hash(Pointer ptr, int length) {
            this.value = new Allocated(ptr, length);
        }

        @Override
        public void destroy() {
            this.value.destroy();
        }

        @Override
        public boolean isDestroyed() {
            return this.value.isDestroyed();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Hash)) {
                return false;
            }
            Hash other = (Hash)obj;
            return other.value.equals(this.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public Bytes bytes() {
            return this.value.bytes();
        }

        public byte[] bytesArray() {
            return this.value.bytesArray();
        }

        public static int length() {
            long hashbytes = Sodium.crypto_hash_sha512_bytes();
            if (hashbytes > Integer.MAX_VALUE) {
                throw new SodiumException("crypto_hash_sha512_bytes: " + hashbytes + " is too large");
            }
            return (int)hashbytes;
        }
    }

    public static final class Input
    implements Destroyable {
        private final Allocated value;

        public static Input fromSecret(DiffieHelman.Secret secret) {
            return new Input(Sodium.dup(secret.value.pointer(), DiffieHelman.Secret.length()), DiffieHelman.Secret.length());
        }

        public static Input fromPointer(Allocated allocated) {
            return new Input(Sodium.dup(allocated.pointer(), allocated.length()), allocated.length());
        }

        public static Input fromHash(Hash hash) {
            return new Input(Sodium.dup(hash.value.pointer(), hash.value.length()), hash.value.length());
        }

        public static Input fromBytes(Bytes bytes) {
            return Input.fromBytes(bytes.toArrayUnsafe());
        }

        public static Input fromBytes(byte[] bytes) {
            return Sodium.dup(bytes, Input::new);
        }

        private Input(Pointer ptr, int length) {
            this.value = new Allocated(ptr, length);
        }

        @Override
        public void destroy() {
            this.value.destroy();
        }

        @Override
        public boolean isDestroyed() {
            return this.value.isDestroyed();
        }

        public int length() {
            return this.value.length();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Input)) {
                return false;
            }
            Input other = (Input)obj;
            return other.value.equals(this.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public Bytes bytes() {
            return this.value.bytes();
        }

        public byte[] bytesArray() {
            return this.value.bytesArray();
        }
    }
}

