/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.devp2p.v5.AuthenticationProvider;
import org.apache.tuweni.devp2p.v5.encrypt.AES128GCM;
import org.apache.tuweni.devp2p.v5.encrypt.SessionKeyGenerator;
import org.apache.tuweni.devp2p.v5.misc.AuthHeader;
import org.apache.tuweni.devp2p.v5.misc.HandshakeInitParameters;
import org.apache.tuweni.devp2p.v5.misc.SessionKey;
import org.apache.tuweni.devp2p.v5.storage.RoutingTable;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\u000bH\u0016J0\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\fH\u0016J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/apache/tuweni/devp2p/v5/internal/DefaultAuthenticationProvider;", "Lorg/apache/tuweni/devp2p/v5/AuthenticationProvider;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "routingTable", "Lorg/apache/tuweni/devp2p/v5/storage/RoutingTable;", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;Lorg/apache/tuweni/devp2p/v5/storage/RoutingTable;)V", "nodeId", "Lorg/apache/tuweni/bytes/Bytes;", "sessionKeys", "Lcom/google/common/cache/Cache;", "", "Lorg/apache/tuweni/devp2p/v5/misc/SessionKey;", "authenticate", "Lorg/apache/tuweni/devp2p/v5/misc/AuthHeader;", "handshakeParams", "Lorg/apache/tuweni/devp2p/v5/misc/HandshakeInitParameters;", "finalizeHandshake", "", "senderNodeId", "authHeader", "findSessionKey", "generateAuthHeader", "enr", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "params", "authRespKey", "ephemeralPubKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "setSessionKey", "sessionKey", "sign", "verifySignature", "", "signatureBytes", "idNonce", "publicKey", "Companion", "devp2p"})
public final class DefaultAuthenticationProvider
implements AuthenticationProvider {
    private final Cache<String, SessionKey> sessionKeys;
    private final Bytes nodeId;
    private final SECP256K1.KeyPair keyPair;
    private final RoutingTable routingTable;
    private static final long SESSION_KEY_EXPIRATION = 5L;
    private static final int ZERO_NONCE_SIZE = 12;
    private static final int VERSION = 5;
    private static final Bytes DISCOVERY_ID_NONCE;
    public static final Companion Companion;

    @Override
    @NotNull
    public synchronized AuthHeader authenticate(@NotNull HandshakeInitParameters handshakeParams) {
        Intrinsics.checkParameterIsNotNull((Object)handshakeParams, (String)"handshakeParams");
        SECP256K1.KeyPair ephemeralKeyPair = SECP256K1.KeyPair.random();
        SECP256K1.SecretKey ephemeralKey = ephemeralKeyPair.secretKey();
        EthereumNodeRecord destEnr = EthereumNodeRecord.Companion.fromRLP(handshakeParams.getDestEnr());
        Bytes32 destNodeId = Hash.sha2_256((Bytes)handshakeParams.getDestEnr());
        Bytes32 secret = SECP256K1.calculateKeyAgreement((SECP256K1.SecretKey)ephemeralKey, (SECP256K1.PublicKey)destEnr.publicKey());
        Bytes32 bytes32 = destNodeId;
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes32, (String)"destNodeId");
        Bytes bytes = (Bytes)bytes32;
        Bytes32 bytes322 = secret;
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes322, (String)"secret");
        SessionKey sessionKey = SessionKeyGenerator.INSTANCE.generate(this.nodeId, bytes, (Bytes)bytes322, handshakeParams.getIdNonce());
        this.sessionKeys.put((Object)destNodeId.toHexString(), (Object)sessionKey);
        SECP256K1.Signature signature = this.sign(this.keyPair, handshakeParams);
        Bytes bytes2 = this.routingTable.getSelfEnr();
        Bytes bytes3 = sessionKey.getAuthRespKey();
        SECP256K1.PublicKey publicKey = ephemeralKeyPair.publicKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"ephemeralKeyPair.publicKey()");
        return this.generateAuthHeader(bytes2, signature, handshakeParams, bytes3, publicKey);
    }

    @Override
    @Nullable
    public synchronized SessionKey findSessionKey(@NotNull String nodeId) {
        Intrinsics.checkParameterIsNotNull((Object)nodeId, (String)"nodeId");
        return (SessionKey)this.sessionKeys.getIfPresent((Object)nodeId);
    }

    @Override
    public synchronized void setSessionKey(@NotNull String nodeId, @NotNull SessionKey sessionKey) {
        Intrinsics.checkParameterIsNotNull((Object)nodeId, (String)"nodeId");
        Intrinsics.checkParameterIsNotNull((Object)sessionKey, (String)"sessionKey");
        this.sessionKeys.put((Object)nodeId, (Object)sessionKey);
    }

    @Override
    public synchronized void finalizeHandshake(@NotNull Bytes senderNodeId, @NotNull AuthHeader authHeader) {
        Bytes32 secret;
        Intrinsics.checkParameterIsNotNull((Object)senderNodeId, (String)"senderNodeId");
        Intrinsics.checkParameterIsNotNull((Object)authHeader, (String)"authHeader");
        SECP256K1.PublicKey ephemeralPublicKey = SECP256K1.PublicKey.fromBytes((Bytes)authHeader.getEphemeralPublicKey());
        Bytes32 bytes32 = secret = SECP256K1.calculateKeyAgreement((SECP256K1.SecretKey)this.keyPair.secretKey(), (SECP256K1.PublicKey)ephemeralPublicKey);
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes32, (String)"secret");
        SessionKey sessionKey = SessionKeyGenerator.INSTANCE.generate(senderNodeId, this.nodeId, (Bytes)bytes32, authHeader.getIdNonce());
        Bytes bytes = authHeader.getAuthResponse();
        Bytes bytes2 = sessionKey.getAuthRespKey();
        Bytes bytes3 = Bytes.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes3, (String)"Bytes.EMPTY");
        Bytes decryptedAuthResponse = AES128GCM.INSTANCE.decrypt(bytes, bytes2, bytes3);
        RLP.decodeList((Bytes)Bytes.wrap((Bytes[])new Bytes[]{decryptedAuthResponse}), (Function)new Function<RLPReader, T>(this, authHeader, senderNodeId, sessionKey){
            final /* synthetic */ DefaultAuthenticationProvider this$0;
            final /* synthetic */ AuthHeader $authHeader;
            final /* synthetic */ Bytes $senderNodeId;
            final /* synthetic */ SessionKey $sessionKey;

            public final void apply(RLPReader reader) {
                Bytes enrRLP;
                reader.skipNext();
                Bytes signatureBytes = reader.readValue();
                Bytes bytes = enrRLP = reader.readValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"enrRLP");
                EthereumNodeRecord enr = EthereumNodeRecord.Companion.fromRLP(bytes);
                SECP256K1.PublicKey publicKey = enr.publicKey();
                Bytes bytes2 = signatureBytes;
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes2, (String)"signatureBytes");
                boolean signatureVerified = DefaultAuthenticationProvider.access$verifySignature(this.this$0, bytes2, this.$authHeader.getIdNonce(), publicKey);
                if (!signatureVerified) {
                    throw (Throwable)new IllegalArgumentException("Signature is not verified");
                }
                DefaultAuthenticationProvider.access$getSessionKeys$p(this.this$0).put((Object)this.$senderNodeId.toHexString(), (Object)this.$sessionKey);
                DefaultAuthenticationProvider.access$getRoutingTable$p(this.this$0).add(enrRLP);
            }
            {
                this.this$0 = defaultAuthenticationProvider;
                this.$authHeader = authHeader;
                this.$senderNodeId = bytes;
                this.$sessionKey = sessionKey;
            }
        });
    }

    private final SECP256K1.Signature sign(SECP256K1.KeyPair keyPair, HandshakeInitParameters params) {
        Bytes signValue = Bytes.wrap((Bytes[])new Bytes[]{DISCOVERY_ID_NONCE, params.getIdNonce()});
        Bytes32 hashedSignValue = Hash.sha2_256((Bytes)signValue);
        SECP256K1.Signature signature = SECP256K1.sign((Bytes)((Bytes)hashedSignValue), (SECP256K1.KeyPair)keyPair);
        Intrinsics.checkExpressionValueIsNotNull((Object)signature, (String)"SECP256K1.sign(hashedSignValue, keyPair)");
        return signature;
    }

    private final boolean verifySignature(Bytes signatureBytes, Bytes idNonce, SECP256K1.PublicKey publicKey) {
        SECP256K1.Signature signature = SECP256K1.Signature.fromBytes((Bytes)signatureBytes);
        Bytes signValue = Bytes.wrap((Bytes[])new Bytes[]{DISCOVERY_ID_NONCE, idNonce});
        Bytes32 hashedSignValue = Hash.sha2_256((Bytes)signValue);
        return SECP256K1.verify((Bytes)((Bytes)hashedSignValue), (SECP256K1.Signature)signature, (SECP256K1.PublicKey)publicKey);
    }

    private final AuthHeader generateAuthHeader(Bytes enr, SECP256K1.Signature signature, HandshakeInitParameters params, Bytes authRespKey, SECP256K1.PublicKey ephemeralPubKey) {
        Bytes zeroNonce;
        Bytes plain2 = RLP.encodeList((Consumer)new Consumer<RLPWriter>(signature, enr){
            final /* synthetic */ SECP256K1.Signature $signature;
            final /* synthetic */ Bytes $enr;

            public final void accept(RLPWriter writer) {
                writer.writeInt(5);
                writer.writeValue(this.$signature.bytes());
                writer.writeValue(this.$enr);
            }
            {
                this.$signature = signature;
                this.$enr = bytes;
            }
        });
        Bytes bytes = zeroNonce = Bytes.wrap((byte[])new byte[12]);
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"zeroNonce");
        Bytes bytes2 = plain2;
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes2, (String)"plain");
        Bytes bytes3 = Bytes.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes3, (String)"Bytes.EMPTY");
        Bytes authResponse = AES128GCM.INSTANCE.encrypt(authRespKey, bytes, bytes2, bytes3);
        Bytes bytes4 = params.getAuthTag();
        Bytes bytes5 = params.getIdNonce();
        Bytes bytes6 = ephemeralPubKey.bytes();
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes6, (String)"ephemeralPubKey.bytes()");
        Bytes bytes7 = Bytes.wrap((Bytes[])new Bytes[]{authResponse});
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes7, (String)"Bytes.wrap(authResponse)");
        return new AuthHeader(bytes4, bytes5, bytes6, bytes7, null, 16, null);
    }

    public DefaultAuthenticationProvider(@NotNull SECP256K1.KeyPair keyPair, @NotNull RoutingTable routingTable) {
        Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
        Intrinsics.checkParameterIsNotNull((Object)routingTable, (String)"routingTable");
        this.keyPair = keyPair;
        this.routingTable = routingTable;
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cache, (String)"CacheBuilder\n    .newBui\u2026nit.MINUTES)\n    .build()");
        this.sessionKeys = cache;
        Bytes32 bytes32 = Hash.sha2_256((Bytes)this.routingTable.getSelfEnr());
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes32, (String)"Hash.sha2_256(routingTable.getSelfEnr())");
        this.nodeId = (Bytes)bytes32;
    }

    static {
        Companion = new Companion(null);
        String string = "discovery-id-nonce";
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Bytes bytes = Bytes.wrap((byte[])byArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"Bytes.wrap(\"discovery-id-nonce\".toByteArray())");
        DISCOVERY_ID_NONCE = bytes;
    }

    public static final /* synthetic */ boolean access$verifySignature(DefaultAuthenticationProvider $this, Bytes signatureBytes, Bytes idNonce, SECP256K1.PublicKey publicKey) {
        return $this.verifySignature(signatureBytes, idNonce, publicKey);
    }

    public static final /* synthetic */ Cache access$getSessionKeys$p(DefaultAuthenticationProvider $this) {
        return $this.sessionKeys;
    }

    public static final /* synthetic */ RoutingTable access$getRoutingTable$p(DefaultAuthenticationProvider $this) {
        return $this.routingTable;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/apache/tuweni/devp2p/v5/internal/DefaultAuthenticationProvider$Companion;", "", "()V", "DISCOVERY_ID_NONCE", "Lorg/apache/tuweni/bytes/Bytes;", "SESSION_KEY_EXPIRATION", "", "VERSION", "", "ZERO_NONCE_SIZE", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

