/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5.packet;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.Hash;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\b\u0010\u0005\u001a\u00020\u0004H&\u00a8\u0006\u0007"}, d2={"Lorg/apache/tuweni/devp2p/v5/packet/UdpMessage;", "", "()V", "encode", "Lorg/apache/tuweni/bytes/Bytes;", "getMessageType", "Companion", "devp2p"})
public abstract class UdpMessage {
    public static final int MAX_UDP_MESSAGE_SIZE = 1280;
    public static final int TAG_LENGTH = 32;
    public static final int AUTH_TAG_LENGTH = 12;
    public static final int RANDOM_DATA_LENGTH = 44;
    public static final int ID_NONCE_LENGTH = 32;
    public static final int REQUEST_ID_LENGTH = 8;
    private static final Bytes WHO_ARE_YOU;
    public static final Companion Companion;

    @NotNull
    public abstract Bytes encode();

    @NotNull
    public abstract Bytes getMessageType();

    static {
        Companion = new Companion(null);
        String string = "WHOAREYOU";
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Bytes bytes = Bytes.wrap((byte[])byArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"Bytes.wrap(\"WHOAREYOU\".toByteArray())");
        WHO_ARE_YOU = bytes;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u000bJ\u0006\u0010\u0013\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/apache/tuweni/devp2p/v5/packet/UdpMessage$Companion;", "", "()V", "AUTH_TAG_LENGTH", "", "ID_NONCE_LENGTH", "MAX_UDP_MESSAGE_SIZE", "RANDOM_DATA_LENGTH", "REQUEST_ID_LENGTH", "TAG_LENGTH", "WHO_ARE_YOU", "Lorg/apache/tuweni/bytes/Bytes;", "authTag", "getSourceFromTag", "tag", "dest", "idNonce", "magic", "randomData", "requestId", "src", "devp2p"})
    public static final class Companion {
        @NotNull
        public final Bytes magic(@NotNull Bytes dest) {
            Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
            Bytes concatView = Bytes.wrap((Bytes[])new Bytes[]{dest, WHO_ARE_YOU});
            Bytes32 bytes32 = Hash.sha2_256((Bytes)concatView);
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes32, (String)"Hash.sha2_256(concatView)");
            return (Bytes)bytes32;
        }

        @NotNull
        public final Bytes tag(@NotNull Bytes src, @NotNull Bytes dest) {
            Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
            Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
            Bytes32 encodedDestKey = Hash.sha2_256((Bytes)dest);
            Bytes bytes = Bytes.wrap((Bytes[])new Bytes[]{(Bytes)encodedDestKey}).xor(src);
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"Bytes.wrap(encodedDestKey).xor(src)");
            return bytes;
        }

        @NotNull
        public final Bytes getSourceFromTag(@NotNull Bytes tag, @NotNull Bytes dest) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
            Bytes32 encodedDestKey = Hash.sha2_256((Bytes)dest);
            Bytes bytes = Bytes.wrap((Bytes[])new Bytes[]{(Bytes)encodedDestKey}).xor(tag);
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"Bytes.wrap(encodedDestKey).xor(tag)");
            return bytes;
        }

        @NotNull
        public final Bytes requestId() {
            Bytes bytes = Bytes.random((int)8);
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"Bytes.random(REQUEST_ID_LENGTH)");
            return bytes;
        }

        @NotNull
        public final Bytes authTag() {
            Bytes bytes = Bytes.random((int)12);
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"Bytes.random(AUTH_TAG_LENGTH)");
            return bytes;
        }

        @NotNull
        public final Bytes randomData() {
            Bytes bytes = Bytes.random((int)44);
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"Bytes.random(RANDOM_DATA_LENGTH)");
            return bytes;
        }

        @NotNull
        public final Bytes idNonce() {
            Bytes bytes = Bytes.random((int)32);
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"Bytes.random(ID_NONCE_LENGTH)");
            return bytes;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

