/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.junit;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.SecureRandom;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuweni.junit.RedisPort;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import redis.embedded.RedisServer;

public final class RedisServerExtension
implements ParameterResolver,
AfterAllCallback {
    private static Set<Integer> rangesIssued = ConcurrentHashMap.newKeySet();
    private static SecureRandom random = new SecureRandom();
    private RedisServer redisServer;
    private Thread shutdownThread = new Thread(() -> {
        if (this.redisServer != null) {
            this.redisServer.stop();
        }
    });

    private static int findFreeRange() {
        int range = random.nextInt(326);
        if (!rangesIssued.add(range)) {
            return RedisServerExtension.findFreeRange();
        }
        return range;
    }

    private static int findFreePort() {
        int range;
        for (int port = range = RedisServerExtension.findFreeRange() * 100 + 32768; port < range + 100; ++port) {
            try {
                ServerSocket socket = new ServerSocket(port, 0, InetAddress.getLoopbackAddress());
                socket.setReuseAddress(false);
                socket.close();
                return port;
            }
            catch (IOException e) {
                continue;
            }
        }
        throw new IllegalStateException("Could not reserve a port in range " + range + " and " + range + "100");
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return Integer.class.equals(parameterContext.getParameter().getType()) && parameterContext.isAnnotated(RedisPort.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.redisServer == null) {
            String localhost = InetAddress.getLoopbackAddress().getHostAddress();
            this.redisServer = RedisServer.builder().setting("bind " + localhost).setting("maxmemory 128mb").setting("maxmemory-policy allkeys-lru").setting("appendonly no").setting("save \"\"").port(Integer.valueOf(RedisServerExtension.findFreePort())).build();
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
            this.redisServer.start();
        }
        return this.redisServer.ports().get(0);
    }

    public void afterAll(ExtensionContext context) {
        if (this.redisServer != null) {
            this.redisServer.stop();
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
        }
    }
}

