/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.junit;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.tuweni.io.file.Files;
import org.apache.tuweni.junit.TempDirectory;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public final class TempDirectoryExtension
implements ParameterResolver,
AfterAllCallback {
    private Path tempDirectory;

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().isAnnotationPresent(TempDirectory.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.tempDirectory == null) {
            try {
                this.tempDirectory = java.nio.file.Files.createTempDirectory(extensionContext.getRequiredTestClass().getSimpleName(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.tempDirectory;
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.tempDirectory != null) {
            Files.deleteRecursively((Path)this.tempDirectory);
        }
    }
}

