/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import com.google.common.collect.DiscreteDomain;
import org.apache.tuweni.units.bigints.UInt256;

public final class UInt256Domain
extends DiscreteDomain<UInt256> {
    public UInt256 next(UInt256 value) {
        return value.add(1L);
    }

    public UInt256 previous(UInt256 value) {
        return value.subtract(1L);
    }

    public long distance(UInt256 start, UInt256 end) {
        UInt256 distance;
        boolean negativeDistance = start.compareTo(end) < 0;
        UInt256 uInt256 = distance = negativeDistance ? end.subtract(start) : start.subtract(end);
        if (!distance.fitsLong()) {
            return negativeDistance ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        long distanceLong = distance.toLong();
        return negativeDistance ? -distanceLong : distanceLong;
    }

    public UInt256 minValue() {
        return UInt256.MIN_VALUE;
    }

    public UInt256 maxValue() {
        return UInt256.MAX_VALUE;
    }
}

