/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.units.bigints.UInt32Value;

public final class UInt32
implements UInt32Value<UInt32> {
    private static final int MAX_CONSTANT = 32;
    private static UInt32[] CONSTANTS = new UInt32[33];
    public static final UInt32 MIN_VALUE;
    public static final UInt32 MAX_VALUE;
    public static final UInt32 ZERO;
    public static final UInt32 ONE;
    private static final BigInteger P_2_32;
    private final int value;

    public static UInt32 valueOf(int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"Argument must be positive");
        return UInt32.create(value);
    }

    public static UInt32 valueOf(BigInteger value) {
        Preconditions.checkArgument((value.signum() >= 0 ? 1 : 0) != 0, (Object)"Argument must be positive");
        Preconditions.checkArgument((value.bitLength() <= 32 ? 1 : 0) != 0, (Object)"Argument is too large to represent a UInt32");
        return UInt32.create(value.intValue());
    }

    public static UInt32 fromBytes(Bytes bytes) {
        Preconditions.checkArgument((bytes.size() <= 8 ? 1 : 0) != 0, (Object)"Argument is greater than 8 bytes");
        return UInt32.create(bytes.toInt());
    }

    public static UInt32 fromHexString(String str) {
        return UInt32.fromBytes(Bytes.fromHexStringLenient((CharSequence)str));
    }

    private static UInt32 create(int value) {
        if (value >= 0 && value <= 32) {
            return CONSTANTS[value];
        }
        return new UInt32(value);
    }

    private UInt32(int value) {
        this.value = value;
    }

    @Override
    public boolean isZero() {
        return this.value == 0;
    }

    @Override
    public UInt32 add(UInt32 value) {
        if (value.value == 0) {
            return this;
        }
        if (this.value == 0) {
            return value;
        }
        return UInt32.create(this.value + value.value);
    }

    @Override
    public UInt32 add(int value) {
        if (value == 0) {
            return this;
        }
        return UInt32.create(this.value + value);
    }

    @Override
    public UInt32 addMod(UInt32 value, UInt32 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("addMod with zero modulus");
        }
        return UInt32.create(this.toBigInteger().add(value.toBigInteger()).mod(modulus.toBigInteger()).intValue());
    }

    @Override
    public UInt32 addMod(long value, UInt32 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("addMod with zero modulus");
        }
        return UInt32.create(this.toBigInteger().add(BigInteger.valueOf(value)).mod(modulus.toBigInteger()).intValue());
    }

    @Override
    public UInt32 addMod(long value, long modulus) {
        if (modulus == 0L) {
            throw new ArithmeticException("addMod with zero modulus");
        }
        if (modulus < 0L) {
            throw new ArithmeticException("addMod unsigned with negative modulus");
        }
        return UInt32.create(this.toBigInteger().add(BigInteger.valueOf(value)).mod(BigInteger.valueOf(modulus)).intValue());
    }

    @Override
    public UInt32 subtract(UInt32 value) {
        if (value.isZero()) {
            return this;
        }
        return UInt32.create(this.value - value.value);
    }

    @Override
    public UInt32 subtract(int value) {
        return this.add(-value);
    }

    @Override
    public UInt32 multiply(UInt32 value) {
        if (this.value == 0 || value.value == 0) {
            return ZERO;
        }
        if (value.value == 1) {
            return this;
        }
        return UInt32.create(this.value * value.value);
    }

    @Override
    public UInt32 multiply(int value) {
        if (value < 0) {
            throw new ArithmeticException("multiply unsigned by negative");
        }
        if (value == 0 || this.value == 0) {
            return ZERO;
        }
        if (value == 1) {
            return this;
        }
        return UInt32.create(this.value * value);
    }

    @Override
    public UInt32 multiplyMod(UInt32 value, UInt32 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("multiplyMod with zero modulus");
        }
        if (this.value == 0 || value.value == 0) {
            return ZERO;
        }
        if (value.value == 1) {
            return this.mod(modulus);
        }
        return UInt32.create(this.toBigInteger().multiply(value.toBigInteger()).mod(modulus.toBigInteger()).intValue());
    }

    @Override
    public UInt32 multiplyMod(int value, UInt32 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("multiplyMod with zero modulus");
        }
        if (value == 0 || this.value == 0) {
            return ZERO;
        }
        if (value == 1) {
            return this.mod(modulus);
        }
        if (value < 0) {
            throw new ArithmeticException("multiplyMod unsigned by negative");
        }
        return UInt32.create(this.toBigInteger().multiply(BigInteger.valueOf(value)).mod(modulus.toBigInteger()).intValue());
    }

    @Override
    public UInt32 multiplyMod(int value, int modulus) {
        if (modulus == 0) {
            throw new ArithmeticException("multiplyMod with zero modulus");
        }
        if (modulus < 0) {
            throw new ArithmeticException("multiplyMod unsigned with negative modulus");
        }
        if (value == 0 || this.value == 0) {
            return ZERO;
        }
        if (value == 1) {
            return this.mod(modulus);
        }
        if (value < 0) {
            throw new ArithmeticException("multiplyMod unsigned by negative");
        }
        return UInt32.create(this.toBigInteger().multiply(BigInteger.valueOf(value)).mod(BigInteger.valueOf(modulus)).intValue());
    }

    @Override
    public UInt32 divide(UInt32 value) {
        if (value.value == 0) {
            throw new ArithmeticException("divide by zero");
        }
        if (value.value == 1) {
            return this;
        }
        return UInt32.create(this.toBigInteger().divide(value.toBigInteger()).intValue());
    }

    @Override
    public UInt32 divide(int value) {
        if (value == 0) {
            throw new ArithmeticException("divide by zero");
        }
        if (value < 0) {
            throw new ArithmeticException("divide unsigned by negative");
        }
        if (value == 1) {
            return this;
        }
        if (UInt32.isPowerOf2(value)) {
            return this.shiftRight(UInt32.log2(value));
        }
        return UInt32.create(this.toBigInteger().divide(BigInteger.valueOf(value)).intValue());
    }

    @Override
    public UInt32 pow(UInt32 exponent) {
        return UInt32.create(this.toBigInteger().modPow(exponent.toBigInteger(), P_2_32).intValue());
    }

    @Override
    public UInt32 pow(long exponent) {
        return UInt32.create(this.toBigInteger().modPow(BigInteger.valueOf(exponent), P_2_32).intValue());
    }

    @Override
    public UInt32 mod(UInt32 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("mod by zero");
        }
        return UInt32.create(this.toBigInteger().mod(modulus.toBigInteger()).intValue());
    }

    @Override
    public UInt32 mod(int modulus) {
        if (modulus == 0) {
            throw new ArithmeticException("mod by zero");
        }
        if (modulus < 0) {
            throw new ArithmeticException("mod by negative");
        }
        return UInt32.create(this.value % modulus);
    }

    public UInt32 and(UInt32 value) {
        if (this.value == 0 || value.value == 0) {
            return ZERO;
        }
        return UInt32.create(this.value & value.value);
    }

    public UInt32 and(Bytes bytes) {
        Preconditions.checkArgument((bytes.size() <= 4 ? 1 : 0) != 0, (Object)"and with more than 4 bytes");
        if (this.value == 0) {
            return ZERO;
        }
        int value = bytes.toInt();
        if (value == 0) {
            return ZERO;
        }
        return UInt32.create(this.value & value);
    }

    public UInt32 or(UInt32 value) {
        return UInt32.create(this.value | value.value);
    }

    public UInt32 or(Bytes bytes) {
        Preconditions.checkArgument((bytes.size() <= 4 ? 1 : 0) != 0, (Object)"or with more than 4 bytes");
        return UInt32.create(this.value | bytes.toInt());
    }

    public UInt32 xor(UInt32 value) {
        return UInt32.create(this.value ^ value.value);
    }

    public UInt32 xor(Bytes bytes) {
        Preconditions.checkArgument((bytes.size() <= 4 ? 1 : 0) != 0, (Object)"xor with more than 4 bytes");
        return UInt32.create(this.value ^ bytes.toInt());
    }

    public UInt32 not() {
        return UInt32.create(~this.value);
    }

    public UInt32 shiftRight(int distance) {
        if (distance == 0) {
            return this;
        }
        if (distance >= 32) {
            return ZERO;
        }
        return UInt32.create(this.value >>> distance);
    }

    public UInt32 shiftLeft(int distance) {
        if (distance == 0) {
            return this;
        }
        if (distance >= 32) {
            return ZERO;
        }
        return UInt32.create(this.value << distance);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UInt32)) {
            return false;
        }
        UInt32 other = (UInt32)object;
        return this.value == other.value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @Override
    public int compareTo(UInt32 other) {
        return Long.compareUnsigned(this.value, other.value);
    }

    @Override
    public int intValue() {
        if (!this.fitsInt()) {
            throw new ArithmeticException("Value does not fit a 4 byte int");
        }
        return this.value;
    }

    @Override
    public long toLong() {
        if (!this.fitsLong()) {
            throw new ArithmeticException("Value does not fit a 8 byte long");
        }
        return this.toBigInteger().longValue();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public BigInteger toBigInteger() {
        byte[] mag = new byte[]{(byte)(this.value >>> 24 & 0xFF), (byte)(this.value >>> 16 & 0xFF), (byte)(this.value >>> 8 & 0xFF), (byte)(this.value & 0xFF)};
        return new BigInteger(1, mag);
    }

    @Override
    public UInt32 toUInt32() {
        return this;
    }

    @Override
    public Bytes toBytes() {
        MutableBytes bytes = MutableBytes.create((int)4);
        bytes.setInt(0, this.value);
        return bytes;
    }

    @Override
    public Bytes toMinimalBytes() {
        int requiredBytes = 4 - Integer.numberOfLeadingZeros(this.value) / 8;
        MutableBytes bytes = MutableBytes.create((int)requiredBytes);
        int j = 0;
        switch (requiredBytes) {
            case 4: {
                bytes.set(j++, (byte)(this.value >>> 24 & 0xFF));
            }
            case 3: {
                bytes.set(j++, (byte)(this.value >>> 16 & 0xFF));
            }
            case 2: {
                bytes.set(j++, (byte)(this.value >>> 8 & 0xFF));
            }
            case 1: {
                bytes.set(j, (byte)(this.value & 0xFF));
            }
        }
        return bytes;
    }

    @Override
    public int numberOfLeadingZeros() {
        return Integer.numberOfLeadingZeros(this.value);
    }

    @Override
    public int bitLength() {
        return 32 - Integer.numberOfLeadingZeros(this.value);
    }

    private static boolean isPowerOf2(long n) {
        assert (n > 0L);
        return (n & n - 1L) == 0L;
    }

    private static int log2(int v) {
        assert (v > 0);
        return 63 - Long.numberOfLeadingZeros(v);
    }

    static {
        UInt32.CONSTANTS[0] = new UInt32(0);
        for (int i = 1; i <= 32; ++i) {
            UInt32.CONSTANTS[i] = new UInt32(i);
        }
        MIN_VALUE = UInt32.valueOf(0);
        MAX_VALUE = new UInt32(-1);
        ZERO = UInt32.valueOf(0);
        ONE = UInt32.valueOf(1);
        P_2_32 = BigInteger.valueOf(2L).pow(32);
    }
}

