/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.api;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.twill.api.EventHandlerContext;
import org.apache.twill.api.EventHandlerSpecification;

public abstract class EventHandler {
    protected EventHandlerContext context;

    public EventHandlerSpecification configure() {
        return new EventHandlerSpecification(){

            @Override
            public String getClassName() {
                return EventHandler.this.getClass().getName();
            }

            @Override
            public Map<String, String> getConfigs() {
                return EventHandler.this.getConfigs();
            }
        };
    }

    public void initialize(EventHandlerContext context) {
        this.context = context;
    }

    public void destroy() {
    }

    public abstract TimeoutAction launchTimeout(Iterable<TimeoutEvent> var1);

    protected Map<String, String> getConfigs() {
        return Collections.emptyMap();
    }

    public static final class TimeoutEvent {
        private final String runnableName;
        private final int expectedInstances;
        private final int actualInstances;
        private final long requestTime;

        public TimeoutEvent(String runnableName, int expectedInstances, int actualInstances, long requestTime) {
            this.runnableName = runnableName;
            this.expectedInstances = expectedInstances;
            this.actualInstances = actualInstances;
            this.requestTime = requestTime;
        }

        public String getRunnableName() {
            return this.runnableName;
        }

        public int getExpectedInstances() {
            return this.expectedInstances;
        }

        public int getActualInstances() {
            return this.actualInstances;
        }

        public long getRequestTime() {
            return this.requestTime;
        }
    }

    public static final class TimeoutAction {
        private final long timeout;

        public static TimeoutAction abort() {
            return new TimeoutAction(-1L);
        }

        public static TimeoutAction recheck(long elapse, TimeUnit unit) {
            return new TimeoutAction(TimeUnit.MILLISECONDS.convert(elapse, unit));
        }

        private TimeoutAction(long timeout) {
            this.timeout = timeout;
        }

        public long getTimeout() {
            return this.timeout;
        }
    }
}

