/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uniffle.com.google.common.collect.Sets;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleServerInfo;

public class ShuffleHandleInfo
implements Serializable {
    private int shuffleId;
    private Map<Integer, List<ShuffleServerInfo>> partitionToServers;
    private Set<ShuffleServerInfo> shuffleServersForData;
    private RemoteStorageInfo remoteStorage;
    public static final ShuffleHandleInfo EMPTY_HANDLE_INFO = new ShuffleHandleInfo(-1, Collections.EMPTY_MAP, RemoteStorageInfo.EMPTY_REMOTE_STORAGE);

    public ShuffleHandleInfo(int shuffleId, Map<Integer, List<ShuffleServerInfo>> partitionToServers, RemoteStorageInfo storageInfo) {
        this.shuffleId = shuffleId;
        this.partitionToServers = partitionToServers;
        this.shuffleServersForData = Sets.newHashSet();
        for (List<ShuffleServerInfo> ssis : partitionToServers.values()) {
            this.shuffleServersForData.addAll(ssis);
        }
        this.remoteStorage = storageInfo;
    }

    public Map<Integer, List<ShuffleServerInfo>> getPartitionToServers() {
        return this.partitionToServers;
    }

    public Set<ShuffleServerInfo> getShuffleServersForData() {
        return this.shuffleServersForData;
    }

    public RemoteStorageInfo getRemoteStorage() {
        return this.remoteStorage;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }
}

