/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.factory;

import org.apache.uniffle.client.api.ShuffleReadClient;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.impl.ShuffleReadClientImpl;
import org.apache.uniffle.client.impl.ShuffleWriteClientImpl;
import org.apache.uniffle.client.request.CreateShuffleReadClientRequest;
import org.apache.uniffle.common.config.RssConf;

public class ShuffleClientFactory {
    private static final ShuffleClientFactory INSTANCE = new ShuffleClientFactory();

    private ShuffleClientFactory() {
    }

    public static ShuffleClientFactory getInstance() {
        return INSTANCE;
    }

    public ShuffleWriteClient createShuffleWriteClient(String clientType, int retryMax, long retryIntervalMax, int heartBeatThreadNum, int replica, int replicaWrite, int replicaRead, boolean replicaSkipEnabled, int dataTransferPoolSize, int dataCommitPoolSize) {
        return this.createShuffleWriteClient(clientType, retryMax, retryIntervalMax, heartBeatThreadNum, replica, replicaWrite, replicaRead, replicaSkipEnabled, dataTransferPoolSize, dataCommitPoolSize, 10, 10, new RssConf());
    }

    public ShuffleWriteClient createShuffleWriteClient(String clientType, int retryMax, long retryIntervalMax, int heartBeatThreadNum, int replica, int replicaWrite, int replicaRead, boolean replicaSkipEnabled, int dataTransferPoolSize, int dataCommitPoolSize, RssConf rssConf) {
        return this.createShuffleWriteClient(clientType, retryMax, retryIntervalMax, heartBeatThreadNum, replica, replicaWrite, replicaRead, replicaSkipEnabled, dataTransferPoolSize, dataCommitPoolSize, 10, 10, rssConf);
    }

    public ShuffleWriteClient createShuffleWriteClient(String clientType, int retryMax, long retryIntervalMax, int heartBeatThreadNum, int replica, int replicaWrite, int replicaRead, boolean replicaSkipEnabled, int dataTransferPoolSize, int dataCommitPoolSize, int unregisterThreadPoolSize, int unregisterRequestTimeoutSec) {
        return this.createShuffleWriteClient(clientType, retryMax, retryIntervalMax, heartBeatThreadNum, replica, replicaWrite, replicaRead, replicaSkipEnabled, dataTransferPoolSize, dataCommitPoolSize, unregisterThreadPoolSize, unregisterRequestTimeoutSec, new RssConf());
    }

    public ShuffleWriteClient createShuffleWriteClient(String clientType, int retryMax, long retryIntervalMax, int heartBeatThreadNum, int replica, int replicaWrite, int replicaRead, boolean replicaSkipEnabled, int dataTransferPoolSize, int dataCommitPoolSize, int unregisterThreadPoolSize, int unregisterRequestTimeoutSec, RssConf rssConf) {
        if (replicaSkipEnabled && replica > replicaWrite) {
            retryMax /= 2;
        }
        return new ShuffleWriteClientImpl(clientType, retryMax, retryIntervalMax, heartBeatThreadNum, replica, replicaWrite, replicaRead, replicaSkipEnabled, dataTransferPoolSize, dataCommitPoolSize, unregisterThreadPoolSize, unregisterRequestTimeoutSec, rssConf);
    }

    public ShuffleReadClient createShuffleReadClient(CreateShuffleReadClientRequest request) {
        return new ShuffleReadClientImpl(request.getAppId(), request.getShuffleId(), request.getPartitionId(), request.getPartitionNumPerRange(), request.getPartitionNum(), request.getBasePath(), request.getBlockIdBitmap(), request.getTaskIdBitmap(), request.getShuffleServerInfoList(), request.getHadoopConf(), request.getIdHelper(), request.getShuffleDataDistributionType(), request.isExpectedTaskIdsBitmapFilterEnable(), request.getRssConf());
    }
}

