/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.RequestMessage;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;

public class GetLocalShuffleDataRequest
extends RequestMessage {
    private String appId;
    private int shuffleId;
    private int partitionId;
    private int partitionNumPerRange;
    private int partitionNum;
    private long offset;
    private int length;
    private long timestamp;

    public GetLocalShuffleDataRequest(long requestId, String appId, int shuffleId, int partitionId, int partitionNumPerRange, int partitionNum, long offset, int length, long timestamp) {
        super(requestId);
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.partitionId = partitionId;
        this.partitionNumPerRange = partitionNumPerRange;
        this.partitionNum = partitionNum;
        this.offset = offset;
        this.length = length;
        this.timestamp = timestamp;
    }

    @Override
    public Message.Type type() {
        return Message.Type.GET_LOCAL_SHUFFLE_DATA_REQUEST;
    }

    @Override
    public int encodedLength() {
        return 8 + ByteBufUtils.encodedLength(this.appId) + 16 + 20;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.getRequestId());
        ByteBufUtils.writeLengthAndString(buf, this.appId);
        buf.writeInt(this.shuffleId);
        buf.writeInt(this.partitionId);
        buf.writeInt(this.partitionNumPerRange);
        buf.writeInt(this.partitionNum);
        buf.writeLong(this.offset);
        buf.writeInt(this.length);
        buf.writeLong(this.timestamp);
    }

    public static GetLocalShuffleDataRequest decode(ByteBuf byteBuf) {
        long requestId = byteBuf.readLong();
        String appId = ByteBufUtils.readLengthAndString(byteBuf);
        int shuffleId = byteBuf.readInt();
        int partitionId = byteBuf.readInt();
        int partitionNumPerRange = byteBuf.readInt();
        int partitionNum = byteBuf.readInt();
        long offset = byteBuf.readLong();
        int length = byteBuf.readInt();
        long timestamp = byteBuf.readLong();
        return new GetLocalShuffleDataRequest(requestId, appId, shuffleId, partitionId, partitionNumPerRange, partitionNum, offset, length, timestamp);
    }

    public String getAppId() {
        return this.appId;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public int getPartitionNumPerRange() {
        return this.partitionNumPerRange;
    }

    public int getPartitionNum() {
        return this.partitionNum;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getOperationType() {
        return "getLocalShuffleData";
    }
}

