/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools;

import java.util.Map;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.Toolbox;
import org.apache.velocity.tools.ToolboxFactory;
import org.apache.velocity.tools.config.ConfigurationUtils;
import org.apache.velocity.tools.config.FactoryConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolManager {
    private VelocityEngine engine;
    private ToolboxFactory factory = new ToolboxFactory();
    private Toolbox application;

    public ToolManager() {
        this(true);
    }

    public ToolManager(boolean includeDefaults) {
        FactoryConfiguration config = ConfigurationUtils.getAutoLoaded(includeDefaults);
        FactoryConfiguration sys = ConfigurationUtils.findFromSystemProperty();
        if (sys != null) {
            config.addConfiguration(sys);
        }
        this.configure(config);
    }

    public void configure(FactoryConfiguration config) {
        this.application = null;
        this.factory.configure(config);
    }

    public void configure(String path) {
        FactoryConfiguration config = ConfigurationUtils.find(path);
        if (config == null) {
            throw new RuntimeException("Could not find any configuration at " + path);
        }
        this.configure(config);
    }

    public void setVelocityEngine(VelocityEngine engine) {
        this.engine = engine;
    }

    public ToolContext createContext() {
        ToolContext context = this.engine != null ? new ToolContext(this.engine) : new ToolContext((Map<String, Object>)null);
        this.addToolboxes(context);
        return context;
    }

    public ToolContext createContext(Map<String, Object> toolProps) {
        ToolContext context;
        if (this.engine != null) {
            context = new ToolContext(this.engine);
            if (toolProps != null && !toolProps.isEmpty()) {
                for (Map.Entry<String, Object> prop : toolProps.entrySet()) {
                    context.putToolProperty(prop.getKey(), prop.getValue());
                }
            }
        } else {
            context = new ToolContext(toolProps);
        }
        this.addToolboxes(context);
        return context;
    }

    protected void addToolboxes(ToolContext context) {
        if (this.hasApplicationTools()) {
            context.addToolbox(this.getApplicationToolbox());
        }
        if (this.hasRequestTools()) {
            context.addToolbox(this.getRequestToolbox());
        }
    }

    protected boolean hasRequestTools() {
        return this.factory.hasTools("request");
    }

    protected Toolbox getRequestToolbox() {
        return this.factory.createToolbox("request");
    }

    protected boolean hasApplicationTools() {
        return this.factory.hasTools("application");
    }

    protected Toolbox getApplicationToolbox() {
        if (this.application == null) {
            this.application = this.factory.createToolbox("application");
        }
        return this.application;
    }
}

