/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.ValidScope;
import org.apache.velocity.tools.generic.SafeConfig;
import org.apache.velocity.tools.generic.ValueParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultKey(value="link")
@ValidScope(value={"request"})
public class LinkTool
extends SafeConfig
implements Cloneable {
    public static final String HTML_QUERY_DELIMITER = "&";
    public static final String XHTML_QUERY_DELIMITER = "&amp;";
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String DEFAULT_SCHEME = "http";
    public static final String SECURE_SCHEME = "https";
    public static final String URI_KEY = "uri";
    public static final String SCHEME_KEY = "scheme";
    public static final String USER_KEY = "user";
    public static final String HOST_KEY = "host";
    public static final String PORT_KEY = "port";
    public static final String PATH_KEY = "requestPath";
    public static final String QUERY_KEY = "params";
    public static final String FRAGMENT_KEY = "anchor";
    public static final String CHARSET_KEY = "charset";
    public static final String XHTML_MODE_KEY = "xhtml";
    protected Log LOG;
    protected String scheme = null;
    protected String user = null;
    protected String host = null;
    protected int port = -1;
    protected String path = null;
    protected String query = null;
    protected String fragment = null;
    protected String charset = "UTF-8";
    protected String queryDelim = "&amp;";
    private boolean opaque = false;
    private final LinkTool self = this;

    private void logError(String msg, Throwable t) {
        if (this.LOG != null) {
            this.LOG.error((Object)("LinkTool: " + msg), t);
        }
    }

    @Override
    protected void configure(ValueParser props) {
        Boolean xhtml;
        String chrst;
        String anchor;
        String params;
        String pth;
        Integer prt;
        String hst;
        String info;
        String schm;
        this.LOG = (Log)props.getValue("log");
        String link = props.getString(URI_KEY);
        if (link != null) {
            this.setFromURI(link);
        }
        if ((schm = props.getString(SCHEME_KEY)) != null) {
            this.setScheme(schm);
        }
        if ((info = props.getString(USER_KEY)) != null) {
            this.setUserInfo(info);
        }
        if ((hst = props.getString(HOST_KEY)) != null) {
            this.setHost(hst);
        }
        if ((prt = props.getInteger(PORT_KEY)) != null) {
            this.setPort((int)prt);
        }
        if ((pth = props.getString(PATH_KEY)) != null) {
            this.setPath(pth);
        }
        if ((params = props.getString(QUERY_KEY)) != null) {
            this.setQuery(params);
        }
        if ((anchor = props.getString(FRAGMENT_KEY)) != null) {
            this.setFragment(anchor);
        }
        if ((chrst = props.getString(CHARSET_KEY)) != null) {
            this.charset = chrst;
        }
        if ((xhtml = props.getBoolean(XHTML_MODE_KEY)) != null) {
            this.setXHTML(xhtml);
        }
    }

    protected void setXHTML(boolean xhtml) {
        this.queryDelim = xhtml ? XHTML_QUERY_DELIMITER : HTML_QUERY_DELIMITER;
    }

    protected LinkTool duplicate() {
        try {
            return (LinkTool)this.clone();
        }
        catch (CloneNotSupportedException e) {
            String msg = "Could not properly clone " + this.getClass();
            this.logError(msg, e);
            throw new RuntimeException(msg, e);
        }
    }

    protected void setScheme(Object obj) {
        if (obj == null) {
            this.scheme = null;
        } else {
            this.scheme = String.valueOf(obj);
            if (this.scheme.length() == 0) {
                this.scheme = null;
            }
            if (this.scheme.endsWith(":")) {
                this.scheme = this.scheme.substring(0, this.scheme.length() - 1);
            }
        }
    }

    protected void setUserInfo(Object obj) {
        this.user = obj == null ? null : String.valueOf(obj);
    }

    protected void setHost(Object obj) {
        this.host = obj == null ? null : String.valueOf(obj);
    }

    protected void setPort(Object obj) {
        if (obj == null) {
            this.port = -1;
        } else if (obj instanceof Number) {
            this.port = ((Number)obj).intValue();
        } else {
            try {
                this.port = Integer.parseInt(String.valueOf(obj));
            }
            catch (NumberFormatException nfe) {
                this.logError("Could convert '" + obj + "' to int", nfe);
                this.port = -2;
            }
        }
    }

    protected void setPath(Object obj) {
        if (obj == null) {
            this.path = null;
        } else {
            this.path = String.valueOf(obj);
            if (!this.opaque && !this.path.startsWith("/")) {
                this.path = '/' + this.path;
            }
        }
    }

    protected void appendPath(Object obj) {
        if (obj != null && !this.opaque) {
            this.setPath(this.combinePath(this.getPath(), String.valueOf(obj)));
        }
    }

    protected String combinePath(String start, String end) {
        boolean endStarts;
        if (end == null) {
            return start;
        }
        if (start == null) {
            return end;
        }
        boolean startEnds = start.endsWith("/");
        if (startEnds ^ (endStarts = end.startsWith("/"))) {
            return start + end;
        }
        if (startEnds & endStarts) {
            return start + end.substring(1, end.length());
        }
        return start + '/' + end;
    }

    protected void setQuery(Object obj) {
        if (obj == null) {
            this.query = null;
        } else {
            this.query = String.valueOf(obj);
            if (this.query.startsWith("?")) {
                this.query = this.query.substring(1, this.query.length());
            }
            if (this.query.contains(HTML_QUERY_DELIMITER)) {
                this.query = this.query.replaceAll("&(amp;)?", this.queryDelim);
            }
        }
    }

    protected void appendQuery(Object obj) {
        if (obj != null) {
            this.setQuery(this.combineQuery(this.getQuery(), String.valueOf(obj)));
        }
    }

    protected String combineQuery(String current, String add) {
        if (add == null || add.length() == 0) {
            return current;
        }
        if (add.startsWith("?")) {
            add = add.substring(1, add.length());
        }
        if (current == null) {
            return add;
        }
        if (current.endsWith(this.queryDelim)) {
            current = current.substring(0, current.length() - this.queryDelim.length());
        } else if (current.endsWith(HTML_QUERY_DELIMITER)) {
            current = current.substring(0, current.length() - 1);
        }
        if (add.startsWith(this.queryDelim)) {
            return current + add;
        }
        if (add.startsWith(HTML_QUERY_DELIMITER)) {
            add = add.substring(1, add.length());
        }
        return current + this.queryDelim + add;
    }

    protected String toQuery(Object key, Object value) {
        StringBuilder out = new StringBuilder();
        if (value == null) {
            out.append(this.encode(key));
            out.append('=');
        } else if (value instanceof List) {
            this.appendAsArray(out, key, ((List)value).toArray());
        } else if (value instanceof Object[]) {
            this.appendAsArray(out, key, (Object[])value);
        } else {
            out.append(this.encode(key));
            out.append('=');
            out.append(this.encode(value));
        }
        return out.toString();
    }

    private void appendAsArray(StringBuilder out, Object key, Object[] arr) {
        String encKey = this.encode(key);
        for (int i = 0; i < arr.length; ++i) {
            out.append(encKey);
            out.append('=');
            if (arr[i] != null) {
                out.append(this.encode(arr[i]));
            }
            if (i + 1 >= arr.length) continue;
            out.append(this.queryDelim);
        }
    }

    protected Map<String, Object> parseQuery(String query) {
        String[] pairs;
        if (query.startsWith("?")) {
            query = query.substring(1, query.length());
        }
        if ((pairs = query.split(this.queryDelim)).length == 0) {
            return null;
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(pairs.length);
        for (String pair : pairs) {
            Object value;
            String[] kv = pair.split("=");
            String key = kv[0];
            Object object = value = kv.length > 1 ? kv[1] : null;
            if (params.containsKey(kv[0])) {
                Object oldval = params.get(key);
                if (oldval instanceof List) {
                    ((List)oldval).add(value);
                    value = oldval;
                } else {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add((String)oldval);
                    list.add((String)value);
                    value = list;
                }
            }
            params.put(key, value);
        }
        return params;
    }

    protected void setFragment(Object obj) {
        if (obj == null) {
            this.fragment = null;
        } else {
            this.fragment = String.valueOf(obj);
            if (this.fragment.length() == 0) {
                this.fragment = null;
            }
        }
    }

    protected boolean setFromURI(Object obj) {
        URI uri;
        if (obj == null) {
            this.setScheme(null);
            this.setUserInfo(null);
            this.setHost(null);
            this.setPort(null);
            this.setPath(null);
            this.setQuery(null);
            this.setFragment(null);
            return true;
        }
        if (obj instanceof URI) {
            uri = (URI)obj;
        } else {
            try {
                uri = new URI(String.valueOf(obj));
            }
            catch (Exception e) {
                this.logError("Could convert '" + obj + "' to URI", e);
                return false;
            }
        }
        this.setScheme(uri.getScheme());
        if (uri.isOpaque()) {
            this.opaque = true;
            this.setPath(uri.getSchemeSpecificPart());
        } else {
            this.setUserInfo(uri.getUserInfo());
            this.setHost(uri.getHost());
            this.setPort(uri.getPort());
            String pth = uri.getPath();
            if (pth.equals("/") || pth.length() == 0) {
                pth = null;
            }
            this.setPath(pth);
            this.setQuery(uri.getQuery());
        }
        this.setFragment(uri.getFragment());
        return true;
    }

    protected URI createURI() {
        try {
            if (this.port > -2) {
                String anchor = this.fragment;
                if (anchor != null) {
                    anchor = this.encode(anchor);
                }
                if (this.opaque) {
                    return new URI(this.scheme, this.path, anchor);
                }
                if (this.scheme == null && this.user == null && this.host == null && this.path == null && this.query == null && this.fragment == null) {
                    return null;
                }
                return new URI(this.scheme, this.user, this.host, this.port, this.path, this.query, this.fragment);
            }
        }
        catch (Exception e) {
            this.logError("Could not create URI", e);
        }
        return null;
    }

    public LinkTool scheme(Object scheme) {
        LinkTool copy = this.duplicate();
        copy.setScheme(scheme);
        return copy;
    }

    public LinkTool secure() {
        return this.scheme(SECURE_SCHEME);
    }

    public LinkTool insecure() {
        return this.scheme(DEFAULT_SCHEME);
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isSecure() {
        return SECURE_SCHEME.equalsIgnoreCase(this.getScheme());
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public LinkTool user(Object info) {
        LinkTool copy = this.duplicate();
        copy.setUserInfo(info);
        return copy;
    }

    public String getUser() {
        return this.user;
    }

    public LinkTool host(Object host) {
        LinkTool copy = this.duplicate();
        copy.setHost(host);
        if (copy.getHost() != null && !copy.isAbsolute()) {
            copy.setScheme(DEFAULT_SCHEME);
        }
        return copy;
    }

    public String getHost() {
        return this.host;
    }

    public LinkTool port(Object port) {
        LinkTool copy = this.duplicate();
        copy.setPort(port);
        return copy;
    }

    public Integer getPort() {
        if (this.port < 0) {
            return null;
        }
        return this.port;
    }

    public LinkTool path(Object pth) {
        LinkTool copy = this.duplicate();
        copy.setPath(pth);
        return copy;
    }

    public String getPath() {
        return this.path;
    }

    public LinkTool append(Object pth) {
        LinkTool copy = this.duplicate();
        copy.appendPath(pth);
        return copy;
    }

    public String getContextPath() {
        if (this.path == null || this.opaque) {
            return null;
        }
        int lastSlash = this.path.lastIndexOf(47);
        if (lastSlash <= 0) {
            return "";
        }
        return this.path.substring(0, lastSlash);
    }

    public String getRequestPath() {
        if (this.path == null || this.opaque) {
            return null;
        }
        int lastSlash = this.path.lastIndexOf(47);
        if (lastSlash <= 0) {
            return this.path;
        }
        return this.path.substring(lastSlash, this.path.length());
    }

    public String getRoot() {
        if (this.host == null) {
            return null;
        }
        if (this.scheme == null) {
            this.scheme = DEFAULT_SCHEME;
        }
        StringBuilder out = new StringBuilder();
        out.append(this.scheme);
        out.append("://");
        out.append(this.host);
        if (this.port >= 0 && (this.scheme.equals(DEFAULT_SCHEME) && this.port != 80 || this.isSecure() && this.port != 443)) {
            out.append(':');
            out.append(this.port);
        }
        return out.toString();
    }

    public String getContextURL() {
        String root = this.getRoot();
        if (root == null) {
            return null;
        }
        return this.combinePath(root, this.getContextPath());
    }

    public LinkTool relative(Object obj) {
        if (obj == null) {
            return this.path(this.getContextPath());
        }
        String pth = String.valueOf(obj);
        LinkTool copy = this.duplicate();
        copy.setPath(this.combinePath(this.getContextPath(), pth));
        return copy;
    }

    public LinkTool absolute(Object obj) {
        if (obj == null) {
            return this.uri(obj);
        }
        String pth = String.valueOf(obj);
        if (pth.startsWith(DEFAULT_SCHEME)) {
            return this.uri(pth);
        }
        String root = this.getRoot();
        if (root != null) {
            return this.uri(this.combinePath(root, pth));
        }
        LinkTool copy = this.duplicate();
        copy.setScheme(DEFAULT_SCHEME);
        copy.setPath(pth);
        return copy;
    }

    public LinkTool uri(Object uri) {
        LinkTool copy = this.duplicate();
        if (copy.setFromURI(uri)) {
            return copy;
        }
        return null;
    }

    public URI getUri() {
        if (!this.isSafeMode()) {
            return this.createURI();
        }
        return null;
    }

    public String getBaseRef() {
        LinkTool copy = this.duplicate();
        copy.setQuery(null);
        copy.setFragment(null);
        return copy.toString();
    }

    public LinkTool query(Object query) {
        LinkTool copy = this.duplicate();
        copy.setQuery(query);
        return copy;
    }

    public String getQuery() {
        return this.query;
    }

    public LinkTool param(Object key, Object value) {
        LinkTool copy = this.duplicate();
        copy.appendQuery(this.toQuery(key, value));
        return copy;
    }

    public LinkTool params(Map parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return this;
        }
        LinkTool copy = this.duplicate();
        StringBuilder query = new StringBuilder();
        Iterator i$ = parameters.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry e;
            Map.Entry entry = e = i$.next();
            if (query.length() > 0) {
                query.append(this.queryDelim);
            }
            query.append(this.toQuery(entry.getKey(), entry.getValue()));
        }
        copy.appendQuery(query);
        return copy;
    }

    public Map getParams() {
        if (this.query == null || this.query.length() == 0) {
            return null;
        }
        return this.parseQuery(this.query);
    }

    public LinkTool anchor(Object anchor) {
        LinkTool copy = this.duplicate();
        copy.setFragment(anchor);
        return copy;
    }

    public String getAnchor() {
        return this.fragment;
    }

    public LinkTool getSelf() {
        return this.self;
    }

    public String toString() {
        URI uri = this.createURI();
        if (uri == null) {
            return null;
        }
        return uri.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LinkTool)) {
            return false;
        }
        String that = obj.toString();
        if (that == null && this.toString() == null) {
            return true;
        }
        return that.equals(this.toString());
    }

    public int hashCode() {
        String hashme = this.toString();
        if (hashme == null) {
            return -1;
        }
        return hashme.hashCode();
    }

    public String encode(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return URLEncoder.encode(String.valueOf(obj), this.charset);
        }
        catch (UnsupportedEncodingException uee) {
            this.logError("Character encoding '" + this.charset + "' is unsupported", uee);
            return null;
        }
    }

    public String decode(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return URLDecoder.decode(String.valueOf(obj), this.charset);
        }
        catch (UnsupportedEncodingException uee) {
            this.logError("Character encoding '" + this.charset + "' is unsupported", uee);
            return null;
        }
    }
}

