/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.io.VelocityWriter;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.tools.ClassUtils;
import org.apache.velocity.tools.Toolbox;
import org.apache.velocity.tools.ToolboxFactory;
import org.apache.velocity.tools.config.ConfigurationCleaner;
import org.apache.velocity.tools.config.ConfigurationUtils;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.apache.velocity.tools.config.FileFactoryConfiguration;
import org.apache.velocity.tools.config.PropertiesFactoryConfiguration;
import org.apache.velocity.tools.config.XmlFactoryConfiguration;
import org.apache.velocity.tools.generic.log.LogChuteCommonsLog;
import org.apache.velocity.tools.view.JeeConfig;
import org.apache.velocity.tools.view.ServletUtils;
import org.apache.velocity.tools.view.ViewToolContext;
import org.apache.velocity.tools.view.context.ChainedContext;
import org.apache.velocity.util.SimplePool;

public class VelocityView {
    public static final String CONTENT_TYPE_KEY = "default.contentType";
    public static final String SERVLET_CONTEXT_KEY = ServletContext.class.getName();
    public static final String DEFAULT_TOOLBOX_KEY = Toolbox.class.getName();
    public static final String CREATE_SESSION_PROPERTY = "createSession";
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String DEFAULT_OUTPUT_ENCODING = "ISO-8859-1";
    public static final String TOOLS_KEY = "org.apache.velocity.tools";
    @Deprecated
    public static final String DEPRECATED_TOOLS_KEY = "org.apache.velocity.toolbox";
    public static final String USER_TOOLS_PATH = "/WEB-INF/tools.xml";
    @Deprecated
    public static final String DEPRECATED_USER_TOOLS_PATH = "/WEB-INF/toolbox.xml";
    public static final String DEFAULT_PROPERTIES_PATH = "/org/apache/velocity/tools/view/velocity.properties";
    public static final String PROPERTIES_KEY = "org.apache.velocity.properties";
    public static final String USER_PROPERTIES_PATH = "/WEB-INF/velocity.properties";
    public static final String LOAD_DEFAULTS_KEY = "org.apache.velocity.tools.loadDefaults";
    public static final String CLEAN_CONFIGURATION_KEY = "org.apache.velocity.tools.cleanConfiguration";
    public static final String DEPRECATION_SUPPORT_MODE_KEY = "org.apache.velocity.tools.deprecationSupportMode";
    private static SimplePool writerPool = new SimplePool(40);
    private ToolboxFactory toolboxFactory = null;
    private VelocityEngine velocity = null;
    private ServletContext servletContext;
    private String defaultContentType = "text/html";
    private String toolboxKey = DEFAULT_TOOLBOX_KEY;
    private boolean createSession = true;
    private boolean deprecationSupportMode = true;

    public VelocityView(ServletConfig config) {
        this(new JeeConfig(config));
    }

    public VelocityView(FilterConfig config) {
        this(new JeeConfig(config));
    }

    public VelocityView(JeeConfig config) {
        this(config, DEFAULT_TOOLBOX_KEY);
    }

    public VelocityView(JeeConfig config, String toolboxKey) {
        this.setToolboxKey(toolboxKey);
        this.servletContext = config.getServletContext();
        this.init(config);
    }

    public VelocityView(ServletContext context) {
        this(new JeeConfig(context), DEFAULT_TOOLBOX_KEY);
    }

    private final void setToolboxKey(String toolboxKey) {
        if (toolboxKey == null) {
            throw new NullPointerException("toolboxKey cannot be null");
        }
        this.toolboxKey = toolboxKey;
    }

    protected final String getToolboxKey() {
        return this.toolboxKey;
    }

    protected final void setDeprecationSupportMode(boolean support) {
        this.deprecationSupportMode = support;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocity;
    }

    protected Log getLog() {
        return this.getVelocityEngine().getLog();
    }

    protected ToolboxFactory getToolboxFactory() {
        return this.toolboxFactory;
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    protected String getProperty(String key, String alternate) {
        String prop = (String)this.velocity.getProperty(key);
        if (prop == null || prop.length() == 0) {
            return alternate;
        }
        return prop;
    }

    protected void init(JeeConfig config) {
        String depMode = this.findInitParameter(DEPRECATION_SUPPORT_MODE_KEY, config);
        if (depMode != null && depMode.equalsIgnoreCase("false")) {
            this.setDeprecationSupportMode(false);
        }
        this.init(config, new VelocityEngine());
        this.init(config, new ToolboxFactory());
        this.setEncoding(config);
    }

    protected void init(JeeConfig config, VelocityEngine velocity) {
        if (velocity == null) {
            throw new NullPointerException("VelocityEngine cannot be null");
        }
        this.velocity = velocity;
        LogChuteCommonsLog.setVelocityLog(this.getLog());
        velocity.setApplicationAttribute((Object)SERVLET_CONTEXT_KEY, (Object)this.servletContext);
        this.configure(config, velocity);
        try {
            velocity.init();
        }
        catch (Exception e) {
            String msg = "Could not initialize VelocityEngine";
            this.getLog().error((Object)msg, (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException(msg + ": " + e, e);
        }
    }

    protected void init(JeeConfig config, ToolboxFactory factory) {
        Toolbox appTools;
        if (factory == null) {
            throw new NullPointerException("ToolboxFactory cannot be null");
        }
        this.toolboxFactory = factory;
        this.configure(config, this.toolboxFactory);
        Boolean bool = (Boolean)this.toolboxFactory.getGlobalProperty(CREATE_SESSION_PROPERTY);
        if (bool != null) {
            this.createSession = bool;
        }
        if ((appTools = this.toolboxFactory.createToolbox("application")) != null && this.servletContext.getAttribute(this.toolboxKey) == null) {
            this.servletContext.setAttribute(this.toolboxKey, (Object)appTools);
        }
    }

    protected String findInitParameter(String key, JeeConfig config) {
        String param = config.getInitParameter(key);
        if (param == null) {
            param = config.getServletContext().getInitParameter(key);
        }
        return param;
    }

    protected void configure(JeeConfig config, VelocityEngine velocity) {
        velocity.setExtendedProperties(this.getProperties(DEFAULT_PROPERTIES_PATH, true));
        String appPropsPath = this.servletContext.getInitParameter(PROPERTIES_KEY);
        this.setProps(velocity, appPropsPath, true);
        this.setProps(velocity, USER_PROPERTIES_PATH, false);
        String servletPropsPath = config.getInitParameter(PROPERTIES_KEY);
        this.setProps(velocity, servletPropsPath, true);
    }

    private boolean setProps(VelocityEngine velocity, String path, boolean require) {
        if (path == null) {
            return false;
        }
        ExtendedProperties props = this.getProperties(path, require);
        if (props == null) {
            return false;
        }
        this.getLog().debug((Object)("Configuring Velocity with properties at: " + path));
        velocity.setExtendedProperties(props);
        return true;
    }

    protected void configure(JeeConfig config, ToolboxFactory factory) {
        FactoryConfiguration oldToolbox;
        FactoryConfiguration factoryConfig = new FactoryConfiguration("VelocityView.configure(config,factory)");
        boolean hasOldToolbox = false;
        if (this.deprecationSupportMode && (oldToolbox = this.getDeprecatedConfig(config)) != null) {
            hasOldToolbox = true;
            factoryConfig.addConfiguration(oldToolbox);
        }
        String loadDefaults = this.findInitParameter(LOAD_DEFAULTS_KEY, config);
        if (!hasOldToolbox && loadDefaults == null || "true".equalsIgnoreCase(loadDefaults)) {
            this.getLog().trace((Object)"Loading default tools configuration...");
            factoryConfig.addConfiguration(ConfigurationUtils.getDefaultTools());
        } else {
            this.getLog().debug((Object)("Default tools configuration has been suppressed" + (hasOldToolbox ? " to avoid conflicts with older application's context and toolbox definition." : ".")));
        }
        FactoryConfiguration autoLoaded = ConfigurationUtils.getAutoLoaded(false);
        factoryConfig.addConfiguration(autoLoaded);
        String appToolsPath = this.servletContext.getInitParameter(TOOLS_KEY);
        this.setConfig(factoryConfig, appToolsPath, true);
        this.setConfig(factoryConfig, USER_TOOLS_PATH, false);
        String servletToolsPath = config.getInitParameter(TOOLS_KEY);
        this.setConfig(factoryConfig, servletToolsPath, true);
        String cleanConfig = this.findInitParameter(CLEAN_CONFIGURATION_KEY, config);
        if ("true".equals(cleanConfig)) {
            ConfigurationCleaner cleaner = new ConfigurationCleaner();
            cleaner.setLog(this.getLog());
            cleaner.clean(factoryConfig);
        }
        this.getLog().debug((Object)("Configuring toolboxFactory with: " + factoryConfig));
        factory.configure(factoryConfig);
    }

    @Deprecated
    protected FactoryConfiguration getDeprecatedConfig(JeeConfig config) {
        FactoryConfiguration toolbox = null;
        String oldPath = this.findInitParameter(DEPRECATED_TOOLS_KEY, config);
        if (oldPath != null) {
            toolbox = this.getConfiguration(oldPath, true);
        } else {
            oldPath = DEPRECATED_USER_TOOLS_PATH;
            toolbox = this.getConfiguration(oldPath);
        }
        if (toolbox != null) {
            this.getLog().debug((Object)("Loaded deprecated configuration from: " + oldPath));
            this.getLog().warn((Object)"Please upgrade to new \"/WEB-INF/tools.xml\" format and conventional location. Support for \"/WEB-INF/toolbox.xml\" format and conventional file name will be removed in a future version.");
        }
        return toolbox;
    }

    private boolean setConfig(FactoryConfiguration factory, String path, boolean require) {
        if (path == null) {
            return false;
        }
        FactoryConfiguration config = this.getConfiguration(path, require);
        if (config == null) {
            return false;
        }
        this.getLog().debug((Object)("Loaded configuration from: " + path));
        factory.addConfiguration(config);
        return true;
    }

    protected InputStream getInputStream(String path, boolean required) {
        File file;
        InputStream inputStream = ClassUtils.getResourceAsStream(path, this);
        if (inputStream == null && (inputStream = this.servletContext.getResourceAsStream(path)) == null && (file = new File(path)).exists()) {
            try {
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fnfe) {
                throw new IllegalStateException(fnfe);
            }
        }
        if (inputStream == null) {
            String msg = "Could not find resource at: " + path;
            this.getLog().debug((Object)msg);
            if (required) {
                throw new ResourceNotFoundException(msg);
            }
            return null;
        }
        return inputStream;
    }

    protected ExtendedProperties getProperties(String path) {
        return this.getProperties(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExtendedProperties getProperties(String path, boolean required) {
        InputStream inputStream;
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("Searching for properties at: " + path));
        }
        if ((inputStream = this.getInputStream(path, required)) == null) {
            return null;
        }
        ExtendedProperties properties = new ExtendedProperties();
        try {
            properties.load(inputStream);
        }
        catch (IOException ioe) {
            String msg = "Failed to load properties at: " + path;
            this.getLog().error((Object)msg, (Throwable)ioe);
            if (required) {
                throw new RuntimeException(ioe);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ioe) {
                this.getLog().error((Object)("Failed to close input stream for " + path), (Throwable)ioe);
            }
        }
        return properties;
    }

    protected FactoryConfiguration getConfiguration(String path) {
        return this.getConfiguration(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FactoryConfiguration getConfiguration(String path, boolean required) {
        InputStream inputStream;
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("Searching for configuration at: " + path));
        }
        if ((inputStream = this.getInputStream(path, required)) == null) {
            return null;
        }
        FileFactoryConfiguration config = null;
        String source = "VelocityView.getConfiguration(" + path + "," + required + ")";
        if (path.endsWith(".xml")) {
            config = new XmlFactoryConfiguration(this.deprecationSupportMode, source);
        } else if (path.endsWith(".properties")) {
            config = new PropertiesFactoryConfiguration(source);
        } else {
            String msg = "Unknown configuration file type: " + path + "\nOnly .xml and .properties configuration files are supported at this time.";
            this.getLog().debug((Object)msg);
            if (required) {
                throw new UnsupportedOperationException(msg);
            }
            return null;
        }
        try {
            config.read(inputStream);
        }
        catch (IOException ioe) {
            String msg = "Failed to load configuration at: " + path;
            this.getLog().error((Object)msg, (Throwable)ioe);
            if (required) {
                throw new RuntimeException(ioe);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ioe) {
                this.getLog().error((Object)("Failed to close input stream for " + path), (Throwable)ioe);
            }
        }
        return config;
    }

    protected void setEncoding(JeeConfig config) {
        this.defaultContentType = this.getProperty(CONTENT_TYPE_KEY, DEFAULT_CONTENT_TYPE);
        String encoding = this.getProperty("output.encoding", DEFAULT_OUTPUT_ENCODING);
        if (!DEFAULT_OUTPUT_ENCODING.equalsIgnoreCase(encoding)) {
            int index = this.defaultContentType.lastIndexOf("charset");
            if (index < 0) {
                this.defaultContentType = this.defaultContentType + "; charset=" + encoding;
            } else {
                this.getLog().info((Object)"Charset was already specified in the Content-Type property.  Output encoding property will be ignored.");
            }
        }
        this.getLog().debug((Object)("Default content-type is: " + this.defaultContentType));
    }

    public Context render(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Context context = this.getContext(request, response);
        Template template = this.getTemplate(request, response);
        this.merge(template, context, response.getWriter());
        return context;
    }

    public Context render(HttpServletRequest request, Writer out) throws IOException {
        Context context = this.getContext(request);
        Template template = this.getTemplate(request);
        this.merge(template, context, out);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareToolboxes(HttpServletRequest request) {
        HttpSession session;
        Toolbox reqTools;
        if (this.toolboxFactory.hasTools("request") && request.getAttribute(this.toolboxKey) == null && (reqTools = this.toolboxFactory.createToolbox("request")) != null) {
            request.setAttribute(this.toolboxKey, (Object)reqTools);
        }
        if (this.toolboxFactory.hasTools("session") && (session = request.getSession(this.createSession)) != null) {
            Object object = this.getMutex(session);
            synchronized (object) {
                if (session.getAttribute(this.toolboxKey) == null) {
                    Toolbox sessTools = this.toolboxFactory.createToolbox("session");
                    session.setAttribute(this.toolboxKey, (Object)sessTools);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getMutex(HttpSession session) {
        Object lock = session.getAttribute("session.mutex");
        if (lock == null) {
            VelocityView velocityView = this;
            synchronized (velocityView) {
                lock = session.getAttribute("session.mutex");
                if (lock == null) {
                    lock = new Boolean(true);
                    session.setAttribute("session.mutex", lock);
                }
            }
        }
        return lock;
    }

    protected ViewToolContext createContext(HttpServletRequest request, HttpServletResponse response) {
        ViewToolContext ctx = this.deprecationSupportMode ? new ChainedContext(this.velocity, request, response, this.servletContext) : new ViewToolContext(this.velocity, request, response, this.servletContext);
        this.prepareContext(ctx);
        return ctx;
    }

    public void prepareContext(ViewToolContext context) {
        if (!this.toolboxKey.equals(DEFAULT_TOOLBOX_KEY)) {
            context.addToolboxesUnderKey(this.toolboxKey);
        }
    }

    public Context getContext(HttpServletRequest request) {
        return this.getContext(request, null);
    }

    public Context getContext(HttpServletRequest request, HttpServletResponse response) {
        this.prepareToolboxes(request);
        return this.createContext(request, response);
    }

    public Template getTemplate(HttpServletRequest request) {
        return this.getTemplate(request, null);
    }

    public Template getTemplate(HttpServletRequest request, HttpServletResponse response) {
        String path = ServletUtils.getPath(request);
        if (response == null) {
            return this.getTemplate(path);
        }
        return this.getTemplate(path, response.getCharacterEncoding());
    }

    public Template getTemplate(String name) {
        return this.getTemplate(name, null);
    }

    public Template getTemplate(String name, String encoding) {
        try {
            if (encoding == null) {
                return this.getVelocityEngine().getTemplate(name);
            }
            return this.getVelocityEngine().getTemplate(name, encoding);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(Template template, Context context, Writer writer) throws IOException {
        VelocityWriter vw = null;
        try {
            vw = (VelocityWriter)writerPool.get();
            if (vw == null) {
                vw = new VelocityWriter(writer, 4096, true);
            } else {
                vw.recycle(writer);
            }
            this.performMerge(template, context, (Writer)vw);
        }
        finally {
            if (vw != null) {
                try {
                    vw.flush();
                    vw.recycle(null);
                    writerPool.put((Object)vw);
                }
                catch (Exception e) {
                    this.getLog().debug((Object)("Trouble releasing VelocityWriter: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    protected void performMerge(Template template, Context context, Writer writer) throws IOException {
        template.merge(context, writer);
    }
}

