/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.internal.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.ClientRuntimeException;
import org.apache.wink.client.EntityType;
import org.apache.wink.client.internal.ClientRuntimeContext;
import org.apache.wink.client.internal.handlers.BaseRequestResponseImpl;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.internal.runtime.RuntimeContext;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientResponseImpl
extends BaseRequestResponseImpl
implements ClientResponse {
    private Object entity;
    private String message;
    private int status;

    @Override
    public <T> T getEntity(Class<T> type) {
        return this.getEntity(type, type);
    }

    @Override
    public <T> T getEntity(EntityType<T> entityType) {
        return this.getEntity(entityType.getRawClass(), entityType.getType());
    }

    private <T> T getEntity(Class<T> type, Type genericType) {
        if (type.isInstance(this.entity)) {
            return (T)this.entity;
        }
        if (this.entity instanceof InputStream) {
            T t = this.readEntity(type, genericType, (InputStream)this.entity);
            this.setEntity(t);
            return t;
        }
        throw new ClassCastException(String.format("entity of type %s cannot be retrieved as type %s", this.entity.getClass().getName(), type.getName()));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getStatusCode() {
        return this.status;
    }

    @Override
    public void setEntity(Object entity) {
        this.entity = entity;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void setStatusCode(int code) {
        this.status = code;
    }

    private <T> T readEntity(Class<T> type, Type genericType, InputStream is) {
        if (type == null) {
            return null;
        }
        if (ClientResponse.class.equals(type)) {
            return (T)this;
        }
        ProvidersRegistry providersRegistry = this.getAttribute(ProvidersRegistry.class);
        RuntimeContext saved = RuntimeContextTLS.getRuntimeContext();
        ClientRuntimeContext runtimeContext = new ClientRuntimeContext(providersRegistry);
        RuntimeContextTLS.setRuntimeContext((RuntimeContext)runtimeContext);
        try {
            Object entity;
            String contentType = (String)this.getHeaders().getFirst((Object)"Content-Type");
            MediaType contentMediaType = MediaType.valueOf((String)contentType);
            MessageBodyReader reader = providersRegistry.getMessageBodyReader(type, genericType, null, contentMediaType, (RuntimeContext)runtimeContext);
            if (reader == null) {
                throw new RuntimeException(String.format("No reader for type %s and media type %s", String.valueOf(type), contentType));
            }
            Object object = entity = reader.readFrom(type, genericType, null, contentMediaType, this.getHeaders(), is);
            return (T)object;
        }
        catch (WebApplicationException e) {
            throw new ClientRuntimeException(e);
        }
        catch (IOException e) {
            throw new ClientRuntimeException(e);
        }
        finally {
            RuntimeContextTLS.setRuntimeContext((RuntimeContext)saved);
        }
    }
}

