/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.internal.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.HandlerContext;
import org.apache.wink.client.handlers.InputStreamAdapter;
import org.apache.wink.client.handlers.OutputStreamAdapter;

public class GzipHandler
implements ClientHandler {
    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        request.getHeaders().add((Object)"Accept-Encoding", (Object)"gzip");
        context.addInputStreamAdapter(new GzipAdapter());
        context.addOutputStreamAdapter(new GzipAdapter());
        return context.doChain(request);
    }

    private static class GzipAdapter
    implements InputStreamAdapter,
    OutputStreamAdapter {
        private GzipAdapter() {
        }

        public OutputStream adapt(OutputStream os, ClientRequest request) throws IOException {
            request.getHeaders().add((Object)"Content-Encoding", (Object)"gzip");
            return new GZIPOutputStream(os);
        }

        public InputStream adapt(InputStream is, ClientResponse response) throws IOException {
            String header = (String)response.getHeaders().getFirst((Object)"Content-Encoding");
            if (header != null && header.equalsIgnoreCase("gzip")) {
                return new GZIPInputStream(is);
            }
            return is;
        }
    }
}

