/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *  
 *   http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *  
 *******************************************************************************/
//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.1.1-b02-fcs 
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a> 
// Any modifications to this file will be lost upon recompilation of the source schema. 
// Generated on: 2008.05.27 at 11:24:25 AM IDT 
//

package org.apache.wink.common.model.atom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;

import org.apache.wink.common.RestConstants;
import org.apache.wink.common.RestException;
import org.apache.wink.common.internal.model.ModelUtils;
import org.apache.wink.common.internal.utils.JAXBUtils;
import org.apache.wink.common.model.opensearch.OpenSearchDescription;
import org.apache.wink.common.model.opensearch.OpenSearchQuery;
import org.apache.wink.common.model.synd.SyndCategory;
import org.apache.wink.common.model.synd.SyndEntry;
import org.apache.wink.common.model.synd.SyndFeed;
import org.apache.wink.common.model.synd.SyndGenerator;
import org.apache.wink.common.model.synd.SyndLink;
import org.apache.wink.common.model.synd.SyndPerson;
import org.apache.wink.common.model.synd.SyndText;
import org.w3c.dom.Element;

/**
 * The "atom:feed" element Per RFC4287
 * 
 * <pre>
 * The &quot;atom:feed&quot; element is the document (i.e., top-level) element of
 * an Atom Feed Document, acting as a container for metadata and data
 * associated with the feed.  Its element children consist of metadata
 * elements followed by zero or more atom:entry child elements.
 * 
 * atomFeed =
 *   element atom:feed {
 *       atomCommonAttributes,
 *       (atomAuthor*
 *        &amp; atomCategory*
 *        &amp; atomContributor*
 *        &amp; atomGenerator?
 *        &amp; atomIcon?
 *        &amp; atomId
 *        &amp; atomLink*
 *        &amp; atomLogo?
 *        &amp; atomRights?
 *        &amp; atomSubtitle?
 *        &amp; atomTitle
 *        &amp; atomUpdated
 *        &amp; extensionElement*),
 *       atomEntry*
 *   }
 * 
 * This specification assigns no significance to the order of atom:entry
 * elements within the feed.
 * 
 * The following child elements are defined by this specification (note
 * that the presence of some of these elements is required):
 * 
 * o  atom:feed elements MUST contain one or more atom:author elements,
 *    unless all of the atom:feed element's child atom:entry elements
 *    contain at least one atom:author element.
 * o  atom:feed elements MAY contain any number of atom:category
 *    elements.
 * o  atom:feed elements MAY contain any number of atom:contributor
 *    elements.
 * o  atom:feed elements MUST NOT contain more than one atom:generator
 *    element.
 * o  atom:feed elements MUST NOT contain more than one atom:icon
 *    element.
 * o  atom:feed elements MUST NOT contain more than one atom:logo
 *    element.
 * o  atom:feed elements MUST contain exactly one atom:id element.
 * o  atom:feed elements SHOULD contain one atom:link element with a rel
 *    attribute value of &quot;self&quot;.  This is the preferred URI for
 *    retrieving Atom Feed Documents representing this Atom feed.
 * o  atom:feed elements MUST NOT contain more than one atom:link
 *    element with a rel attribute value of &quot;alternate&quot; that has the
 *    same combination of type and hreflang attribute values.
 * o  atom:feed elements MAY contain additional atom:link elements
 *    beyond those described above.
 * o  atom:feed elements MUST NOT contain more than one atom:rights
 *    element.
 * o  atom:feed elements MUST NOT contain more than one atom:subtitle
 *    element.
 * o  atom:feed elements MUST contain exactly one atom:title element.
 * o  atom:feed elements MUST contain exactly one atom:updated element.
 * 
 * If multiple atom:entry elements with the same atom:id value appear in
 * an Atom Feed Document, they represent the same entry.  Their
 * atom:updated timestamps SHOULD be different.  If an Atom Feed
 * Document contains multiple entries with the same atom:id, Atom
 * Processors MAY choose to display all of them or some subset of them.
 * One typical behavior would be to display only the entry with the
 * latest atom:updated timestamp.
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlAccessorOrder(XmlAccessOrder.UNDEFINED)
@XmlType(name = "atomFeed", propOrder = {"id", "updated", "title", "subtitle", "itemsPerPage",
                                         "startIndex", "totalResults", "opensearchQuery", "link",
                                         "author", "contributor", "category", "generator", "icon",
                                         "logo", "rights", "any", "entry"})
@XmlSeeAlso(value = {OpenSearchQuery.class})
public class AtomFeed extends AtomCommonAttributes {

    @XmlElement(required = true)
    protected String                                                id;
    @XmlElement(required = true)
    protected XMLGregorianCalendar                                  updated;
    @XmlElement(required = true)
    protected AtomText                                              title;
    protected AtomText                                              subtitle;
    protected List<AtomLink>                                        link;
    protected List<AtomPerson>                                      author;
    protected List<AtomPerson>                                      contributor;
    protected List<AtomCategory>                                    category;
    protected AtomGenerator                                         generator;
    protected String                                                icon;
    protected String                                                logo;
    protected AtomText                                              rights;
    @XmlAnyElement
    protected List<Object>                                          any;
    protected List<AtomEntry>                                       entry;

    @XmlElement(namespace = RestConstants.NAMESPACE_OPENSEARCH)
    protected BigInteger                                            totalResults;
    @XmlElement(namespace = RestConstants.NAMESPACE_OPENSEARCH)
    protected BigInteger                                            itemsPerPage;
    @XmlElement(namespace = RestConstants.NAMESPACE_OPENSEARCH)
    protected BigInteger                                            startIndex;
    @XmlElement(name = "Query", namespace = RestConstants.NAMESPACE_OPENSEARCH)
    protected List<OpenSearchQuery>                                 opensearchQuery;

    @XmlTransient
    private static final JAXBContext                                atomContext;
    @XmlTransient
    protected org.apache.wink.common.model.opensearch.ObjectFactory opensearchFactory;

    static {
        try {
            atomContext =
                JAXBContext.newInstance(AtomFeed.class.getPackage().getName() + ":"
                    + OpenSearchDescription.class.getPackage().getName());
        } catch (JAXBException e) {
            throw new RestException("Failed to create JAXBContext for AtomFeed", e);
        }
    }

    public AtomFeed() {
        opensearchFactory = new org.apache.wink.common.model.opensearch.ObjectFactory();
    }

    public AtomFeed(SyndFeed value) {
        super(value);
        if (value == null) {
            return;
        }
        setUpdated(value.getUpdated());
        setGenerator(value.getGenerator() != null ? new AtomGenerator(value.getGenerator()) : null);
        setIcon(value.getIcon());
        setId(value.getId());
        setItemsPerPage(value.getItemsPerPage());
        setLogo(value.getLogo());
        setRights(value.getRights() != null ? new AtomText(value.getRights()) : null);
        setStartIndex(value.getStartIndex());
        setSubtitle(value.getSubtitle() != null ? new AtomText(value.getSubtitle()) : null);
        setTitle(value.getTitle() != null ? new AtomText(value.getTitle()) : null);
        setTotalResults(value.getTotalResults());
        setAuthors(value.getAuthors());
        setCategories(value.getCategories());
        setLinks(value.getLinks());
        setEntries(value.getEntries());
    }

    public SyndFeed toSynd(SyndFeed value) {
        if (value == null) {
            return value;
        }
        super.toSynd(value);
        value.setUpdated(getUpdated());
        value.setGenerator(getGenerator() != null ? getGenerator().toSynd(new SyndGenerator())
            : null);
        value.setIcon(getIcon());
        value.setId(getId());
        value.setItemsPerPage(getItemsPerPage());
        value.setLogo(getLogo());
        value.setRights(getRights() != null ? getRights().toSynd(new SyndText()) : null);
        value.setStartIndex(getStartIndex());
        value.setSubtitle(getSubtitle() != null ? getSubtitle().toSynd(new SyndText()) : null);
        value.setTitle(getTitle() != null ? getTitle().toSynd(new SyndText()) : null);
        value.setTotalResults(getTotalResults());
        value.getAuthors().addAll(getAuthorsAsSynd());
        value.getCategories().addAll(getCategoriesAsSynd());
        value.getLinks().addAll(getLinksAsSynd());
        value.getEntries().addAll(getEntriesAsSynd());
        return value;
    }

    public static Marshaller getMarshaller() {
        return JAXBUtils.createMarshaller(atomContext);
    }

    public static Unmarshaller getUnmarshaller() {
        return JAXBUtils.createUnmarshaller(atomContext);
    }

    /**
     * Convenience method for creating an AtomFeed from xml
     * 
     * @param reader input reader
     * @return AtomFeed instance from the input
     */
    public static AtomFeed unmarshal(Reader reader) throws IOException {
        return (AtomFeed)ModelUtils.unmarshal(AtomFeed.getUnmarshaller(), reader);
    }

    public static void marshal(AtomFeed feed, OutputStream os) throws IOException {
        JAXBElement<AtomFeed> feedElement = new ObjectFactory().createFeed(feed);
        Marshaller marshaller = AtomFeed.getMarshaller();
        ModelUtils.marshal(marshaller, feedElement, os);
    }

    private List<SyndPerson> getAuthorsAsSynd() {
        List<SyndPerson> authors = new ArrayList<SyndPerson>();
        for (AtomPerson value : getAuthors()) {
            if (value != null) {
                authors.add(value.toSynd(new SyndPerson()));
            }
        }
        return authors;
    }

    private List<SyndCategory> getCategoriesAsSynd() {
        List<SyndCategory> authors = new ArrayList<SyndCategory>();
        for (AtomCategory value : getCategories()) {
            if (value != null) {
                authors.add(value.toSynd(new SyndCategory()));
            }
        }
        return authors;
    }

    private List<SyndLink> getLinksAsSynd() {
        List<SyndLink> authors = new ArrayList<SyndLink>();
        for (AtomLink value : getLinks()) {
            if (value != null) {
                authors.add(value.toSynd(new SyndLink()));
            }
        }
        return authors;
    }

    private List<SyndEntry> getEntriesAsSynd() {
        List<SyndEntry> authors = new ArrayList<SyndEntry>();
        for (AtomEntry value : getEntries()) {
            if (value != null) {
                authors.add(value.toSynd(new SyndEntry()));
            }
        }
        return authors;
    }

    private void setAuthors(List<SyndPerson> values) {
        getAuthors().clear();
        if (values == null) {
            return;
        }
        for (SyndPerson value : values) {
            if (value != null) {
                this.author.add(new AtomPerson(value));
            }
        }
    }

    private void setCategories(List<SyndCategory> values) {
        getCategories().clear();
        if (values == null) {
            return;
        }
        for (SyndCategory value : values) {
            if (value != null) {
                this.category.add(new AtomCategory(value));
            }
        }
    }

    private void setLinks(List<SyndLink> values) {
        getLinks().clear();
        if (values == null) {
            return;
        }
        for (SyndLink value : values) {
            if (value != null) {
                this.link.add(new AtomLink(value));
            }
        }
    }

    private void setEntries(List<SyndEntry> values) {
        getEntries().clear();
        if (values == null) {
            return;
        }
        for (SyndEntry value : values) {
            if (value != null) {
                this.entry.add(new AtomEntry(value));
            }
        }
    }

    /**
     * Gets the value of id.
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of id.
     */
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets the value of updated as a long value
     * 
     * @return the updated value, or -1 if it is not set
     */
    public long getUpdatedAsTime() {
        return ModelUtils.xmlGregorianCalendarToTime(updated);
    }

    /**
     * Gets the value of updated as a Date object
     */
    public Date getUpdated() {
        long updatedAsTime = getUpdatedAsTime();
        if (updatedAsTime == -1) {
            return null;
        }
        return new Date(updatedAsTime);
    }

    /**
     * Sets the value of updated.
     */
    public void setUpdated(XMLGregorianCalendar value) {
        this.updated = value;
    }

    /**
     * Sets the value of updated.
     */
    public void setUpdated(long value) {
        setUpdated(ModelUtils.timeToXmlGregorianCalendar(value));
    }

    /**
     * Sets the value of updated.
     */
    public void setUpdated(Date value) {
        if (value == null) {
            this.updated = null;
            return;
        }
        setUpdated(value.getTime());
    }

    /**
     * Gets the value of title.
     */
    public AtomText getTitle() {
        return title;
    }

    /**
     * Sets the value of title.
     */
    public void setTitle(AtomText value) {
        this.title = value;
    }

    /**
     * Gets the value of subtitle.
     */
    public AtomText getSubtitle() {
        return subtitle;
    }

    /**
     * Sets the value of subtitle.
     */
    public void setSubtitle(AtomText value) {
        this.subtitle = value;
    }

    /**
     * Gets the value of link.
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside the JAXB object. This is why there is not a
     * <CODE>set</CODE> method for the link.
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getLink().add(newItem);
     * </pre>
     * <p>
     * Objects of the following type(s) are allowed in the list {@link AtomLink }
     */
    public List<AtomLink> getLinks() {
        if (link == null) {
            link = new ArrayList<AtomLink>();
        }
        return this.link;
    }

    /**
     * Gets the value of author.
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside the JAXB object. This is why there is not a
     * <CODE>set</CODE> method for the author.
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getAuthor().add(newItem);
     * </pre>
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AtomPerson }
     */
    public List<AtomPerson> getAuthors() {
        if (author == null) {
            author = new ArrayList<AtomPerson>();
        }
        return this.author;
    }

    /**
     * Gets the value of contributor.
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside the JAXB object. This is why there is not a
     * <CODE>set</CODE> method for the contributor.
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getContributor().add(newItem);
     * </pre>
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AtomPerson }
     */
    public List<AtomPerson> getContributors() {
        if (contributor == null) {
            contributor = new ArrayList<AtomPerson>();
        }
        return this.contributor;
    }

    /**
     * Gets the value of category.
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside the JAXB object. This is why there is not a
     * <CODE>set</CODE> method for the category.
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getCategory().add(newItem);
     * </pre>
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AtomCategory }
     */
    public List<AtomCategory> getCategories() {
        if (category == null) {
            category = new ArrayList<AtomCategory>();
        }
        return this.category;
    }

    /**
     * Gets the value of generator.
     */
    public AtomGenerator getGenerator() {
        return generator;
    }

    /**
     * Sets the value of generator.
     */
    public void setGenerator(AtomGenerator value) {
        this.generator = value;
    }

    /**
     * Gets the value of icon.
     */
    public String getIcon() {
        return icon;
    }

    /**
     * Sets the value of icon.
     */
    public void setIcon(String value) {
        this.icon = value;
    }

    /**
     * Gets the value of logo.
     */
    public String getLogo() {
        return logo;
    }

    /**
     * Sets the value of logo.
     */
    public void setLogo(String value) {
        this.logo = value;
    }

    /**
     * Gets the value of rights.
     */
    public AtomText getRights() {
        return rights;
    }

    /**
     * Sets the value of rights.
     */
    public void setRights(AtomText value) {
        this.rights = value;
    }

    /**
     * Gets extension elements
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside the JAXB object. This is why there is not a
     * <CODE>set</CODE> method for the any.
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getAny().add(newItem);
     * </pre>
     * <p>
     * Objects of the following type(s) are allowed in the list {@link Element }
     */
    public List<Object> getAny() {
        if (any == null) {
            any = new ArrayList<Object>();
        }
        return this.any;
    }

    /**
     * Gets the value of entry.
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside the JAXB object. This is why there is not a
     * <CODE>set</CODE> method for the entry.
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getEntry().add(newItem);
     * </pre>
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AtomEntry }
     */
    public List<AtomEntry> getEntries() {
        if (entry == null) {
            entry = new ArrayList<AtomEntry>();
        }
        return this.entry;
    }

    /**
     * Gets the value of opensearch totalResults.
     */
    public long getTotalResults() {
        if (totalResults == null) {
            return -1;
        }
        return totalResults.longValue();
    }

    /**
     * Sets the value of opensearch totalResults.
     */
    public void setTotalResults(long totalResults) {
        if (totalResults >= 0) {
            this.totalResults = BigInteger.valueOf(totalResults);
        } else {
            this.totalResults = null;
        }
    }

    /**
     * Gets the value of opensearch startIndex.
     */
    public long getStartIndex() {
        if (startIndex == null) {
            return -1;
        }
        return startIndex.longValue();
    }

    /**
     * Sets the value of opensearch startIndex.
     */
    public void setStartIndex(long startIndex) {
        if (startIndex >= 0) {
            this.startIndex = BigInteger.valueOf(startIndex);
        } else {
            this.startIndex = null;
        }
    }

    /**
     * Gets the value of opensearch itemsPerPage.
     */
    public long getItemsPerPage() {
        if (itemsPerPage == null) {
            return -1;
        }
        return itemsPerPage.longValue();

    }

    /**
     * Sets the value of opensearch itemsPerPage.
     */
    public void setItemsPerPage(long itemsPerPage) {
        if (itemsPerPage >= 0) {
            this.itemsPerPage = BigInteger.valueOf(itemsPerPage);
        } else {
            this.itemsPerPage = null;
        }
    }

    /**
     * Gets the list of opensearch Query elements
     */
    public List<OpenSearchQuery> getOpenSearchQueries() {
        if (opensearchQuery == null) {
            opensearchQuery = new ArrayList<OpenSearchQuery>();
        }
        return opensearchQuery;
    }

    /**
     * Sets the list of opensearch Query elements
     */
    public void setOpenSearchQueries(List<OpenSearchQuery> queries) {
        this.opensearchQuery = queries;
    }

    /**
     * Adds an opensearch Query element
     */
    public void addOpenSearchQuery(OpenSearchQuery query) {
        if (query != null) {
            getOpenSearchQueries().add(query);
        }
    }

}
