/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.lifecycle;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.lifecycle.ObjectCreationException;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.registry.InjectableFactory;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.apache.wink.common.internal.registry.metadata.ConstructorMetadata;

public class CreationUtils {
    private CreationUtils() {
    }

    static Object createObject(ClassMetadata metadata, RuntimeContext runtimeContext) {
        try {
            ConstructorMetadata constructorMetadata = metadata.getConstructor();
            Constructor<?> constructor = constructorMetadata.getConstructor();
            List<Injectable> formalParameters = constructorMetadata.getFormalParameters();
            Object[] params = InjectableFactory.getInstance().instantiate(formalParameters, runtimeContext);
            Object object = constructor.newInstance(params);
            CreationUtils.injectFields(object, metadata, runtimeContext);
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new ObjectCreationException(targetException);
        }
        catch (Exception e) {
            throw new ObjectCreationException(e);
        }
    }

    public static void injectFields(Object object, ClassMetadata metadata, RuntimeContext runtimeContext) throws IOException, PrivilegedActionException {
        List<Injectable> injectableFields = metadata.getInjectableFields();
        for (Injectable injectableData : injectableFields) {
            Object value = injectableData.getValue(runtimeContext);
            Member member = injectableData.getMember();
            if (member instanceof Field) {
                CreationUtils.injectField(object, value, (Field)member);
                continue;
            }
            if (member instanceof Method) {
                CreationUtils.invokeMethod(object, value, (Method)member);
                continue;
            }
            throw new WebApplicationException();
        }
    }

    static void invokeMethod(final Object object, final Object value, final Method method) throws PrivilegedActionException {
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                    method.setAccessible(true);
                }
                method.invoke(object, value);
                return null;
            }
        });
    }

    static void injectField(final Object object, final Object value, final Field field) throws PrivilegedActionException {
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
                    field.setAccessible(true);
                }
                field.set(object, value);
                return null;
            }
        });
    }
}

