/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.lifecycle;

import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.LifecycleManager;
import org.apache.wink.common.internal.lifecycle.LifecycleManagerUtils;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.common.internal.lifecycle.SingletonObjectFactory;
import org.apache.wink.common.internal.registry.metadata.ApplicationMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultLifecycleManager<T>
implements LifecycleManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLifecycleManager.class);

    DefaultLifecycleManager() {
    }

    @Override
    public ObjectFactory<T> createObjectFactory(T object) {
        if (object == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "object"));
        }
        logger.debug("Creating a {} for {}", SingletonObjectFactory.class, object);
        return LifecycleManagerUtils.createSingletonObjectFactory(object);
    }

    @Override
    public ObjectFactory<T> createObjectFactory(Class<T> cls) {
        if (cls == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "cls"));
        }
        if (ResourceMetadataCollector.isDynamicResource(cls)) {
            throw new IllegalArgumentException(Messages.getMessage("cannotCreateDefaultFactoryForDR", String.valueOf(cls)));
        }
        if (ApplicationMetadataCollector.isApplication(cls)) {
            return LifecycleManagerUtils.createSingletonObjectFactory(cls);
        }
        if (ProviderMetadataCollector.isProvider(cls)) {
            return LifecycleManagerUtils.createSingletonObjectFactory(cls);
        }
        if (ResourceMetadataCollector.isStaticResource(cls)) {
            return LifecycleManagerUtils.createPrototypeObjectFactory(cls);
        }
        throw new IllegalArgumentException(Messages.getMessage("cannotCreateDefaultFactoryFor", String.valueOf(cls)));
    }
}

