/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.entity.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.providers.entity.xml.AbstractJAXBProvider;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"text/xml", "application/xml", "*/*"})
@Produces(value={"text/xml", "application/xml", "*/*"})
public class JAXBXmlProvider
extends AbstractJAXBProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(JAXBXmlProvider.class);

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JAXBXmlProvider.isJAXBObject(type, genericType) && this.isSupportedMediaType(mediaType);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Unmarshaller unmarshaller = null;
        Object unmarshaledResource = null;
        XMLStreamReader xmlStreamReader = null;
        try {
            JAXBContext context = this.getContext(type, mediaType);
            unmarshaller = this.getJAXBUnmarshaller(type, context, mediaType);
            xmlStreamReader = JAXBXmlProvider.getXMLStreamReader(entityStream);
            if (type.isAnnotationPresent(XmlRootElement.class)) {
                unmarshaledResource = unmarshaller.unmarshal(xmlStreamReader);
                JAXBXmlProvider.closeXMLStreamReader(xmlStreamReader);
                if (unmarshaledResource instanceof JAXBElement) {
                    unmarshaledResource = ((JAXBElement)unmarshaledResource).getValue();
                }
            } else {
                unmarshaledResource = unmarshaller.unmarshal(xmlStreamReader, type).getValue();
                JAXBXmlProvider.closeXMLStreamReader(xmlStreamReader);
            }
            this.releaseJAXBUnmarshaller(context, unmarshaller);
        }
        catch (JAXBException e) {
            JAXBXmlProvider.closeXMLStreamReader(xmlStreamReader);
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("jaxbFailToUnmarshal", type.getName()), (Throwable)e);
            }
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (XMLStreamException e) {
            JAXBXmlProvider.closeXMLStreamReader(xmlStreamReader);
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("entityRefsNotSupported"));
            }
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (RuntimeException e) {
            JAXBXmlProvider.closeXMLStreamReader(xmlStreamReader);
            throw e;
        }
        return unmarshaledResource;
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JAXBXmlProvider.isJAXBObject(type, genericType) && this.isSupportedMediaType(mediaType);
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        mediaType = MediaTypeUtils.setDefaultCharsetOnMediaTypeHeader(httpHeaders, mediaType);
        try {
            if (JAXBXmlProvider.isJAXBObject(type)) {
                JAXBContext context = this.getContext(type, genericType, mediaType);
                Marshaller marshaller = this.getJAXBMarshaller(type, context, mediaType);
                Object entityToMarshal = this.getEntityToMarshal(t, type);
                marshaller.marshal(entityToMarshal, entityStream);
                this.releaseJAXBMarshaller(context, marshaller);
            } else if (genericType instanceof Class) {
                JAXBContext context = this.getContext((Class)genericType, genericType, mediaType);
                Marshaller marshaller = this.getJAXBMarshaller((Class)genericType, context, mediaType);
                Object entityToMarshal = this.getEntityToMarshal(t, (Class)genericType);
                marshaller.marshal(entityToMarshal, entityStream);
                this.releaseJAXBMarshaller(context, marshaller);
            }
        }
        catch (JAXBException e) {
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("jaxbFailToMarshal", type.getName()), (Throwable)e);
            }
            throw new WebApplicationException((Throwable)e);
        }
    }
}

