/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.utils;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.contexts.MediaTypeCharsetAdjuster;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.common.internal.uri.UriEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaTypeUtils {
    private static final Logger logger = LoggerFactory.getLogger(MediaTypeUtils.class);
    public static final String ATOM_SERVICE_DOCUMENT = "application/atomsvc+xml";
    public static final MediaType ATOM_SERVICE_DOCUMENT_TYPE = new MediaType("application", "atomsvc+xml");
    public static final String ATOM_CATEGORIES_DOCUMENT = "application/atomcat+xml";
    public static final MediaType ATOM_CATEGORIES_DOCUMENT_TYPE = new MediaType("application", "atomcat+xml");
    public static final String ATOM_ENTRY = "application/atom+xml;type=entry";
    public static final MediaType ATOM_ENTRY_TYPE = new MediaType("application", "atom+xml", Collections.singletonMap("type", "entry"));
    public static final String ATOM_FEED = "application/atom+xml;type=feed";
    public static final MediaType ATOM_FEED_TYPE = new MediaType("application", "atom+xml", Collections.singletonMap("type", "feed"));
    public static final MediaType IMAGE_X_ICON = new MediaType("image", "x-icon");
    public static final MediaType IMAGE_PNG = new MediaType("image", "png");
    public static final MediaType IMAGE_VND = new MediaType("image", "vnd.microsoft.icon");
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final MediaType IMAGE_JPEG_TYPE = new MediaType("image", "jpeg");
    public static final String UNKNOWN = "x-internal/unknown";
    public static final MediaType UNKNOWN_TYPE = new MediaType("x-internal", "unknown");
    public static final String OPENSEARCH = "application/opensearchdescription+xml";
    public static final MediaType OPENSEARCH_TYPE = new MediaType("application", "opensearchdescription+xml");
    public static final String JAVASCRIPT = "application/javascript";
    public static final MediaType JAVASCRIPT_TYPE = new MediaType("application", "javascript");
    public static final String ECMASCRIPT = "application/ecmascript";
    public static final MediaType ECMASCRIPT_TYPE = new MediaType("application", "ecmascript");
    public static final String TEXT_ECMASCRIPT = "text/ecmascript";
    public static final MediaType TEXT_ECMASCRIPT_TYPE = new MediaType("text", "ecmascript");
    public static final String TEXT_JAVASCRIPT = "text/javascript";
    public static final MediaType TEXT_JAVASCRIPT_TYPE = new MediaType("text", "javascript");
    public static final MediaType CSV = new MediaType("text", "csv");
    public static final String PDF = "application/pdf";
    public static final MediaType PDF_TYPE = new MediaType("application", "pdf");
    public static final String ZIP = "application/zip";
    public static final MediaType ZIP_TYPE = new MediaType("application", "zip");
    public static final MediaType MS_WORD = new MediaType("application", "msword");
    public static final MediaType MS_EXCEL = new MediaType("application", "vnd.ms-excel");
    public static final MediaType MS_PPT = new MediaType("application", "vnd.ms-powerpoint");
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final MediaType MULTIPART_MIXED_TYPE = new MediaType("multipart", "mixed");
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final MediaType MULTIPART_FORM_DATA_TYPE = new MediaType("multipart", "form-data");
    public static final Set<MediaType> JSON_TYPES = MediaTypeUtils.createJsonTypes();

    private static Set<MediaType> createJsonTypes() {
        LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
        result.add(MediaType.APPLICATION_JSON_TYPE);
        result.add(JAVASCRIPT_TYPE);
        result.add(ECMASCRIPT_TYPE);
        result.add(TEXT_JAVASCRIPT_TYPE);
        result.add(TEXT_ECMASCRIPT_TYPE);
        return Collections.unmodifiableSet(result);
    }

    public static boolean isXmlType(MediaType mediaType) {
        return MediaTypeUtils.equalsIgnoreParameters(mediaType, MediaType.TEXT_XML_TYPE) || MediaTypeUtils.equalsIgnoreParameters(mediaType, MediaType.APPLICATION_XML_TYPE) || mediaType.getType().equals("application") && mediaType.getSubtype().endsWith("+xml");
    }

    public static MediaType clone(MediaType mt) {
        return new MediaType(mt.getType(), mt.getSubtype(), mt.getParameters());
    }

    public static String toEncodedString(MediaType mediaType) {
        return UriEncoder.encodeString(mediaType.toString());
    }

    public static boolean isCompatibleNonCommutative(MediaType m1, MediaType m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        if (m1.getType().equals("*")) {
            return true;
        }
        if (m1.getType().equalsIgnoreCase(m2.getType()) && m1.getSubtype().equals("*")) {
            return true;
        }
        return m1.getType().equalsIgnoreCase(m2.getType()) && m1.getSubtype().equalsIgnoreCase(m2.getSubtype());
    }

    public static boolean equalsIgnoreParameters(MediaType m1, MediaType m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        return m1.getType().equalsIgnoreCase(m2.getType()) && m1.getSubtype().equalsIgnoreCase(m2.getSubtype());
    }

    public static int compareTo(MediaType m1, MediaType m2) {
        if (m1 == m2) {
            return 0;
        }
        return MediaTypeUtils.compareTypeAndSubType(m1, m2);
    }

    private static int compareTypeAndSubType(MediaType m1, MediaType m2) {
        int ret = MediaTypeUtils.compareSubType(m1, m2);
        if (ret != 0) {
            return ret;
        }
        return MediaTypeUtils.compareType(m1, m2);
    }

    private static int compareType(MediaType m1, MediaType m2) {
        return MediaTypeUtils.compareMediaPart(m1.getType(), m2.getType());
    }

    private static int compareSubType(MediaType m1, MediaType m2) {
        return MediaTypeUtils.compareMediaPart(m1.getSubtype(), m2.getSubtype());
    }

    private static int compareMediaPart(String part1, String part2) {
        if (part1.equals("*")) {
            if (part2.equals("*")) {
                return 0;
            }
            return -1;
        }
        if (part2.equals("*")) {
            return 1;
        }
        return 0;
    }

    public static MediaType setDefaultCharsetOnMediaTypeHeader(MultivaluedMap<String, Object> httpHeaders, MediaType mediaType) {
        RuntimeContext context = RuntimeContextTLS.getRuntimeContext();
        MediaTypeCharsetAdjuster adjuster = null;
        if (context != null && (adjuster = context.getAttribute(MediaTypeCharsetAdjuster.class)) != null) {
            return adjuster.setDefaultCharsetOnMediaTypeHeader(httpHeaders, mediaType);
        }
        return mediaType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MediaTypeComparator
    implements Comparator<MediaType> {
        @Override
        public int compare(MediaType m1, MediaType m2) {
            return MediaTypeUtils.compareTo(m1, m2);
        }
    }
}

