/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.lifecycle;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.wink.common.internal.lifecycle.DefaultLifecycleManager;
import org.apache.wink.common.internal.lifecycle.LifecycleManager;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleManagersRegistry {
    private LinkedList<LifecycleManager<?>> store = new LinkedList();
    private LifecycleManager defaultFactoryFactory = new DefaultLifecycleManager();

    public void setFactoryFactoryArray(LifecycleManager<?>[] factories) {
        for (LifecycleManager<?> factory : factories) {
            this.addFactoryFactory(factory);
        }
    }

    public void addFactoryFactory(LifecycleManager<?> factory) {
        this.store.addFirst(factory);
    }

    public <T> ObjectFactory<T> getObjectFactory(T object) {
        for (LifecycleManager lifecycleManager : this.store) {
            ObjectFactory<T> objectFactory = lifecycleManager.createObjectFactory(object);
            if (objectFactory == null) continue;
            return objectFactory;
        }
        return this.defaultFactoryFactory.createObjectFactory(object);
    }

    public <T> ObjectFactory<T> getObjectFactory(Class<T> cls) {
        for (LifecycleManager lifecycleManager : this.store) {
            ObjectFactory<T> objectFactory = lifecycleManager.createObjectFactory(cls);
            if (objectFactory == null) continue;
            return objectFactory;
        }
        return this.defaultFactoryFactory.createObjectFactory(cls);
    }

    public List<LifecycleManager<?>> getLifecycleManagers() {
        return Collections.unmodifiableList(this.store);
    }
}

