/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *  
 *   http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *  
 *******************************************************************************/
//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, vhudson-jaxb-ri-2.1-456 
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a> 
// Any modifications to this file will be lost upon recompilation of the source schema. 
// Generated on: 2009.07.20 at 10:55:05 AM IST 
//
package org.apache.wink.common.model.rss;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

import org.apache.wink.common.model.synd.SyndCategory;

/**
 * <p>
 * Java class for "category" element of <a
 * href="http://www.rssboard.org/rss-specification">RSS 2.0 Specification</a>.
 * <p>
 * The following schema fragment specifies the expected content contained within
 * this class.
 * 
 * <pre>
 * &lt;complexType name=&quot;rssCategory&quot;&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base=&quot;{http://www.w3.org/2001/XMLSchema}anyType&quot;&gt;
 *       &lt;attribute name=&quot;domain&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}string&quot; /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * <h5>&lt;category&gt; sub-element of &lt;item&gt;</h5>
 * <p>
 * &lt;category&gt; is an optional sub-element of &lt;item&gt;.
 * </p>
 * <p>
 * It has one optional attribute, domain, a string that identifies a
 * categorization taxonomy.
 * </p>
 * <p>
 * The value of the element is a forward-slash-separated string that identifies
 * a hierarchic location in the indicated taxonomy. Processors may establish
 * conventions for the interpretation of categories. Two examples are provided
 * below:
 * </p>
 * <p class="example">&lt;category&gt;Grateful Dead&lt;/category&gt;</p> <p
 * class="example">&lt;category
 * domain="http://www.fool.com/cusips"&gt;MSFT&lt;/category&gt;</p>
 * <p>
 * You may include as many category elements as you need to, for different
 * domains, and to have an item cross-referenced in different parts of the same
 * domain.
 * </p>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "rssCategory", propOrder = {"content"})
public class RssCategory {

    @XmlValue
    protected String content;
    @XmlAttribute
    protected String domain;

    /**
     * Creates an RssCategory object
     */
    public RssCategory() {
    }

    /**
     * Creates an RssCategory object out of a SyndCategory object. Used for
     * mapping Syndication Object Model into RSS.
     * 
     * @param syndCategory the SyndCategory object which has to be mapped into
     *            an RssCategory object.
     */
    public RssCategory(SyndCategory syndCategory) {
        if (syndCategory.getLabel() != null) {
            setContent(syndCategory.getLabel());
        }
        if (syndCategory.getScheme() != null) {
            setDomain(syndCategory.getScheme());
        }
    }

    /**
     * Maps an RssCategory object into a SyndCategory object. Used for mapping
     * RSS into Syndication Object Model.
     * 
     * @param syndCategory the SyndCategory object into which the given
     *            RssCategory object has to be mapped into
     * @return the SyndCategory object into which the given RssCategory object
     *         has been mapped into
     */
    public SyndCategory toSynd(SyndCategory syndCategory) {
        if (syndCategory == null) {
            return syndCategory;
        }
        if (getContent() != null) {
            syndCategory.setLabel(getContent());
        }
        if (getDomain() != null) {
            syndCategory.setScheme(getDomain());
        }
        return syndCategory;
    }

    /**
     * Gets the value of the content property.
     * 
     * @return possible object is {@link String }
     */
    public String getContent() {
        return content;
    }

    /**
     * Sets the value of the content property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setContent(String value) {
        this.content = value;
    }

    /**
     * Gets the value of the domain property.
     * 
     * @return possible object is {@link String }
     */
    public String getDomain() {
        return domain;
    }

    /**
     * Sets the value of the domain property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setDomain(String value) {
        this.domain = value;
    }

}
