/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.providers.json;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONUtils {
    public static JSONObject objectForString(String input) throws JSONException {
        assert (input != null);
        JSONTokener tok = new JSONTokener(input);
        return new JSONObject(tok);
    }

    public static boolean equals(JSONObject expected, JSONObject actual) {
        return JSONUtils.isJSONEquals(expected, actual);
    }

    public static boolean equals(JSONArray expected, JSONArray actual) {
        return JSONUtils.isJSONEquals(expected, actual);
    }

    private static boolean isJSONEquals(Object expected, Object actual) {
        if (expected == actual) {
            return true;
        }
        if (expected == null || actual == null) {
            return false;
        }
        if (!expected.getClass().equals(actual.getClass())) {
            return false;
        }
        if (expected instanceof JSONObject) {
            JSONObject jsonExpected = (JSONObject)expected;
            JSONObject jsonActual = (JSONObject)actual;
            if (jsonExpected.length() != jsonActual.length()) {
                return false;
            }
            Iterator keys = jsonExpected.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (JSONUtils.isJSONEquals(jsonExpected.opt(key), jsonActual.opt(key))) continue;
                return false;
            }
            return true;
        }
        if (expected instanceof JSONArray) {
            JSONArray jsonExpected = (JSONArray)expected;
            JSONArray jsonActual = (JSONArray)actual;
            if (jsonExpected.length() != jsonActual.length()) {
                return false;
            }
            for (int i = 0; i < jsonExpected.length(); ++i) {
                if (JSONUtils.isJSONEquals(jsonExpected.opt(i), jsonActual.opt(i))) continue;
                return false;
            }
            return true;
        }
        return expected.equals(actual);
    }
}

