/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.providers.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.common.utils.ProviderUtils;
import org.apache.wink.providers.json.JsonProvider;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/json", "application/javascript"})
@Produces(value={"application/json", "application/javascript"})
public class JsonArrayProvider
implements MessageBodyWriter<JSONArray>,
MessageBodyReader<JSONArray> {
    private static final Logger logger = LoggerFactory.getLogger(JsonProvider.class);
    @Context
    private UriInfo uriInfo;

    public long getSize(JSONArray t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == JSONArray.class;
    }

    public void writeTo(JSONArray t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        mediaType = MediaTypeUtils.setDefaultCharsetOnMediaTypeHeader(httpHeaders, (MediaType)mediaType);
        String jsonString = null;
        try {
            jsonString = t.toString(2);
        }
        catch (JSONException e) {
            logger.error(Messages.getMessage((String)"jsonFailWriteJSONArray"), (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        String callbackParam = null;
        try {
            callbackParam = (String)this.uriInfo.getQueryParameters().getFirst((Object)"callback");
        }
        catch (Exception e) {
            logger.trace("Could not get the URI callback param", (Throwable)e);
        }
        Charset charset = Charset.forName(ProviderUtils.getCharset((MediaType)mediaType));
        OutputStreamWriter writer = new OutputStreamWriter(entityStream, charset);
        if (callbackParam != null) {
            writer.write(callbackParam);
            writer.write("(");
        }
        writer.write(jsonString);
        if (callbackParam != null) {
            writer.write(")");
        }
        writer.flush();
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == JSONArray.class;
    }

    public JSONArray readFrom(Class<JSONArray> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return new JSONArray(new JSONTokener(ProviderUtils.createReader((InputStream)entityStream, (MediaType)mediaType)));
        }
        catch (JSONException e) {
            logger.error(Messages.getMessage((String)"jsonFailReadJSONArray"), (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }
}

