/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.json4j;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONArtifact;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONString;
import org.apache.wink.json4j.internal.BeanSerializer;
import org.apache.wink.json4j.internal.Null;
import org.apache.wink.json4j.internal.Parser;
import org.apache.wink.json4j.internal.Serializer;
import org.apache.wink.json4j.internal.SerializerVerbose;

public class JSONObject
extends HashMap
implements JSONArtifact {
    private static final long serialVersionUID = -3269263069889337298L;
    public static final Object NULL = new Null();

    public static boolean isValidObject(Object object) {
        if (null == object) {
            return true;
        }
        return JSONObject.isValidType(object.getClass());
    }

    public static boolean isValidType(Class clazz) {
        if (null == clazz) {
            throw new IllegalArgumentException();
        }
        if (String.class == clazz) {
            return true;
        }
        if (Boolean.class == clazz) {
            return true;
        }
        if (JSONObject.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (JSONArray.class == clazz) {
            return true;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        return JSONString.class.isAssignableFrom(clazz);
    }

    public JSONObject() {
    }

    public JSONObject(JSONObject obj, String[] keys) throws JSONException {
        if (keys != null && keys.length > 0) {
            for (int i = 0; i < keys.length; ++i) {
                if (this.containsKey(keys[i])) {
                    throw new JSONException("Duplicate key: " + keys[i]);
                }
                try {
                    this.put(keys[i], obj.get(keys[i]));
                    continue;
                }
                catch (Exception ex) {
                    JSONException jex = new JSONException("Error occurred during JSONObject creation");
                    jex.initCause(ex);
                    throw jex;
                }
            }
        }
    }

    public JSONObject(String str) throws JSONException {
        StringReader reader = new StringReader(str);
        new Parser(reader).parse(this);
    }

    public JSONObject(String str, boolean strict) throws JSONException {
        StringReader reader = new StringReader(str);
        new Parser(reader, strict).parse(this);
    }

    public JSONObject(Reader rdr) throws JSONException {
        new Parser(rdr).parse(this);
    }

    public JSONObject(Reader rdr, boolean strict) throws JSONException {
        new Parser(rdr, strict).parse(this);
    }

    public JSONObject(InputStream is) throws JSONException {
        InputStreamReader isr = null;
        if (is != null) {
            try {
                isr = new InputStreamReader(is, "UTF-8");
            }
            catch (Exception ex) {
                isr = new InputStreamReader(is);
            }
        } else {
            throw new JSONException("InputStream cannot be null");
        }
        new Parser(isr).parse(true, this);
    }

    public JSONObject(InputStream is, boolean strict) throws JSONException {
        InputStreamReader isr = null;
        if (is != null) {
            try {
                isr = new InputStreamReader(is, "UTF-8");
            }
            catch (Exception ex) {
                isr = new InputStreamReader(is);
            }
        } else {
            throw new JSONException("InputStream cannot be null");
        }
        new Parser(isr, strict).parse(true, this);
    }

    public JSONObject(Map map) {
        Iterator itr;
        Set set = map.keySet();
        if (set != null && (itr = set.iterator()) != null) {
            while (itr.hasNext()) {
                Object key = itr.next();
                String sKey = key.toString();
                try {
                    this.put(sKey, map.get(key));
                }
                catch (Exception ex) {}
            }
        }
    }

    public JSONObject(Object javaBean) throws JSONException {
        if (javaBean != null) {
            JSONObject map = (JSONObject)BeanSerializer.toJson(javaBean, true);
            this.putAll(map);
        }
    }

    public JSONObject(Object javaBean, boolean includeSuperclass) throws JSONException {
        if (javaBean != null) {
            JSONObject map = (JSONObject)BeanSerializer.toJson(javaBean, includeSuperclass);
            this.putAll(map);
        }
    }

    public JSONObject(Map map, boolean includeSuperclass) throws JSONException {
        Iterator itr;
        Set set = map.keySet();
        if (set != null && (itr = set.iterator()) != null) {
            while (itr.hasNext()) {
                Object key = itr.next();
                String sKey = key.toString();
                this.put((Object)sKey, map.get(key), includeSuperclass);
            }
        }
    }

    public OutputStream write(OutputStream os) throws JSONException {
        this.write(os, false);
        return os;
    }

    public OutputStream write(OutputStream os, boolean verbose) throws JSONException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        }
        catch (UnsupportedEncodingException uex) {
            JSONException jex = new JSONException(uex.toString());
            jex.initCause(uex);
            throw jex;
        }
        this.write((Writer)writer, verbose);
        try {
            ((Writer)writer).flush();
        }
        catch (Exception ex) {
            JSONException jex = new JSONException("Error during buffer flush");
            jex.initCause(ex);
            throw jex;
        }
        return os;
    }

    public OutputStream write(OutputStream os, int indentDepth) throws JSONException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        }
        catch (UnsupportedEncodingException uex) {
            JSONException jex = new JSONException(uex.toString());
            jex.initCause(uex);
            throw jex;
        }
        this.write((Writer)writer, indentDepth);
        try {
            ((Writer)writer).flush();
        }
        catch (Exception ex) {
            JSONException jex = new JSONException("Error during buffer flush");
            jex.initCause(ex);
            throw jex;
        }
        return os;
    }

    public Writer write(Writer writer) throws JSONException {
        this.write(writer, false);
        return writer;
    }

    public Writer write(Writer writer, boolean verbose) throws JSONException {
        Class<?> writerClass = writer.getClass();
        boolean flushIt = false;
        if (!(StringWriter.class.isAssignableFrom(writerClass) || CharArrayWriter.class.isAssignableFrom(writerClass) || BufferedWriter.class.isAssignableFrom(writerClass))) {
            writer = new BufferedWriter(writer);
            flushIt = true;
        }
        Serializer serializer = verbose ? new SerializerVerbose(writer) : new Serializer(writer);
        try {
            serializer.writeObject(this);
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during input read.");
            jex.initCause(iox);
            throw jex;
        }
        if (flushIt) {
            try {
                writer.flush();
            }
            catch (Exception ex) {
                JSONException jex = new JSONException("Error during buffer flush");
                jex.initCause(ex);
                throw jex;
            }
        }
        return writer;
    }

    public Writer write(Writer writer, int indentDepth) throws JSONException {
        if (indentDepth < 1) {
            indentDepth = 0;
        } else if (indentDepth > 8) {
            indentDepth = 9;
        }
        Class<?> writerClass = writer.getClass();
        boolean flushIt = false;
        if (!(StringWriter.class.isAssignableFrom(writerClass) || CharArrayWriter.class.isAssignableFrom(writerClass) || BufferedWriter.class.isAssignableFrom(writerClass))) {
            writer = new BufferedWriter(writer);
            flushIt = true;
        }
        Serializer serializer = indentDepth > 0 ? new SerializerVerbose(writer, indentDepth) : new Serializer(writer);
        try {
            serializer.writeObject(this);
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during input read.");
            jex.initCause(iox);
            throw jex;
        }
        if (flushIt) {
            try {
                writer.flush();
            }
            catch (Exception ex) {
                JSONException jex = new JSONException("Error during buffer flush");
                jex.initCause(ex);
                throw jex;
            }
        }
        return writer;
    }

    public String write(int indentDepth) throws JSONException {
        StringWriter writer = new StringWriter();
        if (indentDepth < 1) {
            indentDepth = 0;
        } else if (indentDepth > 8) {
            indentDepth = 9;
        }
        Serializer serializer = indentDepth > 0 ? new SerializerVerbose(writer, indentDepth) : new Serializer(writer);
        try {
            serializer.writeObject(this).flush();
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during write.");
            jex.initCause(iox);
            throw jex;
        }
        return writer.toString();
    }

    public String write(boolean verbose) throws JSONException {
        StringWriter writer = new StringWriter();
        Serializer serializer = verbose ? new SerializerVerbose(writer) : new Serializer(writer);
        try {
            serializer.writeObject(this).flush();
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during write.");
            jex.initCause(iox);
            throw jex;
        }
        return writer.toString();
    }

    public String write() throws JSONException {
        return this.write(false);
    }

    public Object get(String key) throws JSONException {
        Object val = this.get((Object)key);
        if (val == null && !this.containsKey(key)) {
            throw new JSONException("The key [" + key + "] was not in the map");
        }
        return val;
    }

    public Object opt(String key) {
        return this.get((Object)key);
    }

    public Object put(Object key, Object value, boolean includeSuperclass) throws JSONException {
        if (null == key) {
            throw new JSONException("key must not be null");
        }
        if (!(key instanceof String)) {
            throw new JSONException("key must be a String");
        }
        if (!JSONObject.isValidObject(value) && value != null) {
            try {
                value = BeanSerializer.toJson(value, includeSuperclass);
            }
            catch (Exception ex) {
                throw new JSONException("Invalid type of value.  Could not convert type: [" + value.getClass().getName() + "]");
            }
        }
        return super.put(key, value);
    }

    public Object put(Object key, Object value) {
        try {
            return this.put(key, value, true);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Error occurred during JSON conversion");
            iae.initCause(e);
            throw iae;
        }
    }

    public JSONObject put(String key, Object value) throws JSONException {
        this.put((Object)key, value);
        return this;
    }

    public JSONObject put(String key, boolean value) throws JSONException {
        this.put(key, (Object)new Boolean(value));
        return this;
    }

    public JSONObject put(String key, double value) throws JSONException {
        this.put(key, (Object)new Double(value));
        return this;
    }

    public JSONObject put(String key, int value) throws JSONException {
        this.put(key, (Object)new Integer(value));
        return this;
    }

    public JSONObject put(String key, short value) throws JSONException {
        this.put(key, (Object)new Short(value));
        return this;
    }

    public JSONObject put(String key, long value) throws JSONException {
        this.put(key, (Object)new Long(value));
        return this;
    }

    public JSONObject put(String key, Map value, boolean includeSuperclass) throws JSONException {
        if (value == null) {
            this.put(key, (Object)null);
        } else if (JSONObject.class.isAssignableFrom(value.getClass())) {
            this.put(key, (Object)value);
        } else {
            this.put(key, new JSONObject(value, includeSuperclass));
        }
        return this;
    }

    public JSONObject put(String key, Map value) throws JSONException {
        return this.put(key, value, true);
    }

    public JSONObject put(String key, Collection value, boolean includeSuperclass) throws JSONException {
        if (value == null) {
            this.put(key, (Object)null);
        } else if (JSONArray.class.isAssignableFrom(value.getClass())) {
            this.put(key, (Object)value);
        } else {
            this.put(key, new JSONArray(value, includeSuperclass));
        }
        return this;
    }

    public JSONObject put(String key, Collection value) throws JSONException {
        return this.put(key, value, true);
    }

    public JSONObject put(String key, Object[] value) throws JSONException {
        return this.put(key, new JSONArray(value), true);
    }

    public JSONObject put(String key, Object[] value, boolean includeSuperclass) throws JSONException {
        return this.put(key, new JSONArray(value), includeSuperclass);
    }

    public boolean getBoolean(String key) throws JSONException {
        Object val = this.opt(key);
        if (val != null) {
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            if (Number.class.isAssignableFrom(val.getClass())) {
                throw new JSONException("Value at key: [" + key + "] was not a boolean or string value of 'true' or 'false'.");
            }
            if (String.class.isAssignableFrom(val.getClass())) {
                String str = (String)val;
                if (str.equals("true")) {
                    return true;
                }
                if (str.equals("false")) {
                    return false;
                }
                throw new JSONException("The value for key: [" + key + "]: [" + str + "] was not 'true' or 'false'");
            }
            throw new JSONException("The value for key: [" + key + "] was not a type that can be converted to boolean");
        }
        throw new JSONException("The value for key: [" + key + "] was null");
    }

    public boolean optBoolean(String key) {
        Object val = this.opt(key);
        if (val != null) {
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            if (Number.class.isAssignableFrom(val.getClass())) {
                return false;
            }
            if (String.class.isAssignableFrom(val.getClass())) {
                String str = (String)val;
                return str.equals("true");
            }
            return false;
        }
        return false;
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        Object val = this.opt(key);
        if (val != null) {
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            if (Number.class.isAssignableFrom(val.getClass())) {
                return false;
            }
            if (String.class.isAssignableFrom(val.getClass())) {
                String str = (String)val;
                if (str.equals("true")) {
                    return true;
                }
                if (str.equals("false")) {
                    return false;
                }
                return defaultValue;
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public double getDouble(String key) throws JSONException {
        Object val = this.opt(key);
        if (val != null) {
            if (Number.class.isAssignableFrom(val.getClass())) {
                return ((Number)val).doubleValue();
            }
            throw new JSONException("The value for key: [" + key + "] was not a type that can be converted to double");
        }
        throw new JSONException("The value for key: [" + key + "] was null.  Number required.");
    }

    public double optDouble(String key) {
        Object val = this.opt(key);
        if (val != null && Number.class.isAssignableFrom(val.getClass())) {
            return ((Number)val).doubleValue();
        }
        return Double.NaN;
    }

    public double optDouble(String key, double defaultValue) {
        Object val = this.opt(key);
        if (val != null && Number.class.isAssignableFrom(val.getClass())) {
            return ((Number)val).doubleValue();
        }
        return defaultValue;
    }

    public short getShort(String key) throws JSONException {
        Object val = this.opt(key);
        if (val != null) {
            if (Number.class.isAssignableFrom(val.getClass())) {
                return ((Number)val).shortValue();
            }
            throw new JSONException("The value for key: [" + key + "] was not a type that can be converted to short");
        }
        throw new JSONException("The value for key: [" + key + "] was null.  Number required.");
    }

    public short optShort(String key) {
        Object val = this.opt(key);
        if (val != null && Number.class.isAssignableFrom(val.getClass())) {
            return ((Number)val).shortValue();
        }
        return 0;
    }

    public short optShort(String key, short defaultValue) {
        Object val = this.opt(key);
        if (val != null && Number.class.isAssignableFrom(val.getClass())) {
            return ((Number)val).shortValue();
        }
        return defaultValue;
    }

    public int getInt(String key) throws JSONException {
        Object val = this.opt(key);
        if (val != null) {
            if (Number.class.isAssignableFrom(val.getClass())) {
                return ((Number)val).intValue();
            }
            throw new JSONException("The value for key: [" + key + "] was not a type that can be converted to integer");
        }
        throw new JSONException("The value for key: [" + key + "] was null.  Number required.");
    }

    public int optInt(String key) {
        Object val = this.opt(key);
        if (val != null && Number.class.isAssignableFrom(val.getClass())) {
            return ((Number)val).intValue();
        }
        return 0;
    }

    public int optInt(String key, int defaultValue) {
        Object val = this.opt(key);
        if (val != null && Number.class.isAssignableFrom(val.getClass())) {
            return ((Number)val).intValue();
        }
        return defaultValue;
    }

    public long getLong(String key) throws JSONException {
        Object val = this.opt(key);
        if (val != null) {
            if (Number.class.isAssignableFrom(val.getClass())) {
                return ((Number)val).longValue();
            }
            throw new JSONException("The value for key: [" + key + "] was not a type that can be converted to long");
        }
        throw new JSONException("The value for key: [" + key + "] was null.  Number required.");
    }

    public long optLong(String key) throws JSONException {
        Object val = this.opt(key);
        if (val != null && Number.class.isAssignableFrom(val.getClass())) {
            return ((Number)val).longValue();
        }
        return 0L;
    }

    public long optLong(String key, long defaultValue) throws JSONException {
        Object val = this.opt(key);
        if (val != null && Number.class.isAssignableFrom(val.getClass())) {
            return ((Number)val).intValue();
        }
        return defaultValue;
    }

    public String getString(String key) throws JSONException {
        Object val = this.opt(key);
        if (val != null) {
            return val.toString();
        }
        throw new JSONException("The value for key: [" + key + "] was null.  Object required.");
    }

    public String optString(String key) {
        Object val = this.opt(key);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public String optString(String key, String defaultValue) {
        Object val = this.opt(key);
        if (val != null) {
            return val.toString();
        }
        return defaultValue;
    }

    public JSONObject getJSONObject(String key) throws JSONException {
        Object val = this.opt(key);
        if (val != null) {
            if (JSONObject.class.isAssignableFrom(val.getClass())) {
                return (JSONObject)val;
            }
            throw new JSONException("The value for key: [" + key + "] was not a JSONObject");
        }
        throw new JSONException("The value for key: [" + key + "] was null.  Object required.");
    }

    public JSONObject optJSONObject(String key) {
        Object val = this.opt(key);
        if (val != null && JSONObject.class.isAssignableFrom(val.getClass())) {
            return (JSONObject)val;
        }
        return null;
    }

    public JSONObject optJSONObject(String key, JSONObject defaultValue) {
        Object val = this.opt(key);
        if (val != null && JSONObject.class.isAssignableFrom(val.getClass())) {
            return (JSONObject)val;
        }
        return defaultValue;
    }

    public JSONArray getJSONArray(String key) throws JSONException {
        Object val = this.opt(key);
        if (val != null) {
            if (JSONArray.class.isAssignableFrom(val.getClass())) {
                return (JSONArray)val;
            }
            throw new JSONException("The value for key: [" + key + "] was not a JSONObject");
        }
        throw new JSONException("The value for key: [" + key + "] was null.  Object required.");
    }

    public JSONArray optJSONArray(String key) throws JSONException {
        Object val = this.opt(key);
        if (val != null && JSONArray.class.isAssignableFrom(val.getClass())) {
            return (JSONArray)val;
        }
        return null;
    }

    public JSONArray optJSONArray(String key, JSONArray defaultValue) throws JSONException {
        Object val = this.opt(key);
        if (val != null && JSONArray.class.isAssignableFrom(val.getClass())) {
            return (JSONArray)val;
        }
        return defaultValue;
    }

    public JSONObject putOnce(String key, Object value) throws JSONException {
        if (key == null) {
            throw new JSONException("Key cannot be null");
        }
        if (value == null) {
            throw new JSONException("Value cannot be null");
        }
        if (this.containsKey(key)) {
            throw new JSONException("Key [" + key + "] already exists in the map");
        }
        this.put(key, value);
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key == null) {
            throw new JSONException("Key cannot be null");
        }
        if (value == null) {
            throw new JSONException("Value cannot be null");
        }
        this.put(key, value);
        return this;
    }

    public int length() {
        return this.size();
    }

    public JSONObject append(String key, Object value) throws JSONException {
        JSONArray array = null;
        if (!this.has(key)) {
            array = new JSONArray();
        } else {
            Object oldVal = this.get(key);
            array = new JSONArray();
            if (oldVal == null) {
                array.add((Object)null);
            } else if (JSONArray.class.isAssignableFrom(oldVal.getClass())) {
                array = (JSONArray)oldVal;
            } else {
                array = new JSONArray();
                array.add(oldVal);
            }
        }
        array.add(value);
        return this.put(key, array);
    }

    public JSONArray toJSONArray(JSONArray names) throws JSONException {
        Iterator itr = names.iterator();
        JSONArray array = new JSONArray();
        if (itr != null && itr.hasNext()) {
            array.put(this.get(itr.next()));
        }
        return array;
    }

    public boolean has(String key) {
        if (key != null) {
            return this.containsKey(key);
        }
        return false;
    }

    public boolean isNull(String key) {
        return this.opt(key) == null || NULL == this.opt(key);
    }

    public Iterator keys() {
        Set set = this.keySet();
        if (set != null) {
            return set.iterator();
        }
        return null;
    }

    public JSONArray names() {
        Iterator itr = this.keys();
        if (itr != null) {
            JSONArray array = new JSONArray();
            while (itr.hasNext()) {
                array.add(itr.next());
            }
            return array;
        }
        return null;
    }

    public static String[] getNames(JSONObject obj) {
        String[] array = null;
        if (obj != null && obj.size() > 0) {
            array = new String[obj.size()];
            int pos = 0;
            Iterator itr = obj.keys();
            if (itr != null) {
                while (itr.hasNext()) {
                    array[pos] = (String)itr.next();
                    ++pos;
                }
            }
        }
        return array;
    }

    public Iterator sortedKeys() {
        Iterator itr = this.keys();
        if (itr != null && itr.hasNext()) {
            Vector<Object> vect = new Vector<Object>();
            while (itr.hasNext()) {
                vect.add(itr.next());
            }
            Object[] strs = new String[vect.size()];
            vect.copyInto(strs);
            Arrays.sort(strs);
            vect.clear();
            for (int i = 0; i < strs.length; ++i) {
                vect.add(strs[i]);
            }
            return vect.iterator();
        }
        return null;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        String str = null;
        try {
            str = this.write(verbose);
        }
        catch (JSONException jex) {
            str = "JSON Generation Error: [" + jex.toString() + "]";
        }
        return str;
    }

    public String toString(int indentDepth) throws JSONException {
        return this.write(indentDepth);
    }
}

