/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.json4j.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONArtifact;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class BeanSerializer {
    public static JSONArtifact toJson(Object obj, boolean includeSuperclass) throws IllegalArgumentException, JSONException {
        JSONArtifact ja = null;
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            if (String.class == clazz) {
                throw new IllegalArgumentException("Class was String type, not a Javabean.");
            }
            if (Boolean.class == clazz) {
                throw new IllegalArgumentException("Class was Boolean type, not a Javabean.");
            }
            if (Number.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class was Number type, not a Javabean.");
            }
            ja = JSONObject.class.isAssignableFrom(clazz) ? (JSONObject)obj : (JSONArray.class.isAssignableFrom(clazz) ? (JSONArray)obj : (Map.class.isAssignableFrom(clazz) ? new JSONObject((Map)obj) : (Collection.class.isAssignableFrom(clazz) ? new JSONArray((Collection)obj) : (clazz.isArray() ? new JSONArray((Object[])obj) : BeanSerializer.introspectBean(obj, includeSuperclass, new ArrayList())))));
        }
        return ja;
    }

    private static JSONArtifact introspectBean(Object obj, boolean includeSuperclass, ArrayList parsedObjects) throws JSONException {
        JSONObject ja = null;
        boolean found = false;
        for (int i = 0; i < parsedObjects.size(); ++i) {
            Object possibleObj = parsedObjects.get(i);
            if (possibleObj == null || obj != possibleObj) continue;
            found = true;
            break;
        }
        if (!found) {
            parsedObjects.add(obj);
            ja = new JSONObject();
            Class<?> clazz = obj.getClass();
            ja.put("_type", (Object)"JavaClass");
            ja.put("_classname", (Object)clazz.getName());
            Method[] methods = null;
            methods = includeSuperclass ? clazz.getMethods() : clazz.getDeclaredMethods();
            if (methods != null && methods.length > 0) {
                for (int i = 0; i < methods.length; ++i) {
                    Method m = methods[i];
                    String mName = m.getName();
                    Class<?>[] types = m.getParameterTypes();
                    if (!mName.startsWith("get") || mName.length() <= 3 || types != null && types.length != 0) continue;
                    String attr = mName.substring(3, mName.length());
                    attr = Character.toLowerCase(attr.charAt(0)) + attr.substring(1, attr.length());
                    try {
                        Object val = m.invoke(obj, null);
                        if (val == null) {
                            ja.put(attr, (Object)null);
                            continue;
                        }
                        Class<?> vClazz = val.getClass();
                        if (String.class == vClazz) {
                            ja.put(attr, val);
                            continue;
                        }
                        if (Boolean.class == vClazz) {
                            ja.put(attr, val);
                            continue;
                        }
                        if (Class.class == vClazz) {
                            ja.put(attr, (Object)((Class)val).getName());
                            continue;
                        }
                        if (Number.class.isAssignableFrom(vClazz)) {
                            ja.put(attr, val);
                            continue;
                        }
                        if (JSONObject.class.isAssignableFrom(vClazz)) {
                            ja.put(attr, val);
                            continue;
                        }
                        if (JSONArray.class.isAssignableFrom(vClazz)) {
                            ja.put(attr, val);
                            continue;
                        }
                        if (Map.class.isAssignableFrom(vClazz)) {
                            ja.put(attr, new JSONObject((Map)val));
                            continue;
                        }
                        if (Collection.class.isAssignableFrom(vClazz)) {
                            ja.put(attr, new JSONArray((Collection)obj));
                            continue;
                        }
                        if (val == obj) continue;
                        ja.put(attr, (Object)BeanSerializer.introspectBean(val, includeSuperclass, parsedObjects));
                        continue;
                    }
                    catch (Exception ex) {
                        ja.put(attr, (Object)null);
                    }
                }
            }
        }
        return ja;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object fromJson(JSONObject jo) throws NullPointerException, JSONException {
        Object obj = null;
        if (jo == null) {
            throw new NullPointerException("Input JSONObject cannot be null");
        }
        if (jo.get("_classname") == null || !"JavaClass".equals(jo.get("_type"))) throw new JSONException("Provided JSONObject does not contain attributes '_classname' or '_type'");
        try {
            String cName = (String)jo.get("_classname");
            Class<?> clazz = Class.forName(cName);
            if (clazz == null) throw new JSONException("Could not locate class: [" + cName + "]");
            Method[] methods = clazz.getMethods();
            obj = clazz.newInstance();
            Iterator keys = jo.keys();
            if (keys == null) return obj;
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (key == null || key.equals("_classname") || key.equals("_type")) continue;
                Method m = null;
                String setter = "set" + Character.toUpperCase(key.charAt(0)) + key.substring(1, key.length());
                Object val = jo.get(key);
                if (val != null) {
                    Class<?> c;
                    Method tM;
                    Class<?> vClazz = val.getClass();
                    if (String.class == vClazz) {
                        for (int i = 0; i < methods.length; ++i) {
                            Class<?>[] mParms;
                            tM = methods[i];
                            if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != vClazz) continue;
                            m = tM;
                            break;
                        }
                    } else if (Boolean.class == vClazz) {
                        for (int i = 0; i < methods.length; ++i) {
                            Class<?>[] mParms;
                            tM = methods[i];
                            if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != vClazz && Boolean.TYPE != c) continue;
                            m = tM;
                            break;
                        }
                    } else if (Number.class.isAssignableFrom(vClazz)) {
                        if (Double.class.isAssignableFrom(vClazz)) {
                            int i;
                            for (i = 0; i < methods.length; ++i) {
                                Class<?>[] mParms;
                                tM = methods[i];
                                if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != Double.class && Double.TYPE != c) continue;
                                m = tM;
                                break;
                            }
                            if (m == null) {
                                for (i = 0; i < methods.length; ++i) {
                                    Class<?>[] mParms;
                                    tM = methods[i];
                                    if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != Float.class && Float.TYPE != c) continue;
                                    m = tM;
                                    val = new Float(((Number)val).floatValue());
                                    break;
                                }
                            }
                        } else if (Float.class.isAssignableFrom(vClazz)) {
                            int i;
                            for (i = 0; i < methods.length; ++i) {
                                Class<?>[] mParms;
                                tM = methods[i];
                                if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != Float.class && Float.TYPE != c) continue;
                                m = tM;
                                break;
                            }
                            if (m == null) {
                                for (i = 0; i < methods.length; ++i) {
                                    Class<?>[] mParms;
                                    tM = methods[i];
                                    if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != Double.class && Double.TYPE != c) continue;
                                    m = tM;
                                    val = new Double(((Number)val).doubleValue());
                                    break;
                                }
                            }
                        } else if (Long.class.isAssignableFrom(vClazz)) {
                            int i;
                            for (i = 0; i < methods.length; ++i) {
                                Class<?>[] mParms;
                                tM = methods[i];
                                if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != Long.class && Long.TYPE != c) continue;
                                m = tM;
                                break;
                            }
                            if (m == null) {
                                for (i = 0; i < methods.length; ++i) {
                                    Class<?>[] mParms;
                                    tM = methods[i];
                                    if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != Integer.class && Integer.TYPE != c) continue;
                                    m = tM;
                                    val = new Integer(((Number)val).intValue());
                                    break;
                                }
                            }
                            if (m == null) {
                                for (i = 0; i < methods.length; ++i) {
                                    Class<?>[] mParms;
                                    tM = methods[i];
                                    if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != Short.class && Short.TYPE != c) continue;
                                    m = tM;
                                    val = new Short(((Number)val).shortValue());
                                    break;
                                }
                            }
                        } else if (Integer.class.isAssignableFrom(vClazz)) {
                            int i;
                            for (i = 0; i < methods.length; ++i) {
                                Class<?>[] mParms;
                                tM = methods[i];
                                if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != Integer.class && Integer.TYPE != c) continue;
                                m = tM;
                                break;
                            }
                            if (m == null) {
                                for (i = 0; i < methods.length; ++i) {
                                    Class<?>[] mParms;
                                    tM = methods[i];
                                    if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != Long.class && Long.TYPE != c) continue;
                                    m = tM;
                                    val = new Long(((Number)val).longValue());
                                    break;
                                }
                            }
                            if (m == null) {
                                for (i = 0; i < methods.length; ++i) {
                                    Class<?>[] mParms;
                                    tM = methods[i];
                                    if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != Short.class && Short.TYPE != c) continue;
                                    m = tM;
                                    val = new Short(((Number)val).shortValue());
                                    break;
                                }
                            }
                        } else if (Short.class.isAssignableFrom(vClazz)) {
                            int i;
                            for (i = 0; i < methods.length; ++i) {
                                Class<?>[] mParms;
                                tM = methods[i];
                                if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != Short.class && Short.TYPE != c) continue;
                                m = tM;
                                break;
                            }
                            if (m == null) {
                                for (i = 0; i < methods.length; ++i) {
                                    Class<?>[] mParms;
                                    tM = methods[i];
                                    if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != Integer.class && Integer.TYPE != c) continue;
                                    m = tM;
                                    val = new Integer(((Number)val).intValue());
                                    break;
                                }
                            }
                            if (m == null) {
                                for (i = 0; i < methods.length; ++i) {
                                    Class<?>[] mParms;
                                    tM = methods[i];
                                    if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || (c = mParms[0]) != Long.class && Long.TYPE != c) continue;
                                    m = tM;
                                    val = new Long(((Number)val).longValue());
                                    break;
                                }
                            }
                        }
                    } else if (JSONArray.class.isAssignableFrom(vClazz)) {
                        for (int i = 0; i < methods.length; ++i) {
                            Class<?>[] mParms;
                            tM = methods[i];
                            if (!tM.getName().equals(setter) || (mParms = tM.getParameterTypes()) == null || mParms.length != 1 || !List.class.isAssignableFrom(c = mParms[0])) continue;
                            m = tM;
                            if (c == JSONArray.class) break;
                            List list = (List)c.newInstance();
                            JSONArray array = (JSONArray)val;
                            for (int j = 0; j < array.length(); ++j) {
                                Object aVal = array.get(j);
                                if (aVal != null) {
                                    Class<?> aVClazz = aVal.getClass();
                                    if (Number.class.isAssignableFrom(aVClazz) || Boolean.class.isAssignableFrom(aVClazz) || String.class.isAssignableFrom(aVClazz)) {
                                        list.add(aVal);
                                        continue;
                                    }
                                    if (JSONObject.class.isAssignableFrom(aVClazz)) {
                                        list.add(BeanSerializer.fromJson((JSONObject)aVal));
                                        continue;
                                    }
                                    if (!JSONObject.class.isAssignableFrom(aVClazz)) continue;
                                }
                                list.add(null);
                            }
                            val = list;
                            break;
                        }
                    } else {
                        if (!JSONObject.class.isAssignableFrom(vClazz)) throw new JSONException("Unknown type: [" + vClazz.getName() + "]");
                        JSONObject jObj = (JSONObject)val;
                        Class<?> vC = val.getClass();
                        if (jObj.get("_classname") != null && "JavaClass".equals(jObj.get("_type"))) {
                            val = BeanSerializer.fromJson(jObj);
                            vC = val.getClass();
                        }
                        for (int i = 0; i < methods.length; ++i) {
                            Class<?> c2;
                            Class<?>[] mParms;
                            Method tM2 = methods[i];
                            if (!tM2.getName().equals(setter) || (mParms = tM2.getParameterTypes()) == null || mParms.length != 1 || !(c2 = mParms[0]).isAssignableFrom(vC)) continue;
                            m = tM2;
                            break;
                        }
                    }
                } else {
                    try {
                        m = clazz.getMethod(setter, null);
                    }
                    catch (NoSuchMethodException nmex) {
                        // empty catch block
                    }
                }
                if (m == null) continue;
                m.invoke(obj, val);
            }
            return obj;
        }
        catch (Exception ex) {
            if (ex instanceof JSONException) {
                throw (JSONException)ex;
            }
            JSONException jex = new JSONException("Error in converting JSON to Java Class");
            jex.initCause(ex);
            throw jex;
        }
    }
}

