/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal;

import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.server.internal.DeploymentConfiguration;
import org.apache.wink.server.internal.application.ServletApplicationFileLoader;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.apache.wink.server.internal.handlers.ServerMessageContext;
import org.apache.wink.server.internal.registry.ResourceInstance;
import org.apache.wink.server.internal.resources.HtmlServiceDocumentResource;
import org.apache.wink.server.internal.resources.RootResource;
import org.apache.wink.server.utils.RegistrationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(RequestProcessor.class);
    private static final String PROPERTY_ROOT_RESOURCE_NONE = "none";
    private static final String PROPERTY_ROOT_RESOURCE_ATOM = "atom";
    private static final String PROPERTY_ROOT_RESOURCE_ATOM_HTML = "atom+html";
    private static final String PROPERTY_ROOT_RESOURCE_DEFAULT = "atom+html";
    private static final String PROPERTY_ROOT_RESOURCE = "wink.rootResource";
    private static final String PROPERTY_ROOT_RESOURCE_CSS = "wink.serviceDocumentCssPath";
    private static final String PROPERTY_LOAD_WINK_APPLICATIONS = "wink.loadApplications";
    private final DeploymentConfiguration configuration;

    public RequestProcessor(DeploymentConfiguration configuration) {
        this.configuration = configuration;
        this.registerDefaultApplication();
        this.registerRootResources();
    }

    private void registerDefaultApplication() {
        try {
            String loadWinkApplicationsProperty = this.configuration.getProperties().getProperty(PROPERTY_LOAD_WINK_APPLICATIONS, Boolean.toString(true));
            logger.debug("{} property is set to: {}", (Object)PROPERTY_LOAD_WINK_APPLICATIONS, (Object)loadWinkApplicationsProperty);
            Set classes = new ServletApplicationFileLoader(Boolean.parseBoolean(loadWinkApplicationsProperty)).getClasses();
            RegistrationUtils.InnerApplication application = new RegistrationUtils.InnerApplication(classes);
            application.setPriority(0.1);
            this.configuration.addApplication((Application)application, true);
        }
        catch (FileNotFoundException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private void registerRootResources() {
        Properties properties = this.configuration.getProperties();
        String registerRootResource = properties.getProperty(PROPERTY_ROOT_RESOURCE, "atom+html");
        logger.debug("{} property is set to: {}", (Object)PROPERTY_ROOT_RESOURCE, (Object)registerRootResource);
        if (registerRootResource.equals(PROPERTY_ROOT_RESOURCE_ATOM)) {
            RegistrationUtils.InnerApplication application = new RegistrationUtils.InnerApplication(RootResource.class);
            application.setPriority(0.1);
            this.configuration.addApplication((Application)application, true);
        } else if (!registerRootResource.equals(PROPERTY_ROOT_RESOURCE_NONE)) {
            String css = properties.getProperty(PROPERTY_ROOT_RESOURCE_CSS);
            logger.debug("{} property is set to: {}", (Object)PROPERTY_ROOT_RESOURCE_CSS, (Object)css);
            HtmlServiceDocumentResource instance = new HtmlServiceDocumentResource();
            if (css != null) {
                instance.setServiceDocumentCssPath(css);
            }
            RegistrationUtils.InnerApplication application = new RegistrationUtils.InnerApplication(instance);
            application.setPriority(0.1);
            this.configuration.addApplication((Application)application, true);
        }
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            this.handleRequestWithoutFaultBarrier(request, response);
        }
        catch (Throwable t) {
            if (logger.isDebugEnabled()) {
                logger.debug(Messages.getMessage((String)"unhandledExceptionToContainer"), t);
            } else if (logger.isInfoEnabled()) {
                logger.info(Messages.getMessage((String)"unhandledExceptionToContainer"));
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ServletException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestWithoutFaultBarrier(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        boolean isReleaseResourcesCalled = false;
        try {
            ServerMessageContext msgContext = this.createMessageContext(request, response);
            RuntimeContextTLS.setRuntimeContext((RuntimeContext)msgContext);
            logger.debug("Set message context and starting request handlers chain: {}", (Object)msgContext);
            this.configuration.getRequestHandlersChain().run(msgContext);
            logger.debug("Finished request handlers chain and starting response handlers chain: {}", (Object)msgContext);
            this.configuration.getResponseHandlersChain().run(msgContext);
            logger.debug("Attempting to release resource instance");
            isReleaseResourcesCalled = true;
            try {
                this.releaseResources(msgContext);
            }
            catch (Exception e) {
                logger.debug("Caught exception when releasing resource object", (Throwable)e);
                throw e;
            }
        }
        catch (Throwable t) {
            RuntimeContext originalContext = RuntimeContextTLS.getRuntimeContext();
            ServerMessageContext msgContext = null;
            try {
                this.logException(t);
                msgContext = this.createMessageContext(request, response);
                RuntimeContextTLS.setRuntimeContext((RuntimeContext)msgContext);
                msgContext.setResponseEntity(t);
                logger.debug("Exception occured, starting error handlers chain: {}", (Object)msgContext);
                this.configuration.getErrorHandlersChain().run(msgContext);
                RuntimeContextTLS.setRuntimeContext((RuntimeContext)originalContext);
                if (!isReleaseResourcesCalled) {
                    isReleaseResourcesCalled = true;
                    try {
                        this.releaseResources(originalContext);
                    }
                    catch (Exception e2) {
                        logger.debug("Caught exception when releasing resource object", (Throwable)e2);
                    }
                }
            }
            catch (Exception e) {
                RuntimeContextTLS.setRuntimeContext((RuntimeContext)originalContext);
                if (!isReleaseResourcesCalled) {
                    isReleaseResourcesCalled = true;
                    try {
                        this.releaseResources(originalContext);
                    }
                    catch (Exception e2) {
                        logger.debug("Caught exception when releasing resource object", (Throwable)e2);
                    }
                }
                throw e;
            }
        }
        finally {
            logger.debug("Finished response handlers chain");
            RuntimeContextTLS.setRuntimeContext(null);
        }
    }

    private void releaseResources(RuntimeContext msgContext) throws Exception {
        SearchResult searchResult = (SearchResult)msgContext.getAttribute(SearchResult.class);
        if (searchResult != null) {
            LinkedList<ResourceInstance> resourceInstances = searchResult.getData().getMatchedResources();
            for (ResourceInstance res : resourceInstances) {
                logger.debug("Releasing resource instance");
                res.releaseInstance(msgContext);
            }
        }
    }

    private void logException(Throwable t) {
        String exceptionName = t.getClass().getSimpleName();
        String messageFormat = Messages.getMessage((String)"exceptionOccurredDuringInvocation", (Object[])new Object[]{exceptionName});
        if (t instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)t;
            int statusCode = wae.getResponse().getStatus();
            Response.Status status = Response.Status.fromStatusCode((int)statusCode);
            String statusSep = "";
            String statusMessage = "";
            if (status != null) {
                statusSep = " - ";
                statusMessage = status.toString();
            }
            exceptionName = String.format("%s (%d%s%s)", exceptionName, statusCode, statusSep, statusMessage);
            if (statusCode >= 500) {
                if (logger.isDebugEnabled()) {
                    logger.debug(messageFormat, t);
                } else {
                    logger.info(messageFormat);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug(messageFormat, t);
            } else {
                logger.info(messageFormat);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug(messageFormat, t);
        } else {
            logger.info(messageFormat);
        }
    }

    private ServerMessageContext createMessageContext(HttpServletRequest request, HttpServletResponse response) {
        ServerMessageContext messageContext = new ServerMessageContext(request, response, this.configuration);
        return messageContext;
    }

    public DeploymentConfiguration getConfiguration() {
        return this.configuration;
    }

    public static RequestProcessor getRequestProcessor(ServletContext servletContext, String attributeName) {
        if (attributeName == null) {
            attributeName = RequestProcessor.class.getName();
        }
        RequestProcessor requestProcessor = (RequestProcessor)servletContext.getAttribute(attributeName);
        logger.debug("Retrieving request processor {} using attribute name {} in servlet context {}", new Object[]{requestProcessor, attributeName, servletContext});
        return requestProcessor;
    }

    public void storeRequestProcessorOnServletContext(ServletContext servletContext, String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            attributeName = RequestProcessor.class.getName();
        }
        logger.debug("Storing request processor {} using attribute name {} in servlet context {}", new Object[]{this, attributeName, servletContext});
        servletContext.setAttribute(attributeName, (Object)this);
    }
}

