/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.application;

import java.util.Set;
import javax.ws.rs.core.Application;
import org.apache.wink.common.WinkApplication;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationProcessor.class);
    private final Application application;
    private final ResourceRegistry resourceRegistry;
    private final ProvidersRegistry providersRegistry;
    private final boolean isSystemApplication;

    public ApplicationProcessor(Application application, ResourceRegistry resourceRegistry, ProvidersRegistry providersRegistry, boolean isSystemApplication) {
        this.application = application;
        this.resourceRegistry = resourceRegistry;
        this.providersRegistry = providersRegistry;
        this.isSystemApplication = isSystemApplication;
    }

    public void process() {
        Set classes;
        Set singletons;
        logger.debug("Processing Application: {}", (Object)this.application);
        double priority = 0.5;
        if (this.application instanceof WinkApplication) {
            priority = ((WinkApplication)this.application).getPriority();
            logger.debug("WinkApplication priority is set to: {}", (Object)priority);
        }
        if ((singletons = this.application.getSingletons()) != null && singletons.size() > 0) {
            this.processSingletons(singletons, priority);
        }
        if ((classes = this.application.getClasses()) != null && classes.size() > 0) {
            this.processClasses(classes, priority);
        }
        if (this.application instanceof WinkApplication) {
            this.processWinkApplication((WinkApplication)this.application);
        }
        logger.debug("Processing of Application completed.");
    }

    private void processWinkApplication(WinkApplication sApplication) {
        Set instances = sApplication.getInstances();
        double priority = sApplication.getPriority();
        if (instances == null) {
            logger.debug("WinkApplication.getInstances() returned null");
            return;
        }
        for (Object obj : instances) {
            try {
                logger.debug("Processing instance: {}", obj);
                Class<?> cls = obj.getClass();
                if (ResourceMetadataCollector.isDynamicResource(cls)) {
                    this.resourceRegistry.addResource(obj, priority);
                    continue;
                }
                if (ResourceMetadataCollector.isStaticResource(cls)) {
                    this.resourceRegistry.addResource(obj, priority);
                    continue;
                }
                if (ProviderMetadataCollector.isProvider(cls)) {
                    this.providersRegistry.addProvider(obj, priority, this.isSystemApplication);
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn(Messages.getMessage((String)"classNotADynamicResourceNorResourceNorProvider", (Object[])new Object[]{obj.getClass().getName()}));
            }
            catch (Exception e) {
                logger.warn(Messages.getMessage((String)"exceptionOccurredDuringInstanceProcessing", (Object[])new Object[]{obj.getClass().getCanonicalName()}));
                logger.warn(Messages.getMessage((String)"listExceptionDuringInstanceProcessing"), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                logger.warn(Messages.getMessage((String)"exceptionOccurredDuringInstanceProcessing", (Object[])new Object[]{obj.getClass().getCanonicalName()}));
                logger.warn(Messages.getMessage((String)"listExceptionDuringInstanceProcessing"), (Throwable)e);
            }
        }
    }

    private void processClasses(Set<Class<?>> classes, double priority) {
        for (Class<?> cls : classes) {
            try {
                logger.debug("Processing class: {}", cls);
                if (ResourceMetadataCollector.isStaticResource(cls)) {
                    this.resourceRegistry.addResource(cls, priority);
                    continue;
                }
                if (ProviderMetadataCollector.isProvider(cls)) {
                    this.providersRegistry.addProvider(cls, priority, this.isSystemApplication);
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn(Messages.getMessage((String)"classNotAResourceNorProvider", (Object[])new Object[]{cls.getName()}));
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn(Messages.getMessage((String)"exceptionOccurredDuringClassProcessing", (Object[])new Object[]{cls.getName()}));
                logger.warn(Messages.getMessage((String)"listExceptionDuringClassProcessing"), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn(Messages.getMessage((String)"exceptionOccurredDuringClassProcessing", (Object[])new Object[]{cls.getCanonicalName()}));
                logger.warn(Messages.getMessage((String)"listExceptionDuringClassProcessing"), (Throwable)e);
            }
        }
    }

    private void processSingletons(Set<Object> singletons, double priority) {
        for (Object obj : singletons) {
            try {
                logger.debug("Processing singleton: {}", obj);
                Class<?> cls = obj.getClass();
                if (ResourceMetadataCollector.isStaticResource(cls)) {
                    this.resourceRegistry.addResource(obj, priority);
                    continue;
                }
                if (ProviderMetadataCollector.isProvider(cls)) {
                    this.providersRegistry.addProvider(obj, priority, this.isSystemApplication);
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn(Messages.getMessage((String)"classNotAResourceNorProvider", (Object[])new Object[]{obj.getClass().getName()}));
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn(Messages.getMessage((String)"exceptionOccurredDuringSingletonProcessing", (Object[])new Object[]{obj.getClass().getCanonicalName()}));
                logger.warn(Messages.getMessage((String)"listExceptionDuringSingletonProcessing"), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn(Messages.getMessage((String)"exceptionOccurredDuringSingletonProcessing", (Object[])new Object[]{obj.getClass().getCanonicalName()}));
                logger.warn(Messages.getMessage((String)"listExceptionDuringSingletonProcessing"), (Throwable)e);
            }
        }
    }
}

