/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.registry;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import org.apache.wink.common.internal.uritemplate.UriTemplateMatcher;
import org.apache.wink.common.internal.uritemplate.UriTemplateProcessor;
import org.apache.wink.server.internal.registry.SubResourceInstance;
import org.apache.wink.server.internal.registry.SubResourceLocatorRecord;
import org.apache.wink.server.internal.registry.SubResourceMethodRecord;
import org.apache.wink.server.internal.registry.SubResourceRecord;
import org.apache.wink.server.internal.registry.TemplatedRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRecord
extends TemplatedRecord {
    private ClassMetadata metadata;
    private ObjectFactory<?> objectFactory;
    private List<SubResourceRecord> subResources;
    private double priority;

    public ResourceRecord(ClassMetadata metadata, ObjectFactory<?> objectFactory, UriTemplateProcessor processor) {
        super(processor);
        this.metadata = metadata;
        this.objectFactory = objectFactory;
        this.subResources = new LinkedList<SubResourceRecord>();
        this.priority = -1.0;
        this.build();
    }

    public double getPriority() {
        return this.priority;
    }

    void setPriority(double priority) {
        this.priority = priority;
    }

    public ClassMetadata getMetadata() {
        return this.metadata;
    }

    public ObjectFactory<?> getObjectFactory() {
        return this.objectFactory;
    }

    private void build() {
        this.collectSubResourceMethods();
        this.collectSubResourceLocators();
        Collections.sort(this.subResources, Collections.reverseOrder());
    }

    private void collectSubResourceMethods() {
        List subResourceMethods = this.metadata.getSubResourceMethods();
        for (MethodMetadata meta : subResourceMethods) {
            SubResourceMethodRecord record = new SubResourceMethodRecord(meta);
            this.subResources.add(record);
        }
    }

    private void collectSubResourceLocators() {
        List subResourceLocators = this.metadata.getSubResourceLocators();
        for (MethodMetadata meta : subResourceLocators) {
            SubResourceLocatorRecord record = new SubResourceLocatorRecord(meta);
            this.subResources.add(record);
        }
    }

    public boolean hasSubResources() {
        return this.subResources.size() > 0;
    }

    public List<SubResourceInstance> getMatchingSubResources(String uri) {
        return this.getMatchingSubResources(uri, true, true);
    }

    public List<SubResourceInstance> getMatchingSubResourceMethods(String uri) {
        return this.getMatchingSubResources(uri, true, false);
    }

    public List<SubResourceInstance> getMatchingSubResourceLocators(String uri) {
        return this.getMatchingSubResources(uri, false, true);
    }

    public List<SubResourceInstance> getMatchingSubResources(String uri, boolean method, boolean locator) {
        LinkedList<SubResourceInstance> list = new LinkedList<SubResourceInstance>();
        for (SubResourceRecord record : this.subResources) {
            UriTemplateMatcher matcher = record.getTemplateProcessor().matcher();
            if (!matcher.matches(uri)) continue;
            if (method && record instanceof SubResourceMethodRecord && matcher.isExactMatch()) {
                list.add(new SubResourceInstance(record, matcher));
            }
            if (!locator || !(record instanceof SubResourceLocatorRecord)) continue;
            list.add(new SubResourceInstance(record, matcher));
        }
        return list;
    }

    @Override
    public String toString() {
        return String.format("Path: %s; ClassMetadata: %s", super.toString(), this.metadata);
    }

    @Override
    public int compareTo(TemplatedRecord other) {
        if (other != null && other instanceof ResourceRecord) {
            double ret = this.priority - ((ResourceRecord)other).priority;
            if (ret < 0.0) {
                return -1;
            }
            if (ret > 0.0) {
                return 1;
            }
        }
        return super.compareTo(other);
    }
}

