/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.wink.common.DynamicResource;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.LifecycleManagersRegistry;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;
import org.apache.wink.common.internal.uritemplate.UriTemplateProcessor;
import org.apache.wink.server.internal.registry.ResourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRecordFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRecordFactory.class);
    private final LifecycleManagersRegistry lifecycleManagerRegistry;
    private final Map<Class<?>, ResourceRecord> cacheByClass;
    private Lock readersLock;
    private Lock writersLock;

    public ResourceRecordFactory(LifecycleManagersRegistry lifecycleManagerRegistry) {
        if (lifecycleManagerRegistry == null) {
            throw new NullPointerException("lifecycleManagerRegistry");
        }
        this.lifecycleManagerRegistry = lifecycleManagerRegistry;
        this.cacheByClass = new HashMap();
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readersLock = readWriteLock.readLock();
        this.writersLock = readWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceRecord getResourceRecord(Class<?> cls) {
        this.readersLock.lock();
        try {
            ResourceRecord record = this.cacheByClass.get(cls);
            if (record == null) {
                ObjectFactory of = this.lifecycleManagerRegistry.getObjectFactory(cls);
                this.readersLock.unlock();
                try {
                    record = this.createStaticResourceRecord(cls, of);
                }
                finally {
                    this.readersLock.lock();
                }
            }
            ResourceRecord resourceRecord = record;
            return resourceRecord;
        }
        finally {
            this.readersLock.unlock();
        }
    }

    public ResourceRecord getResourceRecord(Object instance) {
        return this.getResourceRecord(instance, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResourceRecord getResourceRecord(Object instance, boolean isRootResource) {
        Class<?> cls = instance.getClass();
        ResourceRecord record = null;
        this.readersLock.lock();
        try {
            ObjectFactory of;
            if (isRootResource) {
                if (ResourceMetadataCollector.isStaticResource(cls)) {
                    record = this.cacheByClass.get(cls);
                    if (record == null) {
                        of = this.lifecycleManagerRegistry.getObjectFactory(instance);
                        this.readersLock.unlock();
                        try {
                            record = this.createStaticResourceRecord(cls, of);
                        }
                        finally {
                            this.readersLock.lock();
                        }
                    }
                } else {
                    if (!ResourceMetadataCollector.isDynamicResource(cls)) throw new IllegalArgumentException(Messages.getMessage((String)"rootResourceInstanceIsAnInvalidResource", (Object[])new Object[]{instance.getClass().getCanonicalName()}));
                    of = this.lifecycleManagerRegistry.getObjectFactory(instance);
                    this.readersLock.unlock();
                    try {
                        record = this.createDynamicResourceRecord((DynamicResource)instance, of);
                    }
                    finally {
                        this.readersLock.lock();
                    }
                }
            } else {
                of = new InstanceObjectFactory(instance);
                this.readersLock.unlock();
                try {
                    record = this.createSubResourceRecord(instance, of);
                }
                finally {
                    this.readersLock.lock();
                }
            }
            ResourceRecord resourceRecord = record;
            return resourceRecord;
        }
        finally {
            this.readersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceRecord createStaticResourceRecord(Class<? extends Object> cls, ObjectFactory<?> of) {
        ClassMetadata metadata = this.createMetadata(cls);
        UriTemplateProcessor processor = this.createUriTemplateProcessor(metadata);
        ResourceRecord record = new ResourceRecord(metadata, of, processor);
        this.writersLock.lock();
        try {
            if (this.cacheByClass.get(cls) == null) {
                this.cacheByClass.put(cls, record);
            }
        }
        finally {
            this.writersLock.unlock();
        }
        return record;
    }

    private ResourceRecord createDynamicResourceRecord(DynamicResource instance, ObjectFactory<?> of) {
        Class<?> cls = instance.getClass();
        ClassMetadata metadata = this.createMetadata(cls);
        metadata = this.fixInstanceMetadata(metadata, instance);
        UriTemplateProcessor processor = this.createUriTemplateProcessor(metadata);
        return new ResourceRecord(metadata, of, processor);
    }

    private ResourceRecord createSubResourceRecord(Object instance, ObjectFactory<?> of) {
        Class<?> cls = instance.getClass();
        ClassMetadata metadata = this.createMetadata(cls);
        return new ResourceRecord(metadata, of, null);
    }

    private ClassMetadata createMetadata(Class<? extends Object> cls) {
        return ResourceMetadataCollector.collectMetadata(cls);
    }

    private UriTemplateProcessor createUriTemplateProcessor(ClassMetadata metadata) {
        StringBuilder path = new StringBuilder();
        this.appendPathWithParent(metadata, path);
        return UriTemplateProcessor.newNormalizedInstance((String)path.toString());
    }

    private void appendPathWithParent(ClassMetadata metadata, StringBuilder pathStr) {
        String path;
        ResourceRecord parentRecord = this.getParent(metadata);
        if (parentRecord != null) {
            ClassMetadata parentMetadata = parentRecord.getMetadata();
            this.appendPathWithParent(parentMetadata, pathStr);
        }
        if (!(path = UriTemplateProcessor.normalizeUri((String)metadata.getPath())).endsWith("/")) {
            pathStr.append("/");
        }
        pathStr.append(path);
    }

    private ResourceRecord getParent(ClassMetadata metadata) {
        Class parent = metadata.getParent();
        Object parentInstance = metadata.getParentInstance();
        ResourceRecord parentRecord = null;
        if (parent != null) {
            parentRecord = this.getResourceRecord(parent);
        } else if (parentInstance != null) {
            parentRecord = this.getResourceRecord(parentInstance);
        }
        return parentRecord;
    }

    private ClassMetadata fixInstanceMetadata(ClassMetadata classMetadata, DynamicResource dynamicResource) {
        String collectionTitle;
        String workspaceTitle;
        Object parent;
        String path = dynamicResource.getPath();
        if (path != null) {
            classMetadata.addPath(path);
            if (logger.isDebugEnabled()) {
                logger.debug("Adding dispatched path from instance: {}", (Object)path);
            }
        }
        if ((parent = dynamicResource.getParent()) != null) {
            classMetadata.getParentInstances().add(parent);
            if (logger.isDebugEnabled()) {
                logger.debug("Adding parent beans from instance: {}", parent);
            }
        }
        if ((workspaceTitle = dynamicResource.getWorkspaceTitle()) != null) {
            classMetadata.setWorkspaceName(workspaceTitle);
        }
        if ((collectionTitle = dynamicResource.getCollectionTitle()) != null) {
            classMetadata.setCollectionTitle(collectionTitle);
        }
        return classMetadata;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceObjectFactory<T>
    implements ObjectFactory<T> {
        private final T object;

        public InstanceObjectFactory(T object) {
            this.object = object;
        }

        public T getInstance(RuntimeContext context) {
            return this.object;
        }

        public Class<T> getInstanceClass() {
            return this.object.getClass();
        }

        public String toString() {
            return String.format("InstanceObjectFactory: %s", this.getInstanceClass());
        }

        public void releaseInstance(T instance, RuntimeContext context) {
        }

        public void releaseAll(RuntimeContext context) {
        }
    }
}

