/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.wink.common.http.HttpStatus;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.model.admin.AcceptMediaTypes;
import org.apache.wink.common.internal.model.admin.MatrixParameters;
import org.apache.wink.common.internal.model.admin.Methods;
import org.apache.wink.common.internal.model.admin.ObjectFactory;
import org.apache.wink.common.internal.model.admin.Parameter;
import org.apache.wink.common.internal.model.admin.ProducedMediaTypes;
import org.apache.wink.common.internal.model.admin.QueryParameters;
import org.apache.wink.common.internal.model.admin.Registry;
import org.apache.wink.common.internal.model.admin.Resource;
import org.apache.wink.common.internal.model.admin.Resources;
import org.apache.wink.common.internal.model.admin.SubResource;
import org.apache.wink.common.internal.model.admin.SubResources;
import org.apache.wink.common.internal.registry.BoundInjectable;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import org.apache.wink.common.internal.uritemplate.UriTemplateProcessor;
import org.apache.wink.common.internal.utils.JAXBUtils;
import org.apache.wink.server.internal.RequestProcessor;
import org.apache.wink.server.internal.registry.ResourceRecord;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.apache.wink.server.internal.servlet.AbstractRestServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminServlet
extends AbstractRestServlet {
    private static final long serialVersionUID = -5972412568762942420L;
    private static final String APPLICATION_XML = "application/xml";
    private static final String DOCUMENT_TYPE = "doc";
    private static final String DOCUMENT_TYPE_REGISTRY = "registry";
    private static final String DOCUMENT_TYPE_RESOURCE = "resources";
    private static final String SLASH = "/";
    private static final JAXBContext resourceCtx;
    private static final ObjectFactory resourcesObjectFactory;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestProcessor requestProcessor = this.getRequestProcessor();
        if (requestProcessor == null) {
            throw new ServletException(Messages.getMessage((String)"adminServletRequestProcessorInitBeforeAdmin"));
        }
        ResourceRegistry registry = requestProcessor.getConfiguration().getResourceRegistry();
        String[] parameterValues = request.getParameterValues(DOCUMENT_TYPE);
        if (parameterValues == null || parameterValues.length == 0) {
            this.buildAdminHome(response);
            return;
        }
        if (parameterValues[0].equals(DOCUMENT_TYPE_REGISTRY)) {
            this.buildRegistryDocument(request, response, registry);
        } else if (parameterValues[0].equals(DOCUMENT_TYPE_RESOURCE)) {
            this.buildResourcesDocument(request, response, registry);
        } else {
            this.buildAdminHome(response);
            return;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    private void buildRegistryDocument(HttpServletRequest request, HttpServletResponse response, ResourceRegistry registry) throws ServletException, IOException {
        Registry xmlRgistry = resourcesObjectFactory.createRegistry();
        Resources resources = resourcesObjectFactory.createResources();
        List<ResourceRecord> records = registry.getRecords();
        for (ResourceRecord record : records) {
            Resource xmLResource = this.buildResource(record);
            xmLResource.setPriority(new BigDecimal(record.getPriority()));
            xmLResource.setClassName(record.getMetadata().getResourceClass().getCanonicalName());
            this.addSubRrcMethodsAndLocators(xmLResource, record);
            resources.getResource().add(xmLResource);
        }
        xmlRgistry.setResources(resources);
        this.writeDocument(response, xmlRgistry);
    }

    private void addSubRrcMethodsAndLocators(Resource xmLResource, ResourceRecord record) {
        List subResourceLocators = record.getMetadata().getSubResourceLocators();
        List subResourceMethods = record.getMetadata().getSubResourceMethods();
        SubResources subResources = resourcesObjectFactory.createSubResources();
        this.buildSubReasource(record, subResourceLocators, subResources, true);
        this.buildSubReasource(record, subResourceMethods, subResources, false);
        xmLResource.setSubResources(subResources);
    }

    private void buildSubReasource(ResourceRecord record, List<MethodMetadata> subResourceLocators, SubResources subResources, boolean isLocator) {
        for (MethodMetadata subResourceLocator : subResourceLocators) {
            SubResource subResource = resourcesObjectFactory.createSubResource();
            UriTemplateProcessor uriTemplate = record.getTemplateProcessor();
            subResource.setUri(SLASH + uriTemplate.getTemplate() + subResourceLocator.getPath());
            if (isLocator) {
                subResource.setType("Locator");
            } else {
                subResource.setType("Method");
                subResource.setMethod(subResourceLocator.getHttpMethod().toString());
            }
            AcceptMediaTypes acceptMediaTypes = resourcesObjectFactory.createAcceptMediaTypes();
            this.buildCunsumeMimeTypes(subResourceLocator, acceptMediaTypes);
            subResource.setAcceptMediaTypes(acceptMediaTypes);
            ProducedMediaTypes producedMediaTypes = resourcesObjectFactory.createProducedMediaTypes();
            this.buildProduceMimeTypes(subResourceLocator, producedMediaTypes);
            subResource.setProducedMediaTypes(producedMediaTypes);
            QueryParameters qParams = resourcesObjectFactory.createQueryParameters();
            this.buildQueryParams(subResourceLocator, qParams);
            subResource.setQueryParameters(qParams);
            MatrixParameters mParams = resourcesObjectFactory.createMatrixParameters();
            this.buildMatrixParams(subResourceLocator, mParams);
            subResource.setMatrixParameters(mParams);
            subResources.getSubResource().add(subResource);
        }
    }

    private void buildResourcesDocument(HttpServletRequest request, HttpServletResponse response, ResourceRegistry resourceRegistry) throws IOException, ServletException {
        List<ResourceRecord> records = resourceRegistry.getRecords();
        Resources resources = resourcesObjectFactory.createResources();
        for (ResourceRecord record : records) {
            resources.getResource().add(this.buildResource(record));
            this.buildSubRrcMethodsAndLocatorsResources(resources, record);
        }
        this.writeDocument(response, resources);
    }

    private void buildSubRrcMethodsAndLocatorsResources(Resources resources, ResourceRecord record) {
        String uri;
        UriTemplateProcessor uriTemplate;
        List subResourceLocators = record.getMetadata().getSubResourceLocators();
        List subResourceMethods = record.getMetadata().getSubResourceMethods();
        HashMap<String, Resource> uri2ResourceMap = new HashMap<String, Resource>();
        for (MethodMetadata subResourceLocator : subResourceLocators) {
            uriTemplate = record.getTemplateProcessor();
            uri = SLASH + uriTemplate.getTemplate() + subResourceLocator.getPath();
            Methods xmlSRL = this.createXMLSubResourceLocatorMethod(subResourceLocator);
            this.addResourceMethods(uri2ResourceMap, uri, xmlSRL);
        }
        resources.getResource().addAll(uri2ResourceMap.values());
        uri2ResourceMap.clear();
        for (MethodMetadata subResourceMethod : subResourceMethods) {
            uriTemplate = record.getTemplateProcessor();
            uri = SLASH + uriTemplate.getTemplate() + SLASH + subResourceMethod.getPath();
            Methods xmlSRM = this.createXMLSubResourceMethod(subResourceMethod);
            this.addResourceMethods(uri2ResourceMap, uri, xmlSRM);
        }
        resources.getResource().addAll(uri2ResourceMap.values());
    }

    private void addResourceMethods(Map<String, Resource> uri2ResourceMap, String uri, Methods xmlSRL) {
        if (uri2ResourceMap.get(uri) != null) {
            Resource r = uri2ResourceMap.get(uri);
            r.getMethods().getMethod().addAll(xmlSRL.getMethod());
        } else {
            Resource newResource = resourcesObjectFactory.createResource();
            newResource.setUri(uri);
            newResource.setMethods(xmlSRL);
            uri2ResourceMap.put(uri, newResource);
        }
    }

    private Methods createXMLSubResourceLocatorMethod(MethodMetadata subResourceLocator) {
        Methods methods = resourcesObjectFactory.createMethods();
        Methods.Method httpMethod = resourcesObjectFactory.createMethodsMethod();
        httpMethod.setName("Dynamic");
        AcceptMediaTypes acceptMediaTypes = resourcesObjectFactory.createAcceptMediaTypes();
        this.buildCunsumeMimeTypes(subResourceLocator, acceptMediaTypes);
        ProducedMediaTypes producedMediaTypes = resourcesObjectFactory.createProducedMediaTypes();
        this.buildProduceMimeTypes(subResourceLocator, producedMediaTypes);
        QueryParameters qParams = resourcesObjectFactory.createQueryParameters();
        this.buildQueryParams(subResourceLocator, qParams);
        MatrixParameters mParams = resourcesObjectFactory.createMatrixParameters();
        this.buildMatrixParams(subResourceLocator, mParams);
        httpMethod.setQueryParameters(qParams);
        httpMethod.setProducedMediaTypes(producedMediaTypes);
        httpMethod.setAcceptMediaTypes(acceptMediaTypes);
        httpMethod.setMatrixParameters(mParams);
        methods.getMethod().add(httpMethod);
        return methods;
    }

    private Methods createXMLSubResourceMethod(MethodMetadata subResourceMethod) {
        Methods methods = resourcesObjectFactory.createMethods();
        LinkedList<MethodMetadata> methodRecord = new LinkedList<MethodMetadata>();
        methodRecord.add(subResourceMethod);
        this.addResourceMethods(methodRecord, methods);
        return methods;
    }

    private Resource buildResource(ResourceRecord record) {
        Resource newResource = resourcesObjectFactory.createResource();
        UriTemplateProcessor uriTemplate = record.getTemplateProcessor();
        newResource.setUri(SLASH + uriTemplate.getTemplate());
        newResource.setWorkspace(record.getMetadata().getWorkspaceName());
        newResource.setCollection(record.getMetadata().getCollectionTitle());
        LinkedList<MethodMetadata> methodRecords = new LinkedList<MethodMetadata>();
        methodRecords.addAll(record.getMetadata().getResourceMethods());
        Methods methods = resourcesObjectFactory.createMethods();
        this.addResourceMethods(methodRecords, methods);
        newResource.setMethods(methods);
        return newResource;
    }

    private void addResourceMethods(List<MethodMetadata> methodMD, Methods methods2xml) {
        for (MethodMetadata methodMetadata : methodMD) {
            Methods.Method httpMethod = resourcesObjectFactory.createMethodsMethod();
            httpMethod.setName(methodMetadata.getHttpMethod().toString());
            AcceptMediaTypes acceptMediaTypes = resourcesObjectFactory.createAcceptMediaTypes();
            this.buildCunsumeMimeTypes(methodMetadata, acceptMediaTypes);
            ProducedMediaTypes producedMediaTypes = resourcesObjectFactory.createProducedMediaTypes();
            this.buildProduceMimeTypes(methodMetadata, producedMediaTypes);
            QueryParameters qParams = resourcesObjectFactory.createQueryParameters();
            this.buildQueryParams(methodMetadata, qParams);
            MatrixParameters mParams = resourcesObjectFactory.createMatrixParameters();
            this.buildMatrixParams(methodMetadata, mParams);
            httpMethod.setQueryParameters(qParams);
            httpMethod.setProducedMediaTypes(producedMediaTypes);
            httpMethod.setAcceptMediaTypes(acceptMediaTypes);
            httpMethod.setMatrixParameters(mParams);
            methods2xml.getMethod().add(httpMethod);
        }
    }

    private void buildMatrixParams(MethodMetadata methodMetadata, MatrixParameters params) {
        List formalParameters = methodMetadata.getFormalParameters();
        for (Injectable var : formalParameters) {
            if (var.getParamType() != Injectable.ParamType.MATRIX) continue;
            Parameter param = resourcesObjectFactory.createParameter();
            param.setValue(((BoundInjectable)var).getName());
            params.getParameter().add(param);
        }
    }

    private void writeDocument(HttpServletResponse response, Object jaxbObject) throws ServletException, IOException {
        PrintWriter writer = response.getWriter();
        response.setContentType(APPLICATION_XML);
        try {
            Marshaller marshaller = JAXBUtils.createMarshaller((JAXBContext)resourceCtx);
            marshaller.marshal(jaxbObject, (Writer)writer);
        }
        catch (JAXBException e) {
            throw new ServletException(Messages.getMessage((String)"adminServletFailMarshalObject", (Object[])new Object[]{jaxbObject.getClass().getName()}), (Throwable)e);
        }
        response.flushBuffer();
        writer.close();
    }

    private void buildAdminHome(HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.write("<html>\r\n<head>\r\n<title>Admin Console</title>\r\n<style type=\"text/css\" media=\"all\">  h2 {  padding: 4px 4px 4px 24px;  color: #333333;  background-color: #D8D8D8;  font-weight: bold;  font-size: 16px;} h1 {  padding: 4px 4px 4px 24px;  color: #F8F8F8;  background-color: #909090;  font-weight: bold;  font-size: 24px;}    </style></head>\r\n<body>\r\n<form name=\"AdministrationPage\"  method=\"POST\">\r\n<div align=\"left\">\r\n</br>\r\n<h1>Wink Admin Console</h1>\r\n</br>\r\n</div>\r\n<h2>\r\n<a href=\"?doc=resources\"> Application resources xml view</a>&#45&#62\r\n</h2>\r\n<h2>\r\n<a href=\"?doc=registry\"> Wink Resource registry xml view</a>&#45&#62\r\n</h2>\r\n</form>\r\n</body>\r\n</html>");
        response.setStatus(HttpStatus.BAD_REQUEST.getCode());
        writer.close();
    }

    private void buildQueryParams(MethodMetadata methodMetadata, QueryParameters xmlQueryVariables) {
        List formalParameters = methodMetadata.getFormalParameters();
        for (Injectable var : formalParameters) {
            if (var.getParamType() != Injectable.ParamType.MATRIX) continue;
            Parameter param = resourcesObjectFactory.createParameter();
            param.setValue(((BoundInjectable)var).getName());
            xmlQueryVariables.getParameter().add(param);
        }
    }

    private void buildProduceMimeTypes(MethodMetadata methodMetadata, ProducedMediaTypes xmlProducedMediaTypes) {
        Set producedMime = methodMetadata.getProduces();
        for (MediaType mediaType : producedMime) {
            xmlProducedMediaTypes.getProducedMediaType().add(mediaType.getType() + SLASH + mediaType.getSubtype());
        }
    }

    private void buildCunsumeMimeTypes(MethodMetadata methodMetadata, AcceptMediaTypes xmlAcceptMediaTypes) {
        Set consumedMime = methodMetadata.getConsumes();
        for (MediaType mediaType : consumedMime) {
            xmlAcceptMediaTypes.getAcceptMediaType().add(mediaType.getType() + SLASH + mediaType.getSubtype());
        }
    }

    static {
        resourcesObjectFactory = new ObjectFactory();
        try {
            resourceCtx = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        }
        catch (JAXBException e) {
            throw new RuntimeException(Messages.getMessage((String)"adminServletFailCreateJAXBForAdminServlet"), e);
        }
    }
}

